/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.Multiplexer;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.Label;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.ToggleButton;
import com.eazycnc.uwk.widgets.Widget;
import eazycnc.Main;
import eazycnc.ProbeCalibration2;
import eazycnc.TouchPlate;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import java.text.DecimalFormat;

public class WorkOffsetPanel {
    public static Layout newTouchEdgeFinder(Main main, MachState machState, Variable variable) {
        Layout layout = UWKit.newLayout();
        Button button = UWKit.newButton("Touch -X");
        Button button2 = UWKit.newButton("Touch +X");
        Button button3 = UWKit.newButton("Touch -Y");
        Button button4 = UWKit.newButton("Touch +Y");
        Button button5 = UWKit.newButton("Touch");
        Layout layout2 = UWKit.newLayout(true, "");
        Layout layout3 = UWKit.newLayout(true, "");
        Layout layout4 = UWKit.newLayout("");
        layout4.add(UWKit.newLabel("Edge Finder Diam:"), new String[0]);
        layout4.add(UWKit.newTextField((Variable)machState.getScaledVariable(15151), 16.0, 7, variable, null), new String[0]);
        layout4.add(UWKit.newLabel(machState.getLengthUnit()), new String[0]);
        layout2.add(layout4, "cell 1 1 3 1");
        Layout layout5 = UWKit.newLayout("flowx");
        layout5.add(button4, new String[0]);
        layout5.add(button2, "gap 100");
        Layout layout6 = UWKit.newLayout("flowx");
        layout6.add(button3, new String[0]);
        layout6.add(button, "gap 100");
        layout2.add(layout5, "cell 1 2");
        layout2.add(layout6, "cell 1 4,");
        if (main.compactUI()) {
            layout2.add(UWKit.newPicture("edge-finder-compact.png"), "cell 1 3, center ");
        } else {
            layout2.add(UWKit.newPicture("edge-finder.png"), "cell 1 3, center");
        }
        layout3.add(button5, "cell 2 2,center");
        Layout layout7 = UWKit.newLayout("");
        layout7.add(UWKit.newLabel("Gage Height:"), new String[0]);
        layout7.add(UWKit.newTextField((Variable)machState.getScaledVariable(15152), 16.0, 7, variable, null), new String[0]);
        layout7.add(UWKit.newLabel(machState.getLengthUnit()), new String[0]);
        layout3.add(layout7, "cell 1 1,span 2");
        if (main.compactUI()) {
            layout3.add(UWKit.newPicture("height-gauge-compact.png"), "cell 1 2");
        } else {
            layout3.add(UWKit.newPicture("height-gauge.png"), "cell 1 2");
        }
        layout.add(layout2, "growy");
        layout.add(layout3, "growy");
        Label label = UWKit.newLabel("Set XY Origin");
        Label label2 = UWKit.newLabel("Set Z Origin");
        layout2.add(label, "cell 1 0,right,top");
        layout3.add(label2, "cell 1 0,span 2,right,top");
        button.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.setWorkOffset(main, 0, 1, -0.5 * machState.getParamDouble(15151));
            }
        });
        button2.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.setWorkOffset(main, 0, -1, 0.5 * machState.getParamDouble(15151));
            }
        });
        button3.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.setWorkOffset(main, 1, 1, -0.5 * machState.getParamDouble(15151));
            }
        });
        button4.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.setWorkOffset(main, 1, -1, 0.5 * machState.getParamDouble(15151));
            }
        });
        button5.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.setWorkOffset(main, 2, -1, machState.getParamDouble(15152));
            }
        });
        return layout;
    }

    public static Layout newTouchProbe(Main main, MachState machState, Variable variable) {
        Layout layout = UWKit.newLayout();
        Button button = UWKit.newButton("button_green", "Touch -X");
        Button button2 = UWKit.newButton("button_green", "Touch +X");
        Button button3 = UWKit.newButton("button_green", "Touch -Y");
        Button button4 = UWKit.newButton("button_green", "Touch +Y");
        Button button5 = UWKit.newButton("button_green", "Touch");
        Layout layout2 = UWKit.newLayout(true, "");
        Layout layout3 = UWKit.newLayout(true, "");
        Layout layout4 = UWKit.newLayout("flowx");
        layout4.add(button4, new String[0]);
        layout4.add(button2, "gap 100");
        Layout layout5 = UWKit.newLayout("flowx");
        layout5.add(button3, new String[0]);
        layout5.add(button, "gap 100");
        layout2.add(layout4, "cell 1 2");
        layout2.add(layout5, "cell 1 4,");
        if (main.compactUI()) {
            layout2.add(UWKit.newPicture("probe-xy-compact.png"), "cell 1 3,center");
        } else {
            layout2.add(UWKit.newPicture("probe-xy.png"), "cell 1 3,center");
        }
        layout3.add(button5, "cell 2 2,center, hidemode 3");
        Layout layout6 = UWKit.newLayout("");
        layout6.add(UWKit.newLabel("Gage Height:"), new String[0]);
        layout6.add(UWKit.newTextField((Variable)machState.getScaledVariable(15152), 16.0, 7, variable, null), new String[0]);
        layout6.add(UWKit.newLabel(machState.getLengthUnit()), new String[0]);
        layout3.add(layout6, "cell 1 1,span 2");
        if (main.compactUI()) {
            layout3.add(UWKit.newPicture("probe-z-compact.png"), "cell 1 2,center");
        } else {
            layout3.add(UWKit.newPicture("probe-z.png"), "cell 1 2,center");
        }
        layout.add(layout2, "growy");
        layout.add(layout3, "growy");
        Label label = UWKit.newLabel("Set XY Origin");
        Label label2 = UWKit.newLabel("Sets Z Origin");
        layout2.add(label, "cell 1 0,right,top");
        layout3.add(label2, "cell 1 0,span 2,align right,top");
        button.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.runWorkOffsetProbeScript(main, 0, 1, 0.0);
            }
        });
        button2.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.runWorkOffsetProbeScript(main, 0, -1, 0.0);
            }
        });
        button3.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.runWorkOffsetProbeScript(main, 1, 1, 0.0);
            }
        });
        button4.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.runWorkOffsetProbeScript(main, 1, -1, 0.0);
            }
        });
        button5.addActionListener(() -> {
            if (main.checkConnected()) {
                WorkOffsetPanel.runWorkOffsetProbeScript(main, 2, -1, machState.getParamDouble(15152));
            }
        });
        return layout;
    }

    private static Widget newEntry(String string, Variable variable, MachState machState, Variable variable2) {
        Layout layout = UWKit.newLayout();
        layout.add(UWKit.newLabel(string), "align right");
        layout.add(UWKit.newTextField(variable, 16.0, 7, variable2, null), new String[0]);
        layout.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        return layout;
    }

    private static Widget newEntry(Variable variable, MachState machState, Variable variable2) {
        Layout layout = UWKit.newLayout();
        layout.add(UWKit.newTextField(variable, 16.0, 7, variable2, null), new String[0]);
        return layout;
    }

    private static void addEntry(Layout layout, String string, String string2, Variable variable, MachState machState, Variable variable2) {
        layout.add(UWKit.newLabel(string2), "align right");
        layout.add(UWKit.newTextField(variable, 16.0, 7, variable2, null), new String[0]);
        layout.add(UWKit.newLabel(machState.getLengthUnit()), string);
    }

    public static Layout newCalibratePane(Main main, MachState machState, Variable variable) {
        Layout layout = UWKit.newTitledLayout("Calibrated Probe Offsets");
        layout.add(UWKit.newPicture("ruby.png"), "cell 2 2");
        layout.add(WorkOffsetPanel.newEntry(machState.getScaledVariable(0x4000001, 1), machState, variable), "cell 2 1");
        layout.add(WorkOffsetPanel.newEntry(machState.getScaledVariable(0x4000000, 0), machState, variable), "cell 1 2");
        layout.add(WorkOffsetPanel.newEntry(machState.getScaledVariable(0x4000001, 0), machState, variable), "cell 3 2");
        layout.add(WorkOffsetPanel.newEntry(machState.getScaledVariable(0x4000000, 1), machState, variable), "cell 2 3");
        layout.add(UWKit.newLabel("("), "cell 3 3,align right,split 3");
        layout.add(UWKit.newLabel(machState.getLengthUnit()), "cell 3 3");
        layout.add(UWKit.newLabel(")"), "cell 3 3");
        Layout layout2 = UWKit.newLayout();
        Button button = UWKit.newButton("button_green", "CALIBRATE");
        button.addActionListener(() -> new ProbeCalibration2().startCalibration(main, machState.getParamDouble(15193)));
        layout2.add(button, "center");
        if (main.compactUI()) {
            layout2.add(UWKit.newPicture("ring-gauge-compact.png"), "wrap");
        } else {
            layout2.add(UWKit.newPicture("ring-gauge.png"), "wrap");
        }
        Layout layout3 = UWKit.newLayout(true, "");
        layout3.add(layout2, new String[0]);
        layout3.add(layout, "wrap");
        layout3.add(WorkOffsetPanel.newEntry("Gage Diameter:", machState.getScaledVariable(15193), machState, variable), "span 2,wrap");
        return layout3;
    }

    public static Layout newTouchPlate(Main main, MachState machState, Variable variable) {
        Layout layout = UWKit.newLayout();
        Button button = UWKit.newButton("button_green", "Touch\nBot.Left");
        Button button2 = UWKit.newButton("button_green", "Touch\nTop Right");
        Button button3 = UWKit.newButton("button_green", "Touch\nBot. Right");
        Button button4 = UWKit.newButton("button_green", "Touch\nTop Left");
        Layout layout2 = UWKit.newLayout(true, "");
        Layout layout3 = UWKit.newLayout(true, "");
        Layout layout4 = UWKit.newLayout("");
        layout4.add(UWKit.newCheckBox((Variable)machState.getVariable(15206), "Use Tool,"), "split 2,gap right 10 push");
        WorkOffsetPanel.addEntry(layout4, "wrap", "diameter:", machState.getScaledVariable(15151), machState, variable);
        WorkOffsetPanel.addEntry(layout4, "wrap", "Horizontal Edge:", machState.getScaledVariable(15208), machState, variable);
        WorkOffsetPanel.addEntry(layout4, "wrap", "Vertical Edge:", machState.getScaledVariable(15207), machState, variable);
        WorkOffsetPanel.addEntry(layout4, "wrap", "Probe XY move:", machState.getScaledVariable(15213), machState, variable);
        layout4.add(UWKit.newCheckBox((Variable)machState.getVariable(15209), "Touch Z,"), "split 2,gap right 10 push");
        WorkOffsetPanel.addEntry(layout4, "wrap", "Z move:", machState.getScaledVariable(15212), machState, variable);
        layout4.add(UWKit.newCheckBox((Variable)machState.getVariable(15210), "Probe Rot,"), "split 2,gap right 10 push");
        WorkOffsetPanel.addEntry(layout4, "wrap", "move X:", machState.getScaledVariable(15214), machState, variable);
        layout2.add(layout4, "cell 2 1 1 3");
        Layout layout5 = UWKit.newLayout("flowx");
        layout5.add(button4, new String[0]);
        layout5.add(button2, "gap 80");
        Layout layout6 = UWKit.newLayout("flowx");
        layout6.add(button, new String[0]);
        layout6.add(button3, "gap 80");
        layout2.add(layout5, "cell 1 1, top, hidemode 3");
        layout2.add(layout6, "cell 1 3, bottom, hidemode 3");
        if (main.compactUI()) {
            layout2.add(UWKit.newPicture("touch-plate2-compact.png"), "cell 1 2, center");
        } else {
            layout2.add(UWKit.newPicture("touch-plate2.png"), "cell 1 2,center");
        }
        Layout layout7 = UWKit.newLayout("");
        layout7.add(UWKit.newLabel("Gage Height:"), new String[0]);
        layout7.add(UWKit.newTextField((Variable)machState.getScaledVariable(15152), 16.0, 7, variable, null), new String[0]);
        layout7.add(UWKit.newLabel(machState.getLengthUnit()), new String[0]);
        layout3.add(layout7, "cell 1 0,span 2");
        if (main.compactUI()) {
            layout3.add(UWKit.newPicture("set-z-compact.png"), "cell 1 1");
        } else {
            layout3.add(UWKit.newPicture("set-z.png"), "cell 1 1");
        }
        layout.add(layout2, "growy");
        Label label = UWKit.newLabel("Set XYZ Origin");
        layout2.add(label, "cell 2 0,right,top");
        button.addActionListener(() -> {
            if (main.checkConnected()) {
                new TouchPlate().startTouch(main, TouchPlate.Corner.BOTTOM_LEFT);
            }
        });
        button2.addActionListener(() -> {
            if (main.checkConnected()) {
                new TouchPlate().startTouch(main, TouchPlate.Corner.TOP_RIGHT);
            }
        });
        button3.addActionListener(() -> {
            if (main.checkConnected()) {
                new TouchPlate().startTouch(main, TouchPlate.Corner.BOTTOM_RIGHT);
            }
        });
        button4.addActionListener(() -> {
            if (main.checkConnected()) {
                new TouchPlate().startTouch(main, TouchPlate.Corner.TOP_LEFT);
            }
        });
        return layout;
    }

    public static Layout newWorkOffsetPanel(Main main, final MachState machState) {
        Object object;
        int n;
        Variable variable = machState.getDroFormatVariable();
        Layout layout = UWKit.newTitledLayout("Work Offset", "flowy,insets 2");
        Layout layout2 = UWKit.newLayout("flowx");
        Layout layout3 = UWKit.newLayout("flowy,");
        Layout layout4 = UWKit.newLayout(true, "flowx,");
        int n2 = main.compactUI() ? 20 : 24;
        TextField textField = UWKit.newTextField((Variable)machState.getVariable(5220), (double)n2, 3, new DecimalFormat("0"), null);
        final SimpleVariable simpleVariable = new SimpleVariable("");
        Label label = UWKit.newLabel(simpleVariable);
        int n3 = main.isAndroid() ? 4 : 6;
        TextField[] textFieldArray = new TextField[n3];
        for (int i = 0; i < n3; ++i) {
            n = i;
            object = new Multiplexer((Variable)machState.getVariable(5220), new Variable[0]){

                @Override
                public Variable getVariable(Variable variable) {
                    return machState.getScaledVariable(machState.getWorkOffsetBaseIndex() + n);
                }
            };
            textFieldArray[i] = UWKit.newTextField((Variable)object, 16.0, 7, variable, null);
        }
        ToggleButton[] toggleButtonArray = new ToggleButton[6];
        for (n = 1; n <= 5; ++n) {
            ToggleButton toggleButton = UWKit.newToggleButton((Variable)machState.getVariable(5220), n + " (G5" + (4 + n - 1) + ")", (Object)n);
            toggleButtonArray[n - 1] = toggleButton;
            layout3.add(toggleButton, new String[0]);
        }
        layout2.add(UWKit.newLabel("Active Offset:"), new String[0]);
        layout2.add(textField, new String[0]);
        layout2.add(label, new String[0]);
        for (n = 0; n < n3; ++n) {
            layout4.add(UWKit.newLabel(Interpreter.getAxisLetter(n) + ":"), new String[0]);
            layout4.add(textFieldArray[n], "wrap");
        }
        Multiplexer multiplexer = new Multiplexer((Variable)machState.getVariable(5220), new Variable[0]){

            @Override
            public Variable getVariable(Variable variable) {
                return machState.getScaledVariable(machState.getWorkOffsetBaseIndex() + 19);
            }
        };
        layout4.add(UWKit.newLabel("Rot:"), new String[0]);
        layout4.add(UWKit.newTextField((Variable)UWKit.divide((Variable)multiplexer, Math.PI / 180), 16.0, 7, variable, null), new String[0]);
        layout.add(layout2, "cell 1 1,span 2");
        object = UWKit.newLayout("");
        SimpleVariable simpleVariable2 = machState.getVariable(15189);
        object.add(UWKit.newToggleButton((Variable)simpleVariable2, "EDGE FINDER", (Object)0), new String[0]);
        object.add(UWKit.newToggleButton((Variable)simpleVariable2, "TOUCH PLATE", (Object)2), new String[0]);
        object.add(UWKit.newToggleButton((Variable)simpleVariable2, "PROBE", (Object)1), new String[0]);
        object.add(UWKit.newToggleButton((Variable)simpleVariable2, "Calibration", (Object)3), new String[0]);
        layout.add((Widget)object, "cell 3 1, span 2");
        layout.add(layout3, "cell 1 2,top");
        layout.add(layout4, "cell 2 2,top");
        CardLayout cardLayout = UWKit.newCardLayout();
        cardLayout.addCard("0", WorkOffsetPanel.newTouchEdgeFinder(main, machState, variable));
        cardLayout.addCard("1", WorkOffsetPanel.newTouchProbe(main, machState, variable));
        cardLayout.addCard("2", WorkOffsetPanel.newTouchPlate(main, machState, variable));
        cardLayout.addCard("3", WorkOffsetPanel.newCalibratePane(main, machState, variable));
        layout.add(cardLayout, "cell 3 2,growy,span 3,hidemode 3");
        simpleVariable2.addObserver(observable -> cardLayout.selectCard(simpleVariable2.getValue().toString()));
        Main.m_ScreenCap.push(simpleVariable2);
        Main.m_ScreenCap.addValue(0);
        Main.m_ScreenCap.addValue(1);
        Main.m_ScreenCap.addValue(2);
        Main.m_ScreenCap.addValue(3);
        Main.m_ScreenCap.pop();
        machState.getVariable(5220).addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                NumericVariable numericVariable = (NumericVariable)variable;
                int n = numericVariable.intValue();
                simpleVariable.setValue("(" + (n >= 6 ? "G59P" + n : "G" + (54 + n - 1)) + ")");
            }
        });
        return layout;
    }

    public static void runWorkOffsetProbeScript(Main main, int n, int n2, double d) {
        boolean bl = main.m_MachController.getMachState().getParamBoolean(15133);
        String string = "G91 F60 G31 " + Interpreter.getAxisLetter(n) + (n2 < 0 ? "-" : "") + "12.5 \nG0 " + Interpreter.getAxisLetter(n) + (n2 > 0 ? "-" : "") + "12.5";
        Main.m_MainWindow.execute(string, object -> {
            main.m_MachController.getMachState().setParam(15133, bl);
            if (object == null) {
                System.out.println("TARGET " + d);
                main.m_MachController.syncMachStateWithMotorPositions();
                MachState machState = main.m_MachController.getMachState();
                double d2 = machState.getParamDouble(2000 + n) - d;
                System.out.println("PROBED VALUE  " + machState.getParamDouble(2000 + n));
                int n2 = machState.getParamInt(5220);
                int n3 = MachState.getWorkOffsetBaseIndex(n2);
                machState.setParam(n3 + n, main.m_MachController.getMachState().getParamDouble(n3 + n) + d2);
            }
        });
    }

    public static void setWorkOffset(Main main, int n, int n2, double d) {
        main.m_MachController.syncMachStateWithMotorPositions();
        main.m_MachController.getMachState().setWorkOffsetFromLocal(n, d);
    }
}

