/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.UWKit;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class Worker {
    private Thread m_Thread;
    private BlockingQueue<Task> m_TaskQueue = new LinkedBlockingDeque<Task>();

    public void setPriority(int n) {
        System.out.println("setting worker thread priority to " + n);
        this.m_Thread.setPriority(n);
    }

    public void execute(Task task) {
        this.m_TaskQueue.add(task);
    }

    private static Object executeTask(Task task) {
        try {
            return task.doInBackground();
        }
        catch (Exception exception) {
            return exception;
        }
    }

    public Worker() {
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        final Task task = Worker.this.m_TaskQueue.take();
                        final Object object = Worker.executeTask(task);
                        UWKit.scheduleInEDT(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    task.onBackroundTaskCompleted(object);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        });
        this.m_Thread.setUncaughtExceptionHandler((thread, throwable) -> {
            System.err.println("class Worker: uncaught exception");
            throwable.printStackTrace();
        });
        this.m_Thread.start();
    }

    void execute() {
        this.m_Thread.start();
    }

    public static interface Task {
        public Object doInBackground();

        public void onBackroundTaskCompleted(Object var1);
    }
}

