/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.configfile;

import eazycnc.gcode.MachState;
import java.io.BufferedReader;
import java.io.StringReader;

public class OldFormatConfiFileReader {
    private static MachState m_MachState;

    public static int stringAsColorInt(String string) {
        try {
            if (string.startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.startsWith("#")) {
                return Integer.parseInt(string.substring(1), 16);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0xFFFFFF;
        }
    }

    public static String colorIntAsString(int n) {
        String string = String.format("#%06X", n);
        return string;
    }

    private static String removeLeadingWhite(String string) {
        while (string.startsWith(" ")) {
            string = string.substring(1);
        }
        return string;
    }

    private static String removeTrailingWhite(String string) {
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static int parseSign(String string) {
        if (string.startsWith("-")) {
            return -1;
        }
        if (string.startsWith("+")) {
            return 1;
        }
        return 0;
    }

    private static int parseInt(String string) {
        string = OldFormatConfiFileReader.removeLeadingWhite(string);
        int n = OldFormatConfiFileReader.parseSign(string = OldFormatConfiFileReader.removeTrailingWhite(string));
        if (n == 0) {
            n = 1;
        } else {
            string = string.substring(1);
        }
        return n * Integer.parseInt(string);
    }

    private static double parseDouble(String string) {
        int n = OldFormatConfiFileReader.parseSign(string);
        if (n == 0) {
            n = 1;
        } else {
            string = string.substring(1);
        }
        return (double)n * Double.parseDouble(string);
    }

    private static double getParamVersionNumber() {
        return m_MachState.getParamVersionNumber();
    }

    private static void setParamVersionNumber(double d) {
        m_MachState.setParamVersionNumber(d);
    }

    private static void setParam(int n, int n2, Object object) {
        m_MachState.setParam(n, n2, object);
    }

    private static void setParam(int n, Object object) {
        m_MachState.setParam(n, object);
    }

    private static double getParamDouble(int n) {
        return m_MachState.getParamDouble(n);
    }

    private static double getParamDouble(int n, int n2) {
        return m_MachState.getParamDouble(n, n2);
    }

    private static int getParamInt(int n) {
        return m_MachState.getParamInt(n);
    }

    private static int getParamInt(int n, int n2) {
        return m_MachState.getParamInt(n, n2);
    }

    private static boolean getParamBoolean(int n) {
        return m_MachState.getParamBoolean(n);
    }

    private static String getParamString(int n) {
        return m_MachState.getParamString(n);
    }

    public static void read(MachState machState, String string) throws Exception {
        m_MachState = machState;
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            int n;
            String string2;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n2;
                int n3 = string2.indexOf("=");
                try {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8 = OldFormatConfiFileReader.parseInt(string2.substring(0, n3));
                    String string3 = OldFormatConfiFileReader.removeTrailingWhite(OldFormatConfiFileReader.removeLeadingWhite(string2.substring(n3 + 1)));
                    if (n8 == 0) {
                        OldFormatConfiFileReader.setParamVersionNumber(OldFormatConfiFileReader.parseDouble(string3));
                        continue;
                    }
                    if (OldFormatConfiFileReader.getParamVersionNumber() == 1.0 && n8 >= 15500 && n8 < 15628) continue;
                    if (OldFormatConfiFileReader.getParamVersionNumber() == 2.0 && n8 == 15137) {
                        OldFormatConfiFileReader.setParam(n8, 0);
                        continue;
                    }
                    if (OldFormatConfiFileReader.getParamVersionNumber() < 4.0) {
                        n7 = 15200;
                        n6 = 10;
                        if (n8 >= n7 && n8 < n7 + n6 * 8) {
                            n5 = (n8 - n7) / n6;
                            n4 = (n8 - n7) % n6;
                            if (n5 >= 6) continue;
                            n8 = 17000 + n5 * 32 + n4;
                        }
                        n5 = 15400;
                        n4 = 10;
                        if (n8 >= n5 && n8 < n5 + n4 * 8) {
                            int n9 = (n8 - n5) / n4;
                            int n10 = (n8 - n5) % n4;
                            if (n9 >= 6) continue;
                            n8 = 15400 + n9 * 15 + n10;
                        }
                    }
                    if (OldFormatConfiFileReader.getParamVersionNumber() == 4.0) {
                        n7 = 15200;
                        n6 = 15;
                        if (n8 >= n7 && n8 < n7 + n6 * 6) {
                            n5 = (n8 - n7) / n6;
                            n4 = (n8 - n7) % n6;
                            n8 = 17000 + n5 * 32 + n4;
                        }
                    }
                    if (OldFormatConfiFileReader.getParamVersionNumber() < 5.0 && n8 >= 17000 && n8 < 17192 && (n7 = (n8 - 17000) % 32) == 1 || n8 <= 10320) continue;
                    if (string3.startsWith("NaN")) {
                        OldFormatConfiFileReader.setParam(n8, Double.NaN);
                        continue;
                    }
                    if (string3.startsWith("\"")) {
                        OldFormatConfiFileReader.setParam(n8, string3.substring(1, string3.length() - 1));
                        continue;
                    }
                    if (string3.indexOf(".") >= 0) {
                        OldFormatConfiFileReader.setParam(n8, OldFormatConfiFileReader.parseDouble(string3));
                        continue;
                    }
                    if (string3.startsWith("TRUE")) {
                        OldFormatConfiFileReader.setParam(n8, true);
                        continue;
                    }
                    if (string3.startsWith("FALSE")) {
                        OldFormatConfiFileReader.setParam(n8, false);
                        continue;
                    }
                    OldFormatConfiFileReader.setParam(n8, (int)OldFormatConfiFileReader.parseDouble(string3));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("line " + n2 + " was bad: '" + string2 + "'");
                }
            }
            double d = 2.0;
            if (OldFormatConfiFileReader.getParamVersionNumber() < d) {
                System.out.println("...config file format " + OldFormatConfiFileReader.getParamVersionNumber() + " upgrading to format " + d);
                for (int i = 0; i < 4; ++i) {
                    OldFormatConfiFileReader.setParam(0x20000000, i, OldFormatConfiFileReader.getParamDouble(15290));
                    OldFormatConfiFileReader.setParam(0x20000001, i, OldFormatConfiFileReader.getParamDouble(15291));
                    OldFormatConfiFileReader.setParam(0x20000002, i, OldFormatConfiFileReader.getParamDouble(15292));
                    OldFormatConfiFileReader.setParam(0x20000003, i, OldFormatConfiFileReader.getParamDouble(15293));
                    OldFormatConfiFileReader.setParam(0x20000004, i, OldFormatConfiFileReader.getParamDouble(15294));
                }
                OldFormatConfiFileReader.setParamVersionNumber(d);
            }
            d = 3.0;
            if (OldFormatConfiFileReader.getParamVersionNumber() < d) {
                System.out.println("...config file format " + OldFormatConfiFileReader.getParamVersionNumber() + " upgrading to format " + d);
                int n11 = OldFormatConfiFileReader.getParamInt(15306);
                OldFormatConfiFileReader.setParam(0x10000000, n11, "SHIFT LEFT");
                OldFormatConfiFileReader.setParam(0x10000001, n11, "JOG_A_MINUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n11, "SHIFT RIGHT");
                OldFormatConfiFileReader.setParam(0x10000001, n11, "JOG_A_PLUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n11, "SHIFT DOWN");
                OldFormatConfiFileReader.setParam(0x10000001, n11, "JOG_Z_MINUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n11, "SHIFT UP");
                OldFormatConfiFileReader.setParam(0x10000001, n11, "JOG_Z_PLUS");
                OldFormatConfiFileReader.setParam(15306, ++n11);
                OldFormatConfiFileReader.setParamVersionNumber(d);
            }
            d = 4.0;
            if (OldFormatConfiFileReader.getParamVersionNumber() < d) {
                System.out.println("...config file format " + OldFormatConfiFileReader.getParamVersionNumber() + " upgrading to format " + d);
                for (int i = 4; i < 6; ++i) {
                    OldFormatConfiFileReader.setParam(-2147483645, i, false);
                }
                if (OldFormatConfiFileReader.getParamBoolean(15165)) {
                    OldFormatConfiFileReader.setParam(-2147483638, 3, -1);
                    OldFormatConfiFileReader.setParam(-2147483637, 3, -1);
                    OldFormatConfiFileReader.setParam(-2147483637, 0, 3);
                }
                OldFormatConfiFileReader.setParamVersionNumber(d);
            }
            d = 5.0;
            if (OldFormatConfiFileReader.getParamVersionNumber() < d) {
                System.out.println("...config file format " + OldFormatConfiFileReader.getParamVersionNumber() + " upgrading to format " + d);
                for (int i = 0; i < 6; ++i) {
                    OldFormatConfiFileReader.setParam(-2147483647, i, 0.0);
                }
                OldFormatConfiFileReader.setParamVersionNumber(d);
            }
            d = 6.0;
            if (OldFormatConfiFileReader.getParamVersionNumber() < d) {
                System.out.println("...config file format " + OldFormatConfiFileReader.getParamVersionNumber() + " upgrading to format " + d);
                OldFormatConfiFileReader.setParamVersionNumber(d);
            }
            for (n = 0; n < 4; ++n) {
                if (!(OldFormatConfiFileReader.getParamDouble(0x20000004, n) <= 0.0)) continue;
                OldFormatConfiFileReader.setParam(0x20000004, n, 0.1);
            }
            for (n = 0; n < 4; ++n) {
                if (!(OldFormatConfiFileReader.getParamDouble(-2147483641, n) < OldFormatConfiFileReader.getParamDouble(-2147483642, n))) continue;
                double d2 = OldFormatConfiFileReader.getParamDouble(-2147483642, n);
                OldFormatConfiFileReader.setParam(-2147483642, n, OldFormatConfiFileReader.getParamDouble(-2147483641, n));
                OldFormatConfiFileReader.setParam(-2147483641, n, d2);
            }
            try {
                if ("English (US)".equals(OldFormatConfiFileReader.getParamString(15299))) {
                    OldFormatConfiFileReader.setParam(15299, "English");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            double d3 = 7.0;
            if (OldFormatConfiFileReader.getParamVersionNumber() < d3) {
                System.out.println("...config file format " + OldFormatConfiFileReader.getParamVersionNumber() + " upgrading to format " + d3);
                OldFormatConfiFileReader.setParamVersionNumber(d3);
                int n12 = OldFormatConfiFileReader.getParamInt(15306);
                OldFormatConfiFileReader.setParam(0x10000000, n12, "HB04:Spindle");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_SPINDLE_TOGGLE");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Start/Pause");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_RUN_HOLD_TOGGLE");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Stop");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_STOP");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Goto Origin");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_GOTO_ORIGIN_XY");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Set Origin");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_PROBE_ORIGIN");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Safe-Z");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_GOTO_SAFE_Z");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Probe-Z");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_PROBE_Z");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:RESET");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_HOME");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:= 0");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_ZERO");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:= 1/2");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_EDGE");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Step++");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_STEP");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04:Rewind");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_NEXT_TOOL");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Feed-");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "FEED_OVERRIDE_MINUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Feed+");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "FEED_OVERRIDE_PLUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Spindle-");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "SPINDLE_OVERRIDE_MINUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Spindle+");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "SPINDLE_OVERRIDE_PLUS");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Start/Pause");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_RUN_HOLD_TOGGLE");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Stop");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_STOP");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Goto Origin");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_GOTO_ORIGIN_XY");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Safe-Z");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_GOTO_SAFE_Z");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:Probe-Z");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_PROBE_Z");
                OldFormatConfiFileReader.setParam(0x10000000, ++n12, "HB04B:RESET");
                OldFormatConfiFileReader.setParam(0x10000001, n12, "MPG_HOME");
                OldFormatConfiFileReader.setParam(15306, ++n12);
            }
            if (2 == OldFormatConfiFileReader.getParamInt(15355)) {
                OldFormatConfiFileReader.setParam(15150, 0.02);
            }
        }
        m_MachState = null;
    }
}

