/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import eazycnc.gcode.FilePos;
import java.io.IOException;
import java.util.LinkedList;

public class FileReader {
    private LinkedList<ParseCursor> m_CallStack = new LinkedList();
    private ParseCursor m_ParseCursor;
    private FileAccessor m_FileAccessor;

    public FileReader(FileAccessor fileAccessor) {
        this.m_FileAccessor = fileAccessor;
    }

    public FilePos getFilePos() {
        return new FilePos(this.m_ParseCursor.getFileName(), this.m_ParseCursor.getLineNo(), this.m_ParseCursor.getLine());
    }

    public String getFileName() {
        return this.m_ParseCursor.getFileName();
    }

    public void resetFile() throws Exception {
        this.m_ParseCursor.reset();
    }

    public String peekLine() {
        return this.m_ParseCursor.peekLine();
    }

    public boolean popCallStack() {
        if (this.m_CallStack.isEmpty()) {
            return false;
        }
        ParseCursor parseCursor = this.m_CallStack.getLast();
        this.m_ParseCursor = this.m_CallStack.removeLast();
        return true;
    }

    public void pushCallStack() {
        this.m_CallStack.addLast(new ParseCursor(this.m_ParseCursor));
    }

    public String nextLine() throws Exception {
        String string;
        while (null == (string = this.m_ParseCursor.nextLine())) {
            if (this.m_CallStack.isEmpty()) {
                return null;
            }
            this.popCallStack();
        }
        return string;
    }

    public void readFromFile(String string) throws IOException {
        if (this.m_ParseCursor != null) {
            this.pushCallStack();
        }
        byte[] byArray = this.m_FileAccessor.readFile(string);
        this.m_ParseCursor = new ParseCursor(string, byArray);
    }

    public static interface FileAccessor {
        public byte[] readFile(String var1) throws IOException;
    }

    static class ParseCursor {
        private String m_FileName;
        private String m_FileAsString;
        private int m_ReadAt;
        private String m_NextLine;
        private String m_CurrentLine;
        private int m_LineNo;

        public ParseCursor(ParseCursor parseCursor) {
            this.m_FileName = parseCursor.m_FileName;
            this.m_FileAsString = parseCursor.m_FileAsString;
            this.m_ReadAt = parseCursor.m_ReadAt;
            this.m_NextLine = parseCursor.m_NextLine;
            this.m_LineNo = parseCursor.m_LineNo;
        }

        public ParseCursor(String string, byte[] byArray) throws IOException {
            this.m_FileName = string;
            this.m_FileAsString = new String(byArray, "UTF-8");
            this.reset();
        }

        public void reset() throws IOException {
            this.m_ReadAt = 0;
            this.m_LineNo = -1;
            this.nextLine();
        }

        public String peekLine() {
            return this.m_NextLine;
        }

        public String readLine() {
            int n;
            if (this.m_ReadAt >= this.m_FileAsString.length()) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n = this.m_ReadAt;
            while (this.m_ReadAt < this.m_FileAsString.length() && this.m_FileAsString.charAt(this.m_ReadAt++) != '\n') {
                n2 = this.m_ReadAt;
            }
            return this.m_FileAsString.substring(n, n2);
        }

        public String nextLine() throws IOException {
            this.m_CurrentLine = this.m_NextLine;
            this.m_NextLine = this.readLine();
            ++this.m_LineNo;
            return this.m_CurrentLine;
        }

        public String getFileName() {
            return this.m_FileName;
        }

        public int getLineNo() {
            return this.m_LineNo;
        }

        public String getLine() {
            return this.m_CurrentLine;
        }
    }
}

