/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import com.eazycnc.gcode.GCodeCompiler;
import com.eazycnc.gcode.GCodeCompilerExtension;
import eazycnc.gcode.FilePos;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import eazycnc.gcode.Parser;
import eazycnc.planner.VecMath;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Interpreter
implements GCodeCompiler {
    boolean Mach3 = false;
    boolean Mach4 = false;
    boolean Fanuc = true;
    boolean Fadal = true;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final int AXIS_A = 3;
    public static final int AXIS_B = 4;
    public static final int AXIS_C = 5;
    boolean m_Trace = false;
    public static final int NUMBER_OF_TOOLS = 255;
    public static final int NUMBER_OF_PARTS = 255;
    public static final int NUMBER_OF_AXIS = 6;
    private static final Character[] m_AxisLetter = new Character[]{Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C')};
    private Parser m_Parser;
    private int[] m_IndexFromAxis;
    private HashMap<Character, Double> m_WordValues;
    private LinkedList<Integer> m_Gcodes;
    private LinkedList<Integer> m_Mcodes;
    private Machcode m_CCodes;
    private FilePos m_FilePos;
    private double[] m_AxisWords;
    private boolean m_ExplicitMovement;
    private boolean m_G98 = true;
    private List<GCodeCompilerExtension> m_Extensions;
    private double[] m_Center;
    private int m_NextMachCodeID;
    private MachState m_State;
    private boolean[] m_ParamIsSet = new boolean[5000];

    public Interpreter() {
        this.m_WordValues = new HashMap();
        this.m_Gcodes = new LinkedList();
        this.m_Mcodes = new LinkedList();
        this.m_Center = new double[6];
        this.m_AxisWords = new double[6];
        this.m_IndexFromAxis = new int[91];
        for (int i = 0; i < this.m_IndexFromAxis.length; ++i) {
            this.m_IndexFromAxis[i] = -1;
        }
        this.m_IndexFromAxis[88] = 0;
        this.m_IndexFromAxis[89] = 1;
        this.m_IndexFromAxis[90] = 2;
        this.m_IndexFromAxis[73] = 0;
        this.m_IndexFromAxis[74] = 1;
        this.m_IndexFromAxis[75] = 2;
    }

    public void setExtensions(List<GCodeCompilerExtension> list) {
        this.m_Extensions = list;
    }

    public static String getAxisLetter(int n) {
        return m_AxisLetter[n].toString();
    }

    public void setParameter(int n, int n2) {
        if (this.m_Trace) {
            this.trace("set parameter " + n + " to " + n2);
        }
        this.addMachCode(new Machcode.SetParameter(this.m_FilePos, n, n2));
        this.m_State.setParam(n, n2);
    }

    public void setParameter(int n, boolean bl) {
        if (this.m_Trace) {
            this.trace("set parameter " + n + " to " + bl);
        }
        this.addMachCode(new Machcode.SetParameter(this.m_FilePos, n, bl));
        this.m_State.setParam(n, bl);
    }

    public void setParameter(int n, double d) {
        if (this.m_Trace) {
            this.trace("set parameter " + n + " to " + d);
        }
        this.addMachCode(new Machcode.SetParameter(this.m_FilePos, n, d));
        this.m_State.setParam(n, d);
        if (n < this.m_ParamIsSet.length) {
            this.m_ParamIsSet[n] = true;
        }
    }

    public double getDouble(int n) {
        if (n < this.m_ParamIsSet.length && !this.m_ParamIsSet[n]) {
            throw this.newParseException("Parameter " + n + " value has not been set");
        }
        return this.m_State.getParamDouble(n);
    }

    public boolean getBoolean(int n) {
        return this.m_State.getParamBoolean(n);
    }

    public int getInteger(int n) {
        return this.m_State.getParamInt(n);
    }

    public int expectInteger(double d) {
        double d2 = Math.rint(d);
        if (Math.abs(d2 - d) > VecMath.ZERO_TOLERANCE || d2 < -2.147483648E9 || d2 > 2.147483647E9) {
            throw this.newParseException("Expected integer value but got " + d);
        }
        return (int)d2;
    }

    public void addMachCode(Machcode machcode) {
        machcode.validate();
        machcode.m_MachCodeID = this.m_NextMachCodeID++;
        if (this.m_CCodes == null) {
            this.m_CCodes = machcode;
        } else {
            this.m_CCodes.append(machcode);
        }
    }

    public Double pushWordValue(char c, double d) {
        return this.m_WordValues.put(Character.valueOf(c), d);
    }

    @Override
    public Double getWordValue(char c) {
        return this.m_WordValues.remove(Character.valueOf(c));
    }

    @Override
    public Double peekWordValue(char c) {
        return this.m_WordValues.get(Character.valueOf(c));
    }

    @Override
    public boolean getGCode(double d) {
        int n = (int)(d * 10.0);
        int n2 = this.m_Gcodes.indexOf(n);
        if (n2 >= 0) {
            this.m_Gcodes.remove(n2);
            return true;
        }
        return false;
    }

    private boolean getGCodeObsolete(int n, int n2) {
        int n3 = n * 10 + n2;
        int n4 = this.m_Gcodes.indexOf(n3);
        if (n4 >= 0) {
            this.m_Gcodes.remove(n4);
            return true;
        }
        return false;
    }

    @Override
    public boolean getMCode(double d) {
        int n = (int)(d * 10.0);
        int n2 = this.m_Mcodes.indexOf(n);
        if (n2 >= 0) {
            this.m_Mcodes.remove(n2);
            return true;
        }
        return false;
    }

    public int indexFromAxis(char c) {
        int n = 0;
        if (c < 'A' || c > 'Z' || (n = this.m_IndexFromAxis[c]) < 0) {
            throw this.newParseException("BUG - bad axis word: " + c);
        }
        return n;
    }

    private int count(Boolean ... booleanArray) {
        int n = 0;
        for (int i = 0; i < booleanArray.length; ++i) {
            if (!booleanArray[i].booleanValue()) continue;
            ++n;
        }
        return n;
    }

    private int count(Object ... objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            ++n;
        }
        return n;
    }

    private Integer getIntegerWordValue(Character c) {
        Double d = this.getWordValue(c.charValue());
        if (d == null) {
            return null;
        }
        return this.expectInteger(d);
    }

    private void trace(String string) {
        if (this.m_Trace) {
            System.out.println("Trace: " + string);
        }
    }

    @Override
    public void warning(String string) {
        System.out.println("Warning: " + string);
    }

    public void notSupported(String string) {
        System.out.println("Not supported: " + string);
    }

    void reset(MachState machState) {
        int n;
        this.m_State = machState;
        for (n = 0; n < this.m_ParamIsSet.length; ++n) {
            this.m_ParamIsSet[n] = false;
        }
        this.m_ParamIsSet[0] = true;
        for (n = 2000; n < 2006; ++n) {
            this.m_ParamIsSet[n] = true;
        }
        double[] dArray = this.m_State.getLocalPos();
        double d = this.m_State.getParamDouble(15141);
        for (int i = 0; i < 6; ++i) {
            this.m_AxisWords[i] = dArray[i] / d;
        }
        this.m_NextMachCodeID = 1;
        this.m_CCodes = null;
        machState.setParam(15122, 0);
        this.addMachCode(new Machcode.MachCodeStartNode(this.getAxisPos()));
    }

    public void initInterpreter(Parser parser) {
        this.m_Parser = parser;
    }

    private Parser.ParseException newParseException(String string) {
        return this.m_Parser.newParseException(string);
    }

    private String format(double d) {
        String string = Double.toString(d);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private void processGcode(double d) {
        double d2 = d * 10.0;
        int n = (int)Math.round(d2);
        if (Math.abs(d2 - (double)n) > 0.001) {
            throw this.newParseException("Bad G-code number '" + this.format(d) + "'");
        }
        if (this.m_Gcodes.contains(n)) {
            throw this.newParseException("G-code '" + this.format(d) + "' used twice on the same line");
        }
        this.m_Gcodes.add(n);
    }

    private void processMcode(double d) {
        double d2 = d * 10.0;
        int n = (int)Math.round(d2);
        if (Math.abs(d2 - (double)n) > 0.001) {
            throw this.newParseException("Bad M-code number '" + this.format(d) + "'");
        }
        if (this.m_Mcodes.contains(n)) {
            throw this.newParseException("M-code '" + this.format(d) + "' used twice on the same line");
        }
        this.m_Mcodes.add(n);
    }

    void processWord(Character c, double d) {
        switch (c.charValue()) {
            case 'G': {
                this.processGcode(d);
                break;
            }
            case 'M': {
                this.processMcode(d);
                break;
            }
            default: {
                if (this.m_WordValues.containsKey(c)) {
                    throw this.newParseException("Word '" + c + "' used twice on the same line");
                }
                this.pushWordValue(c.charValue(), d);
            }
        }
    }

    void startLine(FilePos filePos) {
        this.m_ExplicitMovement = false;
        this.m_WordValues.clear();
        this.m_Gcodes.clear();
        this.m_Mcodes.clear();
        this.m_FilePos = filePos;
    }

    private void handleSetFeedRateMode() {
        boolean bl = this.getGCode(93.0);
        boolean bl2 = this.getGCode(94.0);
        boolean bl3 = this.getGCode(94.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of G93,G94 or G95 on the same line");
        }
        if (bl) {
            throw this.newParseException("G93 code (inverse time mode) not supported");
        }
        if (bl3) {
            throw this.newParseException("G95 code (rev per minute mode) not supported");
        }
        if (bl2) {
            this.setParameter(15123, 1);
        }
    }

    private void handleSetFeedRate() {
        Double d = this.getWordValue('F');
        if (d != null) {
            if (d <= 0.0) {
                throw this.newParseException("F-word (Feed Rate) must be positive");
            }
            this.setParameter(15145, d);
        }
    }

    private void handleSetSpindleSpeed() {
        Double d = this.getWordValue('S');
        if (d != null) {
            if (d < this.getDouble(15156) || d > this.getDouble(15157)) {
                throw this.newParseException("S-word (spindle speed) " + d + " out of range " + (int)this.getDouble(15156) + " ... " + (int)this.getDouble(15157));
            }
            this.setParameter(15127, d);
        }
    }

    private void handleSelectTool() {
        Integer n = this.getIntegerWordValue(Character.valueOf('T'));
        if (n != null) {
            if (n < 0 || n > 255) {
                throw this.newParseException("T-word (tool number) " + n + " out of range 0 ... 254");
            }
            this.setParameter(15147, n);
        }
    }

    private void handleChangeTool() {
        boolean bl = this.getMCode(6.0);
        if (bl) {
            if (this.m_Trace) {
                this.trace("Tool change: ");
            }
            this.notSupported("M6-code (tool change)");
        }
    }

    private void handleSpindleStartStop() {
        boolean bl = this.getMCode(3.0);
        boolean bl2 = this.getMCode(4.0);
        boolean bl3 = this.getMCode(5.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of M3,M4 or M5 on the same line");
        }
        if (bl) {
            this.setParameter(15128, 1);
            this.setParameter(15126, true);
        }
        if (bl2) {
            this.setParameter(15128, 2);
            this.setParameter(15126, true);
        }
        if (bl3) {
            this.setParameter(15126, false);
        }
    }

    private void handleCoolantOnOff() {
        boolean bl = this.getMCode(7.0);
        boolean bl2 = this.getMCode(8.0);
        boolean bl3 = this.getMCode(9.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of M7,M8 or M9 on the same line");
        }
        if (bl) {
            this.setParameter(15125, 0);
            this.setParameter(15124, true);
        }
        if (bl2) {
            this.setParameter(15125, 1);
            this.setParameter(15124, true);
        }
        if (bl3) {
            this.setParameter(15124, false);
        }
    }

    private void handleSetOverride() {
        boolean bl = this.getMCode(48.0);
        boolean bl2 = this.getMCode(49.0);
        if (bl && bl2) {
            throw this.newParseException("Both M48 and M49 on the same line");
        }
        if (bl) {
            this.setParameter(15131, true);
            this.setParameter(15162, true);
        }
        if (bl2) {
            this.setParameter(15131, false);
            this.setParameter(15162, false);
        }
    }

    private double getWordPAsDwellTime() {
        Double d = this.getWordValue('P');
        if (d == null) {
            throw this.newParseException("P-word (dwell) required");
        }
        if (d < 0.0) {
            throw this.newParseException("P-word (dwell) " + d + " cannot be negative");
        }
        if (this.getBoolean(15159)) {
            d = d / 1000.0;
        }
        return d;
    }

    private void handleDwell() {
        boolean bl = this.getGCode(4.0);
        if (bl) {
            Double d = this.getWordPAsDwellTime();
            this.addMachCode(new Machcode.Dwell(this.m_FilePos, d));
            if (this.m_Trace) {
                this.trace("G4 (dwell) P=" + d);
            }
        }
    }

    private void handleSetActivePlane() {
        boolean bl = this.getGCode(17.0);
        boolean bl2 = this.getGCode(18.0);
        boolean bl3 = this.getGCode(19.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of G17,G18 or G19 on the same line");
        }
        if (bl) {
            this.setParameter(15101, 0);
        }
        if (bl2) {
            if (this.getBoolean(15130)) {
                throw this.newParseException("Cannot select XZ plane with rotation (G68) on");
            }
            this.setParameter(15101, 1);
        }
        if (bl3) {
            if (this.getBoolean(15130)) {
                throw this.newParseException("Cannot select YZ plane with rotation (G68) on");
            }
            this.setParameter(15101, 2);
        }
    }

    private void handleSetLengthUnits() {
        boolean bl = this.getGCode(20.0);
        boolean bl2 = this.getGCode(21.0);
        if (bl && bl2) {
            throw this.newParseException("Both G20 and G21 on the same line");
        }
        if (bl) {
            this.setParameter(15141, 25.4);
        }
        if (bl2) {
            this.setParameter(15141, 1.0);
        }
        if (this.m_Trace && (bl || bl2)) {
            this.trace("set units mode: " + (bl ? "inch" : "mm"));
        }
    }

    private void handleSetRadiusCompensation() {
        boolean bl = this.getGCode(40.0);
        boolean bl2 = this.getGCode(41.0);
        boolean bl3 = this.getGCode(42.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of G40, G41 or G42 on the same line");
        }
        if (this.m_Trace && n > 0) {
            this.trace("set radius compensation mode: " + (bl2 || bl3));
        }
        if (bl) {
            this.setParameter(15136, 0.0);
        } else if (bl2 || bl3) {
            if (this.getDouble(15136) != 0.0) {
                throw this.newParseException("radius compensation already on");
            }
            if (this.getInteger(15101) != 0) {
                throw this.newParseException("radius compensation only allowed when active plane is XY");
            }
            Integer n2 = this.getIntegerWordValue(Character.valueOf('D'));
            Double d = this.getWordValue('P');
            if (n2 != null && d != null) {
                throw this.newParseException("Both P and D word with G41 or G42");
            }
            double d2 = 0.0;
            if (d == null) {
                int n3;
                int n4 = n3 = n2 != null ? n2.intValue() : this.getInteger(15147);
                if (n3 < 0 || n3 > 255) {
                    throw this.newParseException("D-word (tool number) " + n3 + " out of range 0 ... 255");
                }
                d2 = n3 == 0 ? 0.0 : this.m_State.getParamDouble(0x40000000, n3 - 1) / 2.0;
            } else {
                d2 = d * this.getDouble(15141);
            }
            if (bl2) {
                this.setParameter(15136, -d2);
            }
            if (bl3) {
                this.setParameter(15136, d2);
            }
        }
    }

    private void handlePolarMode() {
        boolean bl;
        boolean bl2 = this.getGCode(15.0);
        if (bl2 & (bl = this.getGCode(16.0))) {
            throw this.newParseException("Both G15 and G16 on the same line");
        }
        if (bl2) {
            this.setParameter(15129, false);
        }
        if (bl) {
            this.setParameter(15129, true);
            this.setParameter(15142, this.m_State.m_LocalPosition[0]);
            this.setParameter(15143, this.m_State.m_LocalPosition[1]);
        }
    }

    private void handleSetLengthCompensation() {
        boolean bl = this.getGCode(43.0);
        boolean bl2 = this.getGCode(44.0);
        boolean bl3 = this.getGCode(49.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of G43, G44 or G49 on the same line");
        }
        if (bl3) {
            this.setParameter(15137, 0);
        }
        if (bl || bl2) {
            Integer n2 = this.getIntegerWordValue(Character.valueOf('H'));
            double d = 0.0;
            if (n2 == null) {
                n2 = 0;
            }
            if (n2 < 0 || n2 > 255) {
                throw this.newParseException("H-word (tool number) " + n2 + " out of range 0 ... 255");
            }
            if (bl2) {
                throw this.newParseException("G44 is not supported");
            }
            this.setParameter(15137, n2);
        }
    }

    private void handleSetOffset() {
        boolean bl = this.getGCode(52.0);
        boolean bl2 = this.getGCode(92.0);
        boolean bl3 = this.getGCode(92.1);
        boolean bl4 = this.getGCode(92.2);
        boolean bl5 = this.getGCode(92.3);
        int n = this.count(bl, bl2, bl3, bl4, bl5);
        if (n > 0) {
            int n2;
            if (n > 1) {
                throw this.newParseException("More than one of G52, G92, G92.1, G92.2 or G92.3 on the same line");
            }
            if (bl) {
                n2 = this.getBoolean(15135);
                for (int i = 0; i < 6; ++i) {
                    Double d = this.getWordValue(m_AxisLetter[i].charValue());
                    if (d == null) continue;
                    double d2 = i < 3 ? this.getDouble(15141) : 1.0;
                    this.setParameter(5211 + i, d * d2 * (n2 != 0 ? this.getDouble(5191 + i) : 1.0));
                }
            }
            if (bl2) {
                for (n2 = 0; n2 < 6; ++n2) {
                    Double d = this.getWordValue(m_AxisLetter[n2].charValue());
                    if (d == null) continue;
                    this.m_State.setOffsetFromLocal(n2, d);
                }
            }
            if (bl3) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.setParameter(5211 + n2, 0.0);
                }
            }
            if (bl4) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.setParameter(15000 + n2, this.getDouble(5211 + n2));
                }
            }
            if (bl5) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.setParameter(5211 + n2, this.getDouble(15000 + n2));
                }
            }
        }
    }

    private void handleSetScaling() {
        int n;
        boolean bl = this.getGCode(50.0);
        boolean bl2 = this.getGCode(51.0);
        if (bl && bl2) {
            throw this.newParseException("Both G50 & G51 on the same line");
        }
        if (bl2) {
            this.setParameter(15135, true);
            for (n = 0; n < 6; ++n) {
                Double d = this.getWordValue(m_AxisLetter[n].charValue());
                if (d == null) continue;
                this.setParameter(5191 + n, d);
            }
        }
        if (bl) {
            this.setParameter(15135, false);
            for (n = 0; n < 6; ++n) {
                this.setParameter(5191 + n, 1.0);
            }
        }
    }

    private void handleSetRotation() {
        boolean bl = this.getGCode(68.0);
        boolean bl2 = this.getGCode(69.0);
        if (bl && bl2) {
            throw this.newParseException("Both G68 & G69 on the same line");
        }
        if (bl) {
            Double d;
            this.setParameter(15130, true);
            if (this.getInteger(15101) != 0) {
                throw this.newParseException("Rotation only allowed when active plane is XY");
            }
            Double d2 = null;
            Double d3 = null;
            boolean bl3 = false;
            if (this.Mach3) {
                d2 = this.getWordValue('A');
                if (d2 == null) {
                    throw this.newParseException("A word (rotation center x) missing");
                }
                d3 = this.getWordValue('B');
                if (d3 == null) {
                    throw this.newParseException("B word (rotation center y) missing");
                }
                boolean bl4 = bl3 = this.getWordValue('I') != null;
            }
            if (this.Fanuc) {
                d2 = this.getWordValue('X');
                if (d2 == null) {
                    throw this.newParseException("X word (rotation center x) missing");
                }
                d3 = this.getWordValue('Y');
                if (d3 == null) {
                    throw this.newParseException("Y word (rotation center y) missing");
                }
                bl3 = this.getBoolean(15133);
            }
            if ((d = this.getWordValue('R')) == null) {
                throw this.newParseException("R word (rotation angle) missing");
            }
            if (bl3) {
                d = Math.toDegrees(this.getDouble(15138)) + d;
            }
            this.setParameter(15138, Math.toRadians(d));
            this.setParameter(15139, d2 * this.getDouble(15141));
            this.setParameter(15140, d3 * this.getDouble(15141));
        }
        if (bl2) {
            this.setParameter(15130, false);
        }
        if (this.m_Trace && bl2) {
            this.trace("clear rotation: ");
        }
    }

    private void handleSelectCoordinateSystem() {
        boolean bl = this.getGCode(54.0);
        boolean bl2 = this.getGCode(55.0);
        boolean bl3 = this.getGCode(56.0);
        boolean bl4 = this.getGCode(57.0);
        boolean bl5 = this.getGCode(58.0);
        boolean bl6 = this.getGCode(59.0);
        boolean bl7 = this.getGCode(59.1);
        boolean bl8 = this.getGCode(59.2);
        boolean bl9 = this.getGCode(59.3);
        int n = this.count(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
        if (n > 1) {
            throw this.newParseException("More than one of G54, G55, G56, G57, G58, G59, G59.1, G59.2 or G59.3 on the same line");
        }
        if (n > 0) {
            int n2 = 0;
            if (bl) {
                n2 = 1;
            }
            if (bl2) {
                n2 = 2;
            }
            if (bl3) {
                n2 = 3;
            }
            if (bl4) {
                n2 = 4;
            }
            if (bl5) {
                n2 = 5;
            }
            if (bl7) {
                n2 = 7;
            }
            if (bl8) {
                n2 = 8;
            }
            if (bl9) {
                n2 = 9;
            }
            if (bl6) {
                n2 = 6;
                Integer n3 = this.getIntegerWordValue(Character.valueOf('P'));
                if (n3 != null) {
                    if (n3 < 1 || n3 >= 255) {
                        throw this.newParseException("P-word (coordinate system number) " + n3 + " out of range 1 ... 254");
                    }
                    n2 = n3;
                }
            }
            this.setParameter(5220, n2);
        }
    }

    private void handleSetPathControlMode() {
        boolean bl = this.getGCode(61.0);
        boolean bl2 = this.getGCode(61.1);
        boolean bl3 = this.getGCode(64.0);
        int n = this.count(bl, bl2, bl3);
        if (n > 1) {
            throw this.newParseException("More than one of G61, G61_1 or G64 on the same line");
        }
        if (bl) {
            this.setParameter(15102, 0);
        }
        if (bl2) {
            this.setParameter(15102, 1);
        }
        if (bl3) {
            this.setParameter(15102, 2);
            Double d = this.getWordValue('P');
            if (d != null) {
                this.setParameter(15144, d);
            }
        }
    }

    private void handleSetDistanceMode() {
        boolean bl = this.getGCode(90.0);
        boolean bl2 = this.getGCode(91.0);
        if (bl && bl2) {
            throw this.newParseException("Both G90 and G91 on the same line");
        }
        if (bl) {
            this.setParameter(15133, false);
        }
        if (bl2) {
            this.setParameter(15133, true);
        }
    }

    private void handleSetArcCenterMode() {
        boolean bl = this.getGCode(90.1);
        boolean bl2 = this.getGCode(91.1);
        if (bl && bl2) {
            throw this.newParseException("Both G90.1 and G91.1 on the same line");
        }
        if (bl) {
            this.setParameter(15134, false);
        }
        if (bl2) {
            this.setParameter(15134, true);
        }
    }

    private void handleSetRetractMode() {
        boolean bl = this.getGCode(98.0);
        boolean bl2 = this.getGCode(99.0);
        if (bl && bl2) {
            throw this.newParseException("Both G98 and G99 on the same line");
        }
        if (bl && bl2) {
            this.notSupported("G98, G99-code (retract mode)");
        }
        if (this.m_Trace && (bl || bl2)) {
            this.trace("set retract mode (not supported)");
        }
    }

    private void handleSetPartOrToolOffsets() {
        boolean bl = this.getGCode(10.0);
        if (bl) {
            Integer n = this.getIntegerWordValue(Character.valueOf('L'));
            if (n == null) {
                throw this.newParseException("Missing L word");
            }
            Integer n2 = this.getIntegerWordValue(Character.valueOf('P'));
            if (n2 == null) {
                throw this.newParseException("Missing P word");
            }
            switch (n) {
                case 1: {
                    if (n2 < 1 || n2 > 255) {
                        throw this.newParseException("P word (tool number)" + n2 + " out of range 1 ... 255");
                    }
                    Double d = this.getWordValue('A');
                    Double d2 = this.getWordValue('Z');
                    Double d3 = this.getWordValue('X');
                    if (d2 != null) {
                        this.m_State.setParam(0x40000001, n2 - 1, d2 * this.getDouble(15141));
                    }
                    if (d3 == null) break;
                    this.m_State.setParam(0x40000000, n2 - 1, 2.0 * d3 * this.getDouble(15141));
                    break;
                }
                case 2: {
                    if (n2 < 1 || n2 > 255) {
                        throw this.newParseException("P word (part offset number) " + n2 + " out of range 1 ... 255");
                    }
                    int n3 = 5221 + (n2 - 1) * 20;
                    boolean bl2 = this.getBoolean(15135);
                    for (int i = 0; i < 6; ++i) {
                        Double d = this.getWordValue(m_AxisLetter[i].charValue());
                        if (d == null) continue;
                        this.setParameter(n3 + i, d * this.getDouble(15141) * (bl2 ? this.getDouble(5191 + i) : 0.0));
                    }
                    break;
                }
                case 999920: {
                    if (n2 < 1 || n2 > 255) {
                        throw this.newParseException("P word (part offset number) " + n2 + " out of range 1 ... 255");
                    }
                    boolean bl3 = this.getBoolean(15135);
                    Double[] doubleArray = new Double[6];
                    for (int i = 0; i < 6; ++i) {
                        Double d = this.getWordValue(m_AxisLetter[i].charValue());
                        if (d != null && bl3) {
                            d = d * this.getDouble(15141);
                        }
                        doubleArray[i] = d;
                    }
                    this.addMachCode(new Machcode.ResetWorkOffset(this.m_FilePos, n2, doubleArray));
                    break;
                }
                case 20: {
                    int n4;
                    if (n2 < 1 || n2 > 255) {
                        throw this.newParseException("P word (part offset number) " + n2 + " out of range 1 ... 255");
                    }
                    boolean bl4 = this.getBoolean(15135);
                    Double[] doubleArray = new Double[6];
                    for (n4 = 0; n4 < 6; ++n4) {
                        Double d = this.getWordValue(m_AxisLetter[n4].charValue());
                        if (d != null && bl4) {
                            d = d * this.getDouble(15141);
                        }
                        doubleArray[n4] = d;
                    }
                    for (n4 = 0; n4 < 6; ++n4) {
                        if (doubleArray[n4] == null) continue;
                        double d = doubleArray[n4];
                        double d4 = this.m_State.m_LocalPosition[n4] - d;
                        int n5 = MachState.getWorkOffsetBaseIndex(n2);
                        this.setParameter(n5 + n4, this.m_State.getParamDouble(n5 + n4) + d4);
                        this.m_State.m_LocalPosition[n4] = d;
                    }
                    break;
                }
                default: {
                    throw this.newParseException("L word " + n + " not 1, 2 or 20");
                }
            }
        }
    }

    private void handleGotoReferenceLocation() {
        boolean bl = this.getGCode(28.0);
        boolean bl2 = this.getGCode(30.0);
        boolean bl3 = this.getGCode(28.1);
        boolean bl4 = this.getGCode(30.1);
        if (bl && bl2) {
            throw this.newParseException("Both G28 and G30 on the same line");
        }
        if (bl || bl2 || bl3 || bl4) {
            if (bl) {
                int n = 5161;
                throw this.newParseException("G28 not supported");
            }
            if (bl2) {
                int n = 5181;
                throw this.newParseException("G30 not supported");
            }
            if (bl4) {
                throw this.newParseException("G30.1 not supported");
            }
            if (bl3) {
                boolean[] blArray = new boolean[6];
                boolean bl5 = false;
                for (int i = 0; i < 6; ++i) {
                    blArray[i] = this.getWordValue(m_AxisLetter[i].charValue()) != null;
                }
                this.addMachCode(new Machcode.SeekHome(this.m_FilePos, blArray));
            }
        }
    }

    private boolean getXYZABC(boolean bl) {
        int n;
        int n2 = 0;
        boolean bl2 = this.getBoolean(15135);
        for (n = 0; n < 6; ++n) {
            Double d = this.getWordValue(m_AxisLetter[n].charValue());
            if (d == null) continue;
            double d2 = n < 3 ? this.getDouble(15141) : 1.0;
            double d3 = d * (bl2 ? this.getDouble(5191 + n) : 1.0) * d2;
            if (this.getBoolean(15133)) {
                int n3 = n;
                this.m_AxisWords[n3] = this.m_AxisWords[n3] + d3;
            } else {
                this.m_AxisWords[n] = d3;
            }
            ++n2;
        }
        if (n2 > 0) {
            if (bl) {
                int n4;
                switch (this.getInteger(15101)) {
                    default: {
                        throw this.newParseException("BUG, bad ACTIVE_PLANE: " + this.getInteger(15101));
                    }
                    case 0: {
                        n = 0;
                        n4 = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        n = 1;
                        n4 = 2;
                    }
                }
                this.m_State.m_LocalPosition[0] = this.m_AxisWords[n] * Math.cos(Math.toRadians(this.m_AxisWords[n4])) + this.getDouble(15142);
                this.m_State.m_LocalPosition[1] = this.m_AxisWords[n] * Math.sin(Math.toRadians(this.m_AxisWords[n4])) + this.getDouble(15143);
            } else {
                for (n = 0; n < 6; ++n) {
                    this.m_State.m_LocalPosition[n] = this.m_AxisWords[n];
                }
            }
            if (this.m_Trace && n2 > 0) {
                this.trace("get xyz: " + this.m_State.m_LocalPosition[0] + " " + this.m_State.m_LocalPosition[1] + " " + this.m_State.m_LocalPosition[2]);
            }
            return true;
        }
        return false;
    }

    private double[] getAxisPos() {
        return this.m_State.localToAxis(this.m_State.m_LocalPosition);
    }

    private void traceMotionMode() {
        String string = this.m_ExplicitMovement ? "explicit " : "";
        double d = this.getDouble(15122);
        if (d == 0.0) {
            this.trace(string + "linear move at max velocity");
        } else if (d == 1.0) {
            this.trace(string + "linear move at feed rate");
        } else if (d == 2.0) {
            this.trace(string + "cw arc at feed rate");
        } else if (d == 3.0) {
            this.trace(string + "ccw arc at feed rate");
        } else {
            throw this.newParseException("BUG - unimplemented motion mode: " + d);
        }
    }

    private void handleLinearInterpolation(boolean bl, double d) {
        Double[] doubleArray = null;
        if (this.getGCode(53.0)) {
            if (this.getBoolean(15129)) {
                throw this.newParseException("G53 not allowed in polar mode");
            }
            if (this.getBoolean(15133)) {
                throw this.newParseException("G53 not allowed in incrementa mode");
            }
            doubleArray = new Double[6];
            for (int i = 0; i < 6; ++i) {
                doubleArray[i] = this.peekWordValue(m_AxisLetter[i].charValue());
            }
        }
        if (this.getXYZABC(this.getBoolean(15129))) {
            if (this.m_Trace) {
                this.traceMotionMode();
            }
            double[] dArray = this.m_State.localToAxis(this.m_State.m_LocalPosition);
            if (doubleArray != null) {
                for (int i = 0; i < 6; ++i) {
                    if (doubleArray[i] == null) continue;
                    dArray[i] = doubleArray[i];
                }
            }
            this.addMachCode(new Machcode.LinearMove(this.m_FilePos, this.getInteger(15101), this.getToolCompensation(), bl ? 0.0 : this.getPathTolerance(), d, dArray));
        }
    }

    private static double sqr(double d) {
        return d * d;
    }

    private void handleArcInterpolation(boolean bl, double d, char c, char c2, char c3, char c4) {
        boolean bl2;
        boolean bl3 = this.peekWordValue(c) != null;
        boolean bl4 = this.peekWordValue(c2) != null;
        boolean bl5 = this.peekWordValue(c3) != null;
        boolean bl6 = this.peekWordValue(c4) != null;
        boolean bl7 = bl2 = this.peekWordValue('R') != null;
        if (bl3 || bl4 || bl5 || bl6 || bl2) {
            double d2;
            double d3;
            double d4;
            double d5;
            boolean bl8;
            this.getXYZABC(false);
            if (this.m_Trace) {
                this.traceMotionMode();
            }
            double d6 = this.getDouble(15141) / 500.0;
            int n = this.indexFromAxis(c);
            int n2 = this.indexFromAxis(c2);
            int n3 = this.indexFromAxis(c3);
            int n4 = this.indexFromAxis(c4);
            Double d7 = this.getWordValue(c3);
            Double d8 = this.getWordValue(c4);
            Double d9 = this.getWordValue('R');
            boolean bl9 = bl8 = bl5 || bl6;
            if (d9 != null && bl8) {
                throw this.newParseException("Both R and  " + c3 + "or" + c4 + " used in " + c + c2 + "-plane arc interpolation");
            }
            Machcode.SegmentType segmentType = null;
            boolean bl10 = this.getBoolean(15135);
            if (d9 == null) {
                d7 = (d7 != null ? d7 : 0.0) * (bl10 ? this.getDouble(5191 + n3) : 1.0) * this.getDouble(15141);
                d8 = (d8 != null ? d8 : 0.0) * (bl10 ? this.getDouble(5191 + n4) : 1.0) * this.getDouble(15141);
                boolean bl11 = this.getBoolean(15134);
                d5 = d7 + (bl11 ? this.m_State.m_PrevPos[n] : 0.0);
                d4 = d8 + (bl11 ? this.m_State.m_PrevPos[n2] : 0.0);
            } else {
                if (d9 == 0.0) {
                    throw this.newParseException("R-word zero in arc interpolation");
                }
                double d10 = this.m_State.m_LocalPosition[n];
                d3 = (d10 - this.m_State.m_PrevPos[n]) * 0.5;
                d2 = this.m_State.m_LocalPosition[n2];
                double d11 = (d2 - this.m_State.m_PrevPos[n2]) * 0.5;
                double d12 = Math.sqrt(d3 * d3 + d11 * d11);
                if (d12 * 2.0 < d6) {
                    throw this.newParseException(String.format("Start and end points too close (%1.3f < %f) in arc interpolation", d12 * 2.0, d6));
                }
                if (d12 > d9 + d6) {
                    throw this.newParseException(String.format("Start and end points too far (%1.3f) for given the radius (%f) in arc interpolation", d12, d9));
                }
                if (d12 > d9) {
                    d12 = d9;
                }
                double d13 = Math.sqrt(d9 * d9 - d12 * d12);
                double d14 = 0.0;
                if (bl) {
                    d14 = -Math.signum(d9);
                    segmentType = Machcode.SegmentType.MOVE_ARC_CW;
                } else {
                    d14 = Math.signum(d9);
                    segmentType = Machcode.SegmentType.MOVE_ARC_CCW;
                }
                double d15 = -d11 * d13 / d12 * d14;
                double d16 = d3 * d13 / d12 * d14;
                d5 = this.m_State.m_PrevPos[n] + d3 + d15;
                d4 = this.m_State.m_PrevPos[n2] + d11 + d16;
            }
            double d17 = Math.sqrt(Interpreter.sqr(this.m_State.m_PrevPos[n] - d5) + Interpreter.sqr(this.m_State.m_PrevPos[n2] - d4));
            d2 = Math.sqrt(Interpreter.sqr(this.m_State.m_LocalPosition[n] - d5) + Interpreter.sqr(this.m_State.m_LocalPosition[n2] - d4));
            d3 = Math.abs(d17 - d2);
            if (d3 > d6) {
                System.out.println("arc plane " + this.getInteger(15101) + " xi " + n + " yi " + n2);
                System.out.println("arc start pos " + this.m_State.m_PrevPos[n] + "   " + this.m_State.m_PrevPos[n2]);
                System.out.println("arc end   pos " + this.m_State.m_PrevPos[n] + "   " + this.m_State.m_PrevPos[n2]);
                System.out.println("arc center    " + d5 + "   " + d4);
                throw this.newParseException("Difference ( " + d3 + ")  of start and end point distance from center too high (>" + d6 + ")  in arc interpolation");
            }
            this.m_Center[n] = d5;
            this.m_Center[n2] = d4;
            segmentType = bl ? Machcode.SegmentType.MOVE_ARC_CW : Machcode.SegmentType.MOVE_ARC_CCW;
            this.addMachCode(new Machcode.ArcMove(this.m_FilePos, this.getInteger(15101), this.getToolCompensation(), this.getPathTolerance(), d, this.getAxisPos(), this.m_State.localToAxis(this.m_Center), segmentType));
        }
    }

    private double getToolCompensation() {
        return this.getDouble(15136);
    }

    private double getPathTolerance() {
        return 2 == this.m_State.getParamInt(15102) ? this.m_State.getParamDouble(15144) : 0.0;
    }

    private void handleCannedDrilling(double d, int n) {
        int n2;
        Double d2;
        Integer n3;
        char c;
        int n4;
        if (this.getDouble(15136) != 0.0) {
            throw this.newParseException("Radius compensation must be off when a canned cycle is used");
        }
        int n5 = this.getInteger(15101);
        switch (n5) {
            case 0: {
                n4 = 2;
                c = 'Z';
                break;
            }
            case 1: {
                n4 = 1;
                c = 'Y';
                break;
            }
            case 2: {
                n4 = 0;
                c = 'X';
                break;
            }
            default: {
                throw this.newParseException("BUG - illegal active plane: " + n5);
            }
        }
        if (this.m_ExplicitMovement) {
            if (null == this.peekWordValue('R')) {
                throw this.newParseException("Missing R-word");
            }
            if (null == this.peekWordValue(c)) {
                throw this.newParseException("Missing " + c + "-word");
            }
            if (n == 4 || n == 7) {
                if (null == this.peekWordValue('Q')) {
                    throw this.newParseException("Missing Q-word");
                }
            } else if (null != this.peekWordValue('Q')) {
                throw this.newParseException("Q-word not allowed with this canned cycle");
            }
            if (n == 6 && null == this.peekWordValue('P')) {
                throw this.newParseException("Missing P-word");
            }
            this.setParameter(15180, this.m_State.m_LocalPosition[n4]);
        }
        String string = "XYZ";
        int n6 = string.length();
        int n7 = 0;
        for (int i = 0; i < n6; ++i) {
            if (null == this.peekWordValue(string.charAt(i))) continue;
            ++n7;
        }
        if (n7 == 0) {
            return;
        }
        Double d3 = this.getWordValue('Q');
        if (d3 != null) {
            this.setParameter(15178, d3);
        }
        if (n == 6 && null != this.peekWordValue('P')) {
            this.setParameter(15181, this.getWordPAsDwellTime());
        }
        if ((n3 = this.getIntegerWordValue(Character.valueOf('L'))) == null) {
            n3 = 1;
        }
        if (n3 < 1) {
            throw this.newParseException("L must be positive");
        }
        Double d4 = this.getWordValue('R');
        if (d4 != null) {
            this.setParameter(15177, d4);
        }
        if ((d2 = this.getWordValue(c)) != null) {
            d2 = d2 * this.getDouble(5191 + n4);
            if (this.getBoolean(15133)) {
                this.setParameter(15179, this.getDouble(15177) + d2);
            } else {
                this.setParameter(15179, d2);
            }
        }
        Double[] doubleArray = new Double[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            doubleArray[n2] = this.getWordValue(string.charAt(n2));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n6; ++i) {
                if (doubleArray[i] == null) continue;
                this.pushWordValue(string.charAt(i), doubleArray[i]);
            }
            if (!this.getXYZABC(this.getBoolean(15129)) && !this.m_ExplicitMovement) break;
            double[] dArray = this.m_State.getLocalPos();
            this.addMachCode(new Machcode.LinearMove(this.m_FilePos, n5, 0.0, 0.0, 0.0, this.m_State.localToAxis(dArray)));
            dArray[n4] = this.getDouble(15177);
            this.addMachCode(new Machcode.LinearMove(this.m_FilePos, n5, 0.0, 0.0, 0.0, this.m_State.localToAxis(dArray)));
            double d5 = dArray[n4];
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl = this.getDouble(15177) > this.getDouble(15179);
            double d8 = bl ? -1.0 : 1.0;
            boolean bl2 = false;
            while (!bl2) {
                double d9;
                if (d8 * ((d5 += d8 * this.getDouble(15178)) - this.getDouble(15179)) >= 0.0) {
                    d5 = this.getDouble(15179);
                    bl2 = true;
                }
                if (n == 5 || n == 6 || n == 8) {
                    d5 = this.getDouble(15179);
                    bl2 = true;
                }
                if ((d9 = d6 - d7) > 0.0) {
                    dArray[n4] = d7;
                    this.addMachCode(new Machcode.LinearMove(this.m_FilePos, n5, 0.0, 0.0, 0.0, this.m_State.localToAxis(dArray)));
                }
                dArray[n4] = d5;
                this.addMachCode(new Machcode.Dwell(this.m_FilePos, 0.0));
                this.addMachCode(new Machcode.LinearMove(this.m_FilePos, n5, 0.0, 0.0, d, this.m_State.localToAxis(dArray)));
                d7 = dArray[n4];
                if (bl2) {
                    if (n == 6) {
                        this.addMachCode(new Machcode.Dwell(this.m_FilePos, this.getDouble(15181)));
                    }
                    dArray[n4] = this.m_G98 ? this.getDouble(15180) : this.getDouble(15177);
                } else if (n == 4) {
                    int n8 = n4;
                    dArray[n8] = dArray[n8] + -d8 * this.getDouble(15182);
                } else {
                    dArray[n4] = this.getDouble(15177);
                }
                if (n == 8) {
                    this.addMachCode(new Machcode.LinearMove(this.m_FilePos, n5, 0.0, 0.0, d, this.m_State.localToAxis(dArray)));
                } else {
                    this.addMachCode(new Machcode.LinearMove(this.m_FilePos, n5, 0.0, 0.0, 0.0, this.m_State.localToAxis(dArray)));
                }
                d6 = dArray[n4];
            }
            this.m_AxisWords[n4] = dArray[n4];
            this.m_State.m_LocalPosition[n4] = dArray[n4];
        }
    }

    private void handleCancelCannedCycles() {
        if (this.getGCode(80.0)) {
            this.setParameter(15122, 0);
        }
    }

    private void handleArcInterpolation(boolean bl, double d) {
        int n = this.getInteger(15101);
        if (n == 0) {
            this.handleArcInterpolation(bl, d, 'X', 'Y', 'I', 'J');
        } else if (n == 1) {
            this.handleArcInterpolation(bl, d, 'X', 'Z', 'I', 'K');
        } else if (n == 2) {
            this.handleArcInterpolation(bl, d, 'Y', 'Z', 'J', 'K');
        } else {
            throw this.newParseException("BUG - illegal active plane: " + n);
        }
    }

    private int setCannedMode(int n) {
        if (this.getInteger(15122) >= 4) {
            throw this.newParseException("Missign G80 since last canned cycle");
        }
        return n;
    }

    private void handlePerformMotion() {
        boolean bl = this.getGCode(0.0);
        boolean bl2 = this.getGCode(1.0);
        boolean bl3 = this.getGCode(2.0);
        boolean bl4 = this.getGCode(3.0);
        boolean bl5 = this.getGCode(31.0);
        boolean bl6 = this.getGCode(73.0);
        boolean bl7 = this.getGCode(81.0);
        boolean bl8 = this.getGCode(82.0);
        boolean bl9 = this.getGCode(83.0);
        boolean bl10 = this.getGCode(85.0);
        if (this.count(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10) > 1) {
            throw this.newParseException("More than one of G0,G1,G2,G3,G31,G73,G81,G82 or G83 on the same line");
        }
        this.m_ExplicitMovement = false;
        double d = this.getDouble(15145) * this.getDouble(15141) / 60.0;
        if (d < 0.0) {
            throw this.newParseException("Feed rate must be positive (missing F-word?)");
        }
        int n = this.getInteger(15122);
        if (bl) {
            this.m_ExplicitMovement = true;
            n = 0;
        }
        if (bl2 || bl5) {
            this.m_ExplicitMovement = true;
            n = 1;
        }
        if (bl3) {
            this.m_ExplicitMovement = true;
            n = 2;
        }
        if (bl4) {
            this.m_ExplicitMovement = true;
            n = 3;
        }
        if (bl6) {
            this.m_ExplicitMovement = true;
            n = this.setCannedMode(4);
        }
        if (bl7) {
            this.m_ExplicitMovement = true;
            n = this.setCannedMode(5);
        }
        if (bl8) {
            this.m_ExplicitMovement = true;
            n = this.setCannedMode(6);
        }
        if (bl9) {
            this.m_ExplicitMovement = true;
            n = this.setCannedMode(7);
        }
        if (bl10) {
            this.m_ExplicitMovement = true;
            n = this.setCannedMode(8);
        }
        if (n == 0) {
            d = 0.0;
        }
        if (bl5) {
            this.addMachCode(new Machcode(Machcode.SegmentType.ARM_PROBE, this.m_FilePos));
        }
        if (this.getInteger(15122) != n) {
            this.setParameter(15122, n);
        }
        if (n == 0) {
            this.handleLinearInterpolation(true, d);
        } else if (n == 1) {
            this.handleLinearInterpolation(false, d);
        } else if (n == 2) {
            this.handleArcInterpolation(true, d);
        } else if (n == 3) {
            this.handleArcInterpolation(false, d);
        } else {
            this.handleCannedDrilling(d, n);
        }
        if (bl5) {
            this.addMachCode(new Machcode(Machcode.SegmentType.WAIT_PROBE, this.m_FilePos));
        }
    }

    private boolean handleStop() {
        boolean bl = this.getMCode(0.0);
        boolean bl2 = this.getMCode(1.0);
        boolean bl3 = this.getMCode(2.0);
        boolean bl4 = this.getMCode(30.0);
        boolean bl5 = this.getMCode(60.0);
        int n = this.count(bl, bl2, bl3, bl4, bl5);
        if (n > 1) {
            throw this.newParseException("More than one of M0,M1,M30 or M60 on the same line");
        }
        if (bl) {
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.PAUSE));
            if (this.m_Trace) {
                this.trace("pause");
            }
        }
        if (bl2) {
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.COND_PAUSE));
            if (this.m_Trace) {
                this.trace("pause conditionally");
            }
        }
        if (bl5) {
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.EXCHANGE_PALETTE));
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.PAUSE));
            if (this.m_Trace) {
                this.trace("paletette change and pause");
            }
        }
        if (bl3) {
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.STOP));
            if (this.m_Trace) {
                this.trace("stop");
            }
            return true;
        }
        if (bl4) {
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.EXCHANGE_PALETTE));
            this.addMachCode(new Machcode.ControlCode(this.m_FilePos, Machcode.SegmentType.STOP));
            if (this.m_Trace) {
                this.trace("paletette change and stop");
            }
            return true;
        }
        return false;
    }

    private String format(int n) {
        String string = Integer.toString(n / 10);
        int n2 = n % 10;
        if (n2 == 0) {
            return string;
        }
        return string + "." + Integer.toString(n2);
    }

    void handleSubroutine() throws Exception {
        boolean bl;
        boolean bl2 = this.getMCode(98.0);
        boolean bl3 = this.getMCode(99.0);
        boolean bl4 = bl = this.Fadal ? this.getMCode(17.0) : false;
        if (bl2 && bl3) {
            throw this.newParseException("Both M98 and M99 on the same line");
        }
        if (bl2 && bl) {
            throw this.newParseException("Both M17 and M99 on the same line");
        }
        if (bl && bl3) {
            throw this.newParseException("Both M17 and M99 on the same line");
        }
        if (bl2) {
            Object object;
            Integer n = this.getIntegerWordValue(Character.valueOf('P'));
            if (n == null) {
                throw this.newParseException("P-word required for M98-code (call suboutine)");
            }
            if (n < 1) {
                throw this.newParseException("Repeat count P value " + n + " too small");
            }
            int n2 = 1;
            if (this.Mach3) {
                object = this.getIntegerWordValue(Character.valueOf('L'));
                Integer n3 = this.getIntegerWordValue(Character.valueOf('Q'));
                if (object != null && n3 != null) {
                    throw this.newParseException("Both Q and L words speficied for M98-code (call suboutine)");
                }
                if (object != null) {
                    if ((Integer)object < 1) {
                        throw this.newParseException("Repeat count L value " + (Integer)object + " too small");
                    }
                    n2 = (Integer)object;
                }
                if (n3 != null) {
                    if (n3 < 1) {
                        throw this.newParseException("Repeat count Q value " + n3 + " too small");
                    }
                    n2 = n3;
                }
            }
            if (this.Mach4 && (object = this.getIntegerWordValue(Character.valueOf('L'))) != null) {
                n2 = (Integer)object;
                if (n > 9999) {
                    throw this.newParseException("P word value " + n + " must be 4 digits or less");
                }
            }
            if (this.Fanuc && n >= 10000) {
                n2 = n / 10000;
                n = n % 10000;
            }
            if ((object = this.m_Parser.getLastComment()) == null || ((String)object).length() == 0) {
                object = this.m_Parser.getCurrentFileName();
            }
            this.m_Parser.callSubroutine((String)object, n.intValue(), n2);
            if (this.m_Trace) {
                this.trace("M98 (call subroutine)");
            }
        }
        if (bl3 || bl) {
            if (this.m_Trace) {
                this.trace("M99 (return from subroutine)");
            }
            this.m_Parser.returnFromSubroutine();
        }
    }

    public Machcode getCCodes() {
        return this.m_CCodes;
    }

    private void handleOperatorMsg() {
        String string = this.m_Parser.getLastComment();
        if (string != null) {
            String string2 = null;
            Machcode.OperatorMessageType operatorMessageType = null;
            if (string.startsWith("MSG,")) {
                string2 = string.substring(4);
                operatorMessageType = Machcode.OperatorMessageType.MESSAGE;
            }
            if (string.startsWith("PRINT,")) {
                string2 = string.substring(6);
                operatorMessageType = Machcode.OperatorMessageType.PRINT;
            }
            if (string2 != null) {
                while (string2.startsWith(" ")) {
                    string2 = string2.substring(1);
                }
                this.addMachCode(new Machcode.OperatorMessage(this.m_FilePos, operatorMessageType, string2));
            }
        }
    }

    private void handleRetractionMode() {
        boolean bl = this.getGCode(98.0);
        boolean bl2 = this.getGCode(99.0);
        if (bl && bl2) {
            throw this.newParseException("Both G98 and G99 on the same line");
        }
        if (bl) {
            this.m_G98 = true;
        }
        if (bl2) {
            this.m_G98 = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean endLine() throws Exception {
        if (this.m_Extensions != null) {
            for (GCodeCompilerExtension object2 : this.m_Extensions) {
                object2.processGcodes(this);
            }
        }
        System.arraycopy(this.m_State.m_LocalPosition, 0, this.m_State.m_PrevPos, 0, this.m_State.m_PrevPos.length);
        this.handleOperatorMsg();
        this.handleSetDistanceMode();
        this.handleRetractionMode();
        this.handleSetFeedRateMode();
        this.handleSetFeedRate();
        this.handleSetSpindleSpeed();
        this.handleSelectTool();
        this.handleChangeTool();
        this.handleSpindleStartStop();
        this.handleCoolantOnOff();
        this.handleSetOverride();
        this.handleDwell();
        this.handlePolarMode();
        this.handleSetActivePlane();
        this.handleSetLengthUnits();
        this.handleSetRadiusCompensation();
        this.handleSetLengthCompensation();
        this.handleSetRotation();
        this.handleSetScaling();
        this.handleSetOffset();
        this.handleSelectCoordinateSystem();
        this.handleSetPathControlMode();
        this.handleSetArcCenterMode();
        this.handleGotoReferenceLocation();
        this.handleSetPartOrToolOffsets();
        this.handleCancelCannedCycles();
        this.handlePerformMotion();
        this.handleSubroutine();
        boolean bl = this.handleStop();
        for (Parser.ParamSetting paramSetting : this.m_Parser.getSetParameters()) {
            this.setParameter((int)paramSetting.m_Param, paramSetting.m_Value);
        }
        if (!this.m_Gcodes.isEmpty()) {
            void var2_6;
            Object var2_5 = null;
            for (Integer n : this.m_Gcodes) {
                String string = (String)(var2_6 != null ? (String)var2_6 + "," : "") + "G" + this.format(n);
            }
            throw this.newParseException("Un-recognized G-code" + (this.m_Gcodes.size() > 1 ? "s" : "") + ": " + (String)var2_6);
        }
        if (!this.m_Mcodes.isEmpty()) {
            void var2_9;
            Object var2_8 = null;
            for (Integer n : this.m_Mcodes) {
                String string = (String)(var2_9 != null ? (String)var2_9 + "," : "") + "m" + this.format(n);
            }
            throw this.newParseException("Un-recognized M-code" + (this.m_Gcodes.size() > 1 ? "s" : "") + ": " + (String)var2_9);
        }
        if (!this.m_WordValues.isEmpty()) {
            void var2_12;
            Object var2_11 = null;
            for (Character c : this.m_WordValues.keySet()) {
                String string = (String)(var2_12 != null ? (String)var2_12 + "," : "") + c;
            }
            throw this.newParseException("Extra words: " + (String)var2_12);
        }
        return bl;
    }

    @Override
    public void addMachCode(Runnable runnable) {
        this.addMachCode(new Machcode.Callback(this.m_FilePos, runnable));
    }
}

