/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import com.eazycnc.uwk.Multiplexer;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import eazycnc.Main;
import eazycnc.gcode.MachParam;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.vecmath.Color3f;
import motorcontrol.MachiningState;
import org.json.JSONArray;
import org.json.JSONObject;

public final class MachState
implements com.eazycnc.gcode.MachState {
    private final double PARAMETER_FILE_FORMAT_VERSION = 6.0;
    private double m_ParamVersionNumber;
    private String _m_MachStateName;
    private int m_IdCount = 0;
    private int m_Id = this.m_IdCount++;
    public static final int NUMBER_OF_MOTORS = 4;
    private volatile MachiningState m_MachiningState = MachiningState.STOPPED;
    private static boolean[] m_TrigRecompile;
    private ParamType[] m_ParamType = new ParamType[32768];
    public double[] m_DoubleValues = new double[32768];
    public int[] m_IntegerValues = new int[32768];
    public String[] m_StringValues = new String[32768];
    public boolean[] m_BooleanValues = new boolean[32768];
    SimpleVariable[] m_Variables;
    public volatile double[] m_LocalPosition;
    double[] m_PrevPos;
    private double[] m_TempPos;
    private LinkedList<Integer> m_ListOfParams = new LinkedList();
    private LinkedList<String> m_LoadedParameterNames;
    private Variable m_LengthUnitVariable;
    private Variable m_SpeedUnitVariable;
    private Variable m_AccelUnitVariable;
    private Variable m_JerkUnitVariable;
    private Runnable m_RecompileCallback = null;
    Multiplexer m_CurrentToolDiameterMux;
    private Multiplexer m_CurrentToolLengthMux;

    public void setMachinginState(MachiningState machiningState) {
        this.m_MachiningState = machiningState;
    }

    public void setRecompileCallback(Runnable runnable) {
        this.m_RecompileCallback = runnable;
    }

    public static int getIndex(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index " + n2 + " cannot be negative");
        }
        if ((0x4000000 & n) != 0) {
            if (n2 >= 6) {
                throw new IllegalArgumentException("index " + n2 + " for probe calib parameters must be smaller than 6");
            }
            return 15194 + n2 * 2 + (0x3FFFFFF & n);
        }
        if ((Integer.MIN_VALUE & n) != 0) {
            if (n2 >= 6) {
                throw new IllegalArgumentException("index " + n2 + " for motor parameters must be smaller than 6");
            }
            return 17000 + n2 * 32 + (0x3FFFFFF & n);
        }
        if ((0x40000000 & n) != 0) {
            if (n2 >= 255) {
                throw new IllegalArgumentException("index " + n2 + " for tool parameters must be smaller than 255");
            }
            return 14000 + n2 * 2 + (0x3FFFFFF & n);
        }
        if ((0x20000000 & n) != 0) {
            if (n2 >= 6) {
                throw new IllegalArgumentException("index " + n2 + " for jog parameters must be smaller than 6");
            }
            return 15400 + n2 * 15 + (0x3FFFFFF & n);
        }
        if ((0x10000000 & n) != 0) {
            if (n2 >= 200) {
                throw new IllegalArgumentException("index " + n2 + " for shortcut parameters must be smaller than 200");
            }
            return 15500 + n2 * 2 + (0x3FFFFFF & n);
        }
        if ((0x8000000 & n) != 0) {
            if (n2 >= 10) {
                throw new IllegalArgumentException("index " + n2 + " for joystick parameters must be smaller than 10");
            }
            return 15500 + n2 * 2 + (0x3FFFFFF & n);
        }
        throw new IllegalArgumentException("parameter " + n + " is not indexed");
    }

    @Override
    public int getParamInt(int n, int n2) {
        return this.getParamInt(MachState.getIndex(n, n2));
    }

    @Override
    public double getParamDouble(int n, int n2) {
        return this.getParamDouble(MachState.getIndex(n, n2));
    }

    @Override
    public boolean getParamBoolean(int n, int n2) {
        return this.getParamBoolean(MachState.getIndex(n, n2));
    }

    @Override
    public String getParamString(int n, int n2) {
        return this.getParamString(MachState.getIndex(n, n2));
    }

    @Override
    public void setParam(int n, int n2, Object object) {
        this.setParam(MachState.getIndex(n, n2), object);
    }

    public NumericVariable getNumericVariable(int n) {
        return (NumericVariable)this.getVariable(n);
    }

    public NumericVariable getNumericVariable(int n, int n2) {
        return (NumericVariable)this.getVariable(n, n2);
    }

    public SimpleVariable getVariable(int n, int n2) {
        if ((n = MachState.getIndex(n, n2)) < 0 || n >= this.m_Variables.length) {
            throw new IllegalArgumentException("parameter " + n + " not defined");
        }
        return this.m_Variables[n];
    }

    public SimpleVariable getVariable(int n) {
        if (n < 0 || n >= this.m_Variables.length) {
            throw new IllegalArgumentException("parameter " + n + " not defined");
        }
        return this.m_Variables[n];
    }

    public NumericVariable getScaledVariable(int n) {
        return UWKit.divide((Variable)((NumericVariable)this.getVariable(n)), (NumericVariable)this.getVariable(15141));
    }

    public NumericVariable getScaledVariable(int n, int n2) {
        return UWKit.divide((Variable)((NumericVariable)this.getVariable(n, n2)), (NumericVariable)this.getVariable(15141));
    }

    public String getParamString(int n) {
        if (n < 0 || n >= this.m_StringValues.length || this.m_ParamType[n] != ParamType.STRING) {
            throw new IllegalArgumentException("parameter " + n + " not defined");
        }
        return this.m_StringValues[n];
    }

    @Override
    public int getParamInt(int n) {
        if (n < 0 || n >= this.m_IntegerValues.length || this.m_ParamType[n] != ParamType.INTEGER) {
            throw new IllegalArgumentException("parameter " + n + (this.m_ParamType[n] == null ? " not defined" : " not integer"));
        }
        return this.m_IntegerValues[n];
    }

    @Override
    public boolean getParamBoolean(int n) {
        if (n < 0 || n >= this.m_BooleanValues.length || this.m_ParamType[n] != ParamType.BOOLEAN) {
            throw new IllegalArgumentException("parameter " + n + (this.m_ParamType[n] == null ? " not defined" : " not boolean"));
        }
        return this.m_BooleanValues[n];
    }

    public void setString(int n, String string) {
        this.getVariable(n).setValue(string);
    }

    public boolean hasParam(int n, int n2) {
        return this.m_ParamType[MachState.getIndex(n, n2)] != null;
    }

    public boolean hasParam(int n) {
        return this.m_ParamType[n] != null;
    }

    @Override
    public double getParamDouble(int n) {
        if (n < 0 || n >= this.m_DoubleValues.length || this.m_ParamType[n] != ParamType.DOUBLE) {
            throw new IllegalArgumentException("parameter " + n + (this.m_ParamType[n] == null ? " not defined" : " not double"));
        }
        return this.m_DoubleValues[n];
    }

    public Variable getLengthUnit() {
        return this.m_LengthUnitVariable;
    }

    public Variable getSpeedUnit() {
        return this.m_SpeedUnitVariable;
    }

    public Variable getAccelUnit() {
        return this.m_AccelUnitVariable;
    }

    public Variable getJerkUnit() {
        return this.m_JerkUnitVariable;
    }

    public Variable getDroFormatVariable() {
        return this.getVariable(15300);
    }

    public String formatToUserUnits(double d) {
        String string = this.getDroFormatVariable().getValue().toString();
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d * this.getParamDouble(15141));
    }

    public Object getParameter(int n) throws Exception {
        try {
            switch (this.m_ParamType[n]) {
                case BOOLEAN: {
                    return this.m_BooleanValues[n];
                }
                case INTEGER: {
                    return this.m_IntegerValues[n];
                }
                case DOUBLE: {
                    return this.m_DoubleValues[n];
                }
                case STRING: {
                    return this.m_StringValues[n];
                }
            }
            throw new IllegalArgumentException("param " + n + " has bad type " + this.m_ParamType[n]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public void setParameterNoUpdate(int n, Object object) {
        this.stateChanged(n);
        try {
            switch (this.m_ParamType[n]) {
                case BOOLEAN: {
                    this.m_BooleanValues[n] = (Boolean)object;
                    break;
                }
                case INTEGER: {
                    this.m_IntegerValues[n] = ((Number)object).intValue();
                    break;
                }
                case DOUBLE: {
                    this.m_DoubleValues[n] = ((Number)object).doubleValue();
                    break;
                }
                case STRING: {
                    this.m_StringValues[n] = (String)object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("param " + n + " has bad type " + this.m_ParamType[n]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setParam(int n, Object object) {
        try {
            SimpleVariable simpleVariable;
            ParamType paramType = null;
            if (object instanceof Double) {
                paramType = ParamType.DOUBLE;
            } else if (object instanceof Integer) {
                paramType = ParamType.INTEGER;
            } else if (object instanceof Boolean) {
                paramType = ParamType.BOOLEAN;
            } else if (object instanceof String) {
                paramType = ParamType.STRING;
            } else {
                throw new IllegalArgumentException("Value '" + object + "' of type " + object.getClass().getSimpleName() + " is not alloweved");
            }
            if (paramType == null) {
                throw new IllegalArgumentException("Parameter " + n + " is undefined");
            }
            if (paramType == ParamType.INTEGER && this.m_ParamType[n] == ParamType.DOUBLE) {
                object = ((Integer)object).doubleValue();
                paramType = ParamType.DOUBLE;
            }
            if (paramType == ParamType.DOUBLE && this.m_ParamType[n] == ParamType.INTEGER) {
                double d;
                int n2 = ((Double)object).intValue();
                if ((double)n2 != (d = ((Double)object).doubleValue())) {
                    throw new IllegalArgumentException("Can't assign value' " + object + "' to " + this.m_ParamType[n] + " parameter #" + n);
                }
                object = n2;
                paramType = ParamType.INTEGER;
            }
            if (this.m_ParamType[n] == ParamType.DOUBLE) {
                if (paramType == ParamType.STRING) {
                    if ("NaN".equals(object)) {
                        object = Double.NaN;
                        paramType = ParamType.DOUBLE;
                    } else if ("Inf+".equals(object)) {
                        object = Double.POSITIVE_INFINITY;
                        paramType = ParamType.DOUBLE;
                    } else if ("Inf-".equals(object)) {
                        object = Double.NEGATIVE_INFINITY;
                        paramType = ParamType.DOUBLE;
                    }
                }
            }
            if (this.m_ParamType[n] != paramType) {
                throw new IllegalArgumentException("Can't assign value '" + object + "' to " + this.m_ParamType[n] + " parameter #" + n);
            }
            SimpleVariable simpleVariable2 = simpleVariable = this.m_Variables != null ? this.getVariable(n) : null;
            if (simpleVariable != null) {
                simpleVariable.setValue(object);
            } else {
                switch (paramType) {
                    case INTEGER: {
                        this.m_IntegerValues[n] = (Integer)object;
                        break;
                    }
                    case BOOLEAN: {
                        this.m_BooleanValues[n] = (Boolean)object;
                        break;
                    }
                    case DOUBLE: {
                        this.m_DoubleValues[n] = (Double)object;
                        break;
                    }
                    case STRING: {
                        this.m_StringValues[n] = object != null ? object.toString() : "";
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception " + exception.getClass().getName() + ":" + exception.getMessage() + " in setParam(" + n + ", " + object + ")");
            throw exception;
        }
    }

    public void stateChanged(int n) {
        if (this.m_MachiningState == MachiningState.RUNNING || this.m_MachiningState == MachiningState.PAUSING || this.m_MachiningState == MachiningState.STOPPING) {
            return;
        }
        if (n >= 0 && !m_TrigRecompile[n]) {
            return;
        }
        this.retrigCompile();
    }

    public void toolChanged(int n) {
        this.stateChanged(-1);
    }

    public void retrigCompile() {
        if (this.m_RecompileCallback != null) {
            this.m_RecompileCallback.run();
        }
    }

    private void initDouble(int n, double d) {
        int n2 = n & 0x3FFFFFF;
        this.initDouble(n2, d, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    private void initInteger(int n, int n2) {
        int n3 = n & 0x3FFFFFF;
        this.initInteger(n3, n2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private void initString(int n, String string) {
        final int n2 = n & 0x3FFFFFF;
        this.m_ListOfParams.add(n2);
        if (this.m_ParamType[n2] != null) {
            throw new IllegalArgumentException("param " + n2 + " double defined");
        }
        this.m_ParamType[n2] = ParamType.STRING;
        this.m_StringValues[n2] = string;
        this.m_Variables[n2] = new SimpleVariable((Object)string){

            @Override
            public synchronized Object getValue() {
                return MachState.this.m_StringValues[n2];
            }

            @Override
            public synchronized void setValue(Object object) {
                MachState.this.m_StringValues[n2] = (String)object;
                this.fireChangeEvent();
                MachState.this.stateChanged(n2);
            }
        };
    }

    private void initDouble(int n, double d, double d2, double d3) {
        final int n2 = n & 0x3FFFFFF;
        if (this.m_ParamType[n2] != null) {
            throw new IllegalArgumentException("param " + n2 + " double defined");
        }
        this.m_ListOfParams.add(n2);
        this.m_ParamType[n2] = ParamType.DOUBLE;
        this.m_DoubleValues[n2] = d;
        if (this.m_Variables != null) {
            NumericVariable numericVariable = new NumericVariable(d, d2, d3){

                @Override
                public Object getValue() {
                    return MachState.this.m_DoubleValues[n2];
                }

                @Override
                public void setValue(Object object) {
                    MachState.this.m_DoubleValues[n2] = ((Number)object).doubleValue();
                    this.fireChangeEvent();
                    MachState.this.stateChanged(n2);
                }
            };
            this.m_Variables[n2] = numericVariable;
        }
    }

    private void initInteger(int n, int n2, int n3, int n4) {
        final int n5 = n & 0x3FFFFFF;
        if (this.m_ParamType[n5] != null) {
            throw new IllegalArgumentException("param " + n5 + " double defined");
        }
        this.m_ListOfParams.add(n5);
        this.m_ParamType[n5] = ParamType.INTEGER;
        this.m_IntegerValues[n5] = n2;
        if (this.m_Variables != null) {
            NumericVariable numericVariable = new NumericVariable(n2, n3, n4){

                @Override
                public Object getValue() {
                    return MachState.this.m_IntegerValues[n5];
                }

                @Override
                public void setValue(Object object) {
                    MachState.this.m_IntegerValues[n5] = ((Number)object).intValue();
                    this.fireChangeEvent();
                    MachState.this.stateChanged(n5);
                }
            };
            this.m_Variables[n5] = numericVariable;
        }
    }

    private void initBoolean(int n, boolean bl) {
        final int n2 = n & 0x3FFFFFF;
        if (this.m_ParamType[n2] != null) {
            throw new IllegalArgumentException("param " + n2 + " double defined");
        }
        this.m_ListOfParams.add(n2);
        this.m_ParamType[n2] = ParamType.BOOLEAN;
        this.m_BooleanValues[n2] = bl;
        if (this.m_Variables != null) {
            SimpleVariable simpleVariable;
            this.m_Variables[n2] = simpleVariable = new SimpleVariable((Object)bl){

                @Override
                public Object getValue() {
                    return MachState.this.m_BooleanValues[n2];
                }

                @Override
                public void setValue(Object object) {
                    MachState.this.m_BooleanValues[n2] = (Boolean)object;
                    this.fireChangeEvent();
                    MachState.this.stateChanged(n2);
                }
            };
        }
    }

    public double getParamVersionNumber() {
        return this.m_ParamVersionNumber;
    }

    public void setParamVersionNumber(double d) {
        this.m_ParamVersionNumber = d;
    }

    private void initParams() {
        int n;
        int n2;
        this.m_Variables = new SimpleVariable[32768];
        for (int i = 0; i <= 10320; ++i) {
            if (i == 5220) continue;
            this.initDouble(i, 0.0);
        }
        this.initString(15300, "0.000");
        this.initString(15302, "COM5");
        this.initString(15301, "");
        this.initString(15299, "English");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        boolean bl = dimension.getHeight() < 800.0;
        this.initInteger(15298, bl ? 2 : 0);
        this.initDouble(15297, 20.0, 1.0, 100.0);
        this.initDouble(15308, 2500.0);
        this.initDouble(15303, 50.0);
        this.initDouble(15304, 10.0);
        this.initDouble(15305, 100.0);
        for (n2 = 0; n2 < 10; ++n2) {
            this.initString(15310 + n2, "");
        }
        this.initDouble(15161, 3000.0);
        this.initBoolean(15162, false);
        this.initBoolean(15163, false);
        this.initDouble(15164, 1.0);
        this.initBoolean(15165, false);
        this.initBoolean(15166, true);
        this.initBoolean(15126, false);
        this.initInteger(15128, 1);
        this.initBoolean(15124, false);
        this.initInteger(15125, 1);
        this.initInteger(15123, 1);
        this.initInteger(15122, 0);
        this.initInteger(15101, 0);
        this.initInteger(15102, 2);
        this.initDouble(15136, 0.0);
        this.initInteger(15137, 0);
        this.initDouble(15138, 0.0);
        this.initDouble(15139, 0.0);
        this.initDouble(15140, 0.0);
        this.initDouble(15141, 1.0);
        this.initDouble(15142, 0.0);
        this.initDouble(15143, 0.0);
        this.initDouble(15127, 1000.0);
        this.initDouble(15144, 0.1);
        this.initInteger(15147, 1, 0, 255);
        this.initDouble(15359, 100.0);
        this.initDouble(15360, 15000.0);
        this.initDouble(15158, 50.0);
        this.initBoolean(15159, false);
        this.initDouble(15145, 60.0);
        this.initDouble(15146, 0.0);
        this.initBoolean(15129, false);
        this.initBoolean(15130, false);
        this.initBoolean(15131, false);
        this.initDouble(15132, 1.0);
        this.initBoolean(15133, false);
        this.initBoolean(15134, false);
        this.initBoolean(15135, false);
        this.initDouble(15169, 100000.0);
        this.initDouble(15148, 100.0);
        this.initDouble(15149, 15.0);
        this.initDouble(15150, 0.1);
        this.initDouble(15151, 0.0);
        this.initDouble(15152, 0.0);
        this.initDouble(15153, 0.0);
        this.initBoolean(15170, false);
        this.initDouble(15171, 100.0, 100.0, Double.MAX_VALUE);
        this.initDouble(15173, 100.0, 0.0, Double.MAX_VALUE);
        this.initDouble(15172, 0.01, Double.MIN_VALUE, Double.MAX_VALUE);
        this.initBoolean(15174, false);
        this.initBoolean(15175, false);
        this.initBoolean(15176, true);
        this.initDouble(15177, 0.0);
        this.initDouble(15178, 0.0);
        this.initDouble(15179, 0.0);
        this.initDouble(15180, 0.0);
        this.initDouble(15181, 0.0);
        this.initDouble(15182, 2.5);
        this.initInteger(15189, 0);
        this.initBoolean(15190, false);
        this.initBoolean(15191, false);
        for (n2 = 0; n2 < 255; ++n2) {
            this.initDouble(14000 + n2 * 2 + 0x40000000, 0.0);
            this.initDouble(14000 + n2 * 2 + 0x40000001, 0.0);
        }
        this.initInteger(5220, 1, 1, 255);
        for (n2 = 0; n2 < 6; ++n2) {
            this.setParam(2000 + n2, 0.0);
            this.setParam(5161 + n2, 0.0);
            this.setParam(5181 + n2, 0.0);
            this.setParam(5191 + n2, 1.0);
            this.setParam(5211 + n2, 0.0);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.initDouble(15194 + n2 * 2 + 0x4000000, 0.0);
            this.initDouble(15194 + n2 * 2 + 0x4000001, 0.0);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.initDouble(15000 + n2, 0.0);
        }
        this.initDouble(15290, 1.0);
        this.initDouble(15291, 50.0);
        this.initDouble(15292, 50.0);
        this.initDouble(15293, 2.0);
        this.initDouble(15294, 0.1);
        for (n2 = 0; n2 < 6; ++n2) {
            n = 17000 + 32 * n2;
            this.initInteger(n + Integer.MIN_VALUE, 0);
            this.initDouble(n + -2147483646, 100.0);
            this.initBoolean(n + -2147483645, n2 < 3);
            this.initInteger(n + -2147483644, 0);
            this.initInteger(n + -2147483643, 0);
            this.initBoolean(n + -2147483640, false);
            this.initBoolean(n + -2147483639, false);
            this.initInteger(n + -2147483638, n2);
            this.initInteger(n + -2147483637, -1);
            this.initDouble(n + -2147483636, 3.0);
            this.initDouble(n + -2147483635, 15.0);
            this.initDouble(n + -2147483634, 20.0);
            this.initDouble(n + -2147483633, 1.0, 0.001, 1000.0);
            this.initBoolean(n + -2147483632, false);
            this.initDouble(n + -2147483647, 0.0);
            n = 15400 + n2 * 15;
            this.initDouble(n + 0x20000000, 1.0);
            this.initDouble(n + 0x20000001, 20.0);
            this.initDouble(n + 0x20000002, 40.0);
            this.initDouble(n + 0x20000003, 2.0);
            this.initDouble(n + 0x20000004, 0.1);
        }
        n2 = 17000;
        this.initDouble(n2 + -2147483642, -500.0);
        this.initDouble(n2 + -2147483641, 500.0);
        n2 = 17032;
        this.initDouble(n2 + -2147483642, -200.0);
        this.initDouble(n2 + -2147483641, 200.0);
        n2 = 17064;
        this.initDouble(n2 + -2147483642, -5.0);
        this.initDouble(n2 + -2147483641, 200.0);
        for (n2 = 3; n2 < 6; ++n2) {
            n = 17000 + 32 * n2;
            this.initDouble(n + -2147483642, 0.0);
            this.initDouble(n + -2147483641, 200.0);
        }
        for (n2 = 0; n2 < 200; ++n2) {
            n = 15500 + n2 * 2;
            this.initString(n + 0x10000000, "");
            this.initString(n + 0x10000001, "");
        }
        n2 = 0;
        this.setParam(0x10000000, n2, "LEFT");
        this.setParam(0x10000001, n2, "JOG_X_MINUS");
        this.setParam(0x10000000, ++n2, "RIGHT");
        this.setParam(0x10000001, n2, "JOG_X_PLUS");
        this.setParam(0x10000000, ++n2, "DOWN");
        this.setParam(0x10000001, n2, "JOG_Y_MINUS");
        this.setParam(0x10000000, ++n2, "UP");
        this.setParam(0x10000001, n2, "JOG_Y_PLUS");
        this.setParam(0x10000000, ++n2, "STICK LEFT");
        this.setParam(0x10000001, n2, "JOG_X_MINUS");
        this.setParam(0x10000000, ++n2, "STICK RIGHT");
        this.setParam(0x10000001, n2, "JOG_X_PLUS");
        this.setParam(0x10000000, ++n2, "STICK DOWN");
        this.setParam(0x10000001, n2, "JOG_Y_MINUS");
        this.setParam(0x10000000, ++n2, "STICK UP");
        this.setParam(0x10000001, n2, "JOG_Y_PLUS");
        this.setParam(0x10000000, ++n2, "R");
        this.setParam(0x10000001, n2, "RUN");
        this.setParam(0x10000000, ++n2, "H");
        this.setParam(0x10000001, n2, "HOLD");
        this.setParam(0x10000000, ++n2, "S");
        this.setParam(0x10000001, n2, "STOP");
        this.setParam(0x10000000, ++n2, "BUTTON 1");
        this.setParam(0x10000001, n2, "RUN");
        this.setParam(0x10000000, ++n2, "BUTTON 2");
        this.setParam(0x10000001, n2, "PAUSE");
        this.setParam(0x10000000, ++n2, "BUTTON 3");
        this.setParam(0x10000001, n2, "STOP");
        this.setParam(0x10000000, ++n2, "C");
        this.setParam(0x10000001, n2, "COOLANT_TOGGLE");
        this.setParam(0x10000000, ++n2, "T");
        this.setParam(0x10000001, n2, "SPINDLE_TOGGLE");
        this.setParam(0x10000000, ++n2, "BUTTON 5");
        this.setParam(0x10000001, n2, "SPINDLE_TOGGLE");
        this.setParam(0x10000000, ++n2, "BUTTON 6");
        this.setParam(0x10000001, n2, "COOLANT_TOGGLE");
        this.setParam(0x10000000, ++n2, "SPACE");
        this.setParam(0x10000001, n2, "RUN_HOLD_TOGGLE");
        this.initInteger(15306, ++n2);
        this.initInteger(15307, 1);
        this.initInteger(15167, 1);
        this.initInteger(15168, 0);
        this.initDouble(15330, 0.0, 0.0, 100.0);
        this.initString(15331, "#FF00FF");
        this.initString(15320, "#800000");
        this.initString(15321, "#008000");
        this.initString(15322, "#000080");
        this.initDouble(15339, 4.0, 0.0, 10.0);
        this.initDouble(15340, 4.0, 0.0, 10.0);
        this.initString(15335, "#00FF00");
        this.initString(15336, "#004000");
        this.initString(15337, "#FF0000");
        this.initString(15338, "#400000");
        this.initString(15350, ".csv");
        this.initString(15351, "0.000");
        this.initString(15352, ",");
        this.initBoolean(15353, true);
        this.initInteger(15355, 2);
        for (n = 0; n < 50; ++n) {
            this.initString(16340 + n, "");
        }
        this.setParam(16340, "builtin/com/eazycnc/builtin/RefAllHome.java");
        this.setParam(16344, "builtin/com/eazycnc/builtin/ZeroAll.txt");
        this.initInteger(16500, 0);
        this.initDouble(16501, 1.0);
        this.initDouble(16502, 10.0);
        this.initDouble(16503, 0.0);
        this.initDouble(16504, 0.0);
        this.initDouble(16506, 0.0);
        this.initDouble(16507, 400.0);
        this.initDouble(16508, 200.0);
        this.initDouble(16509, 150.0);
        this.initDouble(16510, 0.0);
        this.initDouble(16511, 0.0);
        this.initDouble(16512, 200.0);
        this.initBoolean(15206, false);
        this.initDouble(15207, 5.0);
        this.initDouble(15208, 5.0);
        this.initBoolean(15209, true);
        this.initBoolean(15210, true);
        this.initDouble(15211, 6.0);
        this.initDouble(15212, 15.0);
        this.initDouble(15213, 15.0);
        this.initDouble(15214, 30.0);
        this.initBoolean(15288, false);
        this.initInteger(15215, 0);
        this.initInteger(15216, 0);
        this.initInteger(15217, 0);
        this.initInteger(15218, 0);
        this.initInteger(15219, 0);
        this.initInteger(15220, Main.m_OSisRasbian ? 2 : 0);
        this.initBoolean(15221, Main.m_OSisRasbian);
        this.initBoolean(15222, Main.m_OSisRasbian);
        Collections.sort(this.m_ListOfParams);
        this.setParam(0, 6.0);
        this.setParamVersionNumber(6.0);
        this.initBoolean(15295, false);
        this.initBoolean(15296, false);
        this.initDouble(15192, Double.NaN);
        this.initDouble(15193, 25.0);
        this.initBoolean(15356, true);
        this.initDouble(15357, 10.0, 0.0, 100.0);
        this.initDouble(15358, 90.0, 0.0, 100.0);
        this.initDouble(15156, 100.0, 0.0, 100000.0);
        this.initDouble(15157, 20000.0, 0.0, 100000.0);
    }

    public void setAxisEnabled(int n, boolean bl) {
        this.setParam(-2147483645, n, bl);
    }

    public boolean isAxisEnabled(int n) {
        return this.getParamBoolean(-2147483645, n);
    }

    public MachState(String string, MachState machState) {
        this(string, false);
        this.restoreStateFrom(machState);
    }

    public MachState(String string, boolean bl) {
        this._m_MachStateName = string;
        this.m_LocalPosition = new double[6];
        this.m_PrevPos = new double[6];
        this.m_TempPos = new double[6];
        if (bl) {
            this.initParams();
            this.m_LengthUnitVariable = new SimpleVariable("");
            this.m_SpeedUnitVariable = new SimpleVariable("");
            this.m_AccelUnitVariable = new SimpleVariable("");
            this.m_JerkUnitVariable = new SimpleVariable("");
            this.getVariable(15141).addObserver(new VariableObserver(){

                @Override
                public void valueChanged(Variable variable) {
                    double d = ((NumericVariable)variable).doubleValue();
                    String string = "?";
                    if (d == 1.0) {
                        string = "mm";
                    }
                    if (d == 25.4) {
                        string = "in.";
                    }
                    if (d == 0.0254) {
                        string = "mils";
                    }
                    MachState.this.m_LengthUnitVariable.setValue(string);
                    MachState.this.m_SpeedUnitVariable.setValue(string + "/s");
                    MachState.this.m_AccelUnitVariable.setValue(string + "/s^2");
                    MachState.this.m_JerkUnitVariable.setValue(string + "/s^3");
                }
            });
        }
    }

    public void restoreStateFrom(MachState machState) {
        this.m_ParamVersionNumber = machState.m_ParamVersionNumber;
        System.arraycopy(machState.m_LocalPosition, 0, this.m_LocalPosition, 0, machState.m_LocalPosition.length);
        System.arraycopy(machState.m_PrevPos, 0, this.m_PrevPos, 0, machState.m_PrevPos.length);
        System.arraycopy(machState.m_ParamType, 0, this.m_ParamType, 0, machState.m_ParamType.length);
        System.arraycopy(machState.m_DoubleValues, 0, this.m_DoubleValues, 0, this.m_DoubleValues.length);
        System.arraycopy(machState.m_IntegerValues, 0, this.m_IntegerValues, 0, this.m_IntegerValues.length);
        System.arraycopy(machState.m_BooleanValues, 0, this.m_BooleanValues, 0, this.m_BooleanValues.length);
        this.m_MachiningState = machState.m_MachiningState;
    }

    public static int getWorkOffsetBaseIndex(int n) {
        if (n < 1) {
            n = 1;
            System.err.println("PARAM_5220_WORK_OFFSET_NO < 1");
        } else if (n > 255) {
            n = 255;
            System.err.println("PARAM_5220_WORK_OFFSET_NO > NUMBER_OF_PARTS");
        }
        return 5221 + (n - 1) * 20;
    }

    public int getWorkOffsetBaseIndex() {
        return MachState.getWorkOffsetBaseIndex(this.getParamInt(5220));
    }

    public double getLengthCompensation() {
        int n = this.getParamInt(15137);
        double d = 0.0;
        if (n > 0) {
            d = this.getParamDouble(0x40000001, n - 1);
        }
        if (n < 0) {
            d = -this.getParamDouble(0x40000001, -n - 1);
        }
        return d;
    }

    public double[] localToAxisWithoutOffsets(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = this.getWorkOffsetBaseIndex();
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray2[i] + this.getParamDouble(n + i);
        }
        return dArray2;
    }

    public double[] localToAxis(double[] dArray) {
        double d;
        double d2;
        double d3;
        int n;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = dArray[n] + this.getParamDouble(5211 + n);
        }
        if (this.getParamBoolean(15130)) {
            double d4 = dArray2[0] - this.getParamDouble(15139);
            double d5 = dArray2[1] - this.getParamDouble(15140);
            d3 = this.getParamDouble(15138);
            d2 = Math.cos(d3);
            d = Math.sin(d3);
            dArray2[0] = d2 * d4 - d * d5 + this.getParamDouble(15139);
            dArray2[1] = d * d4 + d2 * d5 + this.getParamDouble(15140);
        }
        dArray2[2] = dArray2[2] + this.getLengthCompensation();
        n = this.getWorkOffsetBaseIndex();
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray2[i] + this.getParamDouble(n + i);
        }
        double d6 = this.getParamDouble(n + 19);
        int n2 = this.getWorkOffsetBaseIndex();
        d3 = dArray2[0];
        d2 = dArray2[1];
        d = Math.cos(d6);
        double d7 = Math.sin(d6);
        dArray2[0] = d3 * d - d2 * d7;
        dArray2[1] = d3 * d7 + d2 * d;
        return dArray2;
    }

    public double[] axisToLocal(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
        int n = this.getWorkOffsetBaseIndex();
        double d = this.getParamDouble(n + 19);
        double d2 = dArray2[0];
        double d3 = dArray2[1];
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        dArray2[0] = d2 * d4 + d3 * d5;
        dArray2[1] = -d2 * d5 + d3 * d4;
        n = this.getWorkOffsetBaseIndex();
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray2[i] - this.getParamDouble(n + i);
        }
        dArray2[2] = dArray2[2] - this.getLengthCompensation();
        if (this.getParamBoolean(15130)) {
            double d6 = dArray2[0] - this.getParamDouble(15139);
            d2 = dArray2[1] - this.getParamDouble(15140);
            d3 = this.getParamDouble(15138);
            d4 = Math.cos(d3);
            d5 = Math.sin(d3);
            dArray2[0] = d4 * d6 + d5 * d2 + this.getParamDouble(15139);
            dArray2[1] = -d5 * d6 + d4 * d2 + this.getParamDouble(15140);
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray2[i] - this.getParamDouble(5211 + i);
        }
        return dArray2;
    }

    public void setOffsetFromLocal(int n, double d) {
        double d2 = this.m_LocalPosition[n] - d;
        this.setParam(5211 + n, this.getParamDouble(5211 + n) + d2);
    }

    public void setWorkOffsetFromLocal(int n, double d) {
        this.setWorkOffsetFromLocal(this.getParamInt(5220), n, d);
    }

    public void setWorkOffsetFromLocal(int n, int n2, double d) {
        double d2 = this.m_LocalPosition[n2] - d;
        int n3 = MachState.getWorkOffsetBaseIndex(n);
        this.setParam(n3 + n2, this.getParamDouble(n3 + n2) + d2);
        this.m_LocalPosition[n2] = d;
    }

    public void setPositionFromAxisPos(double[] dArray) {
        this.m_LocalPosition = this.axisToLocal(dArray);
    }

    public double[] getAxisPos() {
        return this.localToAxis(this.m_LocalPosition);
    }

    public double getLocalPos(int n) {
        return this.m_LocalPosition[n];
    }

    public static double[] clonePosition(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    public double[] getLocalPos() {
        return MachState.clonePosition(this.m_LocalPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(String string) throws Exception {
        File file = new File(string).getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
            for (Integer n : this.m_ListOfParams) {
                if (n == 0) {
                    printWriter.println(n + " = " + this.m_ParamVersionNumber);
                    continue;
                }
                if (this.m_ParamType[n] == ParamType.BOOLEAN) {
                    printWriter.printf(String.format("%d = %s\n", n, this.getParamBoolean(n) ? "TRUE" : "FALSE"), new Object[0]);
                }
                if (this.m_ParamType[n] == ParamType.INTEGER) {
                    printWriter.printf(String.format("%d = %d\n", n, this.getParamInt(n)), new Object[0]);
                }
                if (this.m_ParamType[n] == ParamType.DOUBLE) {
                    printWriter.println(n + " = " + this.getParamDouble(n));
                }
                if (this.m_ParamType[n] != ParamType.STRING) continue;
                printWriter.print(String.format("%d = \"%s\"\n", n, this.getParamString(n)));
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    public Color3f stringAsColor3f(String string) {
        int n = MachState.stringAsColorInt(string);
        return new Color3f((float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n >> 0 & 0xFF) / 255.0f);
    }

    public static int stringAsColorInt(String string) {
        try {
            if (string.startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            if (string.startsWith("#")) {
                return Integer.parseInt(string.substring(1), 16);
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0xFFFFFF;
        }
    }

    public static String colorIntAsString(int n) {
        String string = String.format("#%06X", n);
        return string;
    }

    private String removeLeadingWhite(String string) {
        while (string.startsWith(" ")) {
            string = string.substring(1);
        }
        return string;
    }

    private String removeTrailingWhite(String string) {
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private int parseSign(String string) {
        if (string.startsWith("-")) {
            return -1;
        }
        if (string.startsWith("+")) {
            return 1;
        }
        return 0;
    }

    private int parseInt(String string) {
        string = this.removeLeadingWhite(string);
        int n = this.parseSign(string = this.removeTrailingWhite(string));
        if (n == 0) {
            n = 1;
        } else {
            string = string.substring(1);
        }
        return n * Integer.parseInt(string);
    }

    private double parseDouble(String string) {
        int n = this.parseSign(string);
        if (n == 0) {
            n = 1;
        } else {
            string = string.substring(1);
        }
        return (double)n * Double.parseDouble(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(String string) throws Exception {
        System.out.println("Loading configuration from " + string);
        BufferedReader bufferedReader = null;
        try {
            int n;
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            int n2 = 0;
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n2;
                int n3 = string2.indexOf("=");
                try {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8 = this.parseInt(string2.substring(0, n3));
                    String string3 = this.removeTrailingWhite(this.removeLeadingWhite(string2.substring(n3 + 1)));
                    if (n8 == 0) {
                        this.setParamVersionNumber(this.parseDouble(string3));
                        continue;
                    }
                    if (this.getParamVersionNumber() == 1.0 && n8 >= 15500 && n8 < 15628) continue;
                    if (this.getParamVersionNumber() == 2.0 && n8 == 15137) {
                        this.setParam(n8, 0);
                        continue;
                    }
                    if (this.getParamVersionNumber() < 4.0) {
                        n7 = 15200;
                        n6 = 10;
                        if (n8 >= n7 && n8 < n7 + n6 * 8) {
                            n5 = (n8 - n7) / n6;
                            n4 = (n8 - n7) % n6;
                            if (n5 >= 6) continue;
                            n8 = 17000 + n5 * 32 + n4;
                        }
                        n5 = 15400;
                        n4 = 10;
                        if (n8 >= n5 && n8 < n5 + n4 * 8) {
                            int n9 = (n8 - n5) / n4;
                            int n10 = (n8 - n5) % n4;
                            if (n9 >= 6) continue;
                            n8 = 15400 + n9 * 15 + n10;
                        }
                    }
                    if (this.getParamVersionNumber() == 4.0) {
                        n7 = 15200;
                        n6 = 15;
                        if (n8 >= n7 && n8 < n7 + n6 * 6) {
                            n5 = (n8 - n7) / n6;
                            n4 = (n8 - n7) % n6;
                            n8 = 17000 + n5 * 32 + n4;
                        }
                    }
                    if (this.getParamVersionNumber() < 5.0 && n8 >= 17000 && n8 < 17192 && (n7 = (n8 - 17000) % 32) == 1) continue;
                    if (string3.startsWith("NaN")) {
                        this.setParam(n8, Double.NaN);
                        continue;
                    }
                    if (string3.startsWith("\"")) {
                        this.setParam(n8, string3.substring(1, string3.length() - 1));
                        continue;
                    }
                    if (string3.indexOf(".") >= 0) {
                        this.setParam(n8, this.parseDouble(string3));
                        continue;
                    }
                    if (string3.startsWith("TRUE")) {
                        this.setParam(n8, true);
                        continue;
                    }
                    if (string3.startsWith("FALSE")) {
                        this.setParam(n8, false);
                        continue;
                    }
                    this.setParam(n8, (int)this.parseDouble(string3));
                }
                catch (Exception exception) {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                    throw new IllegalArgumentException("line " + n2 + " was bad: '" + string2 + "'");
                }
            }
            double d = 2.0;
            if (this.getParamVersionNumber() < d) {
                System.out.println("Old config file format " + this.getParamVersionNumber() + " upgrading to format " + d);
                for (int i = 0; i < 4; ++i) {
                    this.setParam(0x20000000, i, this.getParamDouble(15290));
                    this.setParam(0x20000001, i, this.getParamDouble(15291));
                    this.setParam(0x20000002, i, this.getParamDouble(15292));
                    this.setParam(0x20000003, i, this.getParamDouble(15293));
                    this.setParam(0x20000004, i, this.getParamDouble(15294));
                }
                this.setParamVersionNumber(d);
            }
            d = 3.0;
            if (this.getParamVersionNumber() < d) {
                System.out.println("Old config file format " + this.getParamVersionNumber() + " upgrading to format " + d);
                int n11 = this.getParamInt(15306);
                this.setParam(0x10000000, n11, "SHIFT LEFT");
                this.setParam(0x10000001, n11, "JOG_A_MINUS");
                this.setParam(0x10000000, ++n11, "SHIFT RIGHT");
                this.setParam(0x10000001, n11, "JOG_A_PLUS");
                this.setParam(0x10000000, ++n11, "SHIFT DOWN");
                this.setParam(0x10000001, n11, "JOG_Z_MINUS");
                this.setParam(0x10000000, ++n11, "SHIFT UP");
                this.setParam(0x10000001, n11, "JOG_Z_PLUS");
                this.setParam(15306, ++n11);
                this.setParamVersionNumber(d);
            }
            d = 4.0;
            if (this.getParamVersionNumber() < d) {
                System.out.println("Old config file format " + this.getParamVersionNumber() + " upgrading to format " + d);
                for (int i = 4; i < 6; ++i) {
                    this.setParam(-2147483645, i, false);
                }
                if (this.getParamBoolean(15165)) {
                    this.setParam(-2147483638, 3, -1);
                    this.setParam(-2147483637, 3, -1);
                    this.setParam(-2147483637, 0, 3);
                }
                this.setParamVersionNumber(d);
            }
            d = 5.0;
            if (this.getParamVersionNumber() < d) {
                System.out.println("Old config file format " + this.getParamVersionNumber() + " upgrading to format " + d);
                for (int i = 0; i < 6; ++i) {
                    this.setParam(-2147483647, i, 0.0);
                }
                this.setParamVersionNumber(d);
            }
            d = 6.0;
            if (this.getParamVersionNumber() < d) {
                System.out.println("Old config file format " + this.getParamVersionNumber() + " upgrading to format " + d);
                this.setParamVersionNumber(d);
            }
            for (n = 0; n < 4; ++n) {
                if (!(this.getParamDouble(0x20000004, n) <= 0.0)) continue;
                this.setParam(0x20000004, n, 0.1);
            }
            for (n = 0; n < 4; ++n) {
                if (!(this.getParamDouble(-2147483641, n) < this.getParamDouble(-2147483642, n))) continue;
                double d2 = this.getParamDouble(-2147483642, n);
                this.setParam(-2147483642, n, this.getParamDouble(-2147483641, n));
                this.setParam(-2147483641, n, d2);
            }
            try {
                if ("English (US)".equals(this.getParamString(15299))) {
                    this.setParam(15299, "English");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            double d3 = 7.0;
            if (this.getParamVersionNumber() < d3) {
                System.out.println("Old config file format " + this.getParamVersionNumber() + " upgrading to format " + d3);
                int n12 = this.getParamInt(15306);
                this.setParam(0x10000000, n12, "MPG:Feed-");
                this.setParam(0x10000001, n12, "FEED_OVERRIDE_MINUS");
                this.setParam(0x10000000, ++n12, "MPG:Feed+");
                this.setParam(0x10000001, n12, "FEED_OVERRIDE_PLUS");
                this.setParam(0x10000000, ++n12, "MPG:Spindle-");
                this.setParam(0x10000001, n12, "SPINDLE_OVERRIDE_MINUS");
                this.setParam(0x10000000, ++n12, "MPG:Spindle+");
                this.setParam(0x10000001, n12, "SPINDLE_OVERRIDE_PLUS");
                this.setParam(0x10000000, ++n12, "MPG:Start/Pause");
                this.setParam(0x10000001, n12, "MPG_RUN_HOLD_TOGGLE");
                this.setParam(0x10000000, ++n12, "MPG:Stop");
                this.setParam(0x10000001, n12, "MPG_STOP");
                this.setParam(0x10000000, ++n12, "MPG:Goto Origin");
                this.setParam(0x10000001, n12, "MPG_GOTO_ORIGIN_XY");
                this.setParam(0x10000000, ++n12, "MPG:Safe-Z");
                this.setParam(0x10000001, n12, "MPG_GOTO_SAFE_Z");
                this.setParam(0x10000000, ++n12, "MPG:Probe-Z");
                this.setParam(0x10000001, n12, "MPG_PROBE_Z");
                this.setParam(0x10000000, ++n12, "MPG:RESET");
                this.setParam(0x10000001, n12, "MPG_HOME");
                this.setParam(15306, ++n12);
            }
            if (2 == this.getParamInt(15355)) {
                this.setParam(15150, 0.02);
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public MachiningState getMachiningState() {
        return this.m_MachiningState;
    }

    public Object getParam(int n, int n2) {
        return this.getParam(MachState.getIndex(n, n2));
    }

    public Object getParam(int n) {
        if ((n & 0xFC000000) != 0) {
            return "<parameter " + n + " indexed>";
        }
        if (n < 0 || n > this.m_ParamType.length || this.m_ParamType[n] == null) {
            return "<parameter " + n + " is undefined>";
        }
        try {
            switch (this.m_ParamType[n]) {
                case BOOLEAN: {
                    return this.getParamBoolean(n);
                }
                case INTEGER: {
                    return this.getParamInt(n);
                }
                case DOUBLE: {
                    return this.getParamDouble(n);
                }
                case STRING: {
                    return this.getParamString(n);
                }
            }
            return "<parameter " + n + " has bad type " + this.m_ParamType[n] + ">";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "<" + illegalArgumentException.getMessage() + ">";
        }
    }

    public Multiplexer getCurrentToolDiameterVariable() {
        if (this.m_CurrentToolDiameterMux == null) {
            this.m_CurrentToolDiameterMux = new Multiplexer((Variable)this.getVariable(15147), new Variable[0]){

                @Override
                public Variable getVariable(Variable variable) {
                    return new NumericVariable(0.0){

                        @Override
                        public Object getValue() {
                            int n = MachState.this.getParamInt(15147);
                            if (n < 1) {
                                return 0.0;
                            }
                            return MachState.this.getParamDouble(0x40000000, n - 1);
                        }

                        @Override
                        public void setValue(Object object) {
                            this.validate(object);
                            int n = MachState.this.getParamInt(15147);
                            if (n < 1) {
                                return;
                            }
                            MachState.this.setParam(0x40000000, n - 1, object);
                            super.setValue(object);
                        }
                    };
                }
            };
        }
        return this.m_CurrentToolDiameterMux;
    }

    public Multiplexer getCurrentToolLengthVariable() {
        if (this.m_CurrentToolLengthMux == null) {
            this.m_CurrentToolLengthMux = new Multiplexer((Variable)this.getVariable(15147), new Variable[0]){

                @Override
                public Variable getVariable(Variable variable) {
                    return new NumericVariable(0.0){

                        @Override
                        public Object getValue() {
                            int n = MachState.this.getParamInt(15147);
                            if (n < 1) {
                                return 0.0;
                            }
                            return MachState.this.getParamDouble(0x40000001, n - 1);
                        }

                        @Override
                        public void setValue(Object object) {
                            this.validate(object);
                            int n = MachState.this.getParamInt(15147);
                            if (n < 1) {
                                return;
                            }
                            MachState.this.setParam(0x40000001, n - 1, object);
                            MachState.this.setParam(15137, n);
                            super.setValue(object);
                        }
                    };
                }
            };
        }
        return this.m_CurrentToolLengthMux;
    }

    private void putParam(JSONObject jSONObject, String string, Object object) {
        if (object instanceof Double) {
            double d = (Double)object;
            if (Double.isNaN(d)) {
                object = "NaN";
            } else if (Double.isInfinite(d)) {
                object = d > 0.0 ? "Inf+" : "Inf-";
            }
        }
        jSONObject.put(string, object);
    }

    private static JSONObject newJSONObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            Field field = jSONObject.getClass().getDeclaredField("map");
            field.setAccessible(true);
            field.set(jSONObject, new LinkedHashMap());
            field.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        return jSONObject;
    }

    public String getStateAsJSON() throws Exception {
        JSONObject jSONObject;
        double d;
        JSONObject jSONObject2 = MachState.newJSONObject();
        this.putParam(jSONObject2, "FIRST_CANNED_MODE", this.getParam(4));
        this.putParam(jSONObject2, "AXIS_SCALING_ON", this.getParam(15135));
        this.putParam(jSONObject2, "MAX_ACCELERATION", this.getParam(15148));
        this.putParam(jSONObject2, "MAX_VELOCITY", this.getParam(15149));
        this.putParam(jSONObject2, "MAX_JERK", this.getParam(15169));
        this.putParam(jSONObject2, "CANNED_CYCLE_RETRACT_LEVEL", this.getParam(15177));
        this.putParam(jSONObject2, "CANNED_CYCLE_PECK_DISTANCE", this.getParam(15178));
        this.putParam(jSONObject2, "CANNED_CYCLE_HOLE_BOTTOM", this.getParam(15179));
        this.putParam(jSONObject2, "CANNED_CYCLE_INITIAL_LEVEL", this.getParam(15180));
        this.putParam(jSONObject2, "CANNED_CYCLE_DRILL_DWELL", this.getParam(15181));
        this.putParam(jSONObject2, "CANNED_CYCLE_RECTRACT_DISTANCE", this.getParam(15182));
        this.putParam(jSONObject2, "PARAM_2000_G31_PROBE", this.getParam(2000));
        this.putParam(jSONObject2, "PARAM_5161_G28_HOME", this.getParam(5161));
        this.putParam(jSONObject2, "PARAM_5181_G30_HOME", this.getParam(5181));
        this.putParam(jSONObject2, "PARAM_5191_SCALE", this.getParam(5191));
        this.putParam(jSONObject2, "PARAM_5220_WORK_OFFSET_NO", this.getParam(5220));
        this.putParam(jSONObject2, "PARAM_5221_WORK_OFFSET_1", this.getParam(5221));
        this.putParam(jSONObject2, "G92_SAVED_OFFSETS", this.getParam(15000));
        this.putParam(jSONObject2, "JOG_LO_VELOCITY_OBSOLETE", this.getParam(15290));
        this.putParam(jSONObject2, "JOG_HI_VELOCITY_OBSOLETE", this.getParam(15291));
        this.putParam(jSONObject2, "JOG_ACCELERATION_OBSOLETE", this.getParam(15292));
        this.putParam(jSONObject2, "JOG_CRAWL_OBSOLETE", this.getParam(15293));
        this.putParam(jSONObject2, "JOG_PORCH_OBSOLETE", this.getParam(15294));
        this.putParam(jSONObject2, "NUMBER_OF_MACRO_FILE_NAMES_OBSOLETE", this.getParam(10));
        this.putParam(jSONObject2, "MACRO_FILE_NAME_BASE_OBSOLETE", this.getParam(15310));
        this.putParam(jSONObject2, "MAX_NUMBER_OF_SHORTCUTS", this.getParam(200));
        this.putParam(jSONObject2, "JOYSTICK_MAX_NUMBER_OF_BUTTONS", this.getParam(64));
        this.putParam(jSONObject2, "JOYSTICK_STICK_NEGATIVE_CENTERED", this.getParam(0));
        this.putParam(jSONObject2, "AXIS_GRID_SIZE_MODE", this.getParam(16500));
        this.putParam(jSONObject2, "AXIS_GRID_SIZE_MODE_MANUAL", this.getParam(0));
        this.putParam(jSONObject2, "AXIS_GRID_SIZE_MODE_AUTOMATIC", this.getParam(1));
        this.putParam(jSONObject2, "AXIS_GRID_LINE_WIDTH", this.getParam(16501));
        this.putParam(jSONObject2, "AXIS_GRID_SPACING", this.getParam(16502));
        this.putParam(jSONObject2, "AXIS_GRID_X_MIN", this.getParam(16503));
        this.putParam(jSONObject2, "AXIS_GRID_Y_MIN", this.getParam(16504));
        this.putParam(jSONObject2, "AXIS_GRID_Z_MIN", this.getParam(16506));
        this.putParam(jSONObject2, "AXIS_GRID_X_MAX", this.getParam(16507));
        this.putParam(jSONObject2, "AXIS_GRID_Y_MAX", this.getParam(16508));
        this.putParam(jSONObject2, "AXIS_GRID_Z_MAX", this.getParam(16509));
        this.putParam(jSONObject2, "AXIS_GRID_XY_POS", this.getParam(16510));
        this.putParam(jSONObject2, "AXIS_GRID_YZ_POS", this.getParam(16511));
        this.putParam(jSONObject2, "AXIS_GRID_ZX_POS", this.getParam(16512));
        this.putParam(jSONObject2, "ACTIVE_PLANE", this.getParam(15101));
        this.putParam(jSONObject2, "PATH_CONTROL_MODE", this.getParam(15102));
        this.putParam(jSONObject2, "MOTION_MODE", this.getParam(15122));
        this.putParam(jSONObject2, "FEED_RATE_MODE", this.getParam(15123));
        this.putParam(jSONObject2, "COOLANT_ON", this.getParam(15124));
        this.putParam(jSONObject2, "COOLANT_TYPE", this.getParam(15125));
        this.putParam(jSONObject2, "SPINDLE_ON", this.getParam(15126));
        this.putParam(jSONObject2, "SPINDLE_SPEED", this.getParam(15127));
        this.putParam(jSONObject2, "SPINDLE_DIRECTION", this.getParam(15128));
        this.putParam(jSONObject2, "POLAR_MODE_ON", this.getParam(15129));
        this.putParam(jSONObject2, "ROTATION_ON", this.getParam(15130));
        this.putParam(jSONObject2, "FEED_OVERRIDE_ON", this.getParam(15131));
        this.putParam(jSONObject2, "FEED_OVERRIDE", this.getParam(15132));
        this.putParam(jSONObject2, "INCREMENTAL_XYZ_MODE", this.getParam(15133));
        this.putParam(jSONObject2, "INCREMENTAL_IJK_MODE", this.getParam(15134));
        this.putParam(jSONObject2, "SCALING_ON", this.getParam(15135));
        this.putParam(jSONObject2, "RADIUS_COMPENSATION", this.getParam(15136));
        this.putParam(jSONObject2, "LENGTH_COMPENSATION", this.getParam(15137));
        this.putParam(jSONObject2, "ROT_ANGLE", this.getParam(15138));
        this.putParam(jSONObject2, "ROT_CENTER_X", this.getParam(15139));
        this.putParam(jSONObject2, "ROT_CENTER_Y", this.getParam(15140));
        this.putParam(jSONObject2, "UNIT_SIZE", this.getParam(15141));
        this.putParam(jSONObject2, "POLAR_ORIGIN_X", this.getParam(15142));
        this.putParam(jSONObject2, "POLAR_ORIGIN_Y", this.getParam(15143));
        this.putParam(jSONObject2, "PATH_TOLERANCE", this.getParam(15144));
        this.putParam(jSONObject2, "FEED_RATE", this.getParam(15145));
        this.putParam(jSONObject2, "MOTION_RATE", this.getParam(15146));
        this.putParam(jSONObject2, "CURRENT_TOOL", this.getParam(15147));
        this.putParam(jSONObject2, "CYCLE_TIME", this.getParam(15150));
        this.putParam(jSONObject2, "PROBE_DIAMETER", this.getParam(15151));
        this.putParam(jSONObject2, "Z_GAGE_HEIGHT", this.getParam(15152));
        this.putParam(jSONObject2, "TOOL_GAGE_HEIGHT", this.getParam(15153));
        this.putParam(jSONObject2, "SPINDLE_SPEED_STEP", this.getParam(15158));
        this.putParam(jSONObject2, "P_WORD_IN_MSEC", this.getParam(15159));
        this.putParam(jSONObject2, "SPINDLE_OVERRIDE_SPEED", this.getParam(15161));
        this.putParam(jSONObject2, "SPINDLE_OVERRIDE_ON", this.getParam(15162));
        this.putParam(jSONObject2, "FEED_IN_UNITS_PER_MINUTE", this.getParam(15163));
        this.putParam(jSONObject2, "Z_SPEED_SCALER", this.getParam(15164));
        this.putParam(jSONObject2, "X_PAIRED_WITH_A", this.getParam(15165));
        this.putParam(jSONObject2, "PAUSE_AT_M1", this.getParam(15166));
        this.putParam(jSONObject2, "JOG_KEYS_MODE", this.getParam(15167));
        this.putParam(jSONObject2, "JOG_MODE", this.getParam(15168));
        this.putParam(jSONObject2, "RADIUS_COMPENSATION_MITER_JOIN", this.getParam(15170));
        this.putParam(jSONObject2, "RADIUS_COMPENSATION_MITER_JOIN_LIMIT_PERCENTAGE", this.getParam(15171));
        this.putParam(jSONObject2, "ARC_TOLERANCE", this.getParam(15172));
        this.putParam(jSONObject2, "RADIUS_COMPENSATION_SMALL_ARC_LIMIT_PERCENTAGE", this.getParam(15173));
        this.putParam(jSONObject2, "AUTO_SPINDLE_OFF", this.getParam(15174));
        this.putParam(jSONObject2, "AUTO_COOLANT_OFF", this.getParam(15175));
        this.putParam(jSONObject2, "PROBE_POLARITY", this.getParam(15176));
        this.putParam(jSONObject2, "TOUCH_MODE", this.getParam(15189));
        this.putParam(jSONObject2, "USE_PROBE_TO_TOUCH", this.getParam(15190));
        this.putParam(jSONObject2, "USE_AUTO_TOOL_SETTER_TO_TOUCH", this.getParam(15191));
        this.putParam(jSONObject2, "SAFE_Z", this.getParam(15192));
        this.putParam(jSONObject2, "CALIB_GAZE_SIZE", this.getParam(15193));
        this.putParam(jSONObject2, "TOAD4_COMM_LOG_ENABLE", this.getParam(15295));
        this.putParam(jSONObject2, "JAVA_CONSOLE_LOG_ENABLE", this.getParam(15296));
        this.putParam(jSONObject2, "SCREEN_UPDATE_RATE", this.getParam(15297));
        this.putParam(jSONObject2, "UI_SIZE", this.getParam(15298));
        this.putParam(jSONObject2, "LANGUAGE", this.getParam(15299));
        this.putParam(jSONObject2, "DISPLAY_FORMAT", this.getParam(15300));
        this.putParam(jSONObject2, "FILEDIALOG_START_DIRECTORY", this.getParam(15301));
        this.putParam(jSONObject2, "COM_PORT_NAME", this.getParam(15302));
        this.putParam(jSONObject2, "MOTOR_TEST_ACCELERATION", this.getParam(15303));
        this.putParam(jSONObject2, "MOTOR_TEST_START_VELOCITY", this.getParam(15304));
        this.putParam(jSONObject2, "MOTOR_TEST_TOP_VELOCITY", this.getParam(15305));
        this.putParam(jSONObject2, "MOTOR_TEST_DIRECTION", this.getParam(15307));
        this.putParam(jSONObject2, "MOTOR_TEST_JERK", this.getParam(15308));
        this.putParam(jSONObject2, "COLOR_X_AXIS", this.getParam(15320));
        this.putParam(jSONObject2, "COLOR_Y_AXIS", this.getParam(15321));
        this.putParam(jSONObject2, "COLOR_Z_AXIS", this.getParam(15322));
        this.putParam(jSONObject2, "TOOL_WIDTH_DISPLAY_OVERRIDE", this.getParam(15330));
        this.putParam(jSONObject2, "COLOR_TOOL", this.getParam(15331));
        this.putParam(jSONObject2, "COLOR_PATH_MACHINED_SPINDLE_ON", this.getParam(15335));
        this.putParam(jSONObject2, "COLOR_PATH_MACHINED_SPINDLE_OFF", this.getParam(15336));
        this.putParam(jSONObject2, "COLOR_PATH_PLANNED_SPINDLE_ON", this.getParam(15337));
        this.putParam(jSONObject2, "COLOR_PATH_PLANNED_SPINDLE_OFF", this.getParam(15338));
        this.putParam(jSONObject2, "PLANNED_TOOLPATH_WIDTH", this.getParam(15339));
        this.putParam(jSONObject2, "MACHINED_TOOLPATH_WIDTH", this.getParam(15340));
        this.putParam(jSONObject2, "EXPORT_FORMAT", this.getParam(15350));
        this.putParam(jSONObject2, "CSV_NUMBER_FORMAT", this.getParam(15351));
        this.putParam(jSONObject2, "CSV_LIST_ITEM_SEPARATOR", this.getParam(15352));
        this.putParam(jSONObject2, "USE_COMM_PORT", this.getParam(15353));
        this.putParam(jSONObject2, "MOTOR_CONTROLLER", this.getParam(15355));
        this.putParam(jSONObject2, "USE_NEW_ARC_INTERPOLATOR", this.getParam(15288));
        this.putParam(jSONObject2, "TOUCH_PLATE_USE_CURRENT_TOOL", this.getParam(15206));
        this.putParam(jSONObject2, "TOUCH_PLATE_VERTICAL_EDGE", this.getParam(15207));
        this.putParam(jSONObject2, "TOUCH_PLATE_HORIZONTAL_EDGE", this.getParam(15208));
        this.putParam(jSONObject2, "TOUCH_PLATE_PROBE_Z", this.getParam(15209));
        this.putParam(jSONObject2, "TOUCH_PLATE_PROBE_ROTATION", this.getParam(15210));
        this.putParam(jSONObject2, "TOUCH_PLATE_TOOL_DIAMETER", this.getParam(15211));
        this.putParam(jSONObject2, "TOUCH_PLATE_PROBE_Z_DISTANCE", this.getParam(15212));
        this.putParam(jSONObject2, "TOUCH_PLATE_PROBE_XY_DISTANCE", this.getParam(15213));
        this.putParam(jSONObject2, "TOUCH_PLATE_PROBE_ROTATION_DISTANCE", this.getParam(15214));
        this.putParam(jSONObject2, "WINDOW_SPLIT", this.getParam(15215));
        this.putParam(jSONObject2, "WINDOW_POS_X", this.getParam(15216));
        this.putParam(jSONObject2, "WINDOW_POS_Y", this.getParam(15217));
        this.putParam(jSONObject2, "WINDOW_WIDTH", this.getParam(15218));
        this.putParam(jSONObject2, "WINDOW_HEIGHT", this.getParam(15219));
        this.putParam(jSONObject2, "FULLSCREEN_MODE", this.getParam(15220));
        this.putParam(jSONObject2, "SHUTDOWN_ON_QUIT", this.getParam(15221));
        this.putParam(jSONObject2, "ONSCREEN_KEYBOARD", this.getParam(15222));
        this.putParam(jSONObject2, "LO_SPINDLE_SPEED", this.getParam(15359));
        this.putParam(jSONObject2, "HI_SPINDLE_SPEED", this.getParam(15360));
        this.putParam(jSONObject2, "LO_SPINDLE_SPEED_DAC", this.getParam(15357));
        this.putParam(jSONObject2, "HI_SPINDLE_SPEED_DAC", this.getParam(15358));
        this.putParam(jSONObject2, "SPINDLE_SPEED_MIN", this.getParam(15156));
        this.putParam(jSONObject2, "SPINDLE_SPEED_MAX", this.getParam(15157));
        this.putParam(jSONObject2, "ENABLE_CLICK_SOUND", this.getParam(15356));
        JSONObject jSONObject3 = MachState.newJSONObject();
        this.putParam(jSONObject2, "GRID", jSONObject3);
        this.putParam(jSONObject3, "SIZE_MODE", this.getParam(16500));
        this.putParam(jSONObject3, "LINE_WIDTH", this.getParam(16501));
        this.putParam(jSONObject3, "SPACING", this.getParam(16502));
        this.putParam(jSONObject3, "X_MIN", this.getParam(16503));
        this.putParam(jSONObject3, "Y_MIN", this.getParam(16504));
        this.putParam(jSONObject3, "Z_MIN", this.getParam(16506));
        this.putParam(jSONObject3, "X_MAX", this.getParam(16507));
        this.putParam(jSONObject3, "Y_MAX", this.getParam(16508));
        this.putParam(jSONObject3, "Z_MAX", this.getParam(16509));
        this.putParam(jSONObject3, "XY_POS", this.getParam(16510));
        this.putParam(jSONObject3, "YZ_POS", this.getParam(16511));
        this.putParam(jSONObject3, "ZX_POS", this.getParam(16512));
        JSONArray jSONArray = new JSONArray();
        this.putParam(jSONObject2, "PROBE_OFFSETS", jSONArray);
        for (int i = 0; i < 6; ++i) {
            JSONObject jSONObject4 = MachState.newJSONObject();
            jSONArray.put((Object)jSONObject4);
            this.putParam(jSONObject4, "#", i);
            this.putParam(jSONObject4, "NEG_OFFSET", this.getParam(0x4000000, i));
            this.putParam(jSONObject4, "POS_OFFSET", this.getParam(0x4000001, i));
        }
        JSONArray jSONArray2 = new JSONArray();
        this.putParam(jSONObject2, "AXIS", jSONArray2);
        for (int i = 0; i < 6; ++i) {
            JSONObject jSONObject5 = MachState.newJSONObject();
            jSONArray2.put((Object)jSONObject5);
            this.putParam(jSONObject5, "#", i);
            this.putParam(jSONObject5, "CURRENT_MODE", this.getParam(Integer.MIN_VALUE, i));
            this.putParam(jSONObject5, "STEP_MODE", this.getParam(-2147483647, i));
            this.putParam(jSONObject5, "HOME_POSITION", this.getParam(-2147483647, i));
            this.putParam(jSONObject5, "STEP_RATIO", this.getParam(-2147483646, i));
            this.putParam(jSONObject5, "MACH_ENABLED", this.getParam(-2147483645, i));
            this.putParam(jSONObject5, "HOME_POLARITY", this.getParam(-2147483644, i));
            this.putParam(jSONObject5, "DIR_POLARITY", this.getParam(-2147483643, i));
            this.putParam(jSONObject5, "LIMIT_MIN", this.getParam(-2147483642, i));
            this.putParam(jSONObject5, "LIMIT_MAX", this.getParam(-2147483641, i));
            this.putParam(jSONObject5, "LIMIT_ENABLED", this.getParam(-2147483640, i));
            this.putParam(jSONObject5, "AUTO_ZERO", this.getParam(-2147483639, i));
            this.putParam(jSONObject5, "MASTER_MOTOR", this.getParam(-2147483638, i));
            this.putParam(jSONObject5, "SLAVE_MOTOR", this.getParam(-2147483637, i));
            this.putParam(jSONObject5, "HOMING_CRAWL_SPEED", this.getParam(-2147483636, i));
            this.putParam(jSONObject5, "HOMING_MAX_SPEED", this.getParam(-2147483635, i));
            this.putParam(jSONObject5, "HOMING_ACCELERATION", this.getParam(-2147483634, i));
            this.putParam(jSONObject5, "VELOCITY_SCALER", this.getParam(-2147483633, i));
            this.putParam(jSONObject5, "MOTOR_INVERT_ENABLE", this.getParam(-2147483632, i));
        }
        JSONArray jSONArray3 = new JSONArray();
        this.putParam(jSONObject2, "JOG_SETTINGS", jSONArray3);
        for (int i = 0; i < 6; ++i) {
            JSONObject jSONObject6 = MachState.newJSONObject();
            jSONArray3.put((Object)jSONObject6);
            this.putParam(jSONObject6, "#", i);
            this.putParam(jSONObject6, "LO_VELOCITY", this.getParam(0x20000000, i));
            this.putParam(jSONObject6, "HI_VELOCITY", this.getParam(0x20000001, i));
            this.putParam(jSONObject6, "ACCELERATION", this.getParam(0x20000002, i));
            this.putParam(jSONObject6, "CRAWL", this.getParam(0x20000003, i));
            this.putParam(jSONObject6, "MIN_CRAWL", this.getParam(0x20000004, i));
        }
        JSONArray jSONArray4 = new JSONArray();
        this.putParam(jSONObject2, "TOOL_CONFIGS", jSONArray4);
        for (int i = 0; i < 255; ++i) {
            double d2 = (Double)this.getParam(0x40000000, i);
            d = (Double)this.getParam(0x40000001, i);
            if (d == 0.0 && d2 == 0.0) continue;
            jSONObject = MachState.newJSONObject();
            jSONArray4.put((Object)jSONObject);
            this.putParam(jSONObject, "#", i);
            this.putParam(jSONObject, "DIAMETER", d2);
            this.putParam(jSONObject, "LENGTH", d);
        }
        JSONArray jSONArray5 = new JSONArray();
        this.putParam(jSONObject2, "SHORTCUTS", jSONArray5);
        for (int i = 0; i < this.getParamInt(15306); ++i) {
            JSONObject jSONObject7 = MachState.newJSONObject();
            jSONArray5.put((Object)jSONObject7);
            this.putParam(jSONObject7, "KEY_NAME", this.getParam(0x10000000, i));
            this.putParam(jSONObject7, "ACTION_NAME", this.getParam(0x10000001, i));
        }
        JSONArray jSONArray6 = new JSONArray();
        this.putParam(jSONObject2, "PARAMETERS", jSONArray6);
        for (int i = 5000; i <= 10320; ++i) {
            d = ((Number)this.getParam(i)).doubleValue();
            if (d == 0.0) continue;
            jSONObject = MachState.newJSONObject();
            jSONArray6.put((Object)jSONObject);
            this.putParam(jSONObject, "PARAM", i);
            this.putParam(jSONObject, "VALUE", d);
        }
        return jSONObject2.toString(4);
    }

    private void loadParam(JSONObject jSONObject, String string, int n) {
        if (this.m_LoadedParameterNames != null && !this.m_LoadedParameterNames.contains(string)) {
            this.m_LoadedParameterNames.add(string);
        }
        try {
            if (jSONObject.has(string)) {
                this.setParam(n, jSONObject.get(string));
            } else {
                System.err.println("Using default value for parameter '" + string + "'.");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to load parameter '" + string + "'.");
        }
    }

    private void loadParam(JSONObject jSONObject, String string, int n, int n2) {
        if (this.m_LoadedParameterNames != null && !this.m_LoadedParameterNames.contains(string)) {
            this.m_LoadedParameterNames.add(string);
        }
        try {
            if (jSONObject.has(string)) {
                this.setParam(n, n2, jSONObject.get(string));
            } else {
                System.err.println("Using default value for parameter '" + string + "'.");
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to load parameter '" + string + "'.");
        }
    }

    public void loadStateFromJSON(String string) throws Exception {
        JSONObject jSONObject;
        this.m_LoadedParameterNames = new LinkedList();
        this.setParam(15222, false);
        JSONObject jSONObject2 = new JSONObject(string);
        this.loadParam(jSONObject2, "FIRST_CANNED_MODE", 4);
        this.loadParam(jSONObject2, "AXIS_SCALING_ON", 15135);
        this.loadParam(jSONObject2, "MAX_ACCELERATION", 15148);
        this.loadParam(jSONObject2, "MAX_VELOCITY", 15149);
        this.loadParam(jSONObject2, "MAX_JERK", 15169);
        this.loadParam(jSONObject2, "CANNED_CYCLE_RETRACT_LEVEL", 15177);
        this.loadParam(jSONObject2, "CANNED_CYCLE_PECK_DISTANCE", 15178);
        this.loadParam(jSONObject2, "CANNED_CYCLE_HOLE_BOTTOM", 15179);
        this.loadParam(jSONObject2, "CANNED_CYCLE_INITIAL_LEVEL", 15180);
        this.loadParam(jSONObject2, "CANNED_CYCLE_DRILL_DWELL", 15181);
        this.loadParam(jSONObject2, "CANNED_CYCLE_RECTRACT_DISTANCE", 15182);
        this.loadParam(jSONObject2, "PARAM_2000_G31_PROBE", 2000);
        this.loadParam(jSONObject2, "PARAM_5161_G28_HOME", 5161);
        this.loadParam(jSONObject2, "PARAM_5181_G30_HOME", 5181);
        this.loadParam(jSONObject2, "PARAM_5191_SCALE", 5191);
        this.loadParam(jSONObject2, "PARAM_5220_WORK_OFFSET_NO", 5220);
        this.loadParam(jSONObject2, "PARAM_5221_WORK_OFFSET_1", 5221);
        this.loadParam(jSONObject2, "G92_SAVED_OFFSETS", 15000);
        this.loadParam(jSONObject2, "JOG_LO_VELOCITY_OBSOLETE", 15290);
        this.loadParam(jSONObject2, "JOG_HI_VELOCITY_OBSOLETE", 15291);
        this.loadParam(jSONObject2, "JOG_ACCELERATION_OBSOLETE", 15292);
        this.loadParam(jSONObject2, "JOG_CRAWL_OBSOLETE", 15293);
        this.loadParam(jSONObject2, "JOG_PORCH_OBSOLETE", 15294);
        this.loadParam(jSONObject2, "MACRO_FILE_NAME_BASE_OBSOLETE", 15310);
        this.loadParam(jSONObject2, "JOYSTICK_STICK_NEGATIVE_CENTERED", 0);
        this.loadParam(jSONObject2, "AXIS_GRID_SIZE_MODE", 16500);
        this.loadParam(jSONObject2, "AXIS_GRID_SIZE_MODE_MANUAL", 0);
        this.loadParam(jSONObject2, "AXIS_GRID_SIZE_MODE_AUTOMATIC", 1);
        this.loadParam(jSONObject2, "AXIS_GRID_LINE_WIDTH", 16501);
        this.loadParam(jSONObject2, "AXIS_GRID_SPACING", 16502);
        this.loadParam(jSONObject2, "AXIS_GRID_X_MIN", 16503);
        this.loadParam(jSONObject2, "AXIS_GRID_Y_MIN", 16504);
        this.loadParam(jSONObject2, "AXIS_GRID_Z_MIN", 16506);
        this.loadParam(jSONObject2, "AXIS_GRID_X_MAX", 16507);
        this.loadParam(jSONObject2, "AXIS_GRID_Y_MAX", 16508);
        this.loadParam(jSONObject2, "AXIS_GRID_Z_MAX", 16509);
        this.loadParam(jSONObject2, "AXIS_GRID_XY_POS", 16510);
        this.loadParam(jSONObject2, "AXIS_GRID_YZ_POS", 16511);
        this.loadParam(jSONObject2, "AXIS_GRID_ZX_POS", 16512);
        this.loadParam(jSONObject2, "ACTIVE_PLANE", 15101);
        this.loadParam(jSONObject2, "PATH_CONTROL_MODE", 15102);
        this.loadParam(jSONObject2, "MOTION_MODE", 15122);
        this.loadParam(jSONObject2, "FEED_RATE_MODE", 15123);
        this.loadParam(jSONObject2, "COOLANT_ON", 15124);
        this.loadParam(jSONObject2, "COOLANT_TYPE", 15125);
        this.loadParam(jSONObject2, "SPINDLE_ON", 15126);
        this.loadParam(jSONObject2, "SPINDLE_SPEED", 15127);
        this.loadParam(jSONObject2, "SPINDLE_DIRECTION", 15128);
        this.loadParam(jSONObject2, "POLAR_MODE_ON", 15129);
        this.loadParam(jSONObject2, "ROTATION_ON", 15130);
        this.loadParam(jSONObject2, "FEED_OVERRIDE_ON", 15131);
        this.loadParam(jSONObject2, "FEED_OVERRIDE", 15132);
        this.loadParam(jSONObject2, "INCREMENTAL_XYZ_MODE", 15133);
        this.loadParam(jSONObject2, "INCREMENTAL_IJK_MODE", 15134);
        this.loadParam(jSONObject2, "SCALING_ON", 15135);
        this.loadParam(jSONObject2, "RADIUS_COMPENSATION", 15136);
        this.loadParam(jSONObject2, "LENGTH_COMPENSATION", 15137);
        this.loadParam(jSONObject2, "ROT_ANGLE", 15138);
        this.loadParam(jSONObject2, "ROT_CENTER_X", 15139);
        this.loadParam(jSONObject2, "ROT_CENTER_Y", 15140);
        this.loadParam(jSONObject2, "UNIT_SIZE", 15141);
        this.loadParam(jSONObject2, "POLAR_ORIGIN_X", 15142);
        this.loadParam(jSONObject2, "POLAR_ORIGIN_Y", 15143);
        this.loadParam(jSONObject2, "PATH_TOLERANCE", 15144);
        this.loadParam(jSONObject2, "FEED_RATE", 15145);
        this.loadParam(jSONObject2, "MOTION_RATE", 15146);
        this.loadParam(jSONObject2, "CURRENT_TOOL", 15147);
        this.loadParam(jSONObject2, "CYCLE_TIME", 15150);
        this.loadParam(jSONObject2, "PROBE_DIAMETER", 15151);
        this.loadParam(jSONObject2, "Z_GAGE_HEIGHT", 15152);
        this.loadParam(jSONObject2, "TOOL_GAGE_HEIGHT", 15153);
        this.loadParam(jSONObject2, "SPINDLE_SPEED_STEP", 15158);
        this.loadParam(jSONObject2, "P_WORD_IN_MSEC", 15159);
        this.loadParam(jSONObject2, "SPINDLE_OVERRIDE_SPEED", 15161);
        this.loadParam(jSONObject2, "SPINDLE_OVERRIDE_ON", 15162);
        this.loadParam(jSONObject2, "FEED_IN_UNITS_PER_MINUTE", 15163);
        this.loadParam(jSONObject2, "Z_SPEED_SCALER", 15164);
        this.loadParam(jSONObject2, "X_PAIRED_WITH_A", 15165);
        this.loadParam(jSONObject2, "PAUSE_AT_M1", 15166);
        this.loadParam(jSONObject2, "JOG_KEYS_MODE", 15167);
        this.loadParam(jSONObject2, "JOG_MODE", 15168);
        this.loadParam(jSONObject2, "RADIUS_COMPENSATION_MITER_JOIN", 15170);
        this.loadParam(jSONObject2, "RADIUS_COMPENSATION_MITER_JOIN_LIMIT_PERCENTAGE", 15171);
        this.loadParam(jSONObject2, "ARC_TOLERANCE", 15172);
        this.loadParam(jSONObject2, "RADIUS_COMPENSATION_SMALL_ARC_LIMIT_PERCENTAGE", 15173);
        this.loadParam(jSONObject2, "AUTO_SPINDLE_OFF", 15174);
        this.loadParam(jSONObject2, "AUTO_COOLANT_OFF", 15175);
        this.loadParam(jSONObject2, "PROBE_POLARITY", 15176);
        this.loadParam(jSONObject2, "TOUCH_MODE", 15189);
        this.loadParam(jSONObject2, "USE_PROBE_TO_TOUCH", 15190);
        this.loadParam(jSONObject2, "USE_AUTO_TOOL_SETTER_TO_TOUCH", 15191);
        this.loadParam(jSONObject2, "SAFE_Z", 15192);
        this.loadParam(jSONObject2, "CALIB_GAZE_SIZE", 15193);
        this.loadParam(jSONObject2, "TOAD4_COMM_LOG_ENABLE", 15295);
        this.loadParam(jSONObject2, "JAVA_CONSOLE_LOG_ENABLE", 15296);
        this.loadParam(jSONObject2, "SCREEN_UPDATE_RATE", 15297);
        this.loadParam(jSONObject2, "UI_SIZE", 15298);
        this.loadParam(jSONObject2, "LANGUAGE", 15299);
        this.loadParam(jSONObject2, "DISPLAY_FORMAT", 15300);
        this.loadParam(jSONObject2, "FILEDIALOG_START_DIRECTORY", 15301);
        this.loadParam(jSONObject2, "COM_PORT_NAME", 15302);
        this.loadParam(jSONObject2, "MOTOR_TEST_ACCELERATION", 15303);
        this.loadParam(jSONObject2, "MOTOR_TEST_START_VELOCITY", 15304);
        this.loadParam(jSONObject2, "MOTOR_TEST_TOP_VELOCITY", 15305);
        this.loadParam(jSONObject2, "MOTOR_TEST_DIRECTION", 15307);
        this.loadParam(jSONObject2, "MOTOR_TEST_JERK", 15308);
        this.loadParam(jSONObject2, "COLOR_X_AXIS", 15320);
        this.loadParam(jSONObject2, "COLOR_Y_AXIS", 15321);
        this.loadParam(jSONObject2, "COLOR_Z_AXIS", 15322);
        this.loadParam(jSONObject2, "TOOL_WIDTH_DISPLAY_OVERRIDE", 15330);
        this.loadParam(jSONObject2, "COLOR_TOOL", 15331);
        this.loadParam(jSONObject2, "COLOR_PATH_MACHINED_SPINDLE_ON", 15335);
        this.loadParam(jSONObject2, "COLOR_PATH_MACHINED_SPINDLE_OFF", 15336);
        this.loadParam(jSONObject2, "COLOR_PATH_PLANNED_SPINDLE_ON", 15337);
        this.loadParam(jSONObject2, "COLOR_PATH_PLANNED_SPINDLE_OFF", 15338);
        this.loadParam(jSONObject2, "PLANNED_TOOLPATH_WIDTH", 15339);
        this.loadParam(jSONObject2, "MACHINED_TOOLPATH_WIDTH", 15340);
        this.loadParam(jSONObject2, "EXPORT_FORMAT", 15350);
        this.loadParam(jSONObject2, "CSV_NUMBER_FORMAT", 15351);
        this.loadParam(jSONObject2, "CSV_LIST_ITEM_SEPARATOR", 15352);
        this.loadParam(jSONObject2, "USE_COMM_PORT", 15353);
        this.loadParam(jSONObject2, "MOTOR_CONTROLLER", 15355);
        this.loadParam(jSONObject2, "USE_NEW_ARC_INTERPOLATOR", 15288);
        this.loadParam(jSONObject2, "TOUCH_PLATE_USE_CURRENT_TOOL", 15206);
        this.loadParam(jSONObject2, "TOUCH_PLATE_VERTICAL_EDGE", 15207);
        this.loadParam(jSONObject2, "TOUCH_PLATE_HORIZONTAL_EDGE", 15208);
        this.loadParam(jSONObject2, "TOUCH_PLATE_PROBE_Z", 15209);
        this.loadParam(jSONObject2, "TOUCH_PLATE_PROBE_ROTATION", 15210);
        this.loadParam(jSONObject2, "TOUCH_PLATE_TOOL_DIAMETER", 15211);
        this.loadParam(jSONObject2, "TOUCH_PLATE_PROBE_Z_DISTANCE", 15212);
        this.loadParam(jSONObject2, "TOUCH_PLATE_PROBE_XY_DISTANCE", 15213);
        this.loadParam(jSONObject2, "TOUCH_PLATE_PROBE_ROTATION_DISTANCE", 15214);
        this.loadParam(jSONObject2, "LO_SPINDLE_SPEED", 15359);
        this.loadParam(jSONObject2, "HI_SPINDLE_SPEED", 15360);
        this.loadParam(jSONObject2, "LO_SPINDLE_SPEED_DAC", 15357);
        this.loadParam(jSONObject2, "HI_SPINDLE_SPEED_DAC", 15358);
        this.loadParam(jSONObject2, "SPINDLE_SPEED_MIN", 15156);
        this.loadParam(jSONObject2, "SPINDLE_SPEED_MAX", 15157);
        this.loadParam(jSONObject2, "ENABLE_CLICK_SOUND", 15356);
        if (jSONObject2.has("WINDOW")) {
            jSONObject = jSONObject2.getJSONObject("WINDOW");
            this.loadParam(jSONObject, "SPLIT", 15215);
            this.loadParam(jSONObject, "POS_X", 15216);
            this.loadParam(jSONObject, "POS_Y", 15217);
            this.loadParam(jSONObject, "WIDTH", 15218);
            this.loadParam(jSONObject, "HEIGHT", 15219);
        } else {
            this.loadParam(jSONObject2, "WINDOW_SPLIT", 15215);
            this.loadParam(jSONObject2, "WINDOW_POS_X", 15216);
            this.loadParam(jSONObject2, "WINDOW_POS_Y", 15217);
            this.loadParam(jSONObject2, "WINDOW_WIDTH", 15218);
            this.loadParam(jSONObject2, "WINDOW_HEIGHT", 15219);
        }
        this.loadParam(jSONObject2, "FULLSCREEN_MODE", 15220);
        this.loadParam(jSONObject2, "SHUTDOWN_ON_QUIT", 15221);
        this.loadParam(jSONObject2, "ONSCREEN_KEYBOARD", 15222);
        jSONObject = jSONObject2.getJSONObject("GRID");
        this.loadParam(jSONObject, "SIZE_MODE", 16500);
        this.loadParam(jSONObject, "LINE_WIDTH", 16501);
        this.loadParam(jSONObject, "SPACING", 16502);
        this.loadParam(jSONObject, "X_MIN", 16503);
        this.loadParam(jSONObject, "Y_MIN", 16504);
        this.loadParam(jSONObject, "Z_MIN", 16506);
        this.loadParam(jSONObject, "X_MAX", 16507);
        this.loadParam(jSONObject, "Y_MAX", 16508);
        this.loadParam(jSONObject, "Z_MAX", 16509);
        this.loadParam(jSONObject, "XY_POS", 16510);
        this.loadParam(jSONObject, "YZ_POS", 16511);
        this.loadParam(jSONObject, "ZX_POS", 16512);
        JSONArray jSONArray = jSONObject2.getJSONArray("PROBE_OFFSETS");
        for (int i = 0; i < 6; ++i) {
            JSONObject jSONObject3 = jSONArray.getJSONObject(i);
            this.loadParam(jSONObject3, "NEG_OFFSET", 0x4000000, i);
            this.loadParam(jSONObject3, "POS_OFFSET", 0x4000001, i);
        }
        JSONArray jSONArray2 = jSONObject2.getJSONArray("AXIS");
        for (int i = 0; i < 6; ++i) {
            JSONObject jSONObject4 = jSONArray2.getJSONObject(i);
            this.loadParam(jSONObject4, "CURRENT_MODE", Integer.MIN_VALUE, i);
            this.loadParam(jSONObject4, "STEP_MODE", -2147483647, i);
            this.loadParam(jSONObject4, "HOME_POSITION", -2147483647, i);
            this.loadParam(jSONObject4, "STEP_RATIO", -2147483646, i);
            this.loadParam(jSONObject4, "MACH_ENABLED", -2147483645, i);
            this.loadParam(jSONObject4, "HOME_POLARITY", -2147483644, i);
            this.loadParam(jSONObject4, "DIR_POLARITY", -2147483643, i);
            this.loadParam(jSONObject4, "LIMIT_MIN", -2147483642, i);
            this.loadParam(jSONObject4, "LIMIT_MAX", -2147483641, i);
            this.loadParam(jSONObject4, "LIMIT_ENABLED", -2147483640, i);
            this.loadParam(jSONObject4, "AUTO_ZERO", -2147483639, i);
            this.loadParam(jSONObject4, "MASTER_MOTOR", -2147483638, i);
            this.loadParam(jSONObject4, "SLAVE_MOTOR", -2147483637, i);
            this.loadParam(jSONObject4, "HOMING_CRAWL_SPEED", -2147483636, i);
            this.loadParam(jSONObject4, "HOMING_MAX_SPEED", -2147483635, i);
            this.loadParam(jSONObject4, "HOMING_ACCELERATION", -2147483634, i);
            this.loadParam(jSONObject4, "VELOCITY_SCALER", -2147483633, i);
            this.loadParam(jSONObject4, "MOTOR_INVERT_ENABLE", -2147483632, i);
        }
        JSONArray jSONArray3 = jSONObject2.getJSONArray("JOG_SETTINGS");
        for (int i = 0; i < 6; ++i) {
            JSONObject jSONObject5 = jSONArray3.getJSONObject(i);
            this.loadParam(jSONObject5, "LO_VELOCITY", 0x20000000, i);
            this.loadParam(jSONObject5, "HI_VELOCITY", 0x20000001, i);
            this.loadParam(jSONObject5, "ACCELERATION", 0x20000002, i);
            this.loadParam(jSONObject5, "CRAWL", 0x20000003, i);
            this.loadParam(jSONObject5, "MIN_CRAWL", 0x20000004, i);
        }
        JSONArray jSONArray4 = jSONObject2.getJSONArray("TOOL_CONFIGS");
        for (int i = 0; i < jSONArray4.length(); ++i) {
            JSONObject jSONObject6 = jSONArray4.getJSONObject(i);
            this.loadParam(jSONObject6, "DIAMETER", 0x40000000, i);
            this.loadParam(jSONObject6, "LENGTH", 0x40000001, i);
        }
        JSONArray jSONArray5 = jSONObject2.getJSONArray("SHORTCUTS");
        int n = jSONArray5.length();
        this.setParam(15306, n);
        if (n > 200) {
            throw new IllegalArgumentException("Too many shortcuts " + n + " > 200");
        }
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject7 = jSONArray5.getJSONObject(i);
            this.loadParam(jSONObject7, "KEY_NAME", 0x10000000, i);
            this.loadParam(jSONObject7, "ACTION_NAME", 0x10000001, i);
        }
        JSONArray jSONArray6 = jSONObject2.getJSONArray("PARAMETERS");
        for (int i = 0; i < jSONArray6.length(); ++i) {
            JSONObject jSONObject8 = jSONArray6.getJSONObject(i);
            int n2 = jSONObject8.getInt("PARAM");
            double d = jSONObject8.getDouble("VALUE");
            if (n2 < 5000 || n2 > 10320) {
                throw new IllegalArgumentException("Parameter number " + n2 + " out of range 5000 ... 200");
            }
            this.setParam(n2, d);
        }
        if (this.m_LoadedParameterNames != null) {
            LinkedList<String> linkedList = MachParam.getParamNames();
            for (String string2 : this.m_LoadedParameterNames) {
                linkedList.remove(string2);
            }
            for (String string3 : linkedList) {
                System.err.println("Declared " + string3 + " was not found in the config file");
            }
        }
    }

    static {
        int n;
        m_TrigRecompile = new boolean[32768];
        for (n = 0; n < 6; ++n) {
            MachState.m_TrigRecompile[5211 + n] = true;
        }
        MachState.m_TrigRecompile[15172] = true;
        MachState.m_TrigRecompile[15129] = true;
        MachState.m_TrigRecompile[15130] = true;
        MachState.m_TrigRecompile[15138] = true;
        MachState.m_TrigRecompile[15139] = true;
        MachState.m_TrigRecompile[15140] = true;
        MachState.m_TrigRecompile[15133] = true;
        MachState.m_TrigRecompile[15134] = true;
        MachState.m_TrigRecompile[15135] = true;
        MachState.m_TrigRecompile[15136] = true;
        MachState.m_TrigRecompile[15137] = true;
        MachState.m_TrigRecompile[15141] = true;
        MachState.m_TrigRecompile[15142] = true;
        MachState.m_TrigRecompile[15143] = true;
        MachState.m_TrigRecompile[15144] = true;
        MachState.m_TrigRecompile[15102] = true;
        MachState.m_TrigRecompile[15145] = true;
        MachState.m_TrigRecompile[15147] = true;
        MachState.m_TrigRecompile[15148] = true;
        MachState.m_TrigRecompile[15149] = true;
        MachState.m_TrigRecompile[15150] = true;
        MachState.m_TrigRecompile[15163] = true;
        MachState.m_TrigRecompile[5220] = true;
        for (n = 1; n <= 255; ++n) {
            int n2 = MachState.getWorkOffsetBaseIndex(n);
            for (int i = 0; i < 6; ++i) {
                MachState.m_TrigRecompile[n2 + i] = true;
            }
        }
        for (n = 0; n < 255; ++n) {
            MachState.m_TrigRecompile[MachState.getIndex((int)0x40000000, (int)n)] = true;
            MachState.m_TrigRecompile[MachState.getIndex((int)0x40000001, (int)n)] = true;
        }
    }

    static enum ParamType {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING;

    }
}

