/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import eazycnc.gcode.FilePos;
import eazycnc.planner.VecMath;
import java.io.Serializable;

public class Machcode
implements Cloneable,
Serializable {
    public Machcode m_Next;
    public Machcode m_Prev;
    public int m_MachCodeID = 0;
    public FilePos m_FilePos;
    public SegmentType m_Type;

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        Object object = "";
        for (int i = 0; i < dArray.length; ++i) {
            object = (String)object + String.format(" %1.6f", dArray[i]);
        }
        return "[" + ((String)object).substring(1) + "]";
    }

    public double getTolerance() {
        return 0.0;
    }

    public double getVelocity() {
        return 0.0;
    }

    public double getToolCompensation() {
        throw new IllegalArgumentException("can't call getToolCompensation() on instance of " + this.getClass().getSimpleName());
    }

    public int getPlane() {
        throw new IllegalArgumentException("can't call getPlane() on instance of " + this.getClass().getSimpleName());
    }

    public double[] getPosition() {
        return null;
    }

    public double[] getCenter() {
        return null;
    }

    public Machcode(SegmentType segmentType, FilePos filePos) {
        if (segmentType == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.m_Type = segmentType;
        this.m_FilePos = filePos;
    }

    public void append(Machcode machcode) {
        throw new IllegalArgumentException("Can only 'append' to by using the first node");
    }

    public void validate() {
    }

    public void insert(Machcode machcode) {
        machcode.validate();
        machcode.m_Prev = this;
        machcode.m_Next = this.m_Next;
        this.m_Next.m_Prev = machcode;
        this.m_Next = machcode;
    }

    public static Machcode clonelist(Machcode machcode) {
        Machcode machcode2 = null;
        Machcode machcode3 = null;
        Machcode machcode4 = machcode;
        while (machcode4 != null) {
            Machcode machcode5;
            machcode3 = machcode5 = machcode4.clone();
            machcode4 = machcode4.m_Next;
        }
        return machcode2;
    }

    public Machcode clone() {
        try {
            return (Machcode)super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_FilePos != null ? String.format("line %d", this.m_FilePos.getLineNo()) : "";
        String string2 = String.format("(id %d)", this.m_MachCodeID);
        stringBuffer.append(String.format("%-10s", string));
        stringBuffer.append(String.format("%-10s", string2));
        stringBuffer.append(String.format(" %-14s", new Object[]{this.m_Type}));
        return stringBuffer.toString();
    }

    public static enum SegmentType {
        START,
        MOVE_LINEAR,
        MOVE_ARC_CW,
        MOVE_ARC_CCW,
        EXCHANGE_PALETTE,
        STOP,
        PAUSE,
        COND_PAUSE,
        DWELL,
        SET_OUTPUT,
        CALLBACK,
        OPERATOR_MSG,
        SET_PARAMETER,
        ARM_PROBE,
        WAIT_PROBE,
        SEEK_HOME,
        RESET_WORK_OFFSETS,
        COMMENT;

    }

    public static class Comment
    extends Machcode {
        public String m_Comment;

        Comment(FilePos filePos, String string) {
            super(SegmentType.COMMENT, filePos);
            this.m_Comment = string;
        }
    }

    public static class ResetWorkOffset
    extends Machcode {
        public Double[] m_DroValues;
        public int m_WorkOffsetNo;

        ResetWorkOffset(FilePos filePos, int n, Double[] doubleArray) {
            super(SegmentType.RESET_WORK_OFFSETS, filePos);
            this.m_WorkOffsetNo = n;
            this.m_DroValues = (Double[])doubleArray.clone();
        }
    }

    public static class SeekHome
    extends Machcode {
        public boolean[] m_Axis;

        SeekHome(FilePos filePos, boolean[] blArray) {
            super(SegmentType.SEEK_HOME, filePos);
            this.m_Axis = (boolean[])blArray.clone();
        }
    }

    public static class MachCodeStartNode
    extends MoveCode {
        Machcode m_Last = this;

        public MachCodeStartNode(double[] dArray) {
            super(SegmentType.START, null, -1, 0.0, 0.0, 0.0, dArray);
        }

        @Override
        public void append(Machcode machcode) {
            Machcode machcode2 = this.m_Last;
            this.m_Last = machcode;
            if (machcode2 != null) {
                machcode2.m_Next = machcode;
            }
            machcode.m_Prev = machcode2;
        }

        @Override
        public double[] getPosition() {
            return super.getPosition();
        }
    }

    public static class ArcMove
    extends MoveCode {
        public double[] m_Center;

        public ArcMove(FilePos filePos, int n, double d, double d2, double d3, double[] dArray, double[] dArray2, SegmentType segmentType) {
            super(segmentType, filePos, n, d, d2, d3, dArray);
            if (segmentType != SegmentType.MOVE_ARC_CW && segmentType != SegmentType.MOVE_ARC_CCW) {
                throw new IllegalArgumentException("type must be ARC_CW or ARC_CCW");
            }
            this.m_Center = new double[dArray2.length];
            System.arraycopy(dArray2, 0, this.m_Center, 0, dArray2.length);
        }

        @Override
        public double[] getCenter() {
            return this.m_Center;
        }

        @Override
        public String toString() {
            return super.toString() + String.format(" cntr = %s", Machcode.toString(this.m_Center));
        }

        public static double[][] getArcPoints(int n, double[] dArray, double[] dArray2, double[] dArray3, double d, boolean bl) {
            double[] dArray4 = new double[2];
            double[] dArray5 = new double[2];
            VecMath.getXY(n, dArray5, dArray3);
            double d2 = VecMath.getXY_Z(n, dArray4, dArray);
            VecMath.sub(dArray4, dArray4, dArray5);
            double d3 = VecMath.length(dArray4);
            double d4 = Math.atan2(dArray4[1], dArray4[0]);
            double d5 = VecMath.getXY_Z(n, dArray4, dArray2);
            VecMath.sub(dArray4, dArray4, dArray5);
            double d6 = VecMath.length(dArray4);
            double d7 = Math.atan2(dArray4[1], dArray4[0]);
            double d8 = d7 - d4;
            if (bl) {
                if (d8 > 0.0) {
                    d8 -= Math.PI * 2;
                } else if (d8 == 0.0) {
                    d8 = Math.PI * -2;
                }
            } else if (d8 < 0.0) {
                d8 += Math.PI * 2;
            } else if (d8 == 0.0) {
                d8 = Math.PI * 2;
            }
            double d9 = d6 - d3;
            double d10 = d5 - d2;
            int n2 = (int)(16.0 * Math.abs(d8) / Math.PI + 0.5);
            if (n2 < 3) {
                n2 = 3;
            }
            int n3 = n2;
            double d11 = (d3 + d6) * 0.5;
            if (d > 0.0) {
                double d12;
                if (d > d11) {
                    d = d11;
                }
                if ((d12 = 2.0 * Math.acos(1.0 - d / d11)) > 0.0) {
                    n3 = (int)(Math.abs(d8) / d12);
                }
            }
            if (n3 < n2) {
                n3 = n2;
            }
            double[][] dArrayArray = new double[n3][];
            for (int i = 0; i < n3; ++i) {
                double d13 = (double)i / (double)(n3 - 1);
                double d14 = d4 + d8 * d13;
                double d15 = d3 + d9 * d13;
                double d16 = d2 + d10 * d13;
                dArray4[0] = Math.cos(d14) * d15 + dArray5[0];
                dArray4[1] = Math.sin(d14) * d15 + dArray5[1];
                dArrayArray[i] = new double[dArray.length];
                VecMath.setXY_Z(n, dArrayArray[i], dArray4, d16);
            }
            return dArrayArray;
        }
    }

    public static class LinearMove
    extends MoveCode {
        public LinearMove(FilePos filePos, int n, double d, double d2, double d3, double[] dArray) {
            super(SegmentType.MOVE_LINEAR, filePos, n, d, d2, d3, dArray);
        }
    }

    public static class MoveCode
    extends Machcode {
        public int m_Plane;
        public double m_ToolCompensation;
        public double m_Velocity;
        public double m_Tolerance;
        public double[] m_Position;

        MoveCode(SegmentType segmentType, FilePos filePos, int n, double d, double d2, double d3, double[] dArray) {
            super(segmentType, filePos);
            this.m_Plane = n;
            this.m_Tolerance = d2;
            this.m_Velocity = d3;
            this.m_Position = new double[dArray.length];
            this.m_ToolCompensation = d;
            System.arraycopy(dArray, 0, this.m_Position, 0, dArray.length);
        }

        @Override
        public double getToolCompensation() {
            return this.m_ToolCompensation;
        }

        @Override
        public int getPlane() {
            return this.m_Plane;
        }

        @Override
        public double getTolerance() {
            return this.m_Tolerance;
        }

        @Override
        public double getVelocity() {
            return this.m_Velocity;
        }

        @Override
        public double[] getPosition() {
            return this.m_Position;
        }

        @Override
        public String toString() {
            return super.toString() + String.format(" comp  =  %-6.1f", this.m_ToolCompensation) + String.format(" velo  =  %-6.1f", this.m_Velocity) + String.format(" tole  =  %-6.3f", this.m_Tolerance) + String.format(" posi  =  %s", Machcode.toString(this.m_Position));
        }
    }

    public static class SetParameter
    extends Machcode {
        public int m_Parameter;
        public Object m_Value;

        SetParameter(FilePos filePos, int n, Object object) {
            super(SegmentType.SET_PARAMETER, filePos);
            this.m_Parameter = n;
            this.m_Value = object;
        }

        @Override
        public String toString() {
            return super.toString() + String.format(" parameter[%d] =  %s", this.m_Parameter, this.m_Value);
        }
    }

    public static class Dwell
    extends Machcode {
        public double m_DwellTime;

        Dwell(FilePos filePos, double d) {
            super(SegmentType.DWELL, filePos);
            this.m_DwellTime = d;
        }

        @Override
        public String toString() {
            return super.toString() + String.format(" dwellTime =  %1.3f", this.m_DwellTime);
        }
    }

    private static class SetOutput
    extends Machcode {
        public int m_Output;
        public int m_Value;

        SetOutput(FilePos filePos, int n, int n2) {
            super(SegmentType.SET_OUTPUT, filePos);
            this.m_Output = n;
            this.m_Value = n2;
        }

        @Override
        public String toString() {
            return super.toString() + String.format("output[%d] = %d", this.m_Output, this.m_Value);
        }
    }

    public static class Callback
    extends Machcode {
        public Runnable m_Callback;

        Callback(FilePos filePos, Runnable runnable) {
            super(SegmentType.CALLBACK, filePos);
        }

        @Override
        public String toString() {
            return super.toString() + this.m_Callback;
        }
    }

    public static class ControlCode
    extends Machcode {
        ControlCode(FilePos filePos, SegmentType segmentType) {
            super(segmentType, filePos);
        }

        @Override
        public String toString() {
            return super.toString() + String.format("", new Object[0]);
        }
    }

    public static class OperatorMessage
    extends Machcode {
        public String m_Message;
        public OperatorMessageType m_MessageType;

        OperatorMessage(FilePos filePos, OperatorMessageType operatorMessageType, String string) {
            super(SegmentType.OPERATOR_MSG, filePos);
            this.m_Message = string;
            this.m_MessageType = operatorMessageType;
        }

        @Override
        public String toString() {
            return super.toString() + String.format(" message =  '%s'", this.m_Message);
        }
    }

    public static enum OperatorMessageType {
        MESSAGE,
        PRINT;

    }
}

