/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import com.eazycnc.uwk.InvalidValueException;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import motorcontrol.MachController;

public class ParameterValidators {
    private static double asDouble(Object object) {
        if (!(object instanceof Number)) {
            throw new InvalidValueException("Value " + object + " is not a number");
        }
        return ((Number)object).doubleValue();
    }

    public static void validateStepRatio(MachController machController, int n, double d) throws InvalidValueException {
        int n2 = machController.getMotorController().getMaxVelo();
        int n3 = machController.getMotorController().getMaxTravel();
        MachState machState = machController.getMachState();
        String string = Interpreter.getAxisLetter(n);
        double d2 = machState.getParamDouble(-2147483646, n);
        double d3 = machState.getParamDouble(15149);
        double d4 = machState.getParamDouble(15150);
        double d5 = (double)n2 / (machController.getVelocityUnit() * d3);
        if (d > d5) {
            String string2 = machState.formatToUserUnits(d5);
            throw new InvalidValueException("Step Ratio for axis " + string + " too high, with current Max Velocity max value is " + string2);
        }
        double d6 = (double)n3 / (d4 * d3);
        if (d > d6) {
            String string3 = machState.formatToUserUnits(d6);
            throw new InvalidValueException("Step Ratio for axis " + string + " too high, with current Update Period max value is " + string3);
        }
        double d7 = machController.getVelocityUnit();
        double d8 = 65535.0 / (machState.getParamDouble(0x20000001, n) * machController.getVelocityUnit());
        if (d > d8) {
            String string4 = machState.formatToUserUnits(d8);
            throw new InvalidValueException("Step Ratio for axis " + string + " too high, with current Jog Velocity max value is " + string4);
        }
        double d9 = 65535.0 / (machState.getParamDouble(0x20000002, n) * d7 * d7 * 0.25);
        if (d > d9) {
            String string5 = machState.formatToUserUnits(d9);
            throw new InvalidValueException("Step Ratio for axis " + string + " too high, with current Jog Acceleration max value is " + string5);
        }
    }

    public static void validateCycleTime(MachController machController, double d) throws InvalidValueException {
        int n = machController.getMotorController().getMaxVelo();
        int n2 = machController.getMotorController().getMaxTravel();
        MachState machState = machController.getMachState();
        int n3 = 0;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < machController.getNumberOfMotors(); ++i) {
            double d3;
            double d4 = machState.getParamDouble(-2147483646, i);
            double d5 = (double)n2 / (d4 * (d3 = machState.getParamDouble(15149)));
            if (!(d5 < d2)) continue;
            d2 = d5;
            n3 = i;
        }
        if (d > d2) {
            String string = machController.getAxisLetterFromMotor(n3);
            String string2 = String.format("%1.1f", d2 * 1000.0);
            throw new InvalidValueException("Update Period too high, with current Max Velocity and " + string + "-axis Step Ratio max value is " + string2);
        }
    }

    public static void validateMaxVelocity(MachController machController, double d) throws InvalidValueException {
        int n = machController.getMotorController().getMaxVelo();
        int n2 = machController.getMotorController().getMaxTravel();
        MachState machState = machController.getMachState();
        int n3 = 0;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < machController.getNumberOfMotors(); ++i) {
            double d3;
            double d4 = machState.getParamDouble(-2147483646, i);
            double d5 = machState.getParamDouble(15150);
            double d6 = machController.getVelocityUnit();
            double d7 = (double)n / (d4 * d6);
            double d8 = Math.min(d7, d3 = (double)n2 / (d4 * d5));
            if (!(d8 < d2)) continue;
            d2 = d8;
            n3 = i;
        }
        if (d > d2) {
            String string = machController.getAxisLetterFromMotor(n3);
            String string2 = machState.formatToUserUnits(d2);
            throw new InvalidValueException("Max Velocity too high, with current Update Period or " + string + "-axis Step Ratio max value is " + string2);
        }
    }

    public static void validateMotorParameters(MachController machController) {
        MachState machState = machController.getMachState();
        ParameterValidators.validateMaxVelocity(machController, machState.getParamDouble(15149));
        ParameterValidators.validateCycleTime(machController, machState.getParamDouble(15150));
        for (int i = 0; i < machController.getNumberOfMotors(); ++i) {
            if (!machState.isAxisEnabled(i)) continue;
            ParameterValidators.validateStepRatio(machController, i, machController.getMachState().getParamDouble(-2147483646, i));
        }
    }

    public static void validateJogAcceleration(MachController machController, int n, double d) throws InvalidValueException {
        double d2;
        MachState machState = machController.getMachState();
        String string = Interpreter.getAxisLetter(n);
        if (d < 0.0) {
            throw new InvalidValueException("Jog Acceleration for axis " + string + " negative, only positive or zero allowed.");
        }
        double d3 = machState.getParamDouble(-2147483646, n);
        double d4 = 65535.0 / (d3 * (d2 = machController.getVelocityUnit()) * d2 * 0.25);
        if (d > d4) {
            String string2 = machState.formatToUserUnits(d4);
            throw new InvalidValueException("Jog Acceleration for axis " + string + " too high, with current Step Ratio max value is " + string2);
        }
    }

    public static void validateJogLowVelocity(MachController machController, int n, double d) throws InvalidValueException {
        MachState machState = machController.getMachState();
        String string = Interpreter.getAxisLetter(n);
        if (d <= 0.0) {
            throw new InvalidValueException("Jog Crawl Velocity for axis " + string + " negative or zero, only positive values allowed.");
        }
        if (d > machState.getParamDouble(0x20000001, n)) {
            throw new InvalidValueException("Jog Crawl Velocity higher than Jog Velocity.");
        }
        double d2 = machState.getParamDouble(-2147483646, n);
        double d3 = machController.getVelocityUnit();
        double d4 = (double)machController.getMotorController().getMaxVelo() / (d2 * d3);
        if (d > d4) {
            String string2 = machState.formatToUserUnits(d4);
            throw new InvalidValueException("Jog Crawl Velocity for axis " + string + " too high, with current Step Ratio max value is " + string2);
        }
    }

    public static void validateJogHighVelocity(MachController machController, int n, double d) throws InvalidValueException {
        MachState machState = machController.getMachState();
        String string = Interpreter.getAxisLetter(n);
        if (d <= 0.0) {
            throw new InvalidValueException("Jog Velocity for axis " + string + " negative or zero, only positive values allowed.");
        }
        if (d < machState.getParamDouble(0x20000000, n)) {
            throw new InvalidValueException("Jog Velocity for axis " + string + " lower than Jog Crawl Velocity.");
        }
        double d2 = machState.getParamDouble(-2147483646, n);
        double d3 = machController.getVelocityUnit();
        double d4 = (double)machController.getMotorController().getMaxVelo() / (d2 * d3);
        if (d > d4) {
            String string2 = machState.formatToUserUnits(d4);
            throw new InvalidValueException("Jog Velocity for axis " + string + " too high, with current Step Ratio max value is " + string2);
        }
    }

    public static void validateMinCrawlLength(MachController machController, int n, double d) throws InvalidValueException {
        MachState machState = machController.getMachState();
        String string = Interpreter.getAxisLetter(n);
        if (d <= 0.0) {
            throw new InvalidValueException("Minimum Crawl Length for axis " + string + " negative or zero, only positive values allowed.");
        }
        double d2 = machState.getParamDouble(-2147483646, n);
        double d3 = machController.getVelocityUnit();
        double d4 = (double)machController.getMotorController().getMaxTravel() / d2;
        if (d > d4) {
            String string2 = machState.formatToUserUnits(d4);
            throw new InvalidValueException("Minimum Crawl Length for axis " + string + " too high, with current Step Ratio max value is " + string2);
        }
    }

    public static void validateCrawlLength(MachController machController, int n, double d) throws InvalidValueException {
        MachState machState = machController.getMachState();
        String string = Interpreter.getAxisLetter(n);
        if (d < 0.0) {
            throw new InvalidValueException("Crawl Length for axis " + string + " negative , only positive values allowed or zero.");
        }
        double d2 = machState.getParamDouble(-2147483646, n);
        double d3 = machController.getVelocityUnit();
        double d4 = (double)machController.getMotorController().getMaxTravel() / d2;
        if (d > d4) {
            String string2 = machState.formatToUserUnits(d4);
            throw new InvalidValueException("Craw Length for axis " + string + " too high, with current Step Ratio max value is " + string2);
        }
    }

    public static void validateJogParameters(MachController machController, int n) throws InvalidValueException {
        MachState machState = machController.getMachState();
        ParameterValidators.validateJogAcceleration(machController, n, machState.getParamDouble(0x20000002, n));
        ParameterValidators.validateJogLowVelocity(machController, n, machState.getParamDouble(0x20000000, n));
        ParameterValidators.validateJogHighVelocity(machController, n, machState.getParamDouble(0x20000001, n));
        ParameterValidators.validateMinCrawlLength(machController, n, machState.getParamDouble(0x20000004, n));
        ParameterValidators.validateCrawlLength(machController, n, machState.getParamDouble(0x20000003, n));
    }

    public static void initValidators(MachController machController) {
        int n;
        MachState machState = machController.getMachState();
        int n2 = 0;
        while (n2 < 6) {
            n = n2++;
            machState.getVariable(-2147483646, n).setValidator(object -> {
                double d = ParameterValidators.asDouble(object);
                ParameterValidators.validateStepRatio(machController, n, d);
            });
        }
        machState.getVariable(15150).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            ParameterValidators.validateCycleTime(machController, d);
        });
        machState.getVariable(15149).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            ParameterValidators.validateMaxVelocity(machController, d);
        });
        machState.getVariable(15148).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            if (d <= 0.0) {
                throw new InvalidValueException("Max Acceleration negative or zero, only positive values allowed.");
            }
        });
        machState.getVariable(15169).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            if (d <= 0.0) {
                throw new InvalidValueException("Max Jerk negative or zero, only positive values allowed.");
            }
        });
        n2 = 0;
        while (n2 < 6) {
            n = n2++;
            machState.getVariable(0x20000002, n).setValidator(object -> {
                double d = ParameterValidators.asDouble(object);
                ParameterValidators.validateJogAcceleration(machController, n, d);
            });
            machState.getVariable(0x20000000, n).setValidator(object -> {
                double d = ParameterValidators.asDouble(object);
                ParameterValidators.validateJogLowVelocity(machController, n, d);
            });
            machState.getVariable(0x20000001, n).setValidator(object -> {
                double d = ParameterValidators.asDouble(object);
                ParameterValidators.validateJogHighVelocity(machController, n, d);
            });
            machState.getVariable(0x20000003, n).setValidator(object -> {
                double d = ParameterValidators.asDouble(object);
                ParameterValidators.validateCrawlLength(machController, n, d);
            });
            machState.getVariable(0x20000004, n).setValidator(object -> {
                double d = ParameterValidators.asDouble(object);
                ParameterValidators.validateMinCrawlLength(machController, n, d);
            });
        }
        machState.getVariable(15304).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            if (d <= 0.0) {
                throw new InvalidValueException("Test Start Velocity negative or zero, only positive values allowed.");
            }
            if (d > machState.getParamDouble(15305)) {
                throw new InvalidValueException("Test Start Velocity higher than Motor Test Top Velocity.");
            }
        });
        machState.getVariable(15305).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            if (d <= 0.0) {
                throw new InvalidValueException("Test Top Velocity negative or zero, only positive values allowed.");
            }
        });
        machState.getVariable(15303).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            if (d <= 0.0) {
                throw new InvalidValueException("Motor Test Acceleration negative or zero, only positive values allowed.");
            }
        });
        machState.getVariable(15308).setValidator(object -> {
            double d = ParameterValidators.asDouble(object);
            if (d <= 0.0) {
                throw new InvalidValueException("Motor Test Jerk negative or zero, only positive values allowed.");
            }
        });
        for (n2 = 0; n2 < 6; ++n2) {
            n = n2;
            machState.getVariable(-2147483641, n2).setValidator(object -> {
                double d = machState.getParamDouble(-2147483642, n);
                double d2 = ParameterValidators.asDouble(object);
                if (d2 < d) {
                    throw new InvalidValueException("Max limit cannot be less thatn Min limit.");
                }
            });
            machState.getVariable(-2147483642, n2).setValidator(object -> {
                double d;
                double d2 = ParameterValidators.asDouble(object);
                if (d2 > (d = machState.getParamDouble(-2147483641, n))) {
                    throw new InvalidValueException("Min limit cannot be greater than Max limit.");
                }
            });
        }
    }
}

