/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import eazycnc.gcode.FilePos;
import eazycnc.gcode.FileReader;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Parser {
    private char m_Char;
    private String m_Line;
    private int m_Index;
    private boolean m_BlockDelete;
    private List<ParamSetting> m_SetParameters = new LinkedList<ParamSetting>();
    private Interpreter m_Interpreter;
    private FileReader m_FileReader;
    private String m_LastComment;
    private int m_LineOrdinal;
    private static Map<String, UnaryOp> m_UnaryOpLookup = new Hashtable<String, UnaryOp>();
    private static Map<String, BinaryOp> m_BinaryOpLookup;
    private static Map<BinaryOp, String> m_ReverseBinaryOpLookup;

    public String getLine() {
        return this.m_Line;
    }

    public Parser(Interpreter interpreter) {
        this.m_Interpreter = interpreter;
        this.m_Interpreter.initInterpreter(this);
    }

    private char peekNextChar() {
        if (this.m_Index < this.m_Line.length()) {
            return Character.toUpperCase(this.m_Line.charAt(this.m_Index));
        }
        return '\u0000';
    }

    private void nextChar() {
        do {
            this.m_Char = this.m_Index < this.m_Line.length() ? Character.toUpperCase(this.m_Line.charAt(this.m_Index++)) : (char)'\u0000';
        } while (this.m_Char == ' ' || this.m_Char == '\t');
    }

    private char nextRawChar() {
        if (this.m_Index < this.m_Line.length()) {
            return this.m_Line.charAt(this.m_Index++);
        }
        return '\u0000';
    }

    private void parse(String string) {
        this.m_Line = string;
        this.m_Index = 0;
        this.m_LastComment = null;
    }

    public String getCurrentFileName() {
        return this.m_FileReader.getFileName();
    }

    public String getLastComment() {
        return this.m_LastComment;
    }

    ParseException newParseException(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append("ERROR: ");
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("\n");
        stringBuffer.append("line: ");
        stringBuffer.append(this.m_Line);
        stringBuffer.append("\n");
        stringBuffer.append("     ");
        for (int i = 0; i < this.m_Index; ++i) {
            if (this.m_Line.charAt(i) == '\t') {
                stringBuffer.append('\t');
                continue;
            }
            stringBuffer.append(' ');
        }
        stringBuffer.append("^\n");
        return new ParseException(stringBuffer.toString(), string, this.m_FileReader.getFilePos());
    }

    public List<ParamSetting> getSetParameters() {
        return this.m_SetParameters;
    }

    private boolean parseLine(FilePos filePos, String string) throws Exception {
        this.m_SetParameters.clear();
        this.parse(string);
        if (string.startsWith("/") && this.m_BlockDelete) {
            return false;
        }
        if (string.startsWith("%")) {
            if (string.startsWith("%!")) {
                this.m_Interpreter.addMachCode(new Machcode.Comment(filePos, string));
            }
            return false;
        }
        this.m_Interpreter.startLine(filePos);
        this.nextChar();
        this.parseLineNumber();
        while (this.parseSegment()) {
        }
        this.parseEndOfLine();
        return this.m_Interpreter.endLine();
    }

    private void parseEndOfLine() {
        if (this.m_Char != '\u0000') {
            if (this.m_Char == '/') {
                this.nextChar();
                if (this.m_Char == '/') {
                    return;
                }
            }
            throw this.newParseException("Expected end of line, found '" + this.m_Char + "'");
        }
    }

    private boolean parseLineNumber() {
        int n;
        if (this.m_Char != 'N') {
            return false;
        }
        this.nextChar();
        int n2 = 0;
        for (n = 0; n < 5 && Character.isDigit(this.m_Char); ++n) {
            n2 = n2 * 10 + this.m_Char - 48;
            this.nextChar();
        }
        if (n == 0) {
            throw this.newParseException("Expted a line number of after word 'N'");
        }
        if (this.m_Interpreter.m_Trace) {
            System.out.print("line no: " + n2 + " ");
        }
        return true;
    }

    private boolean parseSegment() {
        return this.parseMidLineWord() || this.parseComment() || this.parseParameterSetting();
    }

    private boolean parseMidLineWord() {
        Character c = this.parseMidLineLetter();
        if (c == null) {
            return false;
        }
        Double d = this.parseRealValue();
        if (d == null) {
            throw this.newParseException("Real value expected after word '" + c + "'");
        }
        this.m_Interpreter.processWord(c, d);
        return true;
    }

    private boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private Character parseMidLineLetter() {
        char c = this.m_Char;
        if (!this.isLetter(c)) {
            return null;
        }
        this.nextChar();
        return Character.valueOf(c);
    }

    private Double parseRealValue() {
        int n = 0;
        n = this.m_Char == '+' ? 1 : (this.m_Char == '-' ? -1 : 0);
        if (n != 0) {
            this.nextChar();
        } else {
            n = 1;
        }
        Double d = this.parseRealNumber();
        if (d != null) {
            return d * (double)n;
        }
        d = this.parseExpression();
        if (d != null) {
            return d * (double)n;
        }
        d = this.parseParameterValue();
        if (d != null) {
            return d * (double)n;
        }
        d = this.parseUnaryCombo();
        if (d != null) {
            return d * (double)n;
        }
        return null;
    }

    private Double parseRealNumber() {
        StringBuffer stringBuffer = null;
        try {
            if (this.m_Char == '.') {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.m_Char);
                this.nextChar();
                if (!Character.isDigit(this.m_Char)) {
                    throw this.newParseException("Digit expected after a decimal point, found '" + this.m_Char + "'");
                }
                while (Character.isDigit(this.m_Char)) {
                    stringBuffer.append(this.m_Char);
                    this.nextChar();
                }
                return Double.parseDouble(stringBuffer.toString());
            }
            if (Character.isDigit(this.m_Char)) {
                stringBuffer = new StringBuffer();
                while (Character.isDigit(this.m_Char)) {
                    stringBuffer.append(this.m_Char);
                    this.nextChar();
                }
                if (this.m_Char == '.') {
                    stringBuffer.append(this.m_Char);
                    this.nextChar();
                    while (Character.isDigit(this.m_Char)) {
                        stringBuffer.append(this.m_Char);
                        this.nextChar();
                    }
                }
                return Double.parseDouble(stringBuffer.toString());
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newParseException("Bad real number '" + stringBuffer + "'");
        }
    }

    private BinaryOp parseBinaryOperation() {
        BinaryOp binaryOp;
        String string = this.parseOperationName();
        if (string != null) {
            return m_BinaryOpLookup.get(string);
        }
        string = Character.toString(this.m_Char);
        if (this.m_Char == '*') {
            this.nextChar();
            if (this.m_Char == '*') {
                string = "**";
            }
        }
        if ((binaryOp = m_BinaryOpLookup.get(string)) != null && !"*".equals(string)) {
            this.nextChar();
        }
        return binaryOp;
    }

    private int precedence(BinaryOp binaryOp) {
        if (binaryOp == null) {
            return 1;
        }
        switch (binaryOp) {
            case AND: 
            case OR: 
            case XOR: 
            case PLUS: 
            case MINUS: {
                return 2;
            }
            case TIMES: 
            case DIVIDED_BY: 
            case MODULO: {
                return 3;
            }
            case POWER: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unimplemented BinaryOp bug");
    }

    private double calculate(double d, BinaryOp binaryOp, double d2) {
        switch (binaryOp) {
            case PLUS: {
                return d + d2;
            }
            case MINUS: {
                return d - d2;
            }
            case TIMES: {
                return d * d2;
            }
            case DIVIDED_BY: {
                if (d2 == 0.0) {
                    throw this.newParseException("Divide " + d + " by zero");
                }
                return d / d2;
            }
            case MODULO: {
                double d3 = d % d2;
                if (d3 < 0.0) {
                    d3 += Math.abs(d2);
                }
                return d3;
            }
            case POWER: {
                if (d < 0.0 && d2 != Math.floor(d2)) {
                    throw this.newParseException("Raise negative value '" + d + "' value to a non integer '" + d2 + "'power");
                }
                return Math.pow(d, d2);
            }
            case XOR: {
                return d != 0.0 ^ d2 != 0.0 ? 1.0 : 0.0;
            }
            case AND: {
                return d != 0.0 && d2 != 0.0 ? 1.0 : 0.0;
            }
            case OR: {
                return d != 0.0 || d2 != 0.0 ? 1.0 : 0.0;
            }
        }
        throw new IllegalArgumentException("Unimplemented BinaryOp bug");
    }

    private Double parseExpression() {
        if (this.m_Char != '[') {
            return null;
        }
        this.nextChar();
        Double[] doubleArray = new Double[5];
        BinaryOp[] binaryOpArray = new BinaryOp[5];
        doubleArray[0] = this.parseRealValue();
        binaryOpArray[0] = this.parseBinaryOperation();
        if (doubleArray[0] == null) {
            throw this.newParseException("Expected a real value after the '[' in expression");
        }
        int n = 1;
        block0: while (binaryOpArray[0] != null) {
            doubleArray[n] = this.parseRealValue();
            binaryOpArray[n] = this.parseBinaryOperation();
            if (doubleArray[n] == null) {
                throw this.newParseException("Expected a real value after the binary operator '" + binaryOpArray[n - 1] + "'");
            }
            if (this.precedence(binaryOpArray[n]) > this.precedence(binaryOpArray[n - 1])) {
                ++n;
                continue;
            }
            while (this.precedence(binaryOpArray[n]) <= this.precedence(binaryOpArray[n - 1])) {
                doubleArray[n - 1] = this.calculate(doubleArray[n - 1], binaryOpArray[n - 1], doubleArray[n]);
                binaryOpArray[n - 1] = binaryOpArray[n];
                if (n <= 1 || this.precedence(binaryOpArray[n - 1]) > this.precedence(binaryOpArray[n - 2])) continue block0;
                --n;
            }
        }
        if (this.m_Char != ']') {
            throw this.newParseException("Expected ']' at the end of an expression");
        }
        this.nextChar();
        return doubleArray[0];
    }

    private int integerValue(Double d) {
        if (d == null) {
            throw this.newParseException("Expected a number, found '" + this.m_Char + "'");
        }
        double d2 = Math.rint(d);
        if (d != d2) {
            throw this.newParseException("Expected an integer, found '" + d + "'");
        }
        return (int)d2;
    }

    private Integer parseParameterIndex() {
        Double d = this.parseRealValue();
        if (d == null) {
            return null;
        }
        double d2 = Math.rint(d);
        if (d != d2) {
            throw this.newParseException("Expected an integer, found '" + d + "'");
        }
        return (int)d2;
    }

    private Double parseParameterValue() {
        if (this.m_Char != '#') {
            return null;
        }
        this.nextChar();
        Integer n = this.parseParameterIndex();
        if (n == null) {
            throw this.newParseException("Expected a parameter index, found '" + this.m_Char + "'");
        }
        if (n < 0 || n > 10320) {
            this.newParseException("Parameter number " + n + " out of range.");
        }
        if (n == 0) {
            return 0.0;
        }
        return this.m_Interpreter.getDouble(n);
    }

    private Double parseUnaryCombo() {
        String string = this.parseOperationName();
        if (string == null) {
            return null;
        }
        Double d = this.parseOrdinaryUnaryCombo(string);
        if (d != null) {
            return d;
        }
        d = this.parseArctangetCombo(string);
        if (d != null) {
            return d;
        }
        return null;
    }

    private String parseOperationName() {
        if (this.isLetter(this.m_Char)) {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.isLetter(this.m_Char)) {
                stringBuffer.append(this.m_Char);
                this.nextChar();
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private UnaryOp parseOrdinaryUnaryOperation(String string) {
        return m_UnaryOpLookup.get(string);
    }

    private Double parseOrdinaryUnaryCombo(String string) {
        UnaryOp unaryOp = this.parseOrdinaryUnaryOperation(string);
        if (unaryOp == null) {
            return null;
        }
        Double d = this.parseExpression();
        if (d == null) {
            throw this.newParseException("Expression expected after op '" + string + "'");
        }
        switch (unaryOp) {
            case ABS: {
                return Math.abs(d);
            }
            case ACOS: {
                if (Math.abs(d) > 1.0) {
                    throw new IllegalArgumentException("Argument to ACOS out of range -1 ... 1 '" + d + "'");
                }
                return Math.toDegrees(Math.acos(d));
            }
            case ASIN: {
                if (Math.abs(d) > 1.0) {
                    throw new IllegalArgumentException("Argument to ASIN out of range -1 ... 1  '" + d + "'");
                }
                return Math.toDegrees(Math.asin(d));
            }
            case COS: {
                return Math.cos(Math.toRadians(d));
            }
            case EXP: {
                return Math.exp(d);
            }
            case FIX: {
                return Math.floor(d);
            }
            case FUP: {
                return Math.ceil(d);
            }
            case LN: {
                if (d <= 0.0) {
                    throw new IllegalArgumentException("Argument to LN negative or zero '" + d + "'");
                }
                return Math.log(d);
            }
            case ROUND: {
                return Math.floor(d + (d < 0.0 ? -0.5 : 0.5));
            }
            case SIN: {
                return Math.sin(Math.toRadians(d));
            }
            case SQRT: {
                if (d < 0.0) {
                    throw new IllegalArgumentException("Argument to SQRT negative '" + d + "'");
                }
                return Math.sqrt(d);
            }
            case TAN: {
                return Math.tan(Math.toRadians(d));
            }
        }
        throw new IllegalArgumentException("Bug, unimplementd unary operation '" + unaryOp + "'");
    }

    private Double parseArctangetCombo(String string) {
        if (!"ATAN".equals(string)) {
            return null;
        }
        Double d = this.parseExpression();
        if (d == null) {
            throw this.newParseException("Expected expression for 'y' expected in ATAN[y]/[x]");
        }
        if (this.m_Char != '/') {
            throw this.newParseException("Expected '/' in ATAN[y]/[x]");
        }
        this.nextChar();
        Double d2 = this.parseExpression();
        if (d2 == null) {
            throw this.newParseException("Expected expression for 'x' expected in ATAN[y]/[x]");
        }
        return Math.toDegrees(Math.atan2(d, d2));
    }

    private boolean parseComment() {
        String string;
        if (this.m_Char == ';') {
            while (this.m_Char != '\u0000') {
                this.nextChar();
            }
            return true;
        }
        if (this.m_Char != '(') {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.nextRawChar();
        while (c != ')') {
            if (c == '\u0000') {
                throw this.newParseException("Unexpected end of line in a comment");
            }
            stringBuffer.append(c);
            c = this.nextRawChar();
        }
        this.nextChar();
        this.m_LastComment = string = stringBuffer.toString();
        return true;
    }

    private boolean parseParameterSetting() {
        Double d;
        if (this.m_Char != '#') {
            return false;
        }
        this.nextChar();
        Integer n = this.parseParameterIndex();
        if (n == null) {
            throw this.newParseException("Expected a parameter index, found '" + this.m_Char + "'");
        }
        if (this.m_Char != '=') {
            throw this.newParseException("Expected '=', found '" + this.m_Char + "'");
        }
        this.nextChar();
        if (n == 0) {
            this.newParseException("Parameter number 0 cannot be assigned.");
        }
        if (n < 0 || n > 10320) {
            this.newParseException("Parameter number " + n + " out of range.");
        }
        if ((d = this.parseRealValue()) == null) {
            throw this.newParseException("Expected a real value, found '" + this.m_Char + "'");
        }
        this.m_SetParameters.add(new ParamSetting(n, d));
        return true;
    }

    void returnFromSubroutine() {
        if (!this.m_FileReader.popCallStack()) {
            throw this.newParseException("Return from subroutine without a matching call");
        }
    }

    void callSubroutine(String string, double d, int n) throws Exception {
        String string2;
        try {
            this.m_FileReader.readFromFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.newParseException("File not found: " + string);
        }
        while (null != (string2 = this.m_FileReader.peekLine())) {
            this.parse(string2);
            this.nextChar();
            if (this.m_Char == 'O') {
                this.nextChar();
                double d2 = this.parseRealNumber();
                if (d2 == d) {
                    this.m_FileReader.nextLine();
                    for (int i = 1; i < n; ++i) {
                        this.m_FileReader.pushCallStack();
                    }
                    return;
                }
            }
            this.m_FileReader.nextLine();
        }
        throw this.newParseException(String.format("%s%.0f%s%s", "Could not find subroutine '", d, "' in file ", string));
    }

    public Machcode getMachCode() {
        return this.m_Interpreter.getCCodes();
    }

    public Machcode parseFile(MachState machState, FileReader.FileAccessor fileAccessor, String string) throws Exception {
        return this.parseFile(machState, fileAccessor, string, null);
    }

    public Machcode parseFile(MachState machState, FileReader.FileAccessor fileAccessor, String string, Preprocessor preprocessor) throws Exception {
        String string2;
        this.m_LineOrdinal = 0;
        this.m_FileReader = new FileReader(fileAccessor);
        this.m_FileReader.readFromFile(string);
        this.m_Interpreter.reset(machState);
        while ((string2 = this.m_FileReader.nextLine()) != null) {
            if (preprocessor != null) {
                string2 = preprocessor.process(string2);
            }
            if (this.parseLine(this.m_FileReader.getFilePos(), string2)) break;
            ++this.m_LineOrdinal;
        }
        Machcode machcode = this.m_Interpreter.getCCodes();
        return machcode;
    }

    public FileReader getFileReader() {
        return this.m_FileReader;
    }

    static {
        m_UnaryOpLookup.put("ABS", UnaryOp.ABS);
        m_UnaryOpLookup.put("ACOS", UnaryOp.ACOS);
        m_UnaryOpLookup.put("ASIN", UnaryOp.ASIN);
        m_UnaryOpLookup.put("COS", UnaryOp.COS);
        m_UnaryOpLookup.put("EXP", UnaryOp.EXP);
        m_UnaryOpLookup.put("FIX", UnaryOp.FIX);
        m_UnaryOpLookup.put("FUP", UnaryOp.FUP);
        m_UnaryOpLookup.put("LN", UnaryOp.LN);
        m_UnaryOpLookup.put("ROUND", UnaryOp.ROUND);
        m_UnaryOpLookup.put("SIN", UnaryOp.SIN);
        m_UnaryOpLookup.put("SQRT", UnaryOp.SQRT);
        m_UnaryOpLookup.put("TAN", UnaryOp.TAN);
        m_BinaryOpLookup = new Hashtable<String, BinaryOp>();
        m_BinaryOpLookup.put("*", BinaryOp.TIMES);
        m_BinaryOpLookup.put("/", BinaryOp.DIVIDED_BY);
        m_BinaryOpLookup.put("+", BinaryOp.PLUS);
        m_BinaryOpLookup.put("-", BinaryOp.MINUS);
        m_BinaryOpLookup.put("MOD", BinaryOp.MODULO);
        m_BinaryOpLookup.put("**", BinaryOp.POWER);
        m_BinaryOpLookup.put("XOR", BinaryOp.XOR);
        m_BinaryOpLookup.put("AND", BinaryOp.AND);
        m_BinaryOpLookup.put("OR", BinaryOp.OR);
        m_ReverseBinaryOpLookup = new Hashtable<BinaryOp, String>();
        for (String string : m_BinaryOpLookup.keySet()) {
            m_ReverseBinaryOpLookup.put(m_BinaryOpLookup.get(string), string);
        }
    }

    public static class ParseException
    extends RuntimeException {
        private FilePos m_FilePos;
        private String m_Error;

        public ParseException(String string, String string2, FilePos filePos) {
            super(string == null ? string2 : string);
            this.m_FilePos = filePos;
            this.m_Error = string2;
        }

        public String getError() {
            return this.m_Error;
        }

        public FilePos getFilePos() {
            return this.m_FilePos;
        }
    }

    static enum BinaryOp {
        PLUS,
        MINUS,
        TIMES,
        DIVIDED_BY,
        MODULO,
        POWER,
        XOR,
        AND,
        OR;


        public String toString() {
            return m_ReverseBinaryOpLookup.get((Object)this);
        }
    }

    static enum UnaryOp {
        ABS,
        ACOS,
        ASIN,
        COS,
        EXP,
        FIX,
        FUP,
        LN,
        ROUND,
        SIN,
        SQRT,
        TAN;

    }

    static class ParamSetting {
        Integer m_Param;
        Double m_Value;

        public ParamSetting(Integer n, Double d) {
            this.m_Param = n;
            this.m_Value = d;
        }
    }

    public static interface Preprocessor {
        public String process(String var1);
    }
}

