/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.gcode;

import eazycnc.gcode.Machcode;
import eazycnc.gcode.Parser;
import eazycnc.planner.VecMath;
import java.awt.Color;

public class RadiusCompensator {
    private static boolean getExitVector(int n, double[] dArray, double[] dArray2, Machcode machcode, double[] dArray3, double[] dArray4) {
        switch (machcode.m_Type) {
            case MOVE_LINEAR: {
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.getXY(n, dArray4, dArray2);
                VecMath.sub(dArray, dArray3, dArray4);
                return !VecMath.isNull(dArray);
            }
            case MOVE_ARC_CCW: {
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.getXY(n, dArray4, machcode.getCenter());
                VecMath.sub(dArray, dArray3, dArray4);
                VecMath.flipl(dArray, dArray);
                return !VecMath.isNull(dArray);
            }
            case MOVE_ARC_CW: {
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.getXY(n, dArray4, machcode.getCenter());
                VecMath.sub(dArray, dArray3, dArray4);
                VecMath.flipr(dArray, dArray);
                return !VecMath.isNull(dArray);
            }
        }
        return false;
    }

    private static void getExitVector(double[] dArray, Machcode machcode, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = machcode.getPlane();
        switch (machcode.m_Type) {
            case MOVE_LINEAR: {
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.getXY(n, dArray4, dArray2);
                VecMath.sub(dArray, dArray3, dArray4);
                return;
            }
            case MOVE_ARC_CCW: {
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.getXY(n, dArray4, machcode.getCenter());
                VecMath.sub(dArray, dArray3, dArray4);
                VecMath.flipl(dArray, dArray);
                return;
            }
            case MOVE_ARC_CW: {
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.getXY(n, dArray4, machcode.getCenter());
                VecMath.sub(dArray, dArray3, dArray4);
                VecMath.flipr(dArray, dArray);
                return;
            }
        }
        throw new IllegalArgumentException("cseg.m_Type == " + machcode.m_Type);
    }

    private static boolean getEntryVector(int n, double[] dArray, Machcode machcode, Machcode machcode2, double[] dArray2, double[] dArray3) {
        switch (machcode2.m_Type) {
            case MOVE_LINEAR: {
                VecMath.getXY(n, dArray2, machcode2.getPosition());
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.sub(dArray, dArray2, dArray3);
                return !VecMath.isNull(dArray);
            }
            case MOVE_ARC_CCW: {
                VecMath.getXY(n, dArray2, machcode.getPosition());
                VecMath.getXY(n, dArray3, machcode2.getCenter());
                VecMath.sub(dArray, machcode.getPosition(), machcode2.getCenter());
                VecMath.flipl(dArray, dArray);
                return !VecMath.isNull(dArray);
            }
            case MOVE_ARC_CW: {
                VecMath.getXY(n, dArray2, machcode.getPosition());
                VecMath.getXY(n, dArray3, machcode2.getCenter());
                VecMath.sub(dArray, dArray2, dArray3);
                VecMath.flipr(dArray, dArray);
                return !VecMath.isNull(dArray);
            }
        }
        return false;
    }

    private static void getEntryVector(double[] dArray, Machcode machcode, Machcode machcode2, double[] dArray2, double[] dArray3) {
        int n = machcode.getPlane();
        switch (machcode2.m_Type) {
            case MOVE_LINEAR: {
                VecMath.getXY(n, dArray2, machcode2.getPosition());
                VecMath.getXY(n, dArray3, machcode.getPosition());
                VecMath.sub(dArray, dArray2, dArray3);
                return;
            }
            case MOVE_ARC_CCW: {
                VecMath.getXY(n, dArray2, machcode.getPosition());
                VecMath.getXY(n, dArray3, machcode2.getCenter());
                VecMath.sub(dArray, machcode.getPosition(), machcode2.getCenter());
                VecMath.flipl(dArray, dArray);
                return;
            }
            case MOVE_ARC_CW: {
                VecMath.getXY(n, dArray2, machcode.getPosition());
                VecMath.getXY(n, dArray3, machcode2.getCenter());
                VecMath.sub(dArray, dArray2, dArray3);
                VecMath.flipr(dArray, dArray);
                return;
            }
        }
        throw new IllegalArgumentException("nseg.m_Type == " + machcode2.m_Type);
    }

    public static void process(Machcode machcode, double d, double d2) {
        RadiusCompensator.process(machcode, d, d2, null);
    }

    private static void adjustPath(int n, Machcode machcode, Machcode machcode2, double[] dArray) {
        VecMath.setXY(n, machcode.getPosition(), dArray);
        machcode = machcode.m_Next;
        while (machcode != machcode2) {
            if (machcode.getPosition() != null) {
                VecMath.setXY(n, machcode.getPosition(), dArray);
            }
            machcode = machcode.m_Next;
        }
    }

    private static boolean equalInXY(Machcode machcode, Machcode machcode2) {
        int n = machcode.getPlane();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        VecMath.getXY(n, dArray, machcode2.getPosition());
        VecMath.getXY(n, dArray2, machcode.getPosition());
        return dArray[0] == dArray2[0] && dArray[1] == dArray2[1];
    }

    private static void processInternalCorner(Machcode machcode, Machcode machcode2, Machcode machcode3, int n, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d) {
        double[] dArray5 = VecMath.vec(2);
        double[] dArray6 = VecMath.vec(2);
        double[] dArray7 = VecMath.vec(2);
        double[] dArray8 = VecMath.vec(2);
        double[] dArray9 = VecMath.vec(2);
        double[] dArray10 = VecMath.vec(2);
        double[] dArray11 = VecMath.vec(2);
        double[] dArray12 = VecMath.vec(2);
        double[] dArray13 = VecMath.vec(2);
        double[] dArray14 = VecMath.vec(2);
        double[] dArray15 = VecMath.vec(2);
        double[] dArray16 = VecMath.vec(2);
        double[] dArray17 = VecMath.vec(2);
        double[] dArray18 = VecMath.vec(2);
        double[][] dArrayArray = new double[][]{VecMath.vec(2), VecMath.vec(2)};
        double[] dArray19 = VecMath.vec(2);
        int n2 = machcode2.getPlane();
        VecMath.getXY(n2, dArray14, machcode2.getPosition());
        double d2 = Math.abs(machcode2.getToolCompensation());
        if (!(bl || machcode2 == null || machcode3 == null || machcode2.m_Type == Machcode.SegmentType.MOVE_LINEAR && machcode3.m_Type == Machcode.SegmentType.MOVE_LINEAR)) {
            int n3;
            int n4;
            double d3;
            if (machcode2.m_Type == Machcode.SegmentType.MOVE_LINEAR) {
                VecMath.addscale(dArray8, dArray14, dArray3, d2);
                VecMath.getXY(n2, dArray11, machcode3.getCenter());
                d3 = VecMath.distance(dArray11, dArray14);
                n4 = VecMath.lineCircleIntersection(dArrayArray, dArray8, dArray, dArray11, d3 += (machcode3.m_Type == Machcode.SegmentType.MOVE_ARC_CW ? -d2 : d2) * (double)n, dArray19);
                if (n4 == 0) {
                    System.err.printf("line   x %f  y %f  dx %f  dy %f \n", dArray8[0], dArray8[1], dArray2[0], dArray2[1]);
                    System.err.printf("circle x %f  y %f  r %f \n", dArray11[0], dArray11[1], d3);
                }
                if (n4 == 0) {
                    String string = "Radius compensation failure, line/circle intersection failed/1";
                    throw new Parser.ParseException(string, string, machcode2.m_FilePos);
                }
                VecMath.set(dArray9, dArray11);
                VecMath.set(dArray10, dArray3);
                n3 = VecMath.side(dArray9, dArray10, dArray14);
            } else if (machcode3.m_Type == Machcode.SegmentType.MOVE_LINEAR) {
                VecMath.addscale(dArray8, dArray14, dArray4, d2);
                VecMath.getXY(n2, dArray11, machcode2.getCenter());
                d3 = VecMath.distance(dArray11, dArray14);
                n4 = VecMath.lineCircleIntersection(dArrayArray, dArray8, dArray2, dArray11, Math.abs(d3 += (machcode2.m_Type == Machcode.SegmentType.MOVE_ARC_CW ? -d2 : d2) * (double)n), dArray19);
                if (n4 == 0) {
                    System.err.printf("line   x %f  y %f  dx %f  dy %f \n", dArray8[0], dArray8[1], dArray2[0], dArray2[1]);
                    System.err.printf("circle x %f  y %f  r %f \n", dArray11[0], dArray11[1], d3);
                }
                if (n4 == 0) {
                    String string = "Radius compensation failure, line/circle intersection failed/2";
                    throw new Parser.ParseException(string, string, machcode2.m_FilePos);
                }
                VecMath.set(dArray9, dArray11);
                VecMath.set(dArray10, dArray4);
                n3 = VecMath.side(dArray9, dArray10, dArray14);
            } else {
                VecMath.getXY(n2, dArray12, machcode2.getCenter());
                double d4 = d3 = VecMath.distance(dArray12, dArray14);
                VecMath.getXY(n2, dArray13, machcode3.getCenter());
                double d5 = VecMath.distance(dArray13, dArray14);
                double d6 = machcode2.m_Type == Machcode.SegmentType.MOVE_ARC_CW ? -d2 : d2;
                double d7 = machcode3.m_Type == Machcode.SegmentType.MOVE_ARC_CW ? -d2 : d2;
                VecMath.set(dArray6, dArray14);
                n4 = VecMath.circleCircleIntersection(dArrayArray, dArray12, Math.abs(d3 += d6 * (double)n), dArray13, Math.abs(d5 += d7 * (double)n), dArray15, dArray16, dArray17);
                if (n4 == 0) {
                    // empty if block
                }
                if (n4 <= 0) {
                    n4 = 1;
                    n3 = 0;
                    VecMath.sub(dArray7, dArray14, dArray12);
                    VecMath.addscale(dArrayArray[0], dArray12, dArray7, d3 / VecMath.length(dArray7));
                } else {
                    VecMath.set(dArray9, dArray12);
                    VecMath.sub(dArray10, dArray13, dArray12);
                    n3 = VecMath.side(dArray9, dArray10, dArray14);
                    if (n3 == 0) {
                        VecMath.add(dArray5, dArray12, dArray2);
                        n3 = VecMath.side(dArray9, dArray10, dArray5);
                    }
                }
            }
            if (n4 == 0) {
                throw new IllegalArgumentException("tool compensation failed on file '" + machcode2.m_FilePos);
            }
            int n5 = 0;
            for (int i = 1; i < n4; ++i) {
                if (n3 != VecMath.side(dArray9, dArray10, dArrayArray[i])) continue;
                n5 = i;
            }
            VecMath.set(dArray6, dArrayArray[n5]);
            VecMath.setXY_Z(n2, machcode2.getPosition(), dArray6, VecMath.getZ(n2, machcode2.getPosition()));
            if (machcode2.m_Type != Machcode.SegmentType.MOVE_LINEAR && VecMath.distance(machcode2.getPosition(), machcode.getPosition()) < d * 2.0 * d2) {
                machcode2.m_Type = Machcode.SegmentType.MOVE_LINEAR;
            }
        } else {
            VecMath.add(dArray18, dArray3, dArray4);
            double d8 = VecMath.length(dArray18);
            if (d8 <= 0.0) {
                throw new Parser.ParseException(null, "Radius compensation failure, internal corner too tight (case 1)", machcode2.m_FilePos);
            }
            VecMath.scale(dArray18, dArray18, 1.0 / d8);
            double d9 = d2 / VecMath.dot(dArray3, dArray18);
            VecMath.addscale(dArray6, dArray14, dArray18, d9);
            RadiusCompensator.adjustPath(n2, machcode2, machcode3, dArray6);
        }
    }

    private static void processExternalCorner(Machcode machcode, Machcode machcode2, Machcode machcode3, int n, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double d2, double d3) {
        double[] dArray5 = VecMath.vec(2);
        double[] dArray6 = VecMath.vec(2);
        double[] dArray7 = VecMath.vec(2);
        double[] dArray8 = VecMath.vec(2);
        double[] dArray9 = VecMath.vec(2);
        double[] dArray10 = VecMath.vec(2);
        double[] dArray11 = VecMath.vec(2);
        double[] dArray12 = VecMath.vec(2);
        double[] dArray13 = VecMath.vec(2);
        double[] dArray14 = VecMath.vec(2);
        double[] dArray15 = VecMath.vec(2);
        double[] dArray16 = VecMath.vec(2);
        double[] dArray17 = VecMath.vec(2);
        double[] dArray18 = VecMath.vec(2);
        double[] dArray19 = VecMath.vec(2);
        double[] dArray20 = VecMath.vec(2);
        double[] dArray21 = VecMath.vec(2);
        double[] dArray22 = VecMath.vec(2);
        double[] dArray23 = VecMath.vec(2);
        double d4 = Math.abs(machcode2.getToolCompensation());
        int n2 = machcode2.getPlane();
        VecMath.getXY(n2, dArray8, machcode2.getPosition());
        if (machcode3 != null) {
            if (d3 == 0.0) {
                Machcode.ArcMove arcMove = new Machcode.ArcMove(machcode2.m_FilePos, n2, d, machcode2.getTolerance(), machcode2.getVelocity(), VecMath.copy(machcode2.getPosition()), VecMath.copy(machcode2.getPosition()), n > 0 ? Machcode.SegmentType.MOVE_ARC_CCW : Machcode.SegmentType.MOVE_ARC_CW);
                VecMath.addscale(dArray5, dArray8, dArray3, d4);
                VecMath.setXY(n2, machcode2.getPosition(), dArray5);
                machcode2.insert(arcMove);
                VecMath.addscale(dArray5, dArray8, dArray4, d4);
                RadiusCompensator.adjustPath(n2, arcMove, machcode3, dArray5);
            } else {
                Machcode.LinearMove linearMove;
                double d5;
                VecMath.scale(dArray12, dArray2, -1.0);
                double d6 = VecMath.dot(dArray, dArray4);
                if (d6 < VecMath.ZERO_TOLERANCE) {
                    d6 = VecMath.ZERO_TOLERANCE;
                }
                if ((d5 = VecMath.dot(dArray12, dArray3)) < VecMath.ZERO_TOLERANCE) {
                    d5 = VecMath.ZERO_TOLERANCE;
                }
                VecMath.scale(dArray13, dArray, d4 / d6);
                VecMath.scale(dArray14, dArray12, Math.abs(d2) / d5);
                VecMath.add(dArray23, dArray14, dArray13);
                VecMath.add(dArray15, dArray8, dArray23);
                VecMath.set(dArray16, dArray15);
                int n3 = 1;
                double d7 = VecMath.length(dArray23);
                double d8 = d3 * 2.0 * d4;
                if (d7 > d8) {
                    n3 = 2;
                    VecMath.scale(dArray23, d4 / d7);
                    VecMath.flipr(dArray20, dArray23);
                    VecMath.add(dArray17, dArray8, dArray23);
                    VecMath.set(dArray21, dArray);
                    VecMath.addscale(dArray18, dArray8, dArray3, d4);
                    VecMath.lineLineIntersection(dArray15, dArray17, dArray20, dArray18, dArray21);
                    VecMath.set(dArray22, dArray2);
                    VecMath.addscale(dArray19, dArray8, dArray4, d4);
                    VecMath.lineLineIntersection(dArray16, dArray17, dArray20, dArray19, dArray22);
                }
                Machcode machcode4 = machcode2;
                if (machcode2.m_Type == Machcode.SegmentType.MOVE_LINEAR) {
                    VecMath.setXY(n2, machcode2.getPosition(), dArray15);
                } else {
                    VecMath.addscale(dArray5, dArray8, dArray3, d4);
                    VecMath.setXY(n2, machcode2.getPosition(), dArray5);
                    linearMove = new Machcode.LinearMove(machcode2.m_FilePos, n2, d, machcode2.getTolerance(), machcode2.getVelocity(), VecMath.copy(machcode2.getPosition()));
                    machcode4.insert(linearMove);
                    VecMath.setXY(n2, ((Machcode)linearMove).getPosition(), dArray15);
                    machcode4 = linearMove;
                }
                if (n3 == 2) {
                    linearMove = new Machcode.LinearMove(machcode2.m_FilePos, n2, d, machcode2.getTolerance(), machcode2.getVelocity(), VecMath.copy(machcode2.getPosition()));
                    machcode4.insert(linearMove);
                    VecMath.setXY(n2, ((Machcode)linearMove).getPosition(), dArray16);
                    machcode4 = linearMove;
                    if (machcode3.m_Type != Machcode.SegmentType.MOVE_LINEAR) {
                        VecMath.addscale(dArray5, dArray8, dArray4, d4);
                        Machcode.LinearMove linearMove2 = new Machcode.LinearMove(machcode2.m_FilePos, n2, d, machcode2.getTolerance(), machcode2.getVelocity(), VecMath.copy(machcode2.getPosition()));
                        machcode4.insert(linearMove2);
                        VecMath.setXY(n2, ((Machcode)linearMove2).getPosition(), dArray5);
                        machcode4 = linearMove2;
                    }
                }
                RadiusCompensator.adjustPath(n2, machcode4, machcode3, machcode4.getPosition());
            }
        }
    }

    private static void processCorner(Machcode machcode, Machcode machcode2, Machcode machcode3, double[] dArray, double d, double d2) {
        double[] dArray2 = VecMath.vec(2);
        double[] dArray3 = VecMath.vec(2);
        double[] dArray4 = VecMath.vec(2);
        double[] dArray5 = VecMath.vec(2);
        double[] dArray6 = VecMath.vec(2);
        double[] dArray7 = VecMath.vec(2);
        double[] dArray8 = VecMath.vec(2);
        double[] dArray9 = VecMath.vec(2);
        double d3 = machcode2.getToolCompensation();
        double d4 = machcode3 != null ? machcode3.getToolCompensation() : 0.0;
        boolean bl = d4 == 0.0;
        RadiusCompensator.getExitVector(dArray2, machcode2, dArray, dArray6, dArray7);
        if (!bl) {
            RadiusCompensator.getEntryVector(dArray3, machcode2, machcode3, dArray6, dArray7);
        } else {
            VecMath.set(dArray3, dArray2);
        }
        int n = d3 > 0.0 ? 1 : -1;
        double d5 = Math.abs(d3);
        double d6 = VecMath.length(dArray2);
        double d7 = VecMath.length(dArray3);
        if (d6 <= 0.0 || d7 <= 0.0) {
            String string = "Radius compensation failure, zero length segment encountered";
            throw new Parser.ParseException(string, string, machcode2.m_FilePos);
        }
        VecMath.scale(dArray2, dArray2, 1.0 / d6);
        VecMath.scale(dArray3, dArray3, 1.0 / d7);
        if (n > 0) {
            VecMath.flipr(dArray4, dArray2);
            VecMath.flipr(dArray5, dArray3);
        } else {
            VecMath.flipl(dArray4, dArray2);
            VecMath.flipl(dArray5, dArray3);
        }
        int n2 = VecMath.side(dArray2, dArray3);
        if (n2 == 0) {
            if (VecMath.dot(dArray2, dArray3) < 0.0) {
                double[] dArray10 = VecMath.vec(2);
                VecMath.add(dArray10, dArray2, dArray4);
                n2 = VecMath.side(dArray10, dArray5) > 0 ? (n2 = n) : -n;
            } else {
                n2 = n;
            }
        }
        if (n2 == n) {
            RadiusCompensator.processInternalCorner(machcode, machcode2, machcode3, n, bl, dArray2, dArray3, dArray4, dArray5, d);
        } else {
            RadiusCompensator.processExternalCorner(machcode, machcode2, machcode3, n, bl, dArray2, dArray3, dArray4, dArray5, d3, d4, d2);
        }
    }

    public static void process(Machcode machcode, double d, double d2, Debug debug) {
        Machcode machcode2 = machcode;
        if (machcode2.getPosition() == null) {
            System.out.println("BUG");
        }
        Machcode machcode3 = null;
        Machcode machcode4 = null;
        int n = machcode.getPosition().length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        machcode4 = machcode.m_Next;
        while ((machcode3 = machcode4) != null) {
            machcode4 = machcode3.m_Next;
            if (machcode3.getPosition() == null) continue;
            VecMath.set(dArray2, machcode3.getPosition());
            if (machcode3.getToolCompensation() == 0.0 || RadiusCompensator.equalInXY(machcode3, machcode2)) {
                machcode2 = machcode3;
                if (machcode2.getPosition() == null) {
                    System.out.println("BUG");
                }
                VecMath.set(dArray, dArray2);
                continue;
            }
            while (machcode4 != null && (machcode4.getPosition() == null || RadiusCompensator.equalInXY(machcode3, machcode4) && machcode4.getToolCompensation() != 0.0)) {
                machcode4 = machcode4.m_Next;
            }
            RadiusCompensator.processCorner(machcode2, machcode3, machcode4, dArray, d2, d);
            machcode2 = machcode3;
            if (machcode2.getPosition() == null) {
                System.out.println("BUG");
            }
            VecMath.set(dArray, dArray2);
        }
        machcode3 = machcode;
        boolean bl = true;
        while (machcode3 != null) {
            machcode3 = machcode3.m_Next;
        }
    }

    public static interface Debug {
        public void showVector(double[] var1, double[] var2, Color var3);
    }
}

