/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.pendant;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import eazycnc.Main;
import eazycnc.ShortcutManager;
import eazycnc.ToolSetupPanel;
import eazycnc.WorkOffsetPanel;
import eazycnc.gcode.MachState;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import motorcontrol.MachController;
import printf.Printf;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.PureJavaHidApi;

public class Pendant {
    protected Hashtable<Integer, String> m_ButtonMapping = new Hashtable();
    protected Main m_Main;
    protected volatile MachController m_MachController;
    protected MotorController m_MotorController;
    protected ShortcutManager m_ShortcutManager;
    protected DecimalFormat m_DroFormatter;
    protected HidDevice m_Device;
    protected MachState m_MachState;
    protected volatile int m_Axis = -1;
    protected volatile int m_StepMultiplier = 3;
    protected volatile int m_KeyPressed = 0;
    protected volatile int m_KeyPressCount = 0;
    private Thread m_UpdateDrosThread;
    private Thread m_UpdateWheelJogThread;
    private byte[] m_OldFeatureReportData = null;

    public Pendant(Main main, HidDeviceInfo hidDeviceInfo) throws Exception {
        this.m_Device = PureJavaHidApi.openDevice((HidDeviceInfo)hidDeviceInfo);
        this.m_Main = main;
        this.m_MachController = this.m_Main.m_MachController;
        this.m_ShortcutManager = Main.m_ShortCutManager;
        this.m_MachState = this.m_MachController.getMachState();
        this.m_MotorController = this.m_MachController.getMotorController();
        this.m_Main.m_MachController.m_MachState.getDroFormatVariable().addObserver(observable -> {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            this.m_DroFormatter = new DecimalFormat(((SimpleVariable)observable).getValue().toString(), decimalFormatSymbols);
        });
        this.m_Device.setDeviceRemovalListener(new DeviceRemovalListener(){

            public void onDeviceRemoval(HidDevice hidDevice) {
                Pendant.this.removePendant();
            }
        });
        this.m_Device.setInputReportListener((hidDevice, by, byArray, n) -> this.onInputReport(hidDevice, by, byArray, n));
        this.m_UpdateDrosThread = new Thread(() -> this.runOnBackgroundUpdateDros());
        this.m_UpdateWheelJogThread = new Thread(() -> this.runOnBackgroundUpdateWheelJog());
        this.m_UpdateDrosThread.start();
        this.m_UpdateWheelJogThread.start();
    }

    protected void init(String string, int n) {
        this.m_ButtonMapping.put(n, string);
    }

    protected void removePendant() {
        Printf.println("Pendant removed");
        this.m_Main.m_PendantManager.removePendant(this.m_Device.getHidDeviceInfo());
        try {
            this.m_Device.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_Device = null;
    }

    protected void onInputReport(HidDevice hidDevice, byte by, byte[] byArray, int n) {
    }

    protected void runOnBackgroundUpdateWheelJog() {
        while (this.m_Device != null) {
            try {
                Thread.sleep(10L);
                this.handleWheel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void handleWheel() {
    }

    protected void runOnBackgroundUpdateDros() {
    }

    public void onMpgZERO() {
        Main.m_MainWindow.tryToZeroAxis(this.m_Axis);
    }

    public void onMpgNextStepMultiplier() {
        if (this.m_StepMultiplier > 0) {
            --this.m_StepMultiplier;
        } else {
            UWKit.beep();
            this.m_StepMultiplier = 3;
        }
    }

    public void onMpgResetStepMultiplier() {
        UWKit.beep();
        this.m_StepMultiplier = 3;
    }

    public void onMpgProbeOrigin() {
        if (this.m_Axis < 0) {
            Main.m_MainWindow.setButtonErrorAndBeep("No axis selected");
        }
        if (this.m_Axis > 1) {
            Main.m_MainWindow.setButtonErrorAndBeep("Set Origin only available for X and Y axis");
        }
        WorkOffsetPanel.runWorkOffsetProbeScript(this.m_Main, this.m_Axis, 1, -this.m_Main.m_MachController.getMachState().getParamDouble(0x4000000, this.m_Axis));
    }

    public void onMpgProbeZ(boolean bl) {
        if (bl) {
            ToolSetupPanel.runAutoToolSetterScript(this.m_Main);
        } else {
            WorkOffsetPanel.runWorkOffsetProbeScript(this.m_Main, 2, -1, this.m_Main.m_MachController.getMachState().getParamDouble(15152));
        }
    }

    public void onMpgHome(boolean bl) {
        for (int i = 0; i < 6; ++i) {
            if (!this.m_Main.m_MachController.m_MachState.isAxisEnabled(i) || i != this.m_Axis && this.m_Axis != -1 && !bl) continue;
            try {
                int n = (int)(Main.m_Main.m_MachController.m_MachState.getParamDouble(-2147483647, i) * Main.m_Main.m_MachController.m_MachState.getParamDouble(-2147483646, i) + 0.5);
                if (Main.m_Main.m_MachController.getMachState().getParamInt(-2147483644, i) < 0) {
                    Main.m_Main.m_MachController.resetPosition(i, n);
                    continue;
                }
                Main.m_Main.m_MachController.startHoming(i, n);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.m_MainWindow.setButtonErrorAndBeep(illegalArgumentException.getMessage());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Main.m_MainWindow.setButtonErrorAndBeep("EXCEPTION " + exception.getClass().getSimpleName() + " press F12 for console");
            }
        }
    }

    public void onMpgEdge() {
        if (this.m_Axis == 0 || this.m_Axis == 1) {
            WorkOffsetPanel.setWorkOffset(this.m_Main, this.m_Axis, 1, -0.5 * this.m_MachState.getParamDouble(15151));
        } else if (this.m_Axis == 2) {
            WorkOffsetPanel.setWorkOffset(this.m_Main, 2, -1, this.m_MachState.getParamDouble(15152));
        } else {
            Main.m_MainWindow.setButtonErrorAndBeep("No axis selected");
        }
    }

    public void onMpgNextTool(boolean bl) {
        int n = this.m_MachState.getParamInt(15147);
        if (bl) {
            n = 1;
        } else if (++n > 255) {
            n = 1;
        }
        if (n == 1) {
            UWKit.beep();
        }
        this.m_MachState.setParam(15147, n);
    }
}

