/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import eazycnc.planner.Segment;
import eazycnc.planner.VecMath;
import eazycnc.planner.WayPoint_OLD;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.vecmath.Point2d;

public class AheadOfTimePlanner {
    private int NUMBER_OF_AXIS;
    private double m_MaxAcceleration = 0.2;
    private double localT;
    private double tau;
    private double[] S1 = new double[this.NUMBER_OF_AXIS];
    private double[] S2 = new double[this.NUMBER_OF_AXIS];
    private double[] S3 = new double[this.NUMBER_OF_AXIS];
    private double f1;
    private double f2;
    private double l1;
    private double l2;
    private double[] V1 = new double[this.NUMBER_OF_AXIS];
    private double[] V2 = new double[this.NUMBER_OF_AXIS];
    private double[] dV = new double[this.NUMBER_OF_AXIS];
    private double[] Amax = new double[this.NUMBER_OF_AXIS];
    private double ablend;
    LinkedList<Point2d> m_Debug = new LinkedList();
    LinkedList<Point2d> m_Debug2 = new LinkedList();

    public AheadOfTimePlanner(int n) {
        this.NUMBER_OF_AXIS = n;
        this.localT = 0.0;
        this.tau = 0.0;
        this.S1 = new double[this.NUMBER_OF_AXIS];
        this.S2 = new double[this.NUMBER_OF_AXIS];
        this.S3 = new double[this.NUMBER_OF_AXIS];
        this.f1 = 0.0;
        this.f2 = 0.0;
        this.l1 = 0.0;
        this.l2 = 0.0;
        this.V1 = new double[this.NUMBER_OF_AXIS];
        this.V2 = new double[this.NUMBER_OF_AXIS];
        this.dV = new double[this.NUMBER_OF_AXIS];
        this.Amax = new double[this.NUMBER_OF_AXIS];
        this.m_Debug = new LinkedList();
        this.m_Debug2 = new LinkedList();
    }

    private boolean calcBlendRegion(double d, double d2) {
        double d3 = this.l1 / d;
        double d4 = this.l2 / d2;
        VecMath.scale(this.V1, this.S1, d);
        VecMath.scale(this.V2, this.S2, d2);
        VecMath.sub(this.dV, this.V2, this.V1);
        double d5 = VecMath.dot(this.S1, this.S2);
        double d6 = Math.acos(-d5) / 2.0;
        if (d6 == 0.0) {
            throw new IllegalArgumentException("theta is zero");
        }
        double d7 = 2.0 * this.localT / Math.cos(d6);
        this.tau = Math.min(d7 / d, d7 / d2);
        if (this.tau == 0.0) {
            throw new IllegalArgumentException("tau is zero");
        }
        VecMath.scale(this.Amax, this.dV, 1.0 / (2.0 * this.tau));
        this.ablend = VecMath.maxabs(this.Amax);
        if (Double.isNaN(this.ablend)) {
            throw new IllegalArgumentException("ablend is NaN");
        }
        return this.ablend <= this.m_MaxAcceleration;
    }

    public boolean planBlend(WayPoint_OLD[] wayPoint_OLDArray, int n) {
        this.f1 = wayPoint_OLDArray[n - 1].m_Speed;
        this.f2 = wayPoint_OLDArray[n + 0].m_Speed;
        double d = this.f1;
        this.localT = wayPoint_OLDArray[n + 0].m_Tolerance;
        if (this.localT == 0.0) {
            throw new IllegalArgumentException("Tolerance at " + n + " is zero");
        }
        VecMath.set(this.S1, wayPoint_OLDArray[n - 1].m_Move);
        this.l1 = wayPoint_OLDArray[n - 1].m_Length;
        VecMath.set(this.S2, wayPoint_OLDArray[n + 0].m_Move);
        this.l2 = wayPoint_OLDArray[n + 0].m_Length;
        double d2 = Math.min(this.l1, this.l2) * 0.5;
        VecMath.scale(this.S1, this.S1, d2 / this.l1);
        VecMath.scale(this.S2, this.S2, d2 / this.l2);
        this.l1 = d2;
        this.l2 = d2;
        VecMath.add(this.S3, this.S1, this.S2);
        VecMath.scale(this.S3, this.S3, 0.5);
        VecMath.sub(this.S3, this.S3, this.S1);
        VecMath.scale(this.S1, this.S1, 1.0 / d2);
        VecMath.scale(this.S2, this.S2, 1.0 / d2);
        double d3 = VecMath.length(this.S3) * 0.5;
        if (this.localT > d3) {
            this.localT = d3;
        }
        if (this.localT > VecMath.ZERO_TOLERANCE) {
            if (!this.calcBlendRegion(this.f1, this.f2)) {
                double d4;
                double d5;
                int n2 = 200;
                boolean bl = false;
                if (this.f1 > this.f2) {
                    d5 = this.f1;
                    d4 = this.f2;
                    int n3 = n2;
                    while (d5 != d4 && --n3 > 0) {
                        this.f1 = (d5 + d4) / 2.0;
                        bl = this.calcBlendRegion(this.f1, this.f2);
                        if (bl) {
                            d4 = this.f1;
                            continue;
                        }
                        d5 = this.f1;
                    }
                } else if (this.f2 > this.f1) {
                    d5 = 0.0;
                    d4 = this.f2;
                    double d6 = this.f1;
                    int n4 = n2;
                    while (d4 != d6 && --n4 > 0) {
                        this.f2 = (d4 + d6) / 2.0;
                        bl = this.calcBlendRegion(this.f1, this.f2);
                        if (bl) {
                            d6 = this.f2;
                            d5 = this.f2;
                            continue;
                        }
                        d4 = this.f2;
                    }
                }
                if (!bl && Math.abs(this.f1 - this.f2) < 1.0E-6) {
                    d5 = this.f1 = (this.f2 = (this.f1 + this.f2) / 2.0);
                    d4 = 0.0;
                    int n5 = n2;
                    while (d5 != d4 && --n5 > 0) {
                        this.f1 = this.f2 = (d5 + d4) / 2.0;
                        bl = this.calcBlendRegion(this.f1, this.f2);
                        if (bl) {
                            d4 = this.f1;
                            continue;
                        }
                        d5 = this.f1;
                    }
                }
            }
            if (this.ablend < this.m_MaxAcceleration) {
                double d7 = this.ablend / this.m_MaxAcceleration;
                this.tau *= d7;
            }
            if (Double.isNaN(this.tau)) {
                throw new IllegalArgumentException("tau is NaN");
            }
        } else {
            this.tau = 0.0;
        }
        wayPoint_OLDArray[n + 0].m_Speed = this.f2;
        wayPoint_OLDArray[n + 0].m_BlendIn = this.tau;
        wayPoint_OLDArray[n - 1].m_BlendOut = this.tau;
        wayPoint_OLDArray[n - 1].m_Speed = this.f1;
        return d != this.f1;
    }

    static double quadratic(double d, double d2, double d3) {
        double d4 = Math.sqrt(d2 * d2 - 4.0 * d * d3);
        double d5 = -0.5 * (d2 + (d2 > 0.0 ? d4 : -d4));
        double d6 = d5 / d;
        double d7 = d3 / d5;
        if (d6 > 0.0 && d7 > 0.0) {
            System.out.printf("Assumption bug, both roots real and positive, %f  %f\n", d6, d7);
        }
        if (d6 > 0.0) {
            return d6;
        }
        return d7;
    }

    public LinkedList<double[]> generatePath2(WayPoint_OLD[] wayPoint_OLDArray, int n, double d) {
        double[] dArray = new double[this.NUMBER_OF_AXIS];
        double[] dArray2 = new double[this.NUMBER_OF_AXIS];
        double[] dArray3 = new double[this.NUMBER_OF_AXIS];
        for (int i = 0; i < wayPoint_OLDArray.length - 1; ++i) {
            WayPoint_OLD wayPoint_OLD = wayPoint_OLDArray[i];
            VecMath.scale(dArray3, wayPoint_OLD.m_Move, 1.0 / wayPoint_OLD.m_Length);
            VecMath.set(dArray, wayPoint_OLD.m_Pos);
            VecMath.set(dArray2, dArray3);
            VecMath.scale(dArray2, dArray2, wayPoint_OLD.m_BlendIn * wayPoint_OLD.m_Speed);
            VecMath.add(dArray, dArray, dArray2);
            this.m_Debug.add(new Point2d(dArray[0], dArray[1]));
            double d2 = i > 0 ? wayPoint_OLDArray[i - 1].m_Speed : 0.0;
            double d3 = wayPoint_OLD.m_RampUp;
            double d4 = i > 0 ? (wayPoint_OLDArray[i - 1].m_Speed + wayPoint_OLDArray[i].m_Speed) / 2.0 : 0.0;
            double d5 = this.m_MaxAcceleration;
            VecMath.scale(dArray2, dArray3, d4 * d3 + 0.5 * d5 * d3 * d3);
            VecMath.add(dArray, dArray, dArray2);
            this.m_Debug.add(new Point2d(dArray[0], dArray[1]));
            d2 = wayPoint_OLD.m_Duration - wayPoint_OLD.m_BlendIn - wayPoint_OLD.m_RampUp - wayPoint_OLD.m_RampDown - wayPoint_OLD.m_BlendOut;
            VecMath.scale(dArray2, dArray3, d2 * wayPoint_OLD.m_TargetSpeed);
            VecMath.add(dArray, dArray, dArray2);
            this.m_Debug.add(new Point2d(dArray[0], dArray[1]));
            d2 = wayPoint_OLD.m_RampDown;
            d3 = this.m_MaxAcceleration;
            VecMath.scale(dArray2, dArray3, wayPoint_OLD.m_TargetSpeed * d2 - 0.5 * d3 * d2 * d2);
            VecMath.add(dArray, dArray, dArray2);
            this.m_Debug.add(new Point2d(dArray[0], dArray[1]));
            VecMath.set(dArray2, dArray3);
            VecMath.scale(dArray2, dArray2, wayPoint_OLD.m_BlendOut * wayPoint_OLD.m_Speed);
            VecMath.add(dArray, dArray, dArray2);
            this.m_Debug.add(new Point2d(dArray[0], dArray[1]));
        }
        return null;
    }

    public LinkedList<Segment> generatePath(WayPoint_OLD[] wayPoint_OLDArray, int n, double d) {
        LinkedList<Segment> linkedList = new LinkedList<Segment>();
        LinkedList<double[]> linkedList2 = null;
        double[] dArray = new double[this.NUMBER_OF_AXIS];
        double[] dArray2 = new double[this.NUMBER_OF_AXIS];
        double[] dArray3 = new double[this.NUMBER_OF_AXIS];
        double[] dArray4 = new double[this.NUMBER_OF_AXIS];
        double[] dArray5 = new double[this.NUMBER_OF_AXIS];
        double[] dArray6 = new double[this.NUMBER_OF_AXIS];
        double[] dArray7 = new double[this.NUMBER_OF_AXIS];
        double[] dArray8 = new double[this.NUMBER_OF_AXIS];
        double[] dArray9 = new double[this.NUMBER_OF_AXIS];
        double[] dArray10 = new double[this.NUMBER_OF_AXIS];
        double[] dArray11 = new double[this.NUMBER_OF_AXIS];
        double[] dArray12 = new double[this.NUMBER_OF_AXIS];
        VecMath.set(dArray, wayPoint_OLDArray[n].m_Pos);
        VecMath.set(dArray4, wayPoint_OLDArray[n].m_Move);
        VecMath.scale(dArray4, dArray4, wayPoint_OLDArray[n].m_Speed / wayPoint_OLDArray[n].m_Length);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n2 = 0;
        int n3 = 0;
        block7: while (true) {
            double d10 = d;
            while (d10 > 0.0) {
                System.out.println("phaseLeft=" + d9);
                while (d9 <= 0.0) {
                    switch (n2++) {
                        case 0: {
                            if (n3 + 1 >= wayPoint_OLDArray.length) break block7;
                            linkedList2 = new LinkedList<double[]>();
                            linkedList.add(new Segment(linkedList2));
                            VecMath.set(dArray3, dArray4);
                            if (n3 + 2 < wayPoint_OLDArray.length) {
                                VecMath.set(dArray4, wayPoint_OLDArray[n3 + 1].m_Move);
                                VecMath.scale(dArray4, dArray4, wayPoint_OLDArray[n3 + 1].m_Speed / wayPoint_OLDArray[n3 + 1].m_Length);
                            } else {
                                VecMath.set(dArray4, dArray5);
                            }
                            WayPoint_OLD wayPoint_OLD = wayPoint_OLDArray[n3];
                            d3 = wayPoint_OLD.m_BlendIn;
                            d7 = wayPoint_OLD.m_BlendOut;
                            d8 = wayPoint_OLD.m_Speed;
                            d4 = wayPoint_OLD.m_RampUp;
                            d6 = wayPoint_OLD.m_RampDown;
                            d2 = wayPoint_OLD.m_Duration;
                            VecMath.sub(dArray11, wayPoint_OLDArray[n3 + 1].m_Pos, wayPoint_OLDArray[n3].m_Pos);
                            double d11 = VecMath.length(dArray11);
                            VecMath.scale(dArray9, dArray11, this.m_MaxAcceleration / d11);
                            d5 = d2 - d3 - d4 - d6 - d7;
                            VecMath.set(dArray7, dArray8);
                            VecMath.sub(dArray8, dArray4, dArray3);
                            VecMath.scale(dArray8, dArray8, 1.0 / (2.0 * d7));
                            VecMath.set(dArray6, dArray7);
                            d9 = d3;
                            break;
                        }
                        case 1: {
                            this.m_Debug2.add(new Point2d(dArray[0], dArray[1]));
                            VecMath.set(dArray6, dArray9);
                            d9 = d4;
                            break;
                        }
                        case 2: {
                            this.m_Debug2.add(new Point2d(dArray[0], dArray[1]));
                            VecMath.set(dArray6, dArray5);
                            d9 = d5;
                            break;
                        }
                        case 3: {
                            this.m_Debug2.add(new Point2d(dArray[0], dArray[1]));
                            VecMath.scale(dArray6, dArray9, -1.0);
                            d9 = d6;
                            break;
                        }
                        case 4: {
                            this.m_Debug2.add(new Point2d(dArray[0], dArray[1]));
                            VecMath.set(dArray6, dArray8);
                            d9 = d7;
                            n2 = 0;
                            ++n3;
                        }
                    }
                }
                linkedList2.add(VecMath.copy(dArray));
                if (Double.isNaN(d9)) {
                    throw new IllegalArgumentException("phaseLeft is NaN");
                }
                double d12 = d9 > d10 ? d10 : d9;
                VecMath.scale(dArray10, dArray6, 0.5 * d12);
                VecMath.add(dArray10, dArray10, dArray2);
                VecMath.scale(dArray10, dArray10, d12);
                VecMath.add(dArray, dArray, dArray10);
                VecMath.scale(dArray12, dArray6, d12);
                VecMath.add(dArray2, dArray2, dArray12);
                d10 -= d12;
                d9 -= d12;
            }
            if (!(d10 < 0.0)) continue;
            System.out.printf("Error, delta step overshoot by %f\n", d10);
        }
        linkedList2.add(VecMath.copy(dArray));
        return linkedList;
    }

    private void planSegment(WayPoint_OLD[] wayPoint_OLDArray, int n) {
        double[] dArray = new double[this.NUMBER_OF_AXIS];
        double[] dArray2 = new double[this.NUMBER_OF_AXIS];
        double[] dArray3 = new double[this.NUMBER_OF_AXIS];
        double[] dArray4 = new double[this.NUMBER_OF_AXIS];
        double[] dArray5 = new double[this.NUMBER_OF_AXIS];
        double[] dArray6 = new double[this.NUMBER_OF_AXIS];
        VecMath.sub(dArray2, wayPoint_OLDArray[n + 1].m_Pos, wayPoint_OLDArray[n].m_Pos);
        VecMath.scale(dArray2, dArray2, wayPoint_OLDArray[n].m_Speed / VecMath.length(dArray2));
        if (n + 2 < wayPoint_OLDArray.length) {
            VecMath.sub(dArray3, wayPoint_OLDArray[n + 2].m_Pos, wayPoint_OLDArray[n + 1].m_Pos);
            VecMath.scale(dArray3, dArray3, wayPoint_OLDArray[n + 1].m_Speed / VecMath.length(dArray3));
        } else {
            VecMath.set(dArray3, dArray4);
        }
        WayPoint_OLD wayPoint_OLD = wayPoint_OLDArray[n];
        double d = wayPoint_OLD.m_BlendIn;
        double d2 = wayPoint_OLD.m_BlendOut;
        double d3 = wayPoint_OLD.m_Speed;
        double d4 = wayPoint_OLD.m_TargetSpeed;
        VecMath.sub(dArray5, wayPoint_OLDArray[n + 1].m_Pos, wayPoint_OLD.m_Pos);
        double d5 = VecMath.length(dArray5);
        double d6 = d5 / d3;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = d6 - d - d2;
        if (d13 < 0.0) {
            System.out.printf("Blend times overshoot segment duration %f\n", d13);
        }
        if (d13 > 0.0) {
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            boolean bl;
            double d19 = d3 * d13;
            d11 = d3;
            d12 = d3;
            if (n == 0) {
                d11 = 0.0;
            }
            if (n + 2 >= wayPoint_OLDArray.length) {
                d12 = 0.0;
            }
            if (bl = d12 < d11) {
                d18 = d12;
                d12 = d11;
                d11 = d18;
            }
            if (d19 < (d17 = d11 * (d16 = (d18 = d12 - d11) / this.m_MaxAcceleration) + this.m_MaxAcceleration * d16 * d16)) {
                System.out.printf("This should never happen sLin (%f) < s3 (%f)\n", d19, d17);
            }
            if ((d10 = d12 + (d15 = AheadOfTimePlanner.quadratic(this.m_MaxAcceleration, 2.0 * d12, -d19 + d17)) * this.m_MaxAcceleration) > d4) {
                d10 = d4;
                d15 = (d10 - d12) / this.m_MaxAcceleration;
            }
            if ((d14 = d19 - (d16 * d11 + 0.5 * this.m_MaxAcceleration * d16 * d16) - 2.0 * (d15 * d12 + 0.5 * this.m_MaxAcceleration * d15 * d15)) < 0.0) {
                d14 = 0.0;
            }
            d9 = d14 / d10;
            double d20 = d16 * d11 + 0.5 * this.m_MaxAcceleration * d16 * d16;
            d20 += 2.0 * (d15 * d12 + 0.5 * this.m_MaxAcceleration * d15 * d15);
            double d21 = (d20 += d9 * d10) - d19;
            if (Math.abs(d21) > 1.0E-12) {
                System.out.printf("Distance error %f too large \n", d21);
            }
            if (bl) {
                d7 = d15;
                d8 = d15 + d16;
                double d22 = d12;
                d12 = d11;
                d11 = d22;
            } else {
                d7 = d15 + d16;
                d8 = d15;
            }
            d21 = d11 + d7 * this.m_MaxAcceleration - d10;
            if (Math.abs(d21) > 1.0E-16) {
                System.out.printf("Ramp up velocity error %f too large\n", d21);
            }
            if (Math.abs(d21 = d10 - d8 * this.m_MaxAcceleration - d12) > 1.0E-16) {
                System.out.printf("Ramp down velocity error %f too large\n", d21);
            }
        }
        if (Double.isNaN(d6 = d + d7 + d9 + d8 + d2)) {
            throw new IllegalArgumentException("tSegment is NaN");
        }
        if (Double.isInfinite(d6)) {
            throw new IllegalArgumentException("tSegment is Infinite");
        }
        wayPoint_OLD.m_RampUp = d7;
        wayPoint_OLD.m_RampDown = d8;
        wayPoint_OLD.m_Duration = d6;
    }

    public static LinkedList<Segment> planPath(double d, double d2, List<WayPoint_OLD> list) {
        return AheadOfTimePlanner.planPath(d, d2, list.toArray(new WayPoint_OLD[0]));
    }

    public static LinkedList<Segment> planPath(double d, double d2, WayPoint_OLD[] wayPoint_OLDArray) {
        AheadOfTimePlanner aheadOfTimePlanner = new AheadOfTimePlanner(wayPoint_OLDArray[0].m_Pos.length);
        aheadOfTimePlanner.plan(d, wayPoint_OLDArray);
        return aheadOfTimePlanner.generatePath(wayPoint_OLDArray, 0, d2);
    }

    public void plan(double d, WayPoint_OLD[] wayPoint_OLDArray) {
        int n;
        this.m_MaxAcceleration = d;
        wayPoint_OLDArray[wayPoint_OLDArray.length - 1].m_Speed = 0.0;
        wayPoint_OLDArray[wayPoint_OLDArray.length - 1].m_Length = 0.0;
        for (n = 0; n < wayPoint_OLDArray.length - 1; ++n) {
            double[] dArray = wayPoint_OLDArray[n].m_Move;
            VecMath.set(dArray, wayPoint_OLDArray[n + 1].m_Pos);
            VecMath.sub(dArray, dArray, wayPoint_OLDArray[n].m_Pos);
            double d2 = VecMath.length(dArray);
            if (d2 == 0.0) {
                throw new IllegalArgumentException("Segment " + n + " length zero");
            }
            if (wayPoint_OLDArray[n].m_TargetSpeed <= 0.0) {
                throw new IllegalArgumentException("Segment " + n + " target speed zero or negative");
            }
            wayPoint_OLDArray[n].m_Length = d2;
        }
        for (n = 1; n < wayPoint_OLDArray.length - 1; ++n) {
            if (!this.planBlend(wayPoint_OLDArray, n) || n <= 1) continue;
            n -= 2;
        }
        for (n = 0; n < wayPoint_OLDArray.length - 1; ++n) {
            this.planSegment(wayPoint_OLDArray, n);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Iterator iterator;
        double d = 10.0;
        double d2 = 10000.0;
        WayPoint_OLD[] wayPoint_OLDArray = new WayPoint_OLD[]{new WayPoint_OLD(d2, 10.0, 0.0, 0.0), new WayPoint_OLD(d2, 10.0, 8000.0, 0.0), new WayPoint_OLD(d2, 10.0, 8000.0, 7000.0), new WayPoint_OLD(d2, 10.0, 0.0, 8000.0), new WayPoint_OLD(0.0, 0.0, 0.0, 0.0)};
        AheadOfTimePlanner aheadOfTimePlanner = new AheadOfTimePlanner(2);
        aheadOfTimePlanner.plan(50000.0, wayPoint_OLDArray);
        for (WayPoint_OLD wayPoint_OLD : wayPoint_OLDArray) {
            System.out.println(wayPoint_OLD);
        }
        double d3 = 0.02;
        LinkedList<Segment> linkedList = aheadOfTimePlanner.generatePath(wayPoint_OLDArray, 0, d3);
        for (Segment segment : linkedList) {
            iterator = segment.getPoints().iterator();
            while (iterator.hasNext()) {
                object = (double[])iterator.next();
                System.out.print((double)object[0] + "," + (double)object[1] + "  ");
            }
            System.out.println();
        }
        double d4 = 0.0;
        iterator = null;
        object = new LinkedList();
        for (Segment segment : linkedList) {
            for (double[] dArray : segment.getPoints()) {
                ((LinkedList)object).add(new Point2d(dArray[0], dArray[1]));
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        wayPoint_OLDArray = null;
    }
}

