/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import eazycnc.planner.PlotDataDouble;
import eazycnc.planner.PlotDataPoint;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.List;

public class Plot
implements Iterable<PlotDataPoint> {
    private String m_Name = "";
    private String m_Unit = "";
    private Color m_Color;
    private Shape m_Marker;
    private PlotDataDouble[] m_Data;
    private int[] m_Stride;
    private int[] m_Offset;
    private int m_X = 0;
    private int m_Y = 1;

    public static Shape smallDot() {
        return new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
    }

    public String getName() {
        return this.m_Name;
    }

    public String getUnit() {
        return this.m_Unit;
    }

    public void setUnit(String string) {
        this.m_Unit = string;
    }

    public void setXY(String string, int n, int n2) {
        this.m_Name = string;
        this.m_X = n;
        this.m_Y = n2;
    }

    public void setData(int n, PlotDataDouble plotDataDouble, int n2, int n3) {
        this.m_Data[n] = plotDataDouble;
        this.m_Stride[n] = n2;
        this.m_Offset[n] = n3;
    }

    public void setData(String string, PlotDataDouble plotDataDouble, PlotDataDouble plotDataDouble2) {
        this.setData(0, plotDataDouble, 1, 0);
        this.setData(1, plotDataDouble2, 1, 0);
        this.setXY(string, 0, 1);
    }

    public Plot(String string, int n, Color color) {
        this(string, n);
        this.m_Color = color;
    }

    public Plot(String string, int n) {
        this.m_Name = string;
        this.m_Data = new PlotDataDouble[n];
        for (int i = 0; i < n; ++i) {
            this.m_Data[i] = new PlotDataDouble();
        }
        this.m_X = 0;
        this.m_Y = 1;
        this.m_Stride = new int[n];
        this.m_Stride[this.m_X] = 1;
        this.m_Stride[this.m_Y] = 1;
        this.m_Offset = new int[n];
        this.m_Offset[this.m_X] = 0;
        this.m_Offset[this.m_Y] = 0;
    }

    public void add(double d, double d2) {
        this.m_Data[this.m_X].add(d);
        this.m_Data[this.m_Y].add(d2);
    }

    public static Shape smallCross() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-1.0f, -1.0f);
        generalPath.lineTo(-1.0f, -3.0f);
        generalPath.lineTo(1.0f, -3.0f);
        generalPath.lineTo(1.0f, -1.0f);
        generalPath.lineTo(3.0f, -1.0f);
        generalPath.lineTo(3.0f, 1.0f);
        generalPath.lineTo(1.0f, 1.0f);
        generalPath.lineTo(1.0f, 3.0f);
        generalPath.lineTo(-1.0f, 3.0f);
        generalPath.lineTo(-1.0f, 1.0f);
        generalPath.lineTo(-3.0f, 1.0f);
        generalPath.lineTo(-3.0f, -1.0f);
        generalPath.closePath();
        return generalPath;
    }

    public Plot(String string, int n, double[] dArray, double[] dArray2, List<String> list, Color color, Shape shape) {
        this(string, 2);
        Iterator<String> iterator = list != null ? list.iterator() : null;
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i], dArray2[i]);
            ++i;
        }
        this.m_Color = color;
        this.m_Marker = shape;
    }

    public Plot(String string, int n, List<Double> list, List<Double> list2, List<String> list3, Color color, Shape shape) {
        this(string, 2);
        Iterator<String> iterator;
        Iterator<Double> iterator2 = list.iterator();
        Iterator<Double> iterator3 = list2.iterator();
        Iterator<String> iterator4 = iterator = list3 != null ? list3.iterator() : null;
        while (iterator2.hasNext()) {
            this.add(iterator2.next(), iterator3.next());
        }
        this.m_Color = color;
        this.m_Marker = shape;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public Shape getMarker() {
        return this.m_Marker;
    }

    public int size() {
        return this.m_Data[this.m_X].size() / this.m_Stride[this.m_X];
    }

    @Override
    public Iterator<PlotDataPoint> iterator() {
        return new Iterator<PlotDataPoint>(){
            private int m_Index = 0;
            private int m_Size = Plot.this.size();

            @Override
            public boolean hasNext() {
                return this.m_Index < this.m_Size;
            }

            @Override
            public PlotDataPoint next() {
                return Plot.this.getDataPoint(this.m_Index++);
            }
        };
    }

    public PlotDataPoint getDataPoint(int n) {
        return new PlotDataPoint(this.m_Data[this.m_X].get(n * this.m_Stride[this.m_X] + this.m_Offset[this.m_X]), this.m_Data[this.m_Y].get(n * this.m_Stride[this.m_Y] + this.m_Offset[this.m_Y]));
    }
}

