/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import eazycnc.planner.Plot;
import eazycnc.planner.PlotDataObject;
import eazycnc.planner.PlotDataPoint;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Plotter
extends JPanel {
    private CursorType m_CursorType;
    private int m_CursorIndex;
    private MouseTracker m_MouseTracker;
    private TrackAxis m_TrackAxis;
    private static Robot g_Robot;
    private Point2D m_Cursor;
    private double m_Zoom = 0.9;
    private double m_ScaleX = 1.0;
    private double m_ScaleY = 1.0;
    private double m_CenterX = 0.0;
    private double m_CenterY = 0.0;
    private Point m_LastClick;
    private Point m_DragStart;
    private double m_DragStartCenterX;
    private double m_DragStartCenterY;
    private Color[] m_AutoColors = new Color[]{Color.BLACK, Color.RED, Color.GREEN.darker().darker(), Color.BLUE, Color.BLACK, Color.CYAN, Color.ORANGE, Color.PINK, Color.MAGENTA};
    private int m_NextAutoColor;
    private AffineTransform m_InverseViewTransform = null;
    private AffineTransform m_ViewTransform;
    private AffineTransform m_OrigTransform;
    private PlotDataObject m_PlotData;
    private List<Plot> m_Plots = new LinkedList<Plot>();
    private Hashtable<Plot, Boolean> m_IsVisible = new Hashtable();
    private Hashtable<Plot, Double> m_Scale = new Hashtable();
    NiceScale m_NiceScaleX;
    NiceScale m_NiceScaleY;

    public void setVisible(Plot plot, boolean bl) {
        this.m_IsVisible.put(plot, bl);
        this.repaint();
    }

    public void setScale(Plot plot, double d) {
        this.m_Scale.put(plot, d);
        this.repaint();
    }

    public void setMouseTracker(TrackAxis trackAxis, MouseTracker mouseTracker) {
        this.m_MouseTracker = mouseTracker;
        this.m_TrackAxis = trackAxis;
    }

    public Plotter(PlotDataObject plotDataObject) {
        this();
        this.m_PlotData = plotDataObject;
    }

    public Plotter() {
        this.setBackground(Color.WHITE);
        if (g_Robot == null) {
            try {
                g_Robot = new Robot();
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
        }
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            private boolean centerMouse() {
                Plotter plotter = Plotter.this;
                Point point = plotter.getLocationOnScreen();
                g_Robot.mouseMove(point.x + plotter.getWidth() / 2, point.y + plotter.getHeight() / 2);
                return true;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (Plotter.this.m_InverseViewTransform == null) {
                    return;
                }
                int n = mouseWheelEvent.getWheelRotation();
                if (n == 0) {
                    return;
                }
                double d = Math.sqrt(Math.sqrt(Math.sqrt(2.0)));
                if (n < 0) {
                    d = 1.0 / d;
                }
                boolean bl = mouseWheelEvent.isShiftDown();
                boolean bl2 = mouseWheelEvent.isAltDown();
                boolean bl3 = mouseWheelEvent.isControlDown();
                boolean bl4 = mouseWheelEvent.isAltGraphDown();
                if (!(bl || bl2 || bl3 || bl4)) {
                    Plotter.this.m_ScaleX *= d;
                    Plotter.this.m_ScaleY *= d;
                } else if (bl && bl2 && !bl3 && !bl4) {
                    Plotter.this.m_ScaleY *= d;
                } else if (!bl && bl2 && !bl3 && !bl4) {
                    Plotter.this.m_ScaleX *= d;
                }
                Point2D point2D = Plotter.this.m_InverseViewTransform.transform(mouseWheelEvent.getPoint(), null);
                Plotter.this.m_CenterX = point2D.getX();
                Plotter.this.m_CenterY = point2D.getY();
                this.centerMouse();
                Plotter.this.repaint();
            }
        };
        this.addMouseWheelListener(mouseWheelListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Plotter.this.trackMouse(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Plotter.this.m_DragStart = mouseEvent.getPoint();
                Plotter.this.m_DragStartCenterX = Plotter.this.m_CenterX;
                Plotter.this.m_DragStartCenterY = Plotter.this.m_CenterY;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (Plotter.this.m_InverseViewTransform == null) {
                    return;
                }
                Point2D point2D = Plotter.this.m_InverseViewTransform.transform(new Point2D.Double(Plotter.this.m_DragStart.x, Plotter.this.m_DragStart.y), null);
                Point2D point2D2 = Plotter.this.m_InverseViewTransform.transform(new Point2D.Double(mouseEvent.getPoint().x, mouseEvent.getPoint().y), null);
                double d = -(point2D2.getX() - point2D.getX());
                double d2 = -(point2D2.getY() - point2D.getY());
                Plotter.this.m_CenterX = Plotter.this.m_DragStartCenterX + d;
                Plotter.this.m_CenterY = Plotter.this.m_DragStartCenterY + d2;
                Plotter.this.repaint();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public void autoscale() {
        this.autoscale(true, true, false);
    }

    public void autoscale(boolean bl, boolean bl2, boolean bl3) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.7976931348623157E308;
        for (Plot plot : this.m_Plots) {
            if (!this.m_IsVisible.get(plot).booleanValue()) continue;
            double d5 = this.m_Scale.get(plot);
            for (PlotDataPoint plotDataPoint : plot) {
                double d6 = plotDataPoint.getX();
                double d7 = plotDataPoint.getY() * d5;
                if (!Double.isNaN(d6) && !Double.isInfinite(d6)) {
                    d = Math.min(d, d6);
                    d3 = Math.max(d3, d6);
                }
                if (Double.isNaN(d7) || Double.isInfinite(d7)) continue;
                d2 = Math.min(d2, d7);
                d4 = Math.max(d4, d7);
            }
        }
        if (bl) {
            this.m_CenterX = (d3 + d) / 2.0;
            this.m_ScaleX = 1.0 / (d3 - d) * 0.9;
        }
        if (bl2) {
            this.m_CenterY = (d4 + d2) / 2.0;
            this.m_ScaleY = 1.0 / (d4 - d2) * 0.9;
        }
        if (bl3) {
            if (this.m_ScaleX < this.m_ScaleY) {
                this.m_ScaleY = this.m_ScaleX;
            }
            if (this.m_ScaleY < this.m_ScaleX) {
                this.m_ScaleX = this.m_ScaleY;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Plotter.this.repaint();
            }
        });
    }

    private void trackMouse(MouseEvent mouseEvent) {
        if (this.m_InverseViewTransform == null) {
            return;
        }
        double d = Double.MAX_VALUE;
        Plot plot = null;
        int n = -1;
        Point2D point2D = this.m_InverseViewTransform.transform(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()), null);
        for (Plot plot2 : this.m_Plots) {
            if (!this.m_IsVisible.get(plot2).booleanValue()) continue;
            int n2 = 0;
            for (PlotDataPoint plotDataPoint : plot2) {
                double d2;
                double d3 = point2D.getX() - plotDataPoint.getX();
                double d4 = point2D.getY() - plotDataPoint.getY();
                if (this.m_TrackAxis == TrackAxis.X) {
                    d4 = 0.0;
                }
                if (this.m_TrackAxis == TrackAxis.Y) {
                    d3 = 0.0;
                }
                if ((d2 = Math.sqrt(d3 * d3 + d4 * d4)) < d) {
                    d = d2;
                    n = n2;
                    plot = plot2;
                }
                ++n2;
            }
        }
        if (plot != null && this.m_MouseTracker != null) {
            this.m_MouseTracker.trackMouse(plot, n, plot.getDataPoint(n));
        }
    }

    public void trackMouse(Point2D point2D) {
    }

    public void setCursor(int n, CursorType cursorType, Point2D point2D) {
        this.m_CursorIndex = n;
        this.m_Cursor = point2D;
        this.m_CursorType = cursorType;
        this.repaint();
    }

    public void setCursor(int n, CursorType cursorType, double d) {
        this.m_Cursor = new Point2D.Double(d, d);
        this.m_CursorType = cursorType;
        this.m_CursorIndex = n;
        this.repaint();
    }

    public void set(Plot plot) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.m_OrigTransform = graphics2D.getTransform();
        this.m_NextAutoColor = 0;
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        graphics2D.setClip(insets.left + 1, insets.top + 1, dimension.width - insets.right - insets.left - 2, dimension.height - insets.top - insets.bottom - 2);
        int n = this.getWidth();
        int n2 = this.getHeight();
        double d = Math.min(dimension.getWidth(), dimension.getHeight());
        double d2 = this.m_ScaleX;
        double d3 = this.m_ScaleY;
        double d4 = this.m_CenterX;
        double d5 = this.m_CenterY;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-d4, -d5));
        affineTransform.preConcatenate(AffineTransform.getScaleInstance(d2 * d, -d3 * d));
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(n / 2, n2 / 2));
        try {
            this.m_InverseViewTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.m_ViewTransform = affineTransform;
        if (this.m_InverseViewTransform != null) {
            Point2D point2D = this.m_InverseViewTransform.transform(new Point2D.Double(0.0, n2), null);
            Point2D point2D2 = this.m_InverseViewTransform.transform(new Point2D.Double(n, 0.0), null);
            this.paint(graphics2D, point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        }
    }

    public void paint(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        this.m_NiceScaleX = new NiceScale(d, d3);
        this.m_NiceScaleY = new NiceScale(d2, d4);
        for (int i = 0; i < 2; ++i) {
            NiceScale niceScale = i == 0 ? this.m_NiceScaleX : this.m_NiceScaleY;
            int n = 5;
            int n2 = (int)Math.ceil((niceScale.m_NiceMax - niceScale.m_NiceMin) / (niceScale.m_TickSpacing / (double)n));
            FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
            int n3 = fontMetrics.getDescent();
            for (int j = -1; j < n2 + 1; ++j) {
                double d5 = niceScale.m_NiceMin + (double)j * niceScale.m_TickSpacing / (double)n;
                boolean bl = j % n == 0;
                graphics2D.setColor(Color.GRAY);
                graphics2D.setStroke(new BasicStroke(bl ? 1.0f : 0.5f));
                Line2D.Double double_ = i == 0 ? new Line2D.Double(d5, d2, d5, d4) : new Line2D.Double(d, d5, d3, d5);
                double_ = new Line2D.Double(this.m_ViewTransform.transform(((Line2D)double_).getP1(), null), this.m_ViewTransform.transform(((Line2D)double_).getP2(), null));
                graphics2D.draw(double_);
                if (!bl) continue;
                Point2D point2D = i == 0 ? this.m_ViewTransform.transform(new Point2D.Double(d5, 0.0), null) : this.m_ViewTransform.transform(new Point2D.Double(0.0, d5), null);
                graphics2D.setColor(Color.BLACK);
                String string = String.format(niceScale.m_Format, d5);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                rectangle2D = i == 0 ? new Rectangle2D.Double(rectangle2D.getX() + point2D.getX() - rectangle2D.getWidth() / 2.0, 2.0, rectangle2D.getWidth(), rectangle2D.getHeight()) : new Rectangle2D.Double(2.0, point2D.getY() - rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
                graphics2D.setColor(this.getBackground());
                graphics2D.fill(rectangle2D);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(string, (float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight() - (double)n3));
            }
        }
        this.m_NextAutoColor = 0;
        double d6 = 80.0;
        graphics2D.setBackground(new Color(230, 230, 230));
        graphics2D.setColor(Color.black);
        graphics2D.setTransform(this.m_OrigTransform);
        for (Plot plot : this.m_Plots) {
            if (!this.m_IsVisible.get(plot).booleanValue()) continue;
            this.paintPlot(graphics2D, this.m_Scale.get(plot), plot, d, d2, d3, d4);
        }
        this.paintCursor(graphics2D, d6);
        double d7 = 40.0;
        for (Plot plot : this.m_Plots) {
            if (!this.m_IsVisible.get(plot).booleanValue()) continue;
            d7 = this.paintPlotLegend(d6, d7, graphics2D, plot);
        }
        Plotter.drawText(graphics2D, "Drag with mouse to move, scroll wheel to zoom, ALT (+SHIFT) to zoom X (Y)!", false, d6, this.getHeight() - 40, (double)this.getWidth() - 2.0 * d6);
    }

    private static double distance(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    private static double distance(Point2D point2D, Point2D point2D2) {
        return Plotter.distance(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    private void paintCursor(Graphics2D graphics2D, double d) {
        if (this.m_Cursor != null) {
            Object object;
            if (this.m_PlotData != null && this.m_CursorIndex >= 0 && (object = this.m_PlotData.get(this.m_CursorIndex)) != null) {
                Plotter.drawText(graphics2D, object.toString(), false, d, 20.0, 500.0).getHeight();
            }
            graphics2D.setStroke(new BasicStroke());
            object = graphics2D.getColor();
            graphics2D.setColor(Color.BLUE);
            Point2D point2D = this.m_ViewTransform.transform(this.m_Cursor, null);
            switch (this.m_CursorType) {
                case CIRCLE: {
                    Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - 3.0, point2D.getY() - 3.0, 6.0, 6.0);
                    graphics2D.draw(double_);
                    break;
                }
                case HORIZONTAL: {
                    Line2D.Double double_ = new Line2D.Double(0.0, point2D.getY(), this.getWidth(), point2D.getY());
                    graphics2D.draw(double_);
                    break;
                }
                case VERTICAL: {
                    Line2D.Double double_ = new Line2D.Double(point2D.getX(), 0.0, point2D.getX(), this.getHeight());
                    graphics2D.draw(double_);
                }
            }
            graphics2D.setColor((Color)object);
        }
    }

    private void paintPlot(Graphics2D graphics2D, double d, Plot plot, double d2, double d3, double d4, double d5) {
        double d6;
        Color color = graphics2D.getColor();
        Color color2 = graphics2D.getBackground();
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(plot.getColor());
        double d7 = Double.MAX_VALUE;
        Point2D point2D = null;
        Point2D point2D2 = null;
        for (Object object : plot) {
            d6 = ((PlotDataPoint)object).getX();
            double d8 = ((PlotDataPoint)object).getY();
            if (Double.isNaN(d6) || Double.isNaN(d8)) {
                point2D = null;
                point2D2 = null;
                continue;
            }
            Point2D point2D3 = this.m_ViewTransform.transform(new Point2D.Double(((PlotDataPoint)object).getX(), ((PlotDataPoint)object).getY() * d), null);
            if (point2D != null) {
                if (d2 <= d6 && d6 <= d4 && d3 <= d8 && d8 <= d5) {
                    d7 = Math.min(d7, Plotter.distance(point2D, point2D3));
                }
                if (point2D2 != null && Plotter.distance(point2D2, point2D3) > 2.0 && point2D != null) {
                    Line2D.Double double_ = new Line2D.Double(point2D2, point2D3);
                    graphics2D.draw(double_);
                    point2D2 = point2D3;
                }
            } else {
                point2D2 = point2D3;
            }
            point2D = point2D3;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
        if (d7 > 10.0) {
            Object object;
            object = plot.getMarker();
            d6 = 0.0;
            if (object != null) {
                d6 = object.getBounds2D().getHeight();
            }
            for (PlotDataPoint plotDataPoint : plot) {
                Object object2;
                double d9 = plotDataPoint.getX();
                double d10 = plotDataPoint.getY();
                if (Double.isNaN(d9) || Double.isNaN(d10)) continue;
                Point2D point2D4 = this.m_ViewTransform.transform(new Point2D.Double(plotDataPoint.getX(), plotDataPoint.getY()), null);
                if (!(d2 <= d9) || !(d9 <= d4) || !(d3 <= d10) || !(d10 <= d5)) continue;
                if (object != null) {
                    object2 = graphics2D.getTransform();
                    ((AffineTransform)object2).preConcatenate(this.m_ViewTransform);
                    ((AffineTransform)object2).concatenate(AffineTransform.getTranslateInstance(point2D4.getX(), point2D4.getY()));
                    graphics2D.setTransform((AffineTransform)object2);
                    graphics2D.fill((Shape)object);
                    graphics2D.setTransform(this.m_OrigTransform);
                }
                if ((object2 = plotDataPoint.getId()) == null) continue;
                double d11 = fontMetrics.stringWidth((String)object2);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object2, graphics2D);
                rectangle2D = new Rectangle2D.Double(rectangle2D.getX() + point2D4.getX() - rectangle2D.getWidth() / 2.0, point2D4.getY() + 2.0 + d6, rectangle2D.getWidth(), rectangle2D.getHeight());
                graphics2D.setColor(this.getBackground());
                graphics2D.fill(rectangle2D);
                graphics2D.setColor(plot.getColor());
                graphics2D.drawString((String)object2, (float)rectangle2D.getX(), (float)(rectangle2D.getY() + rectangle2D.getHeight() - (double)fontMetrics.getDescent()));
            }
        }
        graphics2D.setColor(color);
        graphics2D.setBackground(color2);
    }

    private double paintPlotLegend(double d, double d2, Graphics2D graphics2D, Plot plot) {
        Object object;
        Color color = graphics2D.getColor();
        Color color2 = graphics2D.getBackground();
        String string = plot.getName();
        String string2 = "%1.1f";
        String string3 = "";
        double d3 = 250.0;
        if (this.m_CursorType != null && this.m_CursorIndex < plot.size()) {
            object = plot.getDataPoint(this.m_CursorIndex);
            switch (this.m_CursorType) {
                case CIRCLE: {
                    d3 = 300.0;
                    string3 = String.format(this.m_NiceScaleX.m_Format2 + " , " + this.m_NiceScaleY.m_Format2, ((PlotDataPoint)object).getX(), ((PlotDataPoint)object).getY());
                    break;
                }
                case VERTICAL: {
                    string3 = String.format(this.m_NiceScaleY.m_Format2, ((PlotDataPoint)object).getY());
                    break;
                }
                case HORIZONTAL: {
                    string3 = String.format(this.m_NiceScaleX.m_Format2, ((PlotDataPoint)object).getX());
                }
            }
        }
        graphics2D.setBackground(color2);
        graphics2D.setColor(color);
        object = Plotter.drawText(graphics2D, string, false, d, d2, 150.0);
        Plotter.drawText(graphics2D, string3, true, d + 150.0, d2, 150.0);
        Plotter.drawText(graphics2D, plot.getUnit(), false, d + 150.0 + 150.0, d2, 80.0);
        double d4 = ((RectangularShape)object).getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)object).getX() - d4 - 2.0, ((RectangularShape)object).getY(), d4, d4);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(((RectangularShape)object).getX() - d4 - 1.0, ((RectangularShape)object).getY() + 1.0, d4 - 2.0, d4 - 2.0);
        graphics2D.setColor(color2);
        graphics2D.fill(double_);
        graphics2D.setColor(plot.getColor());
        graphics2D.fill(double_2);
        graphics2D.setColor(color);
        graphics2D.setBackground(color2);
        return d2 + ((RectangularShape)object).getHeight();
    }

    static Rectangle2D drawText(Graphics2D graphics2D, String string, boolean bl, double d, double d2, double d3) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        double d4 = Math.max(d3, rectangle2D.getWidth() + 2.0);
        double d5 = rectangle2D.getHeight() + 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d4, d5);
        Color color = graphics2D.getBackground();
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        graphics2D.setColor(color2);
        graphics2D.drawString(string, (float)(bl ? ((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() - rectangle2D.getWidth() - 1.0 : ((RectangularShape)double_).getX() + 1.0), (float)(((RectangularShape)double_).getY() + ((RectangularShape)double_).getHeight() - (double)fontMetrics.getDescent()));
        return double_;
    }

    public void addPlot(Plot plot) {
        this.m_Plots.add(plot);
        this.setVisible(plot, true);
        this.setScale(plot, 1.0);
    }

    public static Plotter newWithWindow() {
        return Plotter.newWithWindow("");
    }

    public static Plotter newWithWindow(String string) {
        JFrame jFrame = new JFrame(string);
        Plotter plotter = new Plotter();
        jFrame.add(plotter);
        jFrame.setLocation(100, 100);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
        return plotter;
    }

    public static void mainx(String ... stringArray) {
        JFrame jFrame = new JFrame("");
        jFrame.add(new Plotter());
        jFrame.setLocation(100, 100);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }

    public static interface MouseTracker {
        public void trackMouse(Plot var1, int var2, PlotDataPoint var3);
    }

    public static enum TrackAxis {
        X,
        Y,
        XY;

    }

    public static enum CursorType {
        CIRCLE,
        VERTICAL,
        HORIZONTAL;

    }

    static class NiceScale {
        public double m_MinPoint;
        public double m_MaxPoint;
        public double m_MaxTicks = 10.0;
        public double m_TickSpacing;
        public double m_Range;
        public double m_NiceMin;
        public double m_NiceMax;
        public String m_Format;
        public String m_Format2;

        public NiceScale(double d, double d2) {
            this.m_MinPoint = d;
            this.m_MaxPoint = d2;
            this.calculate();
        }

        private void calculate() {
            this.m_Range = this.niceNum(this.m_MaxPoint - this.m_MinPoint, false, false);
            this.m_TickSpacing = this.niceNum(this.m_Range / (this.m_MaxTicks - 1.0), true, true);
            this.m_NiceMin = Math.floor(this.m_MinPoint / this.m_TickSpacing) * this.m_TickSpacing;
            this.m_NiceMax = Math.ceil(this.m_MaxPoint / this.m_TickSpacing) * this.m_TickSpacing;
        }

        private double niceNum(double d, boolean bl, boolean bl2) {
            if (Double.isNaN(d)) {
                if (bl2) {
                    this.m_Format = "%f";
                    this.m_Format2 = "%f";
                }
                return d;
            }
            double d2 = Math.floor(Math.log10(d));
            double d3 = d / Math.pow(10.0, d2);
            double d4 = bl ? (d3 < 1.5 ? 1.0 : (d3 < 3.0 ? 2.0 : (d3 < 7.0 ? 5.0 : 10.0))) : (d3 <= 1.0 ? 1.0 : (d3 <= 2.0 ? 2.0 : (d3 <= 5.0 ? 5.0 : 10.0)));
            if (bl2) {
                this.m_Format = "%+";
                this.m_Format2 = "%+";
                if (d2 >= 0.0) {
                    this.m_Format = this.m_Format + ".0";
                    this.m_Format2 = this.m_Format2 + ".2";
                } else {
                    int n = (int)(-d2);
                    if (d4 >= 10.0) {
                        --n;
                    }
                    if (n > 4) {
                        n = 4;
                    }
                    this.m_Format = this.m_Format + "." + Integer.toString(n);
                    this.m_Format2 = this.m_Format2 + "." + Integer.toString(n + 2);
                }
                this.m_Format = this.m_Format + "f";
                this.m_Format2 = this.m_Format2 + "f";
            }
            return d4 * Math.pow(10.0, d2);
        }

        public void setMinMaxPoints(double d, double d2) {
            this.m_MinPoint = d;
            this.m_MaxPoint = d2;
            this.calculate();
        }

        public void setMaxTicks(double d) {
            this.m_MaxTicks = d;
            this.calculate();
        }
    }
}

