/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import eazycnc.planner.Plot;
import eazycnc.planner.PlotDataDouble;
import eazycnc.planner.PlotDataObject;
import eazycnc.planner.PlotDataPoint;
import eazycnc.planner.Plotter;
import eazycnc.planner.Quintics;
import eazycnc.planner.ToolPathPlannerInterface;
import eazycnc.planner.VecMath;
import eazycnc.planner.Waypoint;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import motorcontrol.TrajectoryPathPlotter;

public class QuinticPlanner {
    private Waypoint m_DumpWaypoints;
    private String m_DebugLogsDir;
    public volatile ToolPathPlannerInterface.CaptureMove m_CaptureMove;
    private volatile Waypoint m_CaptureWaypoint;
    private volatile String m_CaptureInfo;
    private double m_TT;
    private double m_T0;
    private double[] m_GeneratedPlanData;
    private int m_PlanDataElementSize = 6;
    private int m_GeneratedPlanSize;
    private static final boolean TRACE_PLAN = false;
    private static final boolean TRACE_CALC_BLEND = false;
    private static boolean TRACE_CALC_QUINTICS = false;
    private static boolean SHOW_PRE_PLAN_WAYPOINTS = false;
    private static boolean SHOW_PRE_PROCESSED_WAYPOINTS = false;
    private static boolean SHOW_POST_PLAN_WAYPOINTS = false;
    private double amax;
    private double jmax;
    private double dtmax;
    private double dtmax_2;
    private double amax_dtmax;
    private double amax_dtmax_2;
    private double dsmin;
    private double amax_dtmax_d2;
    private double[] qt;
    private double[] qp;
    private double[] qv;
    private double[] qa;
    private double qv1;
    private double qv2;
    private double qpeak;
    double[] m1;
    double[] m2;
    double[] b1;
    double[] b2;
    double[] vd;
    double[] m_LastGeneratedPoint;
    private static final int HEAP_SIZE = 32;
    private double[][] m_Heap;
    private int m_HeapPtr;
    private static QuinticCases _QuinticCase;
    private static AccelerationCases _AccelererationCase;
    int cnt;

    public void setCapture(ToolPathPlannerInterface.CaptureMove captureMove) {
        this.m_CaptureMove = captureMove;
        this.m_CaptureWaypoint = null;
        this.m_CaptureInfo = "???";
    }

    public QuinticPlanner(String string) {
        this.setMaxAccelerationAndJerk(4.0, 10.0);
        this.amax = 4.0;
        this.jmax = 500.0;
        this.dtmax = Math.PI * this.amax / (2.0 * this.jmax);
        this.dtmax_2 = this.dtmax * this.dtmax;
        this.amax_dtmax = this.amax * this.dtmax;
        this.amax_dtmax_2 = this.amax * this.dtmax_2;
        this.dsmin = this.amax_dtmax;
        this.amax_dtmax_d2 = this.amax_dtmax / 2.0;
        this.qt = new double[12];
        this.qp = new double[12];
        this.qv = new double[12];
        this.qa = new double[12];
        this.m1 = new double[6];
        this.m2 = new double[6];
        this.b1 = new double[6];
        this.b2 = new double[6];
        this.vd = new double[6];
        this.m_LastGeneratedPoint = new double[6];
        this.m_Heap = new double[32][];
        for (int i = 0; i < 32; ++i) {
            this.m_Heap[i] = new double[6];
        }
        this.cnt = 0;
        this.m_DebugLogsDir = string;
    }

    public QuinticPlanner() {
        this.setMaxAccelerationAndJerk(4.0, 10.0);
        this.amax = 4.0;
        this.jmax = 500.0;
        this.dtmax = Math.PI * this.amax / (2.0 * this.jmax);
        this.dtmax_2 = this.dtmax * this.dtmax;
        this.amax_dtmax = this.amax * this.dtmax;
        this.amax_dtmax_2 = this.amax * this.dtmax_2;
        this.dsmin = this.amax_dtmax;
        this.amax_dtmax_d2 = this.amax_dtmax / 2.0;
        this.qt = new double[12];
        this.qp = new double[12];
        this.qv = new double[12];
        this.qa = new double[12];
        this.m1 = new double[6];
        this.m2 = new double[6];
        this.b1 = new double[6];
        this.b2 = new double[6];
        this.vd = new double[6];
        this.m_LastGeneratedPoint = new double[6];
        this.m_Heap = new double[32][];
        for (int i = 0; i < 32; ++i) {
            this.m_Heap[i] = new double[6];
        }
        this.cnt = 0;
    }

    private void checkOutputForNaN(double[] dArray) {
        for (double d : dArray) {
            if (!Double.isNaN(d) && !Double.isNaN(d)) continue;
            throw new PlannerException("QuinticPlanner produced a bad value: " + d);
        }
    }

    private void captureMove(boolean bl, Waypoint waypoint, double[] dArray) {
        double d = 0.0;
        if (this.m_CaptureWaypoint != waypoint) {
            this.m_CaptureWaypoint = waypoint;
            if (waypoint != null) {
                d = waypoint.m_DemandSpeed;
                String string = null;
                String string2 = "null";
                if (waypoint.m_Machcode != null) {
                    string2 = Integer.toString(waypoint.m_Machcode.m_MachCodeID);
                    if (waypoint.m_Machcode.m_FilePos != null) {
                        string = Integer.toString(waypoint.m_Machcode.m_FilePos.getLineNo());
                    }
                }
                this.m_CaptureInfo = String.format("line %s machcode %s waypoint %d blend %s tightness %1.3f speed %1.3f", string, string2, waypoint.m_Id, bl ? "Y" : "N", waypoint.m_Tightness, waypoint.m_Speed);
            } else {
                this.m_CaptureInfo = "NULL";
            }
        }
        this.m_CaptureMove.captureMove(this.m_CaptureInfo, bl, d, dArray);
    }

    private void output(boolean bl, Waypoint waypoint, double[] dArray) throws PlannerException {
        ++waypoint.m_GeneratedDataSize;
        if (this.m_CaptureMove != null) {
            this.captureMove(bl, waypoint, dArray);
        }
        this.checkOutputForNaN(dArray);
        int n = this.m_PlanDataElementSize;
        int n2 = n + this.m_GeneratedPlanSize;
        if (this.m_GeneratedPlanData == null || n2 > this.m_GeneratedPlanData.length) {
            double[] dArray2 = new double[n2 + n * 1024];
            if (this.m_GeneratedPlanData != null) {
                System.arraycopy(this.m_GeneratedPlanData, 0, dArray2, 0, this.m_GeneratedPlanData.length);
            }
            this.m_GeneratedPlanData = dArray2;
        }
        System.arraycopy(dArray, 0, this.m_GeneratedPlanData, this.m_GeneratedPlanSize, n);
        this.m_GeneratedPlanSize += n;
    }

    public void reset() {
        this.m_TT = 0.0;
        this.m_T0 = 0.0;
        this.m_GeneratedPlanData = null;
        this.m_GeneratedPlanSize = 0;
    }

    public int getPlanDataSize() {
        return this.m_GeneratedPlanSize;
    }

    public double[] getPlanData() {
        return this.m_GeneratedPlanData;
    }

    public int getPlanDataElementSize() {
        return this.m_PlanDataElementSize;
    }

    private static double dot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2] + dArray[3] * dArray2[3] + dArray[4] * dArray2[4] + dArray[5] * dArray2[5];
    }

    private double[] sub3(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[0] - dArray2[0];
        dArray3[1] = dArray[1] - dArray2[1];
        dArray3[2] = dArray[2] - dArray2[2];
        return dArray3;
    }

    private double[] sub2(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[0] - dArray2[0];
        dArray3[1] = dArray[1] - dArray2[1];
        return dArray3;
    }

    private double[] flip3cw(double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray2[0] = dArray[1];
        dArray2[1] = -dArray[0];
        return dArray2;
    }

    private double[] flip3ccw(double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray2[0] = -dArray[1];
        dArray2[1] = dArray[0];
        return dArray2;
    }

    private double length3(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    private double length2(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
    }

    private double distsqr2(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = dArray[1] - dArray2[1];
        return d * d + d2 * d2;
    }

    private double[] add3(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        dArray3[2] = dArray[2] + dArray2[2];
        return dArray3;
    }

    private double[] add2(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        return dArray3;
    }

    private double[] scale3(double d, double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray2[0] = d * dArray[0];
        dArray2[1] = d * dArray[1];
        dArray2[2] = d * dArray[2];
        return dArray2;
    }

    private double[] scale2(double d, double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray2[0] = d * dArray[0];
        dArray2[1] = d * dArray[1];
        return dArray2;
    }

    private double[] cross3(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
        return dArray3;
    }

    private void set3(double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = dArray2[2];
    }

    private double[] sub(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[0] - dArray2[0];
        dArray3[1] = dArray[1] - dArray2[1];
        dArray3[2] = dArray[2] - dArray2[2];
        dArray3[3] = dArray[3] - dArray2[3];
        dArray3[4] = dArray[4] - dArray2[4];
        dArray3[5] = dArray[5] - dArray2[5];
        return dArray3;
    }

    private double[] add(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        dArray3[2] = dArray[2] + dArray2[2];
        dArray3[3] = dArray[3] + dArray2[3];
        dArray3[4] = dArray[4] + dArray2[4];
        dArray3[5] = dArray[5] + dArray2[5];
        return dArray3;
    }

    private double[] mul(double d, double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray2[0] = d * dArray[0];
        dArray2[1] = d * dArray[1];
        dArray2[2] = d * dArray[2];
        dArray2[3] = d * dArray[3];
        dArray2[4] = d * dArray[4];
        dArray2[5] = d * dArray[5];
        return dArray2;
    }

    private double[] mulAdd(double d, double[] dArray, double[] dArray2) {
        double[] dArray3 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        dArray3[0] = d * dArray[0] + dArray2[0];
        dArray3[1] = d * dArray[1] + dArray2[1];
        dArray3[2] = d * dArray[2] + dArray2[2];
        dArray3[3] = d * dArray[3] + dArray2[3];
        dArray3[4] = d * dArray[4] + dArray2[4];
        dArray3[5] = d * dArray[5] + dArray2[5];
        return dArray3;
    }

    private double[] scaleDiffAdd(double d, double[] dArray, double[] dArray2) {
        double[] dArray3 = this.sub(dArray2, dArray);
        double d2 = QuinticPlanner.len(dArray3);
        if (d2 > 0.0) {
            d2 = d / d2;
        }
        dArray3[0] = dArray3[0] * d2 + dArray[0];
        dArray3[1] = dArray3[1] * d2 + dArray[1];
        dArray3[2] = dArray3[2] * d2 + dArray[2];
        dArray3[3] = dArray3[3] * d2 + dArray[3];
        dArray3[4] = dArray3[4] * d2 + dArray[4];
        dArray3[5] = dArray3[5] * d2 + dArray[5];
        return dArray3;
    }

    private double[] set(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray2[i])) {
                throw new PlannerException("s[" + i + "]\u00a0is NaN");
            }
            if (Double.isInfinite(dArray2[i])) {
                throw new PlannerException("s[" + i + "]\u00a0is Infinite");
            }
            dArray[i] = dArray2[i];
        }
        return dArray;
    }

    private double[] vec() {
        return new double[6];
    }

    private double[] vec(double ... dArray) {
        return new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]};
    }

    private static double len(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2] + dArray[3] * dArray[3] + dArray[4] * dArray[4] + dArray[5] * dArray[5]);
    }

    private double[] norm(double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2] + dArray[3] * dArray[3] + dArray[4] * dArray[4] + dArray[5] * dArray[5]);
        if (d > 0.0) {
            d = 1.0 / d;
        }
        dArray2[0] = d * dArray[0];
        dArray2[1] = d * dArray[1];
        dArray2[2] = d * dArray[2];
        dArray2[3] = d * dArray[3];
        dArray2[4] = d * dArray[4];
        dArray2[5] = d * dArray[5];
        return dArray2;
    }

    private double[] norm3(double[] dArray) {
        double[] dArray2 = this.m_Heap[this.m_HeapPtr++ & 0x1F];
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d > 0.0) {
            d = 1.0 / d;
        }
        dArray2[0] = d * dArray[0];
        dArray2[1] = d * dArray[1];
        dArray2[2] = d * dArray[2];
        return dArray2;
    }

    static double distance(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = dArray[1] - dArray2[1];
        double d3 = dArray[2] - dArray2[2];
        double d4 = dArray[3] - dArray2[3];
        double d5 = dArray[4] - dArray2[4];
        double d6 = dArray[5] - dArray2[5];
        return Math.sqrt(d * d + d2 * d2 + d3 * d3 + d4 * d4 + d5 * d5 + d6 * d6);
    }

    public static String toString(double[] dArray) {
        return String.format("[%f %f %f %f %f %f]", dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    private static void printf(String string, Object ... objectArray) {
        System.out.printf(string, objectArray);
    }

    public void setMaxAccelerationAndJerk(double d, double d2) {
        this.amax = d;
        this.jmax = d2;
        this.dtmax = Math.PI * this.amax / (2.0 * this.jmax);
        this.dtmax_2 = this.dtmax * this.dtmax;
        this.amax_dtmax = this.amax * this.dtmax;
        this.amax_dtmax_2 = this.amax * this.dtmax_2;
        this.dsmin = this.amax_dtmax;
        this.amax_dtmax_d2 = this.amax_dtmax / 2.0;
    }

    public int calculateAccelerationPulse(double d, double d2, double d3, int n) {
        int n2;
        double d4;
        double d5;
        double d6;
        boolean bl;
        _AccelererationCase = null;
        int n3 = n;
        boolean bl2 = bl = d3 < d2;
        if (bl) {
            d6 = d2;
            d2 = d3;
            d3 = d6;
        }
        if ((d5 = d3 - this.amax_dtmax_d2) < (d6 = d2 + this.amax_dtmax_d2)) {
            d5 = d6;
        }
        double d7 = this.amax_dtmax_2 * 0.14867881635766222 + d2 * this.dtmax;
        double d8 = (d5 * d5 - d6 * d6) / (2.0 * this.amax);
        double d9 = this.amax_dtmax_2 * 0.3513211836423378 + d5 * this.dtmax;
        double d10 = d3 - d2;
        if (d7 + d8 + d9 > d) {
            _AccelererationCase = AccelerationCases.C2;
            d5 = -this.amax_dtmax + Math.sqrt(this.amax_dtmax * this.amax_dtmax - 2.0 * this.amax * (this.amax_dtmax_2 / 2.0 + d2 * this.dtmax - d6 * d6 / (2.0 * this.amax) - d));
            d3 = d5 + this.amax_dtmax_d2;
            d8 = (d5 * d5 - d6 * d6) / (2.0 * this.amax);
            d9 = this.amax_dtmax_2 * 0.3513211836423378 + d5 * this.dtmax;
        } else {
            _AccelererationCase = AccelerationCases.C1;
        }
        double d11 = this.amax_dtmax_2 + 2.0 * d2 * this.dtmax;
        if (d < d11 || d10 < this.dsmin) {
            double d12;
            double d13;
            double d14;
            double d15;
            d4 = 0.0;
            if (d < d11) {
                _AccelererationCase = AccelerationCases.C3;
                d15 = -(Math.PI * d) / (4.0 * this.jmax);
                d14 = -(Math.PI * d2) / (3.0 * this.jmax);
                d13 = Math.pow(Math.abs(d15) + Math.sqrt(d15 * d15 - d14 * d14 * d14), 0.3333333333333333);
                d4 = d13 + d14 / d13;
                d12 = 2.0 * this.jmax * d4 / Math.PI;
                if (d10 < this.dsmin && d10 < d12 * d4) {
                    _AccelererationCase = AccelerationCases.C4;
                    d4 = Math.sqrt(Math.PI * d10 / (2.0 * this.jmax));
                    d12 = 2.0 * this.jmax * d4 / Math.PI;
                }
            } else {
                _AccelererationCase = AccelerationCases.C5;
                d4 = Math.sqrt(Math.PI * d10 / (2.0 * this.jmax));
                d12 = 2.0 * this.jmax * d4 / Math.PI;
            }
            d15 = d4 * d4;
            d14 = d12 * d15 * 0.14867881635766222 + d2 * d4;
            d13 = d2 + d12 * d4 / 2.0;
            double d16 = d12 * d15 * 0.3513211836423378 + d13 * d4;
            this.qt[n] = 0.0;
            this.qp[n] = 0.0;
            this.qv[n] = d2;
            this.qa[n] = 0.0;
            this.qt[++n] = d4;
            this.qp[n] = 0.0 + d14;
            this.qv[n] = d2 + d12 * d4 / 2.0;
            this.qa[n] = d12;
            this.qt[++n] = 2.0 * d4;
            this.qp[n] = 0.0 + d14 + d16;
            this.qv[n] = d2 + d12 * d4;
            this.qa[n] = 0.0;
            double d17 = d - this.qp[++n - 1];
            double d18 = d17 / this.qv[n - 1];
            if (d18 > 0.0) {
                this.qt[n] = this.qt[n - 1] + d18;
                this.qp[n] = 0.0 + d;
                this.qv[n] = d2 + d12 * d4;
                this.qa[n] = 0.0;
                ++n;
            }
        } else {
            this.qt[n] = 0.0;
            this.qp[n] = 0.0;
            this.qv[n] = d2;
            this.qa[n] = 0.0;
            this.qt[++n] = this.dtmax;
            this.qp[n] = 0.0 + d7;
            this.qv[n] = d6;
            this.qa[n] = this.amax;
            this.qt[++n] = this.qt[n - 1] + (d5 - d6) / this.amax;
            this.qp[n] = 0.0 + d7 + d8;
            this.qv[n] = d5;
            this.qa[n] = this.amax;
            this.qt[++n] = this.qt[n - 1] + this.dtmax;
            this.qp[n] = 0.0 + d7 + d8 + d9;
            this.qv[n] = d3;
            this.qa[n] = 0.0;
            if ((d4 = d - this.qp[++n - 1]) > 0.0) {
                this.qt[n] = this.qt[n - 1] + d4 / d3;
                this.qp[n] = 0.0 + d;
                this.qv[n] = d3;
                this.qa[n] = 0.0;
                ++n;
            }
        }
        int n4 = n - n3;
        if (bl) {
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            double[] dArray3 = new double[n4];
            double[] dArray4 = new double[n4];
            System.arraycopy(this.qt, n3, dArray, 0, n4);
            System.arraycopy(this.qp, n3, dArray2, 0, n4);
            System.arraycopy(this.qv, n3, dArray3, 0, n4);
            System.arraycopy(this.qa, n3, dArray4, 0, n4);
            for (n2 = 0; n2 < n4; ++n2) {
                this.qt[n3 + n2] = dArray[n4 - 1] - dArray[n4 - 1 - n2];
                this.qp[n3 + n2] = dArray2[n4 - 1] - dArray2[n4 - 1 - n2];
                this.qv[n3 + n2] = dArray3[n4 - 1 - n2];
                this.qa[n3 + n2] = -dArray4[n4 - 1 - n2];
            }
        }
        if (n3 > 0) {
            double d19 = this.qt[n3 - 1];
            double d20 = this.qp[n3 - 1];
            for (n2 = n3 + 1; n2 < n; ++n2) {
                this.qt[n2 - 1] = this.qt[n2] + d19;
                this.qp[n2 - 1] = this.qp[n2] + d20;
                this.qv[n2 - 1] = this.qv[n2];
                this.qa[n2 - 1] = this.qa[n2];
                this.qt[n2] = Double.NaN;
                this.qp[n2] = Double.NaN;
                this.qv[n2] = Double.NaN;
                this.qa[n2] = Double.NaN;
            }
            --n;
        }
        return n;
    }

    private int calculateSpeedCruise(double d, double d2, int n) throws PlannerException {
        if (d2 == 0.0) {
            throw new PlannerException("s == 0.0");
        }
        if (n == 0) {
            this.qt[n] = 0.0;
            this.qp[n] = 0.0;
            this.qv[n] = d2;
            this.qa[n] = 0.0;
            ++n;
        }
        this.qt[n] = this.qt[n - 1] + d / d2;
        this.qp[n] = this.qp[n - 1] + d;
        this.qv[n] = d2;
        this.qa[n] = 0.0;
        return n + 1;
    }

    private double Dv(double d, double d2) throws PlannerException {
        if (d > d2) {
            throw new PlannerException("s1 >= s2");
        }
        if (d == d2) {
            return 0.0;
        }
        double d3 = d2 - this.amax_dtmax_d2;
        double d4 = d + this.amax_dtmax_d2;
        if (d3 < d4) {
            d3 = d4;
        }
        double d5 = this.amax_dtmax_2 * 0.14867881635766222 + d * this.dtmax;
        double d6 = (d3 * d3 - d4 * d4) / (2.0 * this.amax);
        double d7 = this.amax_dtmax_2 * 0.3513211836423378 + d3 * this.dtmax;
        return d5 + d6 + d7;
    }

    private void preprocess(Waypoint waypoint) {
        double[] dArray;
        Object object;
        Waypoint waypoint2;
        Waypoint waypoint3;
        Waypoint waypoint4 = waypoint;
        while (waypoint4 != null) {
            waypoint3 = waypoint4;
            waypoint2 = waypoint3.m_Next;
            while (waypoint2 != null && waypoint2.m_Next != null && QuinticPlanner.distance(waypoint3.m_Position, waypoint2.m_Position) <= waypoint2.m_Tightness) {
                waypoint3.m_Next = waypoint2.m_Next;
                waypoint2.m_Next.m_Prev = waypoint3;
                waypoint2 = waypoint2.m_Next;
            }
            if (waypoint3.m_Speed == 0.0) {
                waypoint3.m_Tightness = 0.0;
            }
            waypoint4 = waypoint4.m_Next;
        }
        waypoint4 = waypoint;
        while (waypoint4 != null) {
            double d;
            waypoint3 = waypoint4;
            waypoint2 = waypoint3.m_Next;
            if (waypoint2 != null && (d = QuinticPlanner.distance(object = waypoint3.m_Position, dArray = waypoint2.m_Position)) <= waypoint3.m_Tightness + waypoint2.m_Tightness) {
                double d2 = waypoint3.m_Tightness;
                double d3 = waypoint2.m_Tightness;
                waypoint3.m_Tightness = Math.min(waypoint3.m_Tightness, d * d2 * 0.99 / (d2 + d3));
                waypoint2.m_Tightness = Math.min(waypoint2.m_Tightness, d * d3 * 0.99 / (d2 + d3));
            }
            waypoint4 = waypoint4.m_Next;
        }
        waypoint4 = waypoint;
        while (waypoint4 != null) {
            double[] dArray2;
            waypoint3 = waypoint4.m_Prev;
            waypoint2 = waypoint4;
            object = waypoint4.m_Next;
            dArray = waypoint2.m_Position;
            this.set(waypoint2.pa, waypoint2.m_Position);
            this.set(waypoint2.pb, waypoint2.m_Position);
            waypoint2.m_Tightness = Math.min(waypoint2.m_Tightness, this.calculateTightness(waypoint4));
            if (waypoint3 != null) {
                dArray2 = waypoint3.m_Position;
                this.setPA(waypoint2, dArray, dArray2);
            }
            if (object != null) {
                dArray2 = object.m_Position;
                this.setPB(waypoint2, dArray, dArray2);
            }
            waypoint4 = waypoint4.m_Next;
        }
        waypoint4 = waypoint;
        while (waypoint4 != null) {
            waypoint3 = waypoint4;
            waypoint2 = waypoint4.m_Next;
            waypoint4 = waypoint4.m_Next;
        }
    }

    private double calculateBlendSpeed(Waypoint waypoint) {
        double d;
        double d2 = waypoint.m_Tightness;
        double d3 = d2 * d2;
        double d4 = d3 * d2;
        Waypoint waypoint2 = waypoint.m_Prev;
        Waypoint waypoint3 = waypoint.m_Next;
        if (waypoint.m_Speed == 0.0 || d2 == 0.0 || d3 == 0.0 || d4 == 0.0 || waypoint2 == null || waypoint3 == null) {
            return 0.0;
        }
        double[] dArray = waypoint.pa;
        double[] dArray2 = waypoint.pb;
        double[] dArray3 = waypoint2.m_Position;
        double[] dArray4 = waypoint.m_Position;
        double[] dArray5 = waypoint3.m_Position;
        double d5 = 0.8;
        double d6 = -QuinticPlanner.dot(this.sub(dArray4, dArray), this.sub(dArray2, dArray4)) / d3;
        double d7 = Math.sqrt(d5 * this.amax * d2 / Math.sqrt((1.0 + (d6 = Math.min(Math.max(d6, -1.0), 1.0))) / 2.0));
        double d8 = Math.min(d7, d = Math.pow(this.jmax * 4.0 * d4 / (15.0 * QuinticPlanner.len(this.add(this.sub(this.sub(dArray2, dArray4), dArray4), dArray))), 0.3333333333333333));
        if (Double.isNaN(d8)) {
            System.out.println("-----------------------------");
            System.out.println("sblendmax is NaN! ");
            System.out.println("p1 " + QuinticPlanner.toString(dArray4));
            System.out.println("p1a " + QuinticPlanner.toString(dArray));
            System.out.println("p1b " + QuinticPlanner.toString(dArray2));
            System.out.println("tightness " + d2);
            System.out.println("tightness_2 " + d3);
            System.out.println("cos_theta " + d6);
            System.out.println("sblendmaxj " + d);
            System.out.println("sblendmaxa " + d7);
            System.out.println("-----------------------------");
            return 0.0;
        }
        return d8;
    }

    private void clearQts() {
        for (int i = 0; i < this.qt.length; ++i) {
            this.qt[i] = Double.NaN;
            this.qp[i] = Double.NaN;
            this.qv[i] = Double.NaN;
            this.qa[i] = Double.NaN;
        }
    }

    void calculateQuintics(Waypoint waypoint) throws PlannerException {
        Object object;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl;
        double d6;
        if (TRACE_CALC_QUINTICS) {
            QuinticPlanner.printf("calculateQuintics(%d,%d) %f -> [%f]-> %f", waypoint.m_Id, waypoint.m_Next.m_Id, waypoint.m_Speed, waypoint.m_MaxSpeed, waypoint.m_Next.m_Speed);
        }
        this.clearQts();
        ++waypoint.m_PlanCntr;
        _QuinticCase = null;
        double d7 = waypoint.m_Speed;
        double d8 = waypoint.m_Next.m_Speed;
        double d9 = QuinticPlanner.distance(waypoint.pb, waypoint.m_Next.pa);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        if (waypoint.m_Next != null && waypoint.m_Next.m_Center != null) {
            double[] dArray = new double[]{0.0, 0.0};
            double[] dArray2 = new double[]{0.0, 0.0};
            VecMath.getXY(waypoint.m_Next.m_ArcPlane, dArray2, waypoint.m_Next.m_Center);
            double[] dArray3 = new double[]{0.0, 0.0};
            d11 = VecMath.getXY_Z(waypoint.m_Next.m_ArcPlane, dArray3, waypoint.pb);
            VecMath.sub(dArray3, dArray3, dArray2);
            d15 = Math.atan2(dArray3[1], dArray3[0]);
            double[] dArray4 = new double[]{0.0, 0.0};
            d12 = VecMath.getXY_Z(waypoint.m_Next.m_ArcPlane, dArray4, waypoint.m_Next.pa);
            VecMath.sub(dArray4, dArray4, dArray2);
            d6 = Math.atan2(dArray4[1], dArray4[0]);
            d10 = VecMath.length(dArray3);
            d13 = d6 - d15;
            if (waypoint.m_Next.m_Clockwise) {
                if (d13 > 0.0) {
                    d13 -= Math.PI * 2;
                } else if (d13 == 0.0) {
                    d13 = Math.PI * -2;
                }
            } else if (d13 < 0.0) {
                d13 += Math.PI * 2;
            } else if (d13 == 0.0) {
                d13 = Math.PI * 2;
            }
            d9 = Math.abs(d13) * d10;
        }
        double d16 = Math.max(waypoint.m_MaxSpeed, waypoint.m_Next.m_MaxSpeed);
        int n = 0;
        if (d8 > d16) {
            throw new PlannerException("s2 > smax");
        }
        boolean bl2 = bl = d8 < d7;
        if (bl) {
            d6 = d7;
            d7 = d8;
            d8 = d6;
        }
        if (d9 <= 0.0) {
            this.qv1 = d7;
            this.qv2 = d7;
            this.qpeak = d7;
            waypoint.m_Quintics = null;
            if (TRACE_CALC_QUINTICS) {
                QuinticPlanner.printf(" %f -> [%f] -> %f\n", this.qv1, this.qpeak, this.qv2);
            }
            return;
        }
        d6 = this.Dv(d7, d8);
        if (d16 == d8 || d16 > d8 && d6 > d9) {
            if (d16 > d8) {
                d16 = d8;
            }
            if (d7 == d8) {
                _QuinticCase = QuinticCases.A1;
                n = this.calculateSpeedCruise(d9, d8, n);
            } else {
                _QuinticCase = QuinticCases.A2;
                n = this.calculateAccelerationPulse(d9, d7, d8, n);
            }
        } else if (d16 - d8 > this.dsmin) {
            double d17;
            d5 = this.amax_dtmax + d8;
            d4 = this.Dv(d7, d5);
            d2 = d4 + (d3 = this.Dv(d8, d5));
            if (d9 > d2) {
                double d18;
                d17 = this.Dv(d7, d16);
                double d19 = d9 - (d17 + (d18 = this.Dv(d8, d16)));
                if (d19 > 0.0) {
                    _QuinticCase = QuinticCases.Biia1;
                    d = d16;
                    n = this.calculateAccelerationPulse(d17, d7, d, n);
                    n = this.calculateSpeedCruise(d19, d, n);
                    n = this.calculateAccelerationPulse(d18, d, d8, n);
                } else {
                    _QuinticCase = QuinticCases.Biia2;
                    double d20 = d7 + this.amax_dtmax_d2;
                    double d21 = d8 + this.amax_dtmax_d2;
                    d = -this.amax_dtmax_d2 + Math.sqrt(this.amax * d9 + (d20 * d20 + d21 * d21) / 2.0 - this.amax_dtmax * (d7 + d8));
                    n = this.calculateAccelerationPulse(d17 + d19 / 2.0, d7, d, n);
                    n = this.calculateAccelerationPulse(d18 + d19 / 2.0, d, d8, n);
                }
            } else {
                _QuinticCase = QuinticCases.Biib;
                d17 = (d9 - d6) / 2.0;
                int n2 = this.calculateAccelerationPulse(d17, d8, d16, n);
                d = this.qv[n2 - 1];
                n = this.calculateAccelerationPulse(d9 - d17, d7, d, n);
                n = this.calculateAccelerationPulse(d17, d, d8, n);
            }
        } else {
            d = d16;
            d5 = this.Dv(d7, d);
            d4 = this.Dv(d8, d);
            d3 = d9 - (d4 + d5);
            if (d3 > 0.0) {
                _QuinticCase = QuinticCases.Biii1;
                n = this.calculateAccelerationPulse(d5, d7, d, n);
                n = this.calculateSpeedCruise(d3, d, n);
                n = this.calculateAccelerationPulse(d4, d, d8, n);
            } else {
                _QuinticCase = QuinticCases.Biii2;
                d2 = (d9 - d6) / 2.0;
                int n3 = this.calculateAccelerationPulse(d2, d8, d16, n);
                d = this.qv[n3 - 1];
                n = this.calculateAccelerationPulse(d9 - d2, d7, d, n);
                n = this.calculateAccelerationPulse(d2, d, d8, n);
            }
        }
        d = this.qv[n - 1];
        int n4 = n;
        if (bl) {
            object = new double[n4];
            double[] dArray = new double[n4];
            double[] dArray5 = new double[n4];
            double[] dArray6 = new double[n4];
            System.arraycopy(this.qt, 0, object, 0, n4);
            System.arraycopy(this.qp, 0, dArray, 0, n4);
            System.arraycopy(this.qv, 0, dArray5, 0, n4);
            System.arraycopy(this.qa, 0, dArray6, 0, n4);
            for (int i = 0; i < n4; ++i) {
                this.qt[i] = object[n4 - 1] - object[n4 - 1 - i];
                this.qp[i] = dArray[n4 - 1] - dArray[n4 - 1 - i];
                this.qv[i] = dArray5[n4 - 1 - i];
                this.qa[i] = -dArray6[n4 - 1 - i];
            }
        }
        object = null;
        Quintics quintics = null;
        for (int i = 0; i < n4 - 1; ++i) {
            try {
                quintics = new Quintics(quintics, i, this.qt, this.qp, this.qv, this.qa);
                if (object != null) continue;
                object = quintics;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        waypoint.m_Quintics = object;
        this.qv1 = this.qv[0];
        this.qv2 = this.qv[n4 - 1];
        if (TRACE_CALC_QUINTICS) {
            QuinticPlanner.printf(" =*=> %f -> [%f] -> %f\n", this.qv1, d, this.qv2);
        }
    }

    private void plotQuintics(Quintics quintics) {
        LinkedList<Double> linkedList = new LinkedList<Double>();
        LinkedList<Double> linkedList2 = new LinkedList<Double>();
        LinkedList<Double> linkedList3 = new LinkedList<Double>();
        LinkedList<Double> linkedList4 = new LinkedList<Double>();
        LinkedList<Double> linkedList5 = new LinkedList<Double>();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.01;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = 0;
        Quintics quintics2 = quintics;
        try {
            while (quintics2 != null) {
                double d7;
                while (!Double.isNaN(d7 = quintics2.interpolate(d))) {
                    double d8 = (d7 - d4) / d3;
                    double d9 = (d8 - d5) / d3;
                    double d10 = (d9 - d6) / d3;
                    d4 = d7;
                    d5 = d8;
                    d6 = d9;
                    if (n > 2) {
                        linkedList.add(d2 + d);
                        linkedList2.add(d7 / 10.0);
                        linkedList3.add(d9);
                        linkedList4.add(d8);
                        linkedList5.add(d10);
                    }
                    ++n;
                    d += d3;
                }
                d -= quintics2.dt;
                d2 += quintics2.dt;
                quintics2 = quintics2.next;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("FIXME747");
    }

    private void vetWaypoint(Waypoint waypoint) throws PlannerException {
    }

    void backPlanTrajectory(Waypoint waypoint) throws PlannerException {
        Waypoint waypoint2;
        while ((waypoint2 = waypoint.m_Prev) != null) {
            double d = waypoint2.m_Speed;
            double d2 = waypoint.m_Speed;
            this.calculateQuintics(waypoint2);
            if (d <= d2 || this.qv1 >= d) break;
            this.setSpeed(waypoint2, this.qv1);
            waypoint = waypoint2;
        }
    }

    void showWaypoints(String string, Waypoint waypoint) {
        System.out.println(string);
        while (waypoint != null) {
            System.out.println(waypoint);
            waypoint = waypoint.m_Next;
        }
    }

    void planTrajectory(Waypoint waypoint) throws PlannerException {
        Waypoint waypoint2;
        this.m_DumpWaypoints = waypoint;
        if (SHOW_PRE_PLAN_WAYPOINTS) {
            this.showWaypoints("PRE-PLAN WAYPOINTS", waypoint);
        }
        this.preprocess(waypoint);
        if (SHOW_PRE_PROCESSED_WAYPOINTS) {
            this.showWaypoints("PREPROCESSED WAYPOINTS", waypoint);
        }
        Waypoint waypoint3 = waypoint;
        this.vetWaypoint(waypoint3);
        this.setSpeed(waypoint3, Math.min(waypoint3.m_Speed, this.calculateBlendSpeed(waypoint3)));
        while ((waypoint2 = waypoint3.m_Next) != null) {
            this.vetWaypoint(waypoint2);
            this.setSpeed(waypoint2, Math.min(waypoint2.m_Speed, this.calculateBlendSpeed(waypoint2)));
            double d = waypoint3.m_Speed;
            double d2 = waypoint2.m_Speed;
            this.calculateQuintics(waypoint3);
            if (d < d2) {
                if (this.qv2 < d2) {
                    this.setSpeed(waypoint2, this.qv2);
                }
            } else if (this.qv1 < d) {
                this.setSpeed(waypoint3, this.qv1);
                this.backPlanTrajectory(waypoint3);
            }
            waypoint3 = waypoint2;
        }
        if (SHOW_POST_PLAN_WAYPOINTS) {
            this.showWaypoints("POST-PLAN WAYPOINTS", waypoint);
        }
    }

    void blendFunction(double[] dArray, double d, double d2, double d3) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d4 = (d - d3 + d2) / (2.0 * d2);
        double d5 = d4 * d4 * d4;
        double d6 = d5 * d4;
        double d7 = d6 * d4;
        double d8 = d7 * d4;
        double d9 = 6.0 * d7 - 15.0 * d6 + 10.0 * d5;
        double d10 = d8 - 3.0 * d7 + 3.0 * d6 - d5;
        double d11 = 7.5;
        this.set(dArray2, this.mulAdd(d4, this.m1, this.b1));
        this.set(dArray3, this.mulAdd(d4, this.m2, this.b2));
        this.set(dArray, this.add(this.add(dArray2, this.mul(d9, this.sub(dArray3, dArray2))), this.mul(-d11 * d10, this.vd)));
    }

    private void setPX(boolean bl, int n, double d, double[] dArray, double[] dArray2, double[] dArray3) {
        if (d == 0.0) {
            return;
        }
        double[] dArray4 = new double[]{0.0, 0.0};
        double[] dArray5 = new double[]{0.0, 0.0};
        VecMath.getXY(n, dArray4, dArray);
        VecMath.getXY(n, dArray5, dArray2);
        double[] dArray6 = this.sub2(dArray5, dArray4);
        double d2 = this.length2(dArray6);
        double d3 = d;
        double[] dArray7 = new double[]{0.0, 0.0};
        double[] dArray8 = new double[]{0.0, 0.0};
        double[] dArray9 = new double[]{0.0, 0.0};
        double[][] dArrayArray = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        int n2 = VecMath.circleCircleIntersection(dArrayArray, dArray4, d2, dArray5, d3, dArray7, dArray8, dArray9);
        double[] dArray10 = this.scale2(d3 / d2, dArray6);
        double[] dArray11 = bl ? this.flip3ccw(dArray10) : this.flip3cw(dArray10);
        double[] dArray12 = this.add2(dArray5, dArray11);
        int n3 = -1;
        double d4 = Double.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            double d5 = this.distsqr2(dArrayArray[i], dArray12);
            if (!(d5 < d4)) continue;
            d4 = d5;
            n3 = i;
        }
        if (n3 >= 0) {
            VecMath.setXY(n, dArray3, dArrayArray[n3]);
        }
    }

    void setPA(Waypoint waypoint, double[] dArray, double[] dArray2) {
        this.set(waypoint.pa, this.scaleDiffAdd(waypoint.m_Tightness, dArray, dArray2));
        double[] dArray3 = waypoint.m_Center;
        if (dArray3 != null) {
            this.setPX(waypoint.m_Clockwise, waypoint.m_ArcPlane, waypoint.m_Tightness, dArray3, waypoint.m_Position, waypoint.pa);
        }
    }

    void setPB(Waypoint waypoint, double[] dArray, double[] dArray2) {
        this.set(waypoint.pb, this.scaleDiffAdd(waypoint.m_Tightness, dArray, dArray2));
        if (waypoint.m_Next == null) {
            return;
        }
        if (waypoint.m_Next != null && waypoint.m_Next.m_Center != null) {
            this.setPX(!waypoint.m_Next.m_Clockwise, waypoint.m_Next.m_ArcPlane, waypoint.m_Tightness, waypoint.m_Next.m_Center, waypoint.m_Position, waypoint.pb);
        }
    }

    void setPA_OBSOLETE(Waypoint waypoint, double[] dArray, double[] dArray2) {
        this.set(waypoint.pa, this.scaleDiffAdd(waypoint.m_Tightness, dArray, dArray2));
        double[] dArray3 = waypoint.m_Center;
        if (dArray3 != null) {
            double[][] dArrayArray = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
            double[] dArray4 = this.sub3(dArray, dArray3);
            double d = this.length3(dArray4);
            double[] dArray5 = waypoint.m_Position;
            double d2 = waypoint.m_Tightness;
            double[] dArray6 = new double[]{0.0, 0.0};
            double[] dArray7 = new double[]{0.0, 0.0};
            double[] dArray8 = new double[]{0.0, 0.0};
            int n = VecMath.circleCircleIntersection(dArrayArray, dArray3, d, dArray5, d2, dArray6, dArray7, dArray8);
            double[] dArray9 = this.scale3(d2 / d, dArray4);
            double[] dArray10 = waypoint.m_Clockwise ? this.flip3ccw(dArray9) : this.flip3cw(dArray9);
            double[] dArray11 = this.add3(dArray, dArray10);
            double d3 = Double.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                double d4 = VecMath.distance(dArrayArray[i], dArray11);
                if (!(d4 < d3)) continue;
                d3 = d4;
                n2 = i;
            }
            if (n2 >= 0) {
                waypoint.pa[0] = dArrayArray[n2][0];
                waypoint.pa[1] = dArrayArray[n2][1];
            }
        }
    }

    void setPB_OBSOLETE(Waypoint waypoint, double[] dArray, double[] dArray2) {
        this.set(waypoint.pb, this.scaleDiffAdd(waypoint.m_Tightness, dArray, dArray2));
        if (waypoint.m_Next == null) {
            return;
        }
        if (waypoint.m_Next != null && waypoint.m_Next.m_Center != null) {
            double[] dArray3 = waypoint.m_Next.m_Center;
            double[][] dArrayArray = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
            double[] dArray4 = this.sub3(dArray, dArray3);
            double d = this.length3(dArray4);
            double[] dArray5 = waypoint.m_Position;
            double d2 = waypoint.m_Tightness;
            double[] dArray6 = new double[]{0.0, 0.0};
            double[] dArray7 = new double[]{0.0, 0.0};
            double[] dArray8 = new double[]{0.0, 0.0};
            int n = VecMath.circleCircleIntersection(dArrayArray, dArray3, d, dArray5, d2, dArray6, dArray7, dArray8);
            double[] dArray9 = this.scale3(d2 / d, dArray4);
            double[] dArray10 = waypoint.m_Next.m_Clockwise ? this.flip3cw(dArray9) : this.flip3ccw(dArray9);
            double[] dArray11 = this.add3(dArray, dArray10);
            double d3 = Double.MAX_VALUE;
            int n2 = -1;
            for (int i = 0; i < n; ++i) {
                double d4 = VecMath.distance(dArrayArray[i], dArray11);
                if (!(d4 < d3)) continue;
                d3 = d4;
                n2 = i;
            }
            if (n2 >= 0) {
                waypoint.pb[0] = dArrayArray[n2][0];
                waypoint.pb[1] = dArrayArray[n2][1];
            }
        }
    }

    private void setSpeed(Waypoint waypoint, double d) throws PlannerException {
        waypoint.m_Speed = d;
        waypoint.m_Tightness = Math.min(waypoint.m_Tightness, this.calculateTightness(waypoint));
        double[] dArray = waypoint.m_Position;
        Waypoint waypoint2 = waypoint.m_Prev;
        Waypoint waypoint3 = waypoint.m_Next;
        double[] dArray2 = waypoint2 != null ? waypoint2.m_Position : dArray;
        this.setPA(waypoint, dArray, dArray2);
        double[] dArray3 = waypoint3 != null ? waypoint3.m_Position : dArray;
        this.setPB(waypoint, dArray, dArray3);
        if (waypoint2 != null) {
            this.calculateQuintics(waypoint2);
        }
        if (waypoint3 != null) {
            this.calculateQuintics(waypoint);
        }
    }

    public void generateBlendPoints(double d, Waypoint waypoint) throws PlannerException {
        Waypoint waypoint2 = waypoint;
        if (waypoint2.m_Speed == 0.0) {
            return;
        }
        double[] dArray = waypoint.pa;
        double[] dArray2 = waypoint.pb;
        this.set(this.b1, dArray);
        this.set(this.b2, this.sub(waypoint2.m_Position, this.sub(dArray2, waypoint2.m_Position)));
        this.set(this.m1, this.sub(waypoint2.m_Position, dArray));
        this.set(this.m2, this.sub(dArray2, waypoint2.m_Position));
        this.set(this.m1, this.mul(2.0, this.m1));
        this.set(this.m2, this.mul(2.0, this.m2));
        this.set(this.vd, this.sub(this.m2, this.m1));
        double d2 = waypoint2.m_Speed;
        double d3 = waypoint2.m_Tightness;
        double d4 = d3 / d2;
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double d5 = d4;
        double[] dArray5 = null;
        while (this.m_T0 < this.m_TT + 2.0 * d4) {
            double d6 = this.m_T0 - this.m_TT;
            double d7 = (d6 - d5 + d4) / (2.0 * d4);
            this.set(dArray3, this.mulAdd(d7, this.m1, this.b1));
            this.set(dArray4, this.mulAdd(d7, this.m2, this.b2));
            double d8 = d7 * d7 * d7;
            double d9 = d8 * d7;
            double d10 = d9 * d7;
            double d11 = d10 * d7;
            double d12 = 6.0 * d10 - 15.0 * d9 + 10.0 * d8;
            double d13 = d11 - 3.0 * d10 + 3.0 * d9 - d8;
            double d14 = 7.5;
            dArray5 = new double[6];
            this.set(dArray5, this.add(this.add(dArray3, this.mul(d12, this.sub(dArray4, dArray3))), this.mul(-d14 * d13, this.vd)));
            this.output(true, d6 > d4 ? waypoint : waypoint.m_Prev, dArray5);
            this.m_T0 += d;
        }
        this.m_TT += 2.0 * d4;
    }

    private void generateQuinticPoints(double d, Waypoint waypoint) throws PlannerException {
        Object object;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = new double[]{0.0, 0.0};
        if (waypoint.m_Next != null && waypoint.m_Next.m_Center != null) {
            VecMath.getXY(waypoint.m_Next.m_ArcPlane, dArray, waypoint.m_Next.m_Center);
            object = new double[]{0.0, 0.0};
            d3 = VecMath.getXY_Z(waypoint.m_Next.m_ArcPlane, (double[])object, waypoint.pb);
            VecMath.sub((double[])object, (double[])object, dArray);
            d7 = Math.atan2((double)object[1], (double)object[0]);
            double[] dArray2 = new double[]{0.0, 0.0};
            d4 = VecMath.getXY_Z(waypoint.m_Next.m_ArcPlane, dArray2, waypoint.m_Next.pa);
            VecMath.sub(dArray2, dArray2, dArray);
            double d8 = Math.atan2(dArray2[1], dArray2[0]);
            d2 = VecMath.length((double[])object);
            d5 = d8 - d7;
            if (waypoint.m_Next.m_Clockwise) {
                if (d5 > 0.0) {
                    d5 -= Math.PI * 2;
                } else if (d5 == 0.0) {
                    d5 = Math.PI * -2;
                }
            } else if (d5 < 0.0) {
                d5 += Math.PI * 2;
            } else if (d5 == 0.0) {
                d5 = Math.PI * 2;
            }
            d6 = Math.abs(d5) * d2;
        }
        object = waypoint.m_Quintics;
        double d9 = this.m_T0;
        while (object != null) {
            if (((Quintics)object).dt > 0.0) {
                double d10;
                while (!Double.isNaN(d10 = ((Quintics)object).interpolate(this.m_T0 - this.m_TT))) {
                    double d11;
                    if (waypoint.m_Next == null || waypoint.m_Next.m_Center == null) {
                        d11 = QuinticPlanner.distance(waypoint.m_Next.pa, waypoint.pb);
                        this.set(this.m_LastGeneratedPoint, this.add(waypoint.pb, this.mul(d10 / d11, this.sub(waypoint.m_Next.pa, waypoint.pb))));
                        this.output(false, waypoint, this.m_LastGeneratedPoint);
                    } else {
                        d11 = d10 / d6;
                        double d12 = d11 * d5 + d7;
                        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        this.set(dArray3, waypoint.m_Position);
                        double[] dArray4 = new double[]{dArray[0] + Math.cos(d12) * d2, dArray[1] + Math.sin(d12) * d2};
                        VecMath.setXY_Z(waypoint.m_Next.m_ArcPlane, dArray3, dArray4, d3 + (d4 - d3) * d11);
                        this.set(this.m_LastGeneratedPoint, dArray3);
                        this.output(false, waypoint, this.m_LastGeneratedPoint);
                    }
                    this.m_T0 += d;
                }
                this.m_TT += ((Quintics)object).dt;
            }
            object = ((Quintics)object).next;
        }
    }

    private void plot(String string, List<double[]> list) {
        System.out.println("FIXME707");
    }

    private void calculateDerivatives(double d, ArrayList<Double> arrayList, ArrayList<Double> arrayList2, ArrayList<Double> arrayList3, ArrayList<Double> arrayList4, ArrayList<Double> arrayList5, ArrayList<Double> arrayList6, double d2, double d3, double d4) {
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double d5 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_GeneratedPlanSize) {
            System.arraycopy(this.m_GeneratedPlanData, n2, dArray, 0, this.m_PlanDataElementSize);
            arrayList.add(dArray[3]);
            arrayList2.add(dArray[4]);
            n2 += this.m_PlanDataElementSize;
            arrayList3.add(d5);
            d5 += d;
            this.set(dArray3, this.sub(dArray, dArray2));
            this.set(dArray2, dArray);
            this.set(dArray3, this.mul(1.0 / d, dArray3));
            this.set(dArray5, this.sub(dArray3, dArray4));
            this.set(dArray4, dArray3);
            this.set(dArray5, this.mul(1.0 / d, dArray5));
            this.set(dArray7, this.sub(dArray5, dArray6));
            this.set(dArray6, dArray5);
            this.set(dArray7, this.mul(1.0 / d, dArray7));
            double d6 = QuinticPlanner.len(dArray3) / d2;
            double d7 = QuinticPlanner.len(dArray5) / d3;
            double d8 = QuinticPlanner.len(dArray7) / d4;
            if (n++ <= 2) {
                d6 = Double.NaN;
                d7 = Double.NaN;
                d8 = Double.NaN;
            }
            arrayList4.add(d6);
            arrayList5.add(d7);
            arrayList6.add(d8);
        }
    }

    private void plot(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        double[] dArray = new double[arrayList.size()];
        double[] dArray2 = new double[arrayList2.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = arrayList.get(i);
            dArray2[i] = arrayList2.get(i);
        }
    }

    private static double fmax(List<Double> list) {
        double d = -1.7976931348623157E308;
        for (double d2 : list) {
            if (Double.isNaN(d2)) continue;
            d = Math.max(d, d2);
        }
        return d;
    }

    private static void test_calculateQuintics(String string, EnumSet<QuinticCases>[] enumSetArray, QuinticCases quinticCases, double d, double d2, double d3, double d4, double d5, double d6) throws PlannerException {
        for (int i = 0; i < 2; ++i) {
            double d7;
            QuinticPlanner quinticPlanner = new QuinticPlanner();
            quinticPlanner.setMaxAccelerationAndJerk(d, d2);
            double d8 = 0.0;
            double d9 = 1.0 / Math.sqrt(3.0);
            double[] dArray = quinticPlanner.vec(10.0, 10.0, 10.0);
            double[] dArray2 = quinticPlanner.set(quinticPlanner.vec(), quinticPlanner.add(dArray, quinticPlanner.vec(d9 * d6, d9 * d6, d9 * d6)));
            Waypoint waypoint = new Waypoint(null, d3, d5, d8, dArray);
            Waypoint waypoint2 = new Waypoint(null, d4, 0.0, d8, dArray2);
            waypoint.addWaypoint(waypoint2);
            quinticPlanner.vetWaypoint(waypoint);
            quinticPlanner.vetWaypoint(waypoint2);
            quinticPlanner.calculateQuintics(waypoint);
            double d10 = quinticPlanner.qpeak;
            if (_QuinticCase == quinticCases) {
                enumSetArray[i].remove((Object)_QuinticCase);
            } else {
                QuinticPlanner.printf("TEST BUG expected case " + quinticCases + " actually executed " + _QuinticCase + "\n", new Object[0]);
            }
            double d11 = d6 / ((d3 + d4) / 2.0);
            double d12 = d11 / 1000.0;
            quinticPlanner.generateQuinticPoints(d12, waypoint);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            ArrayList<Double> arrayList6 = new ArrayList<Double>();
            quinticPlanner.calculateDerivatives(d12, arrayList, arrayList2, arrayList6, arrayList3, arrayList4, arrayList5, 1.0, 1.0, 1.0);
            double d13 = QuinticPlanner.fmax(arrayList3);
            double d14 = QuinticPlanner.fmax(arrayList4);
            double d15 = QuinticPlanner.fmax(arrayList5);
            double d16 = 0.0;
            double[] dArray3 = null;
            double[] dArray4 = null;
            int n = 0;
            while (n < quinticPlanner.m_GeneratedPlanSize) {
                double[] dArray5 = new double[quinticPlanner.m_PlanDataElementSize];
                System.arraycopy(quinticPlanner.m_GeneratedPlanData, n, dArray5, 0, quinticPlanner.m_PlanDataElementSize);
                n += quinticPlanner.m_PlanDataElementSize;
                if (dArray3 == null) {
                    dArray3 = dArray5;
                } else {
                    d16 += QuinticPlanner.distance(dArray4, dArray5);
                }
                dArray4 = dArray5;
            }
            double d17 = QuinticPlanner.distance(dArray3, dArray) / d6;
            double d18 = QuinticPlanner.distance(dArray4, dArray2) / d6;
            if (d13 > Math.max(d5, Math.max(d3, d4)) * 1.01) {
                QuinticPlanner.printf("FAIL max speed %f > max( s1=%f , s2=%f , smax=%f )\n", d13, d3, d4, d5);
            }
            if (d14 > d * 1.01) {
                QuinticPlanner.printf("FAIL max acceleration %f > amax = %f \n", d14, d);
            }
            if (d15 > d2 * 1.01) {
                QuinticPlanner.printf("FAIL max jerk %f > amax = %f \n", d15, d2);
            }
            if (Math.abs(d16 - d6) / d6 > 0.001) {
                QuinticPlanner.printf("FAIL totD=%f  <>  D=%f \n", d16, d6);
            }
            if (d17 > (d7 = 0.01) * d6) {
                QuinticPlanner.printf("FAIL de0=%f > %f \n", d17, d7);
            }
            if (d18 > d7 * d6) {
                QuinticPlanner.printf("FAIL de1=%f > %f \n", d18, d7);
            }
            System.out.println("FIXME123");
            double d19 = d3;
            d3 = d4;
            d4 = d19;
        }
    }

    private void test_calculateAccelerationPulse(String string, EnumSet<AccelerationCases>[] enumSetArray, AccelerationCases accelerationCases, double d, double d2, double d3, double d4) {
        for (int i = 0; i < 2; ++i) {
            double d5;
            int n;
            int n2 = this.calculateAccelerationPulse(d, d2, d3, 0);
            if (_AccelererationCase == accelerationCases) {
                enumSetArray[i].remove((Object)_AccelererationCase);
            } else {
                QuinticPlanner.printf("TEST BUG expected case " + accelerationCases + " actually executed " + _AccelererationCase + "\n", new Object[0]);
            }
            if (n2 < 2) {
                QuinticPlanner.printf("Fail n=%d < 2\n", n2);
            }
            int n3 = -1;
            double d6 = 0.0;
            double d7 = this.qv[0];
            for (n = 0; n < n2; ++n) {
                if (Double.isNaN(this.qt[n]) || Double.isNaN(this.qp[n]) || Double.isNaN(this.qv[n]) || Double.isNaN(this.qa[n])) {
                    n3 = n;
                    QuinticPlanner.printf("Fail NaN in result\n", new Object[0]);
                    break;
                }
                if (Double.isInfinite(this.qt[n]) || Double.isInfinite(this.qp[n]) || Double.isInfinite(this.qv[n]) || Double.isInfinite(this.qa[n])) {
                    n3 = n;
                    QuinticPlanner.printf("Fail Infinite in result\n", new Object[0]);
                    break;
                }
                if (n + 1 >= n2) continue;
                double d8 = this.qt[n + 1] - this.qt[n];
                if (d8 <= 0.0) {
                    n3 = n;
                    QuinticPlanner.printf("Fail dt=%f <= 0.0 at %d\n", d8, n);
                }
                d5 = this.qa[n];
                double d9 = this.qa[n + 1];
                double d10 = d9 - d5;
                d6 += d7 * d8;
                if (d10 != 0.0) {
                    d6 += Math.signum(d9 + d5) * Math.abs(d10) * d8 * d8 * (0.25 - Math.signum(d10) * 1.0 / (Math.PI * Math.PI));
                    d7 += Math.signum(d9 + d5) * Math.abs(d10) * d8 * 0.5;
                    continue;
                }
                d6 += 0.5 * d5 * d8 * d8;
                d7 += d5 * d8;
            }
            if (n3 >= 0) {
                n = n3;
                QuinticPlanner.printf("qt[%d]=%f  qp[%d]=%f  qv[%d]=%f  qa[%d]=%f\n", n, this.qt[n], n, this.qp[n], n, this.qv[n], n, this.qa[n]);
            }
            if (Math.abs(d7 - this.qv[n = n2 - 1]) > 0.001 * d7) {
                QuinticPlanner.printf("Fail qv[%d]=%f <> s2f=%f\n", n, this.qv[n], d7);
            }
            if (Math.abs(d6 - d) > 0.001 * d) {
                QuinticPlanner.printf("Fail p=%f <> D=%f\n", d6, d);
            }
            Quintics quintics = null;
            Quintics quintics2 = null;
            for (int j = 0; j < n2 - 1; ++j) {
                quintics2 = new Quintics(quintics2, j, this.qt, this.qp, this.qv, this.qa);
                if (quintics != null) continue;
                quintics = quintics2;
            }
            d5 = d2;
            d2 = d3;
            d3 = d5;
        }
    }

    private void test_calculateAccelerationPulse() {
        EnumSet[] enumSetArray = new EnumSet[]{EnumSet.allOf(AccelerationCases.class), EnumSet.allOf(AccelerationCases.class)};
        double d = 4.0;
        double d2 = 5.0;
        this.setMaxAccelerationAndJerk(d, d2);
        this.setMaxAccelerationAndJerk(1000000.0, 100000.0);
        double d3 = 2.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 20.0;
        this.test_calculateAccelerationPulse("C1", enumSetArray, AccelerationCases.C1, d3, d4, d5, d6);
        d3 = 100.0;
        d4 = 10.0;
        d5 = 20.0;
        d6 = 20.0;
        this.test_calculateAccelerationPulse("C1", enumSetArray, AccelerationCases.C1, d3, d4, d5, d6);
        d3 = 32.0;
        d4 = 10.0;
        d5 = 20.0;
        d6 = 20.0;
        this.test_calculateAccelerationPulse("C2", enumSetArray, AccelerationCases.C2, d3, d4, d5, d6);
        d3 = 10.0;
        d4 = 10.0;
        d5 = 20.0;
        d6 = 20.0;
        this.test_calculateAccelerationPulse("C3", enumSetArray, AccelerationCases.C3, d3, d4, d5, d6);
        d3 = 12.0;
        d4 = 10.0;
        d5 = 11.0;
        d6 = 20.0;
        this.test_calculateAccelerationPulse("C4", enumSetArray, AccelerationCases.C4, d3, d4, d5, d6);
        d3 = 32.0;
        d4 = 10.0;
        d5 = 11.0;
        d6 = 20.0;
        this.test_calculateAccelerationPulse("C5", enumSetArray, AccelerationCases.C5, d3, d4, d5, d6);
        for (int i = 0; i < 2; ++i) {
            for (AccelerationCases accelerationCases : enumSetArray[i]) {
                QuinticPlanner.printf("Failed to test AccelerationCases case: " + accelerationCases + " " + (i == 0 ? "s1 <= s2 " : "s2 >= s1\n"), new Object[0]);
            }
        }
        QuinticPlanner.printf("All calculateAccelerationPulse() cases tested!\n", new Object[0]);
    }

    private static void test_calculateQuintics() throws PlannerException {
        EnumSet[] enumSetArray = new EnumSet[]{EnumSet.allOf(QuinticCases.class), EnumSet.allOf(QuinticCases.class)};
        String string = "A1";
        double d = 10.0;
        double d2 = 10.0;
        double d3 = 10.0;
        double d4 = 10.0;
        double d5 = 10.0;
        double d6 = 0.3158025295934253;
        QuinticPlanner.test_calculateQuintics(string, enumSetArray, QuinticCases.A1, d, d2, d3, d4, d5, d6);
    }

    private void plotWayPoints(Waypoint waypoint) {
    }

    public double[] getBlendpoint(Waypoint waypoint, double d) {
        Waypoint waypoint2 = waypoint;
        if (waypoint2.m_Speed == 0.0) {
            return null;
        }
        double[] dArray = waypoint.pa;
        double[] dArray2 = waypoint.pb;
        this.set(this.b1, dArray);
        this.set(this.b2, this.sub(waypoint2.m_Position, this.sub(dArray2, waypoint2.m_Position)));
        this.set(this.m1, this.sub(waypoint2.m_Position, dArray));
        this.set(this.m2, this.sub(dArray2, waypoint2.m_Position));
        this.set(this.m1, this.mul(2.0, this.m1));
        this.set(this.m2, this.mul(2.0, this.m2));
        this.set(this.vd, this.sub(this.m2, this.m1));
        double d2 = waypoint2.m_Speed;
        double d3 = waypoint2.m_Tightness;
        double d4 = d3 / d2;
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d5 = d * d * d;
        double d6 = d5 * d;
        double d7 = d6 * d;
        double d8 = d7 * d;
        double d9 = 6.0 * d7 - 15.0 * d6 + 10.0 * d5;
        double d10 = d8 - 3.0 * d7 + 3.0 * d6 - d5;
        double d11 = 7.5;
        this.set(dArray3, this.mulAdd(d, this.m1, this.b1));
        this.set(dArray4, this.mulAdd(d, this.m2, this.b2));
        double[] dArray5 = new double[3];
        this.set(dArray5, this.add(this.add(dArray3, this.mul(d9, this.sub(dArray4, dArray3))), this.mul(-d11 * d10, this.vd)));
        return dArray5;
    }

    private double[] getQuinticPoint(Waypoint waypoint, double d) {
        Quintics quintics = waypoint.m_Quintics;
        double d2 = 0.0;
        double d3 = 0.0;
        while (quintics != null) {
            d3 += quintics.dt;
            quintics = quintics.next;
        }
        double d4 = d * d3;
        quintics = waypoint.m_Quintics;
        while (quintics != null) {
            if (quintics.dt > 0.0) {
                double d5;
                if (d4 >= d2 && d4 < d2 + quintics.dt) {
                    d5 = quintics.interpolate(d4 - d2);
                    if (Double.isNaN(d5)) {
                        d5 = quintics.interpolate(d4 - d2);
                        System.err.println("Bad Quintic detected at Waypoint " + waypoint.m_Id + " Quintic " + quintics.m_Id + " @ " + (d4 - d2));
                    }
                    double[] dArray = new double[3];
                    this.set(dArray, this.add(waypoint.pb, this.mul(d5 / QuinticPlanner.distance(waypoint.m_Next.pa, waypoint.pb), this.sub(waypoint.m_Next.pa, waypoint.pb))));
                    return dArray;
                }
                if (quintics.next != null) {
                    d5 = quintics.interpolate(quintics.dt);
                    double d6 = quintics.next.interpolate(0.0);
                    double[] dArray = new double[3];
                    this.set(dArray, this.add(waypoint.pb, this.mul(d5 / QuinticPlanner.distance(waypoint.m_Next.pa, waypoint.pb), this.sub(waypoint.m_Next.pa, waypoint.pb))));
                    double[] dArray2 = new double[3];
                    this.set(dArray2, this.add(waypoint.pb, this.mul(d6 / QuinticPlanner.distance(waypoint.m_Next.pa, waypoint.pb), this.sub(waypoint.m_Next.pa, waypoint.pb))));
                    double d7 = QuinticPlanner.distance(dArray, dArray2);
                    if (d7 > 1.0E-10) {
                        System.err.println("Discontinuous Quintic detected at Waypoint " + waypoint.m_Id + " Quintic " + quintics.m_Id + " @ " + (d4 - d2));
                    }
                }
                d2 += quintics.dt;
            }
            quintics = quintics.next;
        }
        System.err.println("Could not calculate point  Waypoint " + waypoint.m_Id + " @ " + d + " " + d4 + " " + d3);
        return null;
    }

    double[] checkContinuity(double[] dArray, double[] dArray2, Waypoint waypoint, int n) {
        double d;
        if (dArray != null && dArray2 != null && (d = QuinticPlanner.distance(dArray, dArray2)) > 1.0E-10) {
            System.out.println("discontinuity = " + d);
            if (n == 0) {
                System.out.println("between pb of  " + waypoint.m_Prev);
                System.out.println("and     pa of  " + waypoint);
            } else {
                System.out.println("at " + n + " " + waypoint);
            }
        }
        return dArray2;
    }

    void checkPlannedPathForContinuity(Waypoint waypoint) {
        System.out.println("Checking planned path continuity between blend and quintics");
        double[] dArray = null;
        while (waypoint != null && waypoint.m_Next != null) {
            System.out.println("checking wp " + waypoint.m_Id);
            dArray = this.checkContinuity(dArray, this.getBlendpoint(waypoint, 0.0), waypoint, 0);
            dArray = this.getBlendpoint(waypoint, 1.0);
            dArray = this.checkContinuity(dArray, this.getQuinticPoint(waypoint, 0.0), waypoint, 2);
            dArray = this.getQuinticPoint(waypoint, 0.999999999999);
            waypoint = waypoint.m_Next;
        }
    }

    void generateTrajectory(Waypoint waypoint, double d) throws PlannerException {
        Waypoint waypoint2 = waypoint;
        while (waypoint != null) {
            waypoint2 = waypoint;
            this.generateBlendPoints(d, waypoint);
            this.generateQuinticPoints(d, waypoint);
            waypoint = waypoint.m_Next;
        }
        if (waypoint2 != null && QuinticPlanner.distance(waypoint2.m_Position, this.m_LastGeneratedPoint) > 0.0) {
            this.set(this.m_LastGeneratedPoint, waypoint2.m_Position);
            this.output(false, waypoint2, this.m_LastGeneratedPoint);
        }
    }

    public void plotTrajectory(double d, Waypoint waypoint, double d2, double d3, double d4) throws PlannerException {
        final ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<Double> arrayList5 = new ArrayList<Double>();
        ArrayList<Double> arrayList6 = new ArrayList<Double>();
        this.calculateDerivatives(d, arrayList2, arrayList3, arrayList, arrayList4, arrayList5, arrayList6, d2, d3, d4);
        ArrayList<Double> arrayList7 = new ArrayList<Double>();
        ArrayList<Double> arrayList8 = new ArrayList<Double>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        Waypoint waypoint2 = waypoint;
        while (waypoint2 != null) {
            arrayList7.add(0.0);
            arrayList8.add(-0.1);
            arrayList9.add(Integer.toString(waypoint2.m_Id));
            waypoint2 = waypoint2.m_Next;
        }
        final Plotter plotter = Plotter.newWithWindow();
        plotter.addPlot(new Plot("V", 2, arrayList, arrayList4, null, Color.RED, Plot.smallCross()));
        plotter.addPlot(new Plot("A", 2, arrayList, arrayList5, null, Color.GREEN, Plot.smallCross()));
        plotter.autoscale();
        final Plotter plotter2 = Plotter.newWithWindow();
        final Plot plot = new Plot("XY", 2, arrayList2, arrayList3, null, Color.GREEN, Plot.smallCross());
        plotter2.addPlot(plot);
        plotter2.autoscale();
        plotter.setMouseTracker(Plotter.TrackAxis.X, new Plotter.MouseTracker(){

            @Override
            public void trackMouse(Plot plot2, int n, PlotDataPoint plotDataPoint) {
                int n2 = 0;
                PlotDataPoint plotDataPoint2 = null;
                for (PlotDataPoint plotDataPoint3 : plot) {
                    if (n2 >= n) break;
                    plotDataPoint2 = plotDataPoint3;
                    ++n2;
                }
                if (plotDataPoint2 != null) {
                    plotter2.setCursor(n, Plotter.CursorType.CIRCLE, new Point2D.Double(plotDataPoint2.getX(), plotDataPoint2.getY()));
                }
                plotter.setCursor(n, Plotter.CursorType.VERTICAL, (Double)arrayList.get(n));
            }
        });
        plotter2.setMouseTracker(Plotter.TrackAxis.XY, new Plotter.MouseTracker(){

            @Override
            public void trackMouse(Plot plot, int n, PlotDataPoint plotDataPoint) {
                plotter2.setCursor(n, Plotter.CursorType.CIRCLE, new Point2D.Double(plotDataPoint.getX(), plotDataPoint.getY()));
            }
        });
    }

    private void test_planTrajectory() throws PlannerException {
        double d2 = 10.0;
        double d3 = 20.0;
        double d4 = d3 * d3;
        Waypoint waypoint = null;
        Waypoint waypoint2 = null;
        LinkedList linkedList = new LinkedList();
        this.setCapture((object, bl, d, dArray) -> linkedList.add(bl));
        double d5 = 5.0;
        waypoint = waypoint2 = new Waypoint(null, 0.0, d5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, d5, d5, 10.0, 20.0, 20.0, 0.0, 0.0, 0.0, 0.0));
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, d5, d5, 10.0, 80.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, d5, d5, 10.0, 100.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, d5, d5, 10.0, false, 0, new double[]{100.0, 100.0, 0.0}, 0.0, 100.0, 0.0, 0.0, 0.0, 0.0));
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, d5, d5, 10.0, false, 0, new double[]{50.0, 100.0, 0.0}, 100.0, 100.0, 0.0, 0.0, 0.0, 0.0));
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, d5, d5, 10.0, true, 0, new double[]{140.0, 100.0, 0.0}, 180.0, 100.0, 0.0, 0.0, 0.0, 0.0));
        waypoint2 = waypoint2.addWaypoint(new Waypoint(null, 0.0, d5, 0.0, 180.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        QuinticPlanner quinticPlanner = new QuinticPlanner();
        quinticPlanner.setMaxAccelerationAndJerk(20.0, 1000000.0);
        quinticPlanner.planTrajectory(waypoint);
        double d6 = 0.001;
        quinticPlanner.generateTrajectory(waypoint, d6);
        PlotDataObject plotDataObject = new PlotDataObject();
        PlotDataDouble plotDataDouble = new PlotDataDouble();
        double[] dArray2 = new double[quinticPlanner.m_PlanDataElementSize];
        for (int i = 0; i < quinticPlanner.m_GeneratedPlanSize; i += quinticPlanner.m_PlanDataElementSize) {
            plotDataObject.add("X");
            System.arraycopy(quinticPlanner.m_GeneratedPlanData, i, dArray2, 0, quinticPlanner.m_PlanDataElementSize);
            for (int j = 0; j < quinticPlanner.m_PlanDataElementSize; ++j) {
                plotDataDouble.add(dArray2[j]);
            }
        }
        TrajectoryPathPlotter.showTrajectoryData(plotDataObject, plotDataDouble, quinticPlanner.m_PlanDataElementSize, d6, d2, d3, d4);
        Waypoint waypoint3 = waypoint;
        while (waypoint3 != null) {
            waypoint3 = waypoint3.m_Next;
        }
        Waypoint waypoint4 = waypoint;
    }

    private void test6axis() throws PlannerException {
        double d = 10.0;
        double d2 = 100.0;
        double d3 = d2 * d2;
        Object var7_4 = null;
        Waypoint waypoint = new Waypoint(null, 10.0, 50.0, 0.0, 120.0, 280.0, 0.0, 120.0, 280.0, 0.0);
        Waypoint waypoint2 = waypoint.addWaypoint(new Waypoint(null, 20.0, 20.0, 20.0, 175.0, 225.0, 0.0, 175.0, 225.0, 0.0));
        Waypoint waypoint3 = waypoint2.addWaypoint(new Waypoint(null, 10.0, 20.0, 0.0, 200.0, 260.0, 0.0, 200.0, 260.0, 0.0));
        QuinticPlanner quinticPlanner = new QuinticPlanner();
        quinticPlanner.setMaxAccelerationAndJerk(d2, d3);
        quinticPlanner.planTrajectory(waypoint);
        double d4 = 0.001;
        quinticPlanner.generateTrajectory(waypoint, d4);
        quinticPlanner.plotTrajectory(d4, waypoint, 20.0, d2, d3);
    }

    private double calculateTightness(Waypoint waypoint) {
        Waypoint waypoint2 = waypoint.m_Prev;
        Waypoint waypoint3 = waypoint.m_Next;
        if (waypoint2 == null || waypoint3 == null) {
            return 0.0;
        }
        double[] dArray = waypoint2.m_Position;
        double[] dArray2 = waypoint.m_Position;
        double[] dArray3 = waypoint3.m_Position;
        double[] dArray4 = this.norm(this.sub(dArray2, dArray));
        double[] dArray5 = this.norm(this.sub(dArray3, dArray2));
        if (waypoint.m_Center != null) {
            double[] dArray6 = this.sub3(waypoint.m_Center, dArray2);
            double[] dArray7 = this.norm3(this.cross3(dArray4, dArray5));
            double[] dArray8 = this.norm3(this.cross3(dArray7, dArray6));
            double[] dArray9 = this.norm3(this.cross3(dArray6, dArray7));
            if (waypoint.m_Clockwise) {
                this.set3(dArray4, dArray8);
                this.set3(dArray5, dArray9);
            } else {
                this.set3(dArray4, dArray9);
                this.set3(dArray5, dArray8);
            }
        }
        double d = 0.8;
        double d2 = -QuinticPlanner.dot(dArray4, dArray5);
        double d3 = d2 + 1.0;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        double d4 = waypoint.m_Speed;
        double d5 = Math.sqrt(0.5) * d4 * d4 * Math.sqrt(d3) / (this.amax * d);
        double[] dArray10 = this.sub(this.mul(0.5, this.add(dArray4, dArray5)), dArray4);
        double d6 = QuinticPlanner.len(dArray10);
        double d7 = d6 < 0.01 ? 0.0 : Math.abs(QuinticPlanner.dot(this.mul(1.0 / d6, dArray10), dArray5));
        double d8 = Math.sqrt(0.5) * Math.sqrt(15.0) * Math.sqrt(d7) * Math.pow(d4, 1.5) / Math.sqrt(this.jmax);
        double d9 = Math.max(d5, d8);
        if (Double.isNaN(d9)) {
            throw new PlannerException("tightness is NaN");
        }
        if (Double.isInfinite(d9)) {
            throw new PlannerException("tightness is Infinite");
        }
        return d9;
    }

    public static void main(String[] stringArray) {
        QuinticPlanner.printf("Hello from QuinticPlanner\n", new Object[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new QuinticPlanner().test_planTrajectory();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void main3(String[] stringArray) {
        File file = new File("/Users/nyholku/EazyCNC/debuglogs/planner-coredump-2018.03.18-14.58.bin");
        try (IgnoreSerialVersionUID_ObjectInputStream ignoreSerialVersionUID_ObjectInputStream = new IgnoreSerialVersionUID_ObjectInputStream(new FileInputStream(file));){
            Waypoint waypoint = (Waypoint)ignoreSerialVersionUID_ObjectInputStream.readObject();
            QuinticPlanner quinticPlanner = new QuinticPlanner();
            quinticPlanner.setMaxAccelerationAndJerk(200.0, 1000.0);
            quinticPlanner.planTrajectory(waypoint);
            quinticPlanner.generateTrajectory(waypoint, 0.02);
            System.out.println("done!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class PlannerException
    extends IllegalArgumentException {
        PlannerException(String string) {
            super(string);
            if (QuinticPlanner.this.m_DumpWaypoints != null && QuinticPlanner.this.m_DebugLogsDir != null) {
                String string2 = new SimpleDateFormat("'planner-coredump-'yyyy'.'MM'.'dd'-'HH'.'mm'.bin'").format(new Date(System.currentTimeMillis()));
                File file = new File(QuinticPlanner.this.m_DebugLogsDir + string2);
                try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));){
                    objectOutputStream.writeObject(QuinticPlanner.this.m_DumpWaypoints);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                QuinticPlanner.this.m_DumpWaypoints = null;
            }
        }
    }

    private static enum AccelerationCases {
        C1,
        C2,
        C3,
        C4,
        C5;

    }

    private static enum QuinticCases {
        A1,
        A2,
        Biia1,
        Biia2,
        Biib,
        Biii1,
        Biii2;

    }

    public static class IgnoreSerialVersionUID_ObjectInputStream
    extends ObjectInputStream {
        public IgnoreSerialVersionUID_ObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            Class<?> clazz;
            ObjectStreamClass objectStreamClass = super.readClassDescriptor();
            try {
                clazz = Class.forName(objectStreamClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return objectStreamClass;
            }
            ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(clazz);
            if (objectStreamClass2 != null) {
                long l = objectStreamClass2.getSerialVersionUID();
                long l2 = objectStreamClass.getSerialVersionUID();
                if (l2 != l) {
                    StringBuffer stringBuffer = new StringBuffer("Overriding serialized class version mismatch: ");
                    stringBuffer.append("local serialVersionUID = ").append(l);
                    stringBuffer.append(" stream serialVersionUID = ").append(l2);
                    InvalidClassException invalidClassException = new InvalidClassException(stringBuffer.toString());
                    objectStreamClass = objectStreamClass2;
                }
            }
            return objectStreamClass;
        }
    }
}

