/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import eazycnc.gcode.Machcode;
import eazycnc.planner.MovePipeline;
import eazycnc.planner.QuinticPlanner;
import eazycnc.planner.ToolPathPlannerInterface;
import eazycnc.planner.VecMath;
import eazycnc.planner.Waypoint;

public class QuinticToolPathPlanner
implements ToolPathPlannerInterface {
    public boolean m_UseNewArcInterpolation;
    private volatile boolean m_SimuMode;
    private volatile PlannerState m_State = PlannerState.STOPPED;
    private volatile double m_CycleTime;
    private volatile double m_MaxVelocity;
    private volatile double m_MaxAcceleration;
    private volatile Thread m_RealTimeThread;
    private volatile QuinticPlanner m_Planner;
    private volatile Waypoint m_FirstWaypoint;
    private volatile Waypoint m_PreviousWaypoint;
    private volatile MovePipeline m_MovePipeline;
    private volatile double[] m_PreviousPosition = new double[6];
    private volatile int m_OutputDataOffset;
    private volatile double[] m_OutputData;
    private volatile double[] m_MoveToPosition;
    private volatile double[] m_MoveDirection;
    private volatile double m_Velocity;
    private volatile double m_ArcTolerance = 0.01;
    private volatile Waypoint m_FirstOutputWaypoint;
    private volatile int m_OutputElementSize;
    private volatile Waypoint m_CurrentOutputWaypoint;
    private volatile ToolPathPlannerInterface.InterruptFlush m_InterruptFlush;
    double m_TotalTime;
    private double[] m_VeloScalers = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};

    public QuinticToolPathPlanner(String string, int n, MovePipeline movePipeline, String string2) {
        this.m_MovePipeline = movePipeline;
        this.m_Planner = new QuinticPlanner(string2);
        this.m_RealTimeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                QuinticToolPathPlanner.this.backgroundRun();
            }
        }, this.getClass().getSimpleName() + "/" + string);
        this.m_RealTimeThread.setPriority(1);
        this.m_RealTimeThread.setUncaughtExceptionHandler((thread, throwable) -> {
            System.err.println("class " + this.getClass().getSimpleName() + ": uncaught exception");
            throwable.printStackTrace();
        });
        this.m_RealTimeThread.start();
    }

    @Override
    public void setParameters(double d, double d2, double d3, double d4, double d5) {
        this.m_Planner.setMaxAccelerationAndJerk(d4, d5);
        this.m_CycleTime = d2;
        this.m_MaxVelocity = d3;
        this.m_MaxAcceleration = d4;
        this.m_ArcTolerance = d;
    }

    @Override
    public synchronized double stopPlanner() {
        this.m_State = PlannerState.STOP;
        this.notifyAll();
        return this.m_TotalTime;
    }

    @Override
    public synchronized void startPlanner(boolean bl, double[] dArray) {
        this.m_SimuMode = bl;
        this.m_Planner.reset();
        VecMath.set(this.m_PreviousPosition, dArray);
        this.m_FirstWaypoint = null;
        this.m_PreviousWaypoint = null;
        this.m_State = PlannerState.RUNNING;
        this.notifyAll();
        this.m_TotalTime = 0.0;
    }

    @Override
    public boolean isStarved() {
        return false;
    }

    private synchronized void performFlush() throws InterruptedException {
        if (this.m_FirstWaypoint != null) {
            while (this.m_OutputData != null) {
                this.wait(100L);
            }
            this.m_Planner.planTrajectory(this.m_FirstWaypoint);
            this.m_Planner.generateTrajectory(this.m_FirstWaypoint, this.m_CycleTime);
            this.m_OutputData = this.m_Planner.getPlanData();
            this.m_OutputDataOffset = 0;
            this.m_OutputElementSize = this.m_Planner.getPlanDataElementSize();
            this.m_MoveToPosition = new double[this.m_OutputElementSize];
            this.m_MoveDirection = new double[this.m_OutputElementSize];
            System.arraycopy(this.m_FirstWaypoint.m_Position, 0, this.m_MoveToPosition, 0, this.m_OutputElementSize);
            this.scaleBackPosition(this.m_MoveToPosition);
            this.m_FirstOutputWaypoint = this.m_FirstWaypoint;
            this.m_Planner.reset();
            this.m_PreviousWaypoint = null;
            this.m_FirstWaypoint = null;
            this.notifyAll();
        }
    }

    private void generateArcInterpolationWaypoints_new(Machcode machcode) {
        double[][] dArray = Machcode.ArcMove.getArcPoints(machcode.getPlane(), this.m_PreviousPosition, machcode.getPosition(), machcode.getCenter(), this.m_ArcTolerance, machcode.m_Type == Machcode.SegmentType.MOVE_ARC_CW);
        for (int i = 0; i < dArray.length; ++i) {
            double d = i == 0 || i == dArray.length - 1 ? machcode.getTolerance() : Math.max(this.m_ArcTolerance, machcode.getTolerance());
            this.addWaypoint(machcode, machcode.getVelocity(), d, dArray[i]);
        }
    }

    private void generateArcInterpolationWaypoints(double d, Machcode machcode) {
        double[][] dArray = Machcode.ArcMove.getArcPoints(machcode.getPlane(), this.m_PreviousPosition, machcode.getPosition(), machcode.getCenter(), this.m_ArcTolerance, machcode.m_Type == Machcode.SegmentType.MOVE_ARC_CW);
        for (int i = 0; i < dArray.length; ++i) {
            this.addWaypoint(machcode, d, machcode.getTolerance(), dArray[i]);
        }
    }

    private void generateLinearInterpolationWaypoints(double d, Machcode machcode) {
        this.addWaypoint(machcode, d, machcode.getTolerance(), machcode.getPosition());
    }

    private void generateNewPlannerArcInterpolationWaypoints(double d, Machcode machcode) {
        if (d > this.m_MaxVelocity) {
            d = this.m_MaxVelocity;
        }
        if (this.m_PreviousWaypoint == null) {
            this.m_FirstWaypoint = this.m_PreviousWaypoint = new Waypoint(machcode, d, d, 0.0, this.scalePosition(this.m_PreviousPosition));
        }
        double d2 = machcode.getTolerance();
        double[] dArray = machcode.getPosition();
        double[] dArray2 = machcode.getCenter();
        int n = machcode.getPlane();
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0};
        VecMath.getXY(n, dArray3, dArray);
        VecMath.getXY(n, dArray4, dArray2);
        double d3 = dArray3[0] - dArray4[0];
        double d4 = dArray3[1] - dArray4[1];
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = Math.sqrt(d5 * this.m_MaxAcceleration);
        if (d > d6) {
            d = d6;
        }
        boolean bl = machcode.m_Type == Machcode.SegmentType.MOVE_ARC_CW;
        Waypoint waypoint = new Waypoint(machcode, d, d, d2, bl, n, dArray2, dArray);
        this.m_PreviousWaypoint.addWaypoint(waypoint);
        this.m_PreviousWaypoint = waypoint;
        VecMath.set(this.m_PreviousPosition, dArray);
    }

    private void addWaypoint(Machcode machcode, double d, double d2, double[] dArray) {
        block4: {
            for (int i = 0; i < 6; ++i) {
                if (dArray[i] == this.m_PreviousPosition[i]) {
                    continue;
                }
                break block4;
            }
            return;
        }
        if (d > this.m_MaxVelocity) {
            d = this.m_MaxVelocity;
        }
        if (this.m_PreviousWaypoint == null) {
            this.m_FirstWaypoint = this.m_PreviousWaypoint = new Waypoint(machcode, d, d, 0.0, this.scalePosition(this.m_PreviousPosition));
        }
        Waypoint waypoint = new Waypoint(machcode, d, d, d2, this.scalePosition(dArray));
        this.m_PreviousWaypoint.addWaypoint(waypoint);
        this.m_PreviousWaypoint = waypoint;
        VecMath.set(this.m_PreviousPosition, dArray);
    }

    @Override
    public void queueSegment(double d, Machcode machcode) throws InterruptedException {
        if (machcode == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (machcode.m_Type == Machcode.SegmentType.MOVE_LINEAR) {
            this.generateLinearInterpolationWaypoints(d, machcode);
        } else if (this.m_UseNewArcInterpolation) {
            this.generateNewPlannerArcInterpolationWaypoints(d, machcode);
        } else {
            this.generateArcInterpolationWaypoints(d, machcode);
        }
    }

    @Override
    public synchronized void flush() throws InterruptedException {
        this.flush(null);
    }

    @Override
    public synchronized void flush(ToolPathPlannerInterface.InterruptFlush interruptFlush) throws InterruptedException {
        this.m_InterruptFlush = interruptFlush;
        if (this.m_State == PlannerState.RUNNING) {
            this.performFlush();
        }
        while (this.m_OutputData != null) {
            this.wait(100L);
        }
        this.m_MovePipeline.flush();
        this.m_InterruptFlush = null;
    }

    public double[] getCurrentPosition_OBSOLETE() {
        return null;
    }

    @Override
    public Machcode getCurrentMachCode() {
        return this.m_CurrentOutputWaypoint != null && this.m_CurrentOutputWaypoint.m_Next != null ? this.m_CurrentOutputWaypoint.m_Next.m_Machcode : null;
    }

    public double getRunTime() {
        return this.m_TotalTime;
    }

    private void scaleBackPosition(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            dArray[i] = dArray[i] / this.m_VeloScalers[i];
        }
    }

    private double[] scalePosition(double[] dArray) {
        double[] dArray2 = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray2[i] = dArray[i] * this.m_VeloScalers[i];
        }
        return dArray2;
    }

    @Override
    public void setScalers(double[] dArray) {
        System.arraycopy(dArray, 0, this.m_VeloScalers, 0, this.m_VeloScalers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputPlanData() throws InterruptedException {
        double[] dArray = null;
        Waypoint waypoint = null;
        QuinticToolPathPlanner quinticToolPathPlanner = this;
        synchronized (quinticToolPathPlanner) {
            if (this.m_OutputData != null) {
                dArray = this.m_OutputData;
                this.m_OutputDataOffset = 0;
                waypoint = this.m_FirstOutputWaypoint;
            } else {
                this.wait(100L);
            }
        }
        if (dArray != null) {
            block6: while (waypoint != null) {
                this.m_CurrentOutputWaypoint = waypoint;
                for (int i = waypoint.m_GeneratedDataSize; i > 0; --i) {
                    if (this.m_InterruptFlush != null && this.m_InterruptFlush.interrupt()) {
                        this.initStopping();
                        break block6;
                    }
                    System.arraycopy(this.m_MoveToPosition, 0, this.m_MoveDirection, 0, this.m_OutputElementSize);
                    System.arraycopy(dArray, this.m_OutputDataOffset, this.m_MoveToPosition, 0, this.m_OutputElementSize);
                    this.scaleBackPosition(this.m_MoveToPosition);
                    VecMath.sub(this.m_MoveDirection, this.m_MoveDirection, this.m_MoveToPosition);
                    double d = VecMath.length(this.m_MoveDirection);
                    if (d > 0.0) {
                        VecMath.scale(this.m_MoveDirection, this.m_MoveDirection, 1.0 / d);
                    }
                    this.m_MovePipeline.queueMove(this.m_CurrentOutputWaypoint.m_Machcode, this.m_MoveToPosition);
                    this.m_Velocity = d / this.m_CycleTime;
                    this.m_OutputDataOffset += this.m_OutputElementSize;
                    if (!(this.m_Velocity > 0.0)) continue;
                    this.m_TotalTime += this.m_CycleTime;
                }
                waypoint = waypoint.m_Next;
                this.m_CurrentOutputWaypoint = null;
            }
            QuinticToolPathPlanner quinticToolPathPlanner2 = this;
            synchronized (quinticToolPathPlanner2) {
                this.m_OutputData = null;
                this.m_FirstOutputWaypoint = null;
                this.notifyAll();
            }
        }
    }

    private synchronized void initStopping() {
        if (this.m_OutputData != null && this.m_OutputDataOffset > this.m_OutputElementSize) {
            System.arraycopy(this.m_OutputData, this.m_OutputDataOffset - this.m_OutputElementSize, this.m_MoveToPosition, 0, this.m_OutputElementSize);
            this.scaleBackPosition(this.m_MoveToPosition);
            System.arraycopy(this.m_OutputData, this.m_OutputDataOffset, this.m_MoveDirection, 0, this.m_OutputElementSize);
            VecMath.sub(this.m_MoveDirection, this.m_MoveDirection, this.m_MoveToPosition);
            double d = VecMath.length(this.m_MoveDirection);
            if (d > 0.0) {
                VecMath.scale(this.m_MoveDirection, this.m_MoveDirection, 1.0 / d);
            }
            this.m_Velocity = d / this.m_CycleTime;
            this.m_State = PlannerState.STOPPING;
        } else {
            this.m_State = PlannerState.STOPPED;
            this.m_OutputData = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void slowdownToStop() throws InterruptedException {
        this.m_Velocity -= this.m_MaxAcceleration * this.m_CycleTime;
        if (this.m_Velocity > 0.0) {
            double d = this.m_Velocity * this.m_CycleTime;
            VecMath.addscale(this.m_MoveToPosition, this.m_MoveToPosition, this.m_MoveDirection, d);
            this.m_MovePipeline.queueMove(null, this.m_MoveToPosition);
        } else {
            QuinticToolPathPlanner quinticToolPathPlanner = this;
            synchronized (quinticToolPathPlanner) {
                this.m_State = PlannerState.STOPPED;
                this.m_OutputData = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundRun() {
        while (true) {
            try {
                while (true) {
                    switch (this.m_State) {
                        case STOP: {
                            this.initStopping();
                            break;
                        }
                        case STOPPING: {
                            this.slowdownToStop();
                            break;
                        }
                        case STOPPED: {
                            QuinticToolPathPlanner quinticToolPathPlanner = this;
                            synchronized (quinticToolPathPlanner) {
                                this.wait(100L);
                                break;
                            }
                        }
                        case RUNNING: {
                            this.outputPlanData();
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void setCapture(ToolPathPlannerInterface.CaptureMove captureMove) {
        this.m_Planner.setCapture(captureMove);
    }

    static enum PlannerState {
        STOP,
        STOPPING,
        STOPPED,
        RUNNING;

    }
}

