/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import java.io.Serializable;

final class Quintics
implements Serializable {
    private static int m_IdCounter;
    public int m_Id = m_IdCounter++;
    public Quintics next;
    public double dt;
    public double b0;
    public double b1;
    public double b2;
    public double b3;
    public double b4;
    public double b5;

    public boolean isBad() {
        return this.dt == 0.0 || !Double.isFinite(this.b0) || !Double.isFinite(this.b1) || !Double.isFinite(this.b2) || !Double.isFinite(this.b3) || !Double.isFinite(this.b4) || !Double.isFinite(this.b5);
    }

    public double interpolate(double d) {
        if (d >= this.dt) {
            return Double.NaN;
        }
        double d2 = d * d;
        double d3 = d2 * d;
        double d4 = d3 * d;
        double d5 = d4 * d;
        return d5 * this.b5 + d4 * this.b4 + d3 * this.b3 + d2 * this.b2 + d * this.b1 + this.b0;
    }

    public Quintics(Quintics quintics, int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (quintics != null) {
            quintics.next = this;
        }
        double d = dArray4[n];
        double d2 = dArray3[n];
        double d3 = dArray2[n];
        double d4 = dArray4[n + 1];
        double d5 = dArray3[n + 1];
        double d6 = dArray2[n + 1];
        this.dt = dArray[n + 1] - dArray[n];
        if (Double.isInfinite(this.dt)) {
            throw new IllegalArgumentException();
        }
        double d7 = this.dt * this.dt;
        double d8 = d7 * this.dt * 2.0;
        double d9 = d8 * this.dt;
        this.b5 = ((-1.0 * d + 1.0 * d4) * d7 + (-6.0 * d2 - 6.0 * d5) * this.dt + (-12.0 * d3 + 12.0 * d6)) / (d9 * this.dt);
        this.b4 = ((3.0 * d - 2.0 * d4) * d7 + (16.0 * d2 + 14.0 * d5) * this.dt + (30.0 * d3 - 30.0 * d6)) / d9;
        this.b3 = ((-3.0 * d + 1.0 * d4) * d7 + (-12.0 * d2 - 8.0 * d5) * this.dt + (-20.0 * d3 + 20.0 * d6)) / d8;
        this.b2 = d / 2.0;
        this.b1 = d2;
        this.b0 = d3;
    }
}

