/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import com.eazycnc.gcode.MachState;
import concurrentconditionals.Signal;
import eazycnc.gcode.Machcode;
import eazycnc.planner.MovePipeline;
import eazycnc.planner.SegmentState;
import eazycnc.planner.ToolPathPlannerInterface;
import eazycnc.planner.VecMath;
import java.util.ArrayDeque;

public class ToolPathPlanner
implements ToolPathPlannerInterface {
    private MachState m_MachState;
    private static final int debug = 0;
    private Thread m_RealTimeThread;
    private MovePipeline m_Output;
    private volatile double m_CycleTime;
    private volatile double[] m_PosXYZ;
    private volatile double[] m_LastPos;
    private volatile double m_MaxAcceleration;
    private volatile double m_MaxVelocity;
    private volatile double[] pdp;
    private volatile double[] pp0;
    private volatile double[] pp1;
    private volatile double[] sdp;
    private volatile double[] sp0;
    private volatile double[] sp1;
    private volatile double[] v1;
    private volatile double[] v2;
    private volatile SegmentState m_CurSegState;
    private volatile SegmentState m_NxtSegState;
    private int m_NumberOfMotors;
    private double m_ZScaler = 1.0;
    private boolean m_SimulationMode = true;
    private Signal m_HasStoppedSignal = new Signal("HAS-STOPPED", false);
    private Signal m_BrakeOnSignal = new Signal("BRAKE-ON", false);
    private Signal m_StarvedSignal = new Signal("HAS-STOPPED", true);
    private double m_FeedOverride = 1.0;
    private ArrayDeque<Machcode> m_InputQueue = new ArrayDeque();

    @Override
    public synchronized Machcode getCurrentMachCode() {
        if (this.m_CurSegState.m_Progress >= this.m_CurSegState.m_Length) {
            return null;
        }
        return this.m_CurSegState.m_Segment;
    }

    public MachState getMachState() {
        return this.m_MachState;
    }

    public ToolPathPlanner(String string, int n, MachState machState, MovePipeline movePipeline) {
        throw new IllegalArgumentException("ToolPathPlanner is obsolete");
    }

    @Override
    public synchronized void setParameters(double d, double d2, double d3, double d4, double d5) {
        this.m_CycleTime = d2;
        this.m_MaxVelocity = d3;
        this.m_MaxAcceleration = d4;
        this.m_ZScaler = 1.0;
    }

    private synchronized void activate(Machcode machcode, SegmentState segmentState, boolean bl) {
        segmentState.m_Segment = machcode;
        segmentState.m_Active = true;
        segmentState.m_Type = machcode.m_Type;
        VecMath.getXYZ(segmentState.m_PosXYZ, machcode.getPosition());
        segmentState.m_IsBlendable = false;
        segmentState.m_Length = 0.0;
        double d = this.m_MaxAcceleration;
        double d2 = machcode.getVelocity();
        if (segmentState.m_PosXYZ[2] != this.m_LastPos[2]) {
            d *= this.m_ZScaler;
            d2 *= this.m_ZScaler;
        }
        if (machcode.m_Type == Machcode.SegmentType.MOVE_LINEAR) {
            VecMath.sub(segmentState.m_Direction, segmentState.m_PosXYZ, this.m_LastPos);
            segmentState.m_Length = VecMath.length(segmentState.m_Direction);
            if (segmentState.m_Length > 0.0) {
                VecMath.scale(segmentState.m_Direction, segmentState.m_Direction, 1.0 / segmentState.m_Length);
            }
            segmentState.m_IsBlendable = true;
        } else if (machcode.m_Type == Machcode.SegmentType.MOVE_ARC_CW || machcode.m_Type == Machcode.SegmentType.MOVE_ARC_CCW) {
            int n;
            segmentState.m_Plane = n = machcode.getPlane();
            VecMath.getXY(n, segmentState.m_Center, machcode.getCenter());
            double d3 = VecMath.getXY_Z(n, segmentState.m_Temp, this.m_LastPos);
            VecMath.sub(segmentState.m_Temp, segmentState.m_Temp, segmentState.m_Center);
            double d4 = VecMath.length(segmentState.m_Temp);
            double d5 = Math.atan2(segmentState.m_Temp[1], segmentState.m_Temp[0]);
            double d6 = VecMath.getXY_Z(n, segmentState.m_Temp, segmentState.m_PosXYZ);
            VecMath.sub(segmentState.m_Temp, segmentState.m_Temp, segmentState.m_Center);
            double d7 = VecMath.length(segmentState.m_Temp);
            double d8 = Math.atan2(segmentState.m_Temp[1], segmentState.m_Temp[0]);
            double d9 = d8 - d5;
            if (machcode.m_Type == Machcode.SegmentType.MOVE_ARC_CW) {
                if (d9 > 0.0) {
                    d9 -= Math.PI * 2;
                } else if (d9 == 0.0) {
                    d9 = Math.PI * -2;
                }
            } else if (d9 < 0.0) {
                d9 += Math.PI * 2;
            } else if (d9 == 0.0) {
                d9 = Math.PI * 2;
            }
            segmentState.m_EndAngle = d8;
            segmentState.m_EndRadius = d7;
            segmentState.m_EndZ = d6;
            segmentState.m_DeltaAngle = d9;
            segmentState.m_DeltaRadius = d7 - d4;
            segmentState.m_DeltaZ = d6 - d3;
            VecMath.getXY(segmentState.m_Plane, segmentState.m_StartDir, this.m_LastPos);
            VecMath.sub(segmentState.m_StartDir, segmentState.m_StartDir, segmentState.m_Center);
            VecMath.fliplr(segmentState.m_StartDir, segmentState.m_Type == Machcode.SegmentType.MOVE_ARC_CW);
            VecMath.scale(segmentState.m_StartDir, segmentState.m_StartDir, 1.0 / VecMath.length(segmentState.m_StartDir));
            VecMath.getXY(segmentState.m_Plane, segmentState.m_EndDir, segmentState.m_PosXYZ);
            VecMath.sub(segmentState.m_EndDir, segmentState.m_EndDir, segmentState.m_Center);
            VecMath.fliplr(segmentState.m_EndDir, segmentState.m_Type == Machcode.SegmentType.MOVE_ARC_CW);
            VecMath.scale(segmentState.m_EndDir, segmentState.m_EndDir, 1.0 / VecMath.length(segmentState.m_EndDir));
            segmentState.m_Length = Math.abs(d9 * (d4 + d7) * 0.5);
            segmentState.m_IsBlendable = true;
        }
        segmentState.m_Progress = 0.0;
        segmentState.m_CurrentVelocity = 0.0;
        segmentState.m_BlendVelocity = 0.0;
        segmentState.m_BlendStartVelocity = 0.0;
        segmentState.m_Blending = false;
        segmentState.m_TargetVelocity = d2;
        if (segmentState.m_IsBlendable) {
            segmentState.m_Tolerance = machcode.getTolerance();
            segmentState.m_BlendWithNext = machcode.getTolerance() > 0.0;
        } else {
            segmentState.m_Tolerance = 0.0;
            segmentState.m_BlendWithNext = false;
        }
        segmentState.m_MaxAcceleration = d;
        if (bl || segmentState.m_BlendWithNext) {
            segmentState.m_MaxAcceleration /= 2.0;
        }
        VecMath.setXYZ(this.m_LastPos, segmentState.m_PosXYZ);
    }

    @Override
    public synchronized double stopPlanner() {
        this.m_BrakeOnSignal.setCondition(true);
        this.m_HasStoppedSignal.setCondition(this.isStopped());
        this.notifyAll();
        return 0.0;
    }

    @Override
    public synchronized void startPlanner(boolean bl, double[] dArray) {
        this.m_SimulationMode = bl;
        this.m_InputQueue.clear();
        this.m_CurSegState.m_Active = false;
        this.m_NxtSegState.m_Active = false;
        this.setCurrentPosition(dArray);
        this.m_BrakeOnSignal.setCondition(false);
        this.m_HasStoppedSignal.setCondition(this.isStopped());
        this.notifyAll();
    }

    @Override
    public synchronized void queueSegment(double d, Machcode machcode) throws InterruptedException {
        while (this.m_InputQueue.size() >= 2) {
            this.wait(100L);
        }
        this.m_InputQueue.addLast(machcode);
        this.m_StarvedSignal.setCondition(false);
        this.m_HasStoppedSignal.setCondition(this.isStopped());
        this.notifyAll();
    }

    public synchronized void waitQueueEmpty() throws InterruptedException {
        while (this.m_InputQueue.size() > 0) {
            this.wait(100L);
        }
    }

    private synchronized Machcode takeSegment(boolean bl) throws InterruptedException {
        if (bl && this.m_InputQueue.isEmpty()) {
            this.m_StarvedSignal.setCondition(true);
        }
        while (this.m_InputQueue.isEmpty()) {
            if (!bl) {
                return null;
            }
            this.wait(100L);
        }
        this.notifyAll();
        return this.m_InputQueue.removeFirst();
    }

    @Override
    public boolean isStarved() {
        return this.m_StarvedSignal.getCondition();
    }

    public synchronized double[] getCurrentPosition() {
        double[] dArray = new double[this.m_PosXYZ.length];
        System.arraycopy(this.m_PosXYZ, 0, dArray, 0, this.m_PosXYZ.length);
        return dArray;
    }

    private boolean isStopped() {
        return this.m_BrakeOnSignal.getCondition() && (this.m_CurSegState.m_CurrentVelocity == 0.0 || this.m_StarvedSignal.getCondition());
    }

    private void setCurrentPosition(double[] dArray) {
        System.arraycopy(dArray, 0, this.m_LastPos, 0, this.m_LastPos.length);
        System.arraycopy(dArray, 0, this.m_PosXYZ, 0, this.m_PosXYZ.length);
    }

    private double[] getPos() {
        double[] dArray = new double[this.m_NumberOfMotors];
        dArray[0] = this.m_PosXYZ[0];
        dArray[1] = this.m_PosXYZ[1];
        dArray[2] = this.m_PosXYZ[2];
        return dArray;
    }

    private void backgroundRun() {
        while (true) {
            try {
                while (true) {
                    Machcode machcode;
                    if (!this.m_CurSegState.m_Active) {
                        machcode = this.takeSegment(true);
                        this.activate(machcode, this.m_CurSegState, false);
                    }
                    if (!this.m_NxtSegState.m_Active && (machcode = this.takeSegment(false)) != null) {
                        this.activate(machcode, this.m_NxtSegState, this.m_CurSegState.m_BlendWithNext);
                    }
                    double d = 1.0;
                    if (!this.m_SimulationMode) {
                        double d2 = d = this.m_MachState.getParamBoolean(15131) ? this.m_MachState.getParamDouble(15132) : 1.0;
                        if (this.m_BrakeOnSignal.getCondition()) {
                            d = 0.0;
                        }
                    }
                    if (this.m_NxtSegState.m_Active && this.m_CurSegState.m_BlendWithNext && this.m_NxtSegState.m_IsBlendable) {
                        this.m_CurSegState.m_BlendVelocity = this.m_NxtSegState.m_MaxAcceleration * Math.sqrt(this.m_NxtSegState.m_Length / this.m_NxtSegState.m_MaxAcceleration);
                        double d3 = this.m_NxtSegState.m_TargetVelocity * d;
                        if (this.m_CurSegState.m_BlendVelocity > d3) {
                            this.m_CurSegState.m_BlendVelocity = d3;
                        }
                        if (this.m_CurSegState.m_MaxAcceleration < this.m_NxtSegState.m_MaxAcceleration) {
                            this.m_CurSegState.m_BlendVelocity *= this.m_CurSegState.m_MaxAcceleration / this.m_NxtSegState.m_MaxAcceleration;
                        }
                        if (this.m_CurSegState.m_Tolerance > 0.0) {
                            double d4;
                            ToolPathPlanner.getEndVector(this.v1, this.m_CurSegState);
                            ToolPathPlanner.getStartVector(this.v2, this.m_NxtSegState);
                            double d5 = VecMath.dot(this.v1, this.v2);
                            double d6 = Math.acos(-d5) / 2.0;
                            double d7 = Math.cos(d6);
                            if (d7 > 0.001 && (d4 = 2.0 * Math.sqrt(this.m_CurSegState.m_MaxAcceleration * this.m_CurSegState.m_Tolerance / d7)) < this.m_CurSegState.m_BlendVelocity) {
                                this.m_CurSegState.m_BlendVelocity = d4;
                            }
                        } else {
                            this.m_CurSegState.m_BlendVelocity = 0.0;
                        }
                    }
                    ToolPathPlanner.calcPosition(this.pp0, this.m_CurSegState, this.m_CurSegState.m_Progress);
                    boolean bl = this.advancePosition(this.m_CurSegState, d);
                    ToolPathPlanner.calcPosition(this.pp1, this.m_CurSegState, this.m_CurSegState.m_Progress);
                    VecMath.sub(this.pdp, this.pp1, this.pp0);
                    if (this.m_CurSegState.m_Blending || bl && this.m_CurSegState.m_CurrentVelocity < this.m_CurSegState.m_BlendVelocity) {
                        this.m_CurSegState.m_Blending = true;
                        double d8 = this.m_NxtSegState.m_TargetVelocity;
                        this.m_NxtSegState.m_TargetVelocity = d > 0.0 ? (this.m_CurSegState.m_BlendStartVelocity - this.m_CurSegState.m_CurrentVelocity) / d : 0.0;
                        ToolPathPlanner.calcPosition(this.sp0, this.m_NxtSegState, this.m_NxtSegState.m_Progress);
                        this.advancePosition(this.m_NxtSegState, d);
                        ToolPathPlanner.calcPosition(this.sp1, this.m_NxtSegState, this.m_NxtSegState.m_Progress);
                        this.m_NxtSegState.m_TargetVelocity = d8;
                        VecMath.sub(this.sdp, this.sp1, this.sp0);
                        VecMath.add(this.m_PosXYZ, this.m_PosXYZ, this.pdp);
                        VecMath.add(this.m_PosXYZ, this.m_PosXYZ, this.sdp);
                    } else {
                        VecMath.set(this.m_PosXYZ, this.pp1);
                    }
                    if (this.isStopped()) {
                        this.m_CurSegState.m_Active = false;
                        this.m_HasStoppedSignal.setCondition(true);
                    } else {
                        this.m_HasStoppedSignal.setCondition(false);
                        try {
                            this.m_Output.queueMove(null, this.getPos());
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                        }
                    }
                    if (!(this.m_CurSegState.m_Progress >= this.m_CurSegState.m_Length)) continue;
                    SegmentState segmentState = this.m_CurSegState;
                    this.m_CurSegState = this.m_NxtSegState;
                    this.m_NxtSegState = segmentState;
                    this.m_NxtSegState.m_Blending = false;
                    this.m_NxtSegState.m_Active = false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static double sqr(double d) {
        return d * d;
    }

    private boolean advancePosition(SegmentState segmentState, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (!segmentState.m_Blending) {
            segmentState.m_BlendStartVelocity = segmentState.m_CurrentVelocity;
        }
        double d5 = segmentState.m_Length - segmentState.m_Progress;
        if ((d5 = 0.5 * this.m_CycleTime * segmentState.m_CurrentVelocity - d5) < 0.0) {
            double d6 = 0.25 * ToolPathPlanner.sqr(this.m_CycleTime) - 2.0 / segmentState.m_MaxAcceleration * d5;
            d2 = d3 = -0.5 * segmentState.m_MaxAcceleration * this.m_CycleTime + segmentState.m_MaxAcceleration * Math.sqrt(d6);
        }
        if (d3 <= 0.0) {
            d4 = 0.0;
            d3 = 0.0;
            segmentState.m_Progress = segmentState.m_Length;
        } else {
            if (d3 > segmentState.m_TargetVelocity * d) {
                d3 = segmentState.m_TargetVelocity * d;
            }
            if (d3 > this.m_MaxVelocity) {
                d3 = this.m_MaxVelocity;
            }
            if ((d4 = (d3 - segmentState.m_CurrentVelocity) / this.m_CycleTime) > 0.0 && d4 > segmentState.m_MaxAcceleration) {
                d4 = segmentState.m_MaxAcceleration;
                d3 = segmentState.m_CurrentVelocity + d4 * this.m_CycleTime;
            }
            if (d4 < 0.0 && d4 < -segmentState.m_MaxAcceleration) {
                d4 = -segmentState.m_MaxAcceleration;
                d3 = segmentState.m_CurrentVelocity + d4 * this.m_CycleTime;
            }
            segmentState.m_Progress += (d3 + segmentState.m_CurrentVelocity) * 0.5 * this.m_CycleTime;
        }
        if (d3 < 0.001) {
            d3 = 0.0;
        }
        segmentState.m_CurrentVelocity = d3;
        if (Math.abs(d2 - d3) < 0.001) {
            segmentState.m_CurrentVelocity = d2;
            return true;
        }
        return false;
    }

    private static void getEndVector(double[] dArray, SegmentState segmentState) {
        switch (segmentState.m_Type) {
            default: {
                throw new IllegalArgumentException("segment type " + segmentState.m_Type + " not allowed here");
            }
            case MOVE_LINEAR: {
                VecMath.set(dArray, segmentState.m_Direction);
                break;
            }
            case MOVE_ARC_CW: 
            case MOVE_ARC_CCW: {
                VecMath.set(dArray, segmentState.m_EndDir);
            }
        }
    }

    private static void getStartVector(double[] dArray, SegmentState segmentState) {
        switch (segmentState.m_Type) {
            default: {
                throw new IllegalArgumentException("segment type " + segmentState.m_Type + " not allowed here");
            }
            case MOVE_LINEAR: {
                VecMath.set(dArray, segmentState.m_Direction);
                break;
            }
            case MOVE_ARC_CW: 
            case MOVE_ARC_CCW: {
                VecMath.set(dArray, segmentState.m_StartDir);
            }
        }
    }

    private static void calcPosition(double[] dArray, SegmentState segmentState, double d) {
        if (segmentState.m_Type == Machcode.SegmentType.MOVE_LINEAR) {
            VecMath.addscale(dArray, segmentState.m_PosXYZ, segmentState.m_Direction, d - segmentState.m_Length);
        } else if (segmentState.m_Type == Machcode.SegmentType.MOVE_ARC_CW || segmentState.m_Type == Machcode.SegmentType.MOVE_ARC_CCW) {
            double d2 = (segmentState.m_Length - d) / segmentState.m_Length;
            double d3 = segmentState.m_EndAngle - segmentState.m_DeltaAngle * d2;
            double d4 = segmentState.m_EndRadius - segmentState.m_DeltaRadius * d2;
            double d5 = segmentState.m_EndZ - segmentState.m_DeltaZ * d2;
            segmentState.m_ArcPos[0] = Math.cos(d3) * d4 + segmentState.m_Center[0];
            segmentState.m_ArcPos[1] = Math.sin(d3) * d4 + segmentState.m_Center[1];
            VecMath.setXY_Z(segmentState.m_Plane, dArray, segmentState.m_ArcPos, d5);
        } else {
            VecMath.set(dArray, segmentState.m_PosXYZ);
        }
    }

    @Override
    public void flush() {
        while (!this.isStarved()) {
            Thread.yield();
        }
    }

    @Override
    public void setCapture(ToolPathPlannerInterface.CaptureMove captureMove) {
    }

    @Override
    public void flush(ToolPathPlannerInterface.InterruptFlush interruptFlush) throws InterruptedException {
    }

    @Override
    public void setScalers(double[] dArray) {
    }

    private /* synthetic */ void lambda$new$0(Thread thread, Throwable throwable) {
        System.err.println("class " + this.getClass().getSimpleName() + ": uncaught exception");
        throwable.printStackTrace();
    }
}

