/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import java.util.Locale;

public class VecMath {
    public static double ZERO_TOLERANCE = 1.0E-8;

    private static void validate(double[] dArray) {
    }

    public static void getXYZ(double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = dArray2[2];
        VecMath.validate(dArray);
    }

    public static void setXYZ(double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = dArray2[2];
        VecMath.validate(dArray);
    }

    public static double getXY_Z(int n, double[] dArray, double[] dArray2) {
        if (n == 0) {
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            return dArray2[2];
        }
        if (n == 1) {
            dArray[0] = dArray2[2];
            dArray[1] = dArray2[0];
            return dArray2[1];
        }
        if (n == 2) {
            dArray[0] = dArray2[1];
            dArray[1] = dArray2[2];
            return dArray2[0];
        }
        throw new IllegalArgumentException("bad plane: " + n);
    }

    public static double getZ(int n, double[] dArray) {
        if (n == 0) {
            return dArray[2];
        }
        if (n == 1) {
            return dArray[1];
        }
        if (n == 2) {
            return dArray[0];
        }
        throw new IllegalArgumentException("bad plane: " + n);
    }

    public static void getXY(int n, double[] dArray, double[] dArray2) {
        if (n == 0) {
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
        } else if (n == 1) {
            dArray[0] = dArray2[2];
            dArray[1] = dArray2[0];
        } else if (n == 2) {
            dArray[0] = dArray2[1];
            dArray[1] = dArray2[2];
        } else {
            throw new IllegalArgumentException("bad plane: " + n);
        }
    }

    public static boolean equalXY(int n, double[] dArray, double[] dArray2) {
        if (n == 0) {
            return dArray[0] == dArray2[0] && dArray[1] == dArray2[1];
        }
        if (n == 1) {
            return dArray[0] == dArray2[0] && dArray[2] == dArray2[2];
        }
        if (n == 2) {
            return dArray[1] == dArray2[1] && dArray[2] == dArray2[2];
        }
        throw new IllegalArgumentException("bad plane: " + n);
    }

    public static void setXY(int n, double[] dArray, double[] dArray2) {
        if (n == 0) {
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
        } else if (n == 1) {
            dArray[2] = dArray2[0];
            dArray[0] = dArray2[1];
        } else if (n == 2) {
            dArray[1] = dArray2[0];
            dArray[2] = dArray2[1];
        } else {
            throw new IllegalArgumentException("bad plane: " + n);
        }
        VecMath.validate(dArray);
    }

    public static void setXY_Z(int n, double[] dArray, double[] dArray2, double d) {
        if (n == 0) {
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            dArray[2] = d;
        } else if (n == 1) {
            dArray[2] = dArray2[0];
            dArray[1] = d;
            dArray[0] = dArray2[1];
        } else if (n == 2) {
            dArray[0] = d;
            dArray[1] = dArray2[0];
            dArray[2] = dArray2[1];
        } else {
            throw new IllegalArgumentException("bad plane: " + n);
        }
        VecMath.validate(dArray);
    }

    public static int side(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = dArray3[0] - dArray[0];
        double d2 = dArray3[1] - dArray[1];
        double d3 = dArray2[1] * d - dArray2[0] * d2;
        if (d3 > ZERO_TOLERANCE) {
            return 1;
        }
        if (d3 < -ZERO_TOLERANCE) {
            return -1;
        }
        return 0;
    }

    public static int side(double[] dArray, double[] dArray2) {
        double d = dArray[1] * dArray2[0] - dArray[0] * dArray2[1];
        if (d > ZERO_TOLERANCE) {
            return 1;
        }
        if (d < -ZERO_TOLERANCE) {
            return -1;
        }
        return 0;
    }

    public static double[] zero(double[] dArray) {
        return new double[dArray.length];
    }

    public static double[] copy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        VecMath.validate(dArray2);
        return dArray2;
    }

    public static double[] vec(double ... dArray) {
        VecMath.validate(dArray);
        return VecMath.copy(dArray);
    }

    public static double[] vec(int n) {
        return new double[n];
    }

    public static void flipr(double[] dArray, double[] dArray2) {
        double d = dArray2[0];
        dArray[0] = dArray2[1];
        dArray[1] = -d;
        VecMath.validate(dArray);
    }

    public static void flipl(double[] dArray, double[] dArray2) {
        double d = dArray2[0];
        dArray[0] = -dArray2[1];
        dArray[1] = d;
        VecMath.validate(dArray);
    }

    public static void flip(double[] dArray) {
        dArray[0] = -dArray[0];
        dArray[1] = -dArray[1];
        VecMath.validate(dArray);
    }

    public static void fliplr(double[] dArray, boolean bl) {
        double d = dArray[0];
        double d2 = dArray[1];
        if (bl) {
            dArray[0] = d2;
            dArray[1] = -d;
        } else {
            dArray[0] = -d2;
            dArray[1] = d;
        }
        VecMath.validate(dArray);
    }

    public static void set(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        System.arraycopy(dArray2, n2, dArray, n, n3);
        VecMath.validate(dArray);
    }

    public static void set(double[] dArray, double[] dArray2) {
        int n = dArray2.length < dArray.length ? dArray2.length : dArray.length;
        System.arraycopy(dArray2, 0, dArray, 0, n);
        VecMath.validate(dArray);
    }

    public static void set(double[] dArray, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        VecMath.validate(dArray);
    }

    public static boolean isEqual(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i] - dArray2[i];
            if (!(d > ZERO_TOLERANCE) && !(d < -ZERO_TOLERANCE)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(double[] dArray) {
        for (double d : dArray) {
            if (!(d > ZERO_TOLERANCE) && !(d < -ZERO_TOLERANCE)) continue;
            return false;
        }
        return true;
    }

    public static void sub(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i] - dArray3[i];
        }
        VecMath.validate(dArray);
    }

    public static void sub(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] - dArray2[i];
        }
        VecMath.validate(dArray);
    }

    public static void sub(double[] dArray, double d) {
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] - d;
        }
        VecMath.validate(dArray);
    }

    public static void add(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i] + dArray3[i];
        }
        VecMath.validate(dArray);
    }

    public static void add(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] + dArray2[i];
        }
        VecMath.validate(dArray);
    }

    public static void add(double[] dArray, double d) {
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] + d;
        }
        VecMath.validate(dArray);
    }

    public static void scale(double[] dArray, double d) {
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * d;
        }
        VecMath.validate(dArray);
    }

    public static void addscale(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i] + dArray3[i] * d;
        }
        VecMath.validate(dArray);
    }

    public static void scale(double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i] * d;
        }
        VecMath.validate(dArray);
    }

    public static double length(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        if (n == 2) {
            return Math.hypot(dArray[0], dArray[1]);
        }
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i];
            if (Double.isInfinite(d2)) {
                return d2;
            }
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double lengthsq(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2 * d2;
        }
        return d;
    }

    public static double distance(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double distance(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double distancesq(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return d;
    }

    public static double dot(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double dot2(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1];
    }

    public static double dot2perp(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }

    public static double maxabs(double[] dArray) {
        double d = Math.abs(dArray[0]);
        int n = dArray.length;
        for (int i = 1; i < n; ++i) {
            double d2 = Math.abs(dArray[i]);
            d = d > d2 ? d : d2;
        }
        return d;
    }

    public static int lineCircleIntersection(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5) {
        VecMath.sub(dArray5, dArray2, dArray4);
        double d2 = VecMath.lengthsq(dArray5) - d * d;
        double d3 = VecMath.dot(dArray3, dArray5);
        double d4 = d3 * d3 - d2;
        if (d4 > ZERO_TOLERANCE) {
            d4 = Math.sqrt(d4);
            VecMath.addscale(dArray[0], dArray2, dArray3, -d3 - d4);
            VecMath.addscale(dArray[1], dArray2, dArray3, -d3 + d4);
            return 2;
        }
        if (d4 < -ZERO_TOLERANCE) {
            return 0;
        }
        VecMath.addscale(dArray[0], dArray2, dArray3, -d3);
        return 1;
    }

    public static int circleCircleIntersection(double[][] dArray, double[] dArray2, double d, double[] dArray3, double d2, double[] dArray4, double[] dArray5, double[] dArray6) {
        VecMath.sub(dArray5, dArray3, dArray2);
        double d3 = VecMath.lengthsq(dArray5);
        double d4 = d - d2;
        if (d3 < ZERO_TOLERANCE && Math.abs(d4) < ZERO_TOLERANCE) {
            return -1;
        }
        double d5 = d4 * d4;
        if (d3 < d5) {
            return 0;
        }
        double d6 = d + d2;
        double d7 = d6 * d6;
        if (d3 > d7) {
            return 0;
        }
        if (d3 < d7) {
            if (d5 < d3) {
                double d8 = 1.0 / d3;
                double d9 = 0.5 * ((d * d - d2 * d2) * d8 + 1.0);
                VecMath.addscale(dArray4, dArray2, dArray5, d9);
                double d10 = d * d * d8 - d9 * d9;
                if (d10 < 0.0) {
                    d10 = 0.0;
                }
                double d11 = Math.sqrt(d10);
                VecMath.flipr(dArray6, dArray5);
                VecMath.addscale(dArray[0], dArray4, dArray6, -d11);
                VecMath.addscale(dArray[1], dArray4, dArray6, d11);
                return 2;
            }
            VecMath.addscale(dArray[0], dArray2, dArray5, d / d4);
            return 1;
        }
        VecMath.addscale(dArray[0], dArray2, dArray5, d / d6);
        return 1;
    }

    public static boolean lineLineIntersection(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double[] dArray6 = new double[2];
        VecMath.sub(dArray6, dArray4, dArray2);
        double d = VecMath.dot2perp(dArray3, dArray5);
        if (d != 0.0) {
            double d2 = 1.0 / d;
            double d3 = VecMath.dot2perp(dArray6, dArray3);
            double d4 = VecMath.dot2perp(dArray6, dArray5);
            double d5 = d4 * d2;
            double d6 = d3 * d2;
            VecMath.addscale(dArray, dArray2, dArray3, d5);
            return true;
        }
        return false;
    }

    public static int findclosest(double[] dArray, double[][] dArray2, int n) {
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        double d = VecMath.distancesq(dArray, dArray2[0]);
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            double d2 = VecMath.distancesq(dArray, dArray2[i]);
            if (!(d2 < d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{VecMath.vec(2), VecMath.vec(2)};
        double[] dArray = VecMath.vec(2);
        double[] dArray2 = VecMath.vec(2);
        double[] dArray3 = VecMath.vec(2);
        double[] dArray4 = VecMath.vec(2);
        double[] dArray5 = new double[]{1.0, 2.0};
        double[] dArray6 = new double[]{2.0, 1.0};
        VecMath.scale(dArray6, 1.0 / VecMath.length(dArray6));
        double[] dArray7 = new double[]{1.0, 1.0};
        double d = 2.0;
        double[] dArray8 = new double[]{4.0, 2.0};
        double d2 = 3.0;
        System.out.println(VecMath.circleCircleIntersection(dArrayArray, dArray7, d, dArray8, d2, dArray2, dArray3, dArray4));
        VecMath.sub(dArray2, dArrayArray[0], dArray7);
        System.out.println(VecMath.length(dArray2) - d);
        VecMath.sub(dArray2, dArrayArray[1], dArray8);
        System.out.println(VecMath.length(dArray2) - d2);
        System.out.println(dArrayArray[0][0] + " " + dArrayArray[0][1]);
        System.out.println(dArrayArray[1][0] + " " + dArrayArray[1][1]);
        System.out.println(VecMath.lineCircleIntersection(dArrayArray, dArray5, dArray6, dArray7, d, dArray));
        VecMath.sub(dArray2, dArrayArray[0], dArray7);
        System.out.println(VecMath.length(dArray2) - d);
        VecMath.sub(dArray2, dArrayArray[1], dArray7);
        System.out.println(VecMath.length(dArray2) - d);
        System.out.println(dArrayArray[0][0] + " " + dArrayArray[0][1]);
        System.out.println(dArrayArray[1][0] + " " + dArrayArray[1][1]);
        double[] dArray9 = new double[]{1.0, 1.0};
        double[] dArray10 = new double[]{2.0, 1.0};
        double[] dArray11 = new double[]{3.0, 1.999};
        double[] dArray12 = new double[]{3.0, 2.001};
        System.out.println(VecMath.side(dArray9, dArray10, dArray11));
        System.out.println(VecMath.side(dArray9, dArray10, dArray12));
        System.out.println(VecMath.side(dArray9, dArray10, new double[]{3.0, 2.0}));
    }

    public static String toString(double[] dArray) {
        return VecMath.toString(dArray, "%6.3f");
    }

    public static String toString(double[] dArray, String string) {
        Object object = null;
        for (int i = 0; i < dArray.length; ++i) {
            object = object != null ? object + ", " : "";
            object = (String)object + String.format(Locale.US, string, dArray[i]);
        }
        return "[" + object + "]";
    }
}

