/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.planner;

import eazycnc.gcode.Machcode;
import eazycnc.planner.Quintics;
import java.io.Serializable;

public class Waypoint
implements Serializable {
    Machcode m_Machcode;
    int m_GeneratedDataSize;
    private static int m_IdCounter;
    int m_Id = m_IdCounter++;
    Waypoint m_Prev;
    Waypoint m_Next;
    double[] m_Position;
    double m_Tightness;
    double m_Speed;
    double m_DemandSpeed;
    double m_MaxSpeed;
    Quintics m_Quintics;
    double[] pa = new double[6];
    boolean pa_set = false;
    double[] pb = new double[6];
    boolean pb_set = false;
    int m_PlanCntr;
    int m_ArcPlane;
    boolean m_Clockwise;
    double[] m_Center;

    private static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        return String.format("[%f %f %f %f %f %f]", dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Waypoint ");
        stringBuffer.append(String.format("m_Id %d ", this.m_Id));
        stringBuffer.append(String.format("prev %d ", this.m_Prev != null ? this.m_Prev.m_Id : -1));
        stringBuffer.append(String.format("next %d ", this.m_Next != null ? this.m_Next.m_Id : -1));
        stringBuffer.append(String.format("m_Position %s  ", Waypoint.toString(this.m_Position)));
        if (this.m_Center != null) {
            stringBuffer.append(String.format("plane %d  ", this.m_ArcPlane));
            stringBuffer.append(String.format("next %d ", this.m_Next != null ? this.m_Next.m_Id : -1));
        }
        stringBuffer.append(String.format("m_Speed %1.1f ", this.m_Speed));
        stringBuffer.append(String.format("m_DemandSpeed %1.1f ", this.m_DemandSpeed));
        stringBuffer.append(String.format("m_MaxSpeed %1.1f ", this.m_MaxSpeed));
        stringBuffer.append(String.format("m_Tightness %1.1f ", this.m_Tightness));
        return stringBuffer.toString();
    }

    Waypoint(Machcode machcode, double d, double d2, double d3, double ... dArray) {
        this(machcode, d, d2, d3, false, 0, null, dArray);
    }

    Waypoint(Machcode machcode, double d, double d2, double d3, boolean bl, int n, double[] dArray, double ... dArray2) {
        this.m_Machcode = machcode;
        this.m_MaxSpeed = d2;
        this.m_DemandSpeed = d;
        this.m_Speed = d;
        this.m_Tightness = d3;
        this.m_Position = new double[dArray2.length > 3 ? dArray2.length : 3];
        System.arraycopy(dArray2, 0, this.m_Position, 0, dArray2.length);
        System.arraycopy(dArray2, 0, this.pa, 0, dArray2.length);
        System.arraycopy(dArray2, 0, this.pb, 0, dArray2.length);
        if (dArray != null) {
            this.m_Center = new double[dArray.length];
            System.arraycopy(dArray, 0, this.m_Center, 0, dArray.length);
            this.m_ArcPlane = n;
            this.m_Clockwise = bl;
        }
    }

    Waypoint addWaypoint(Waypoint waypoint) {
        this.m_Next = waypoint;
        waypoint.m_Prev = this;
        return waypoint;
    }

    private static double parseDouble(String string) {
        return Double.parseDouble(string);
    }

    private static int find(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            while (stringArray[++i].isEmpty()) {
            }
            return i;
        }
        return -1;
    }

    public Waypoint(String string) {
        String[] stringArray = string.split(" |\\[|\\]");
        int n = 0;
        n = Waypoint.find(stringArray, "m_Id");
        this.m_Id = Integer.parseInt(stringArray[n]);
        n = Waypoint.find(stringArray, "m_MaxSpeed");
        this.m_MaxSpeed = Waypoint.parseDouble(stringArray[n]);
        n = Waypoint.find(stringArray, "m_DemandSpeed");
        this.m_DemandSpeed = Waypoint.parseDouble(stringArray[n]);
        n = Waypoint.find(stringArray, "m_Speed");
        this.m_Speed = Waypoint.parseDouble(stringArray[n]);
        n = Waypoint.find(stringArray, "m_Tightness");
        this.m_Tightness = Waypoint.parseDouble(stringArray[n]);
        n = Waypoint.find(stringArray, "m_Position");
        this.m_Position = new double[]{Waypoint.parseDouble(stringArray[n++]), Waypoint.parseDouble(stringArray[n++]), Waypoint.parseDouble(stringArray[n++])};
        n = Waypoint.find(stringArray, "pa");
        this.pa = new double[]{Waypoint.parseDouble(stringArray[n++]), Waypoint.parseDouble(stringArray[n++]), Waypoint.parseDouble(stringArray[n++])};
        n = Waypoint.find(stringArray, "pb");
        this.pb = new double[]{Waypoint.parseDouble(stringArray[n++]), Waypoint.parseDouble(stringArray[n++]), Waypoint.parseDouble(stringArray[n++])};
    }
}

