/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.plugins;

import eazycnc.plugins.CustomJavaFileObject;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import javax.tools.JavaFileObject;

class PackageInternalsFinder {
    private ClassLoader classLoader;
    private static final String CLASS_FILE_EXTENSION = ".class";

    public PackageInternalsFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<JavaFileObject> find(String string) throws IOException {
        String string2 = string.replaceAll("\\.", "/");
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        Enumeration<URL> enumeration = this.classLoader.getResources(string2);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            arrayList.addAll(this.listUnder(string, uRL));
        }
        return arrayList;
    }

    private Collection<JavaFileObject> listUnder(String string, URL uRL) {
        File file = new File(uRL.getFile());
        if (file.isDirectory()) {
            return this.processDir(string, file);
        }
        return this.processJar(uRL);
    }

    private List<JavaFileObject> processJar(URL uRL) {
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        try {
            String string = uRL.toExternalForm().split("!")[0];
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            String string2 = jarURLConnection.getEntryName();
            int n = string2.length() + 1;
            Enumeration<JarEntry> enumeration = jarURLConnection.getJarFile().entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string3 = jarEntry.getName();
                if (!string3.startsWith(string2) || string3.indexOf(47, n) != -1 || !string3.endsWith(CLASS_FILE_EXTENSION)) continue;
                URI uRI = URI.create(string + "!/" + string3);
                String string4 = string3.replaceAll("/", ".");
                string4 = string4.replaceAll(".class$", "");
                arrayList.add(new CustomJavaFileObject(string4, uRI));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Wasn't able to open " + uRL + " as a jar file", exception);
        }
        return arrayList;
    }

    private List<JavaFileObject> processDir(String string, File file) {
        File[] fileArray;
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isFile() || !file2.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
            Object object = string + "." + file2.getName();
            object = ((String)object).replaceAll(".class$", "");
            arrayList.add(new CustomJavaFileObject((String)object, file2.toURI()));
        }
        return arrayList;
    }
}

