/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.plugins;

import com.eazycnc.plugin.MachController;
import com.eazycnc.plugin.Plugin;
import eazycnc.Dictionary;
import eazycnc.Main;
import eazycnc.PluginMethods;
import eazycnc.plugins.CustomClassloaderJavaFileManager;
import eazycnc.plugins.PluginClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class PluginManager {
    private String m_LastInitError;
    private LinkedHashMap<String, Plugin> m_Plugins = new LinkedHashMap();
    private LinkedList<PluginClassLoader> m_PluginClassLoaders = new LinkedList();
    private String m_PluginsDir;
    private String m_CacheDir;
    private String m_DataDir;
    private LinkedList<Class> m_PluginClasses = new LinkedList();
    private Hashtable<Class, Dictionary> m_Dictionaries = new Hashtable();
    private Hashtable<Class, Class> m_ResourceLoaders = new Hashtable();

    public PluginManager() {
        String string = System.getProperty("user.home");
        String string2 = string + File.separator + "EazyCNC" + File.separator;
        this.m_PluginsDir = string2 + "plugins" + File.separator;
        this.m_CacheDir = string2 + "plugins-cached" + File.separator;
        this.m_DataDir = string2 + "plugins-data" + File.separator;
        if (!new File(this.m_PluginsDir).exists() && !new File(this.m_PluginsDir).mkdirs()) {
            System.err.println("Failed to create '" + this.m_PluginsDir + "'");
        }
        if (!new File(this.m_CacheDir).exists() && !new File(this.m_CacheDir).mkdirs()) {
            System.err.println("Failed to create '" + this.m_CacheDir + "'");
        }
    }

    public String getPluginsDir() {
        return this.m_PluginsDir;
    }

    public Dictionary getDictionary(Class clazz) {
        return this.m_Dictionaries.get(clazz);
    }

    public Class getResourceLoaderClass(Class clazz) {
        return this.m_ResourceLoaders.get(clazz);
    }

    public String getLastInitError() {
        return this.m_LastInitError;
    }

    private Plugin createPlugin() {
        return new Plugin(){

            public void onLoad() {
                System.out.println("Load plugin " + this.getClass().getName());
            }

            public void onLoadDocument() {
            }
        };
    }

    private String installPlugInClasssesJar() {
        try {
            String string = "EazyCNC-plugin-classes.jar";
            String string2 = this.m_CacheDir + string;
            InputStream inputStream = Main.class.getResourceAsStream(string);
            if (inputStream != null) {
                int n;
                byte[] byArray = new byte[131072];
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                while ((n = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public boolean compilePlugin(PluginClassLoader pluginClassLoader, String string) throws NoClassDefFoundError {
        try {
            if (!string.endsWith(".java")) {
                throw new IllegalArgumentException(".java file expected");
            }
            Object object2 = string.substring(this.m_PluginsDir.length() + pluginClassLoader.getPluginHomeDir().length());
            object2 = ((String)object2).substring(0, ((String)object2).length() - 5) + ".class";
            String string2 = this.m_CacheDir + pluginClassLoader.getPluginHomeDir();
            File file = new File(string2 + (String)object2);
            File file2 = new File(string);
            if (file.exists()) {
                if (file.lastModified() > file2.lastModified()) {
                    pluginClassLoader.addClassFile(string2 + (String)object2);
                    return true;
                }
                System.out.println("...class file for '" + string + "' is stale, compiling from source...");
            } else {
                System.out.println("...class file  for '" + string + "' missing, compiling from source...");
            }
            Object object3 = this.m_CacheDir + "EazyCNC-plugin-classes.jar";
            object3 = this.installPlugInClasssesJar();
            File file3 = new File(string2);
            file3.mkdirs();
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object4 = System.getProperty("java.class.path");
            object4 = (String)object4 + File.pathSeparator + (String)object3;
            for (String object5 : pluginClassLoader.getJars()) {
                object4 = (String)object4 + File.pathSeparator + object5;
            }
            arrayList.addAll(Arrays.asList("-d", string2));
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            if (javaCompiler == null) {
                System.err.println("Java compiler not available!");
                return false;
            }
            DiagnosticListener diagnosticListener = new DiagnosticListener(){

                public void report(Diagnostic diagnostic) {
                    if (diagnostic.getMessage(null).startsWith("No file system provider is available to handle this file:")) {
                        return;
                    }
                    System.err.println("diagnostic '" + diagnostic.getMessage(null) + "'");
                }
            };
            StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticListener, null, null);
            CustomClassloaderJavaFileManager customClassloaderJavaFileManager = new CustomClassloaderJavaFileManager(pluginClassLoader, standardJavaFileManager);
            Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(file2));
            boolean bl = javaCompiler.getTask(null, customClassloaderJavaFileManager, null, arrayList, null, iterable).call();
            if (bl) {
                System.out.println("...... compiled OK");
                pluginClassLoader.addClassFile(string2 + (String)object2);
            } else {
                System.err.println("...FAILED!");
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String fileToClassName(String string) {
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        } else if (string.endsWith(".java")) {
            string = string.substring(0, string.length() - 5);
        }
        return string.replaceAll("\\" + File.separator, ".");
    }

    private String classToFileName(String string) {
        return string.replaceAll("\\.", File.separator) + ".class";
    }

    public void scanForPluginClasses(PluginClassLoader pluginClassLoader, String string) {
        String[] stringArray = new File(string).list();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (string2.startsWith(".")) continue;
                String string3 = string + string2;
                if (new File(string3).isDirectory()) {
                    this.scanForPluginClasses(pluginClassLoader, string3 + File.separator);
                    continue;
                }
                if (string3.endsWith(".java")) {
                    pluginClassLoader.addJavaFile(string3);
                    continue;
                }
                if (string3.endsWith(".class")) {
                    pluginClassLoader.addClassFile(string3);
                    continue;
                }
                if (!string3.endsWith(".jar")) continue;
                pluginClassLoader.addJarFile(string3);
            }
        }
    }

    public void setResourceClass(Class clazz) {
        Class clazz2 = this.getCallingPluginsClass();
        if (clazz2 == null) {
            throw new IllegalArgumentException("setResourceLoaderClass can only be called from within a plugin");
        }
        this.setResourceLoaderClass(clazz2, clazz);
    }

    public void setResourceLoaderClass(Class clazz, Class clazz2) {
        this.m_ResourceLoaders.put(clazz, clazz2);
    }

    public Plugin getPlugin(String string) {
        return this.m_Plugins.get(string);
    }

    public void instantiatePlugins(String string, PluginMethods pluginMethods, MachController machController) {
        for (Class clazz : this.m_PluginClasses) {
            try {
                System.out.println("Instantiating plugin: '" + PluginManager.getPluginName(clazz) + "'");
                for (Plugin plugin : this.m_Plugins.values()) {
                    if (!plugin.getClass().getCanonicalName().equals(clazz.getCanonicalName())) continue;
                    System.err.println("...PLUGIN WARNING: plugin with class name '" + clazz.getCanonicalName() + "' already loaded");
                }
                Plugin plugin = (Plugin)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.setMachController(machController);
                Dictionary object2 = new Dictionary("...did not");
                object2.load(plugin.getClass(), "strings.properties");
                this.m_Dictionaries.put(plugin.getClass(), object2);
                pluginMethods.registerMethods(plugin);
                try {
                    plugin.onInit();
                    plugin.onLoad(PluginManager.getPluginDataFilePath(plugin));
                    this.m_Plugins.put(PluginManager.getPluginHomeDir(plugin) + plugin.getClass().getCanonicalName(), plugin);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.m_LastInitError = PluginManager.getPluginName(plugin) + " " + illegalArgumentException.getMessage();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    System.err.println("...failed to initialize: " + exception.getClass().getSimpleName() + " " + exception.getMessage());
                    this.m_LastInitError = PluginManager.getPluginName(plugin) + exception.getClass().getSimpleName() + " " + exception.getMessage();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String getPluginDataFilePath(Plugin plugin) {
        if (!(plugin.getClass().getClassLoader() instanceof PluginClassLoader)) {
            return null;
        }
        PluginClassLoader pluginClassLoader = (PluginClassLoader)plugin.getClass().getClassLoader();
        String string = pluginClassLoader.getDataDirPath() + pluginClassLoader.getPluginHomeDir();
        new File(string).mkdirs();
        return string + plugin.getClass().getCanonicalName();
    }

    public static String getPluginHomeDir(Plugin plugin) {
        try {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)plugin.getClass().getClassLoader();
            return pluginClassLoader.getPluginHomeDir();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPluginHomeDirPath(Plugin plugin) {
        try {
            PluginClassLoader pluginClassLoader = (PluginClassLoader)plugin.getClass().getClassLoader();
            return pluginClassLoader.getPluginsDirPath() + pluginClassLoader.getPluginHomeDir();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPluginName(Plugin plugin) {
        return PluginManager.getPluginName(plugin.getClass());
    }

    public static String getPluginName(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (!(classLoader instanceof PluginClassLoader)) {
            return clazz.getCanonicalName();
        }
        return ((PluginClassLoader)classLoader).getPluginHomeDir() + clazz.getCanonicalName();
    }

    public void loadPluginClasses() {
        System.out.println("Scan for plugins in '" + this.m_PluginsDir + "'");
        String[] stringArray = new File(this.m_PluginsDir).list();
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string.startsWith(".") || !new File(this.m_PluginsDir + (String)string).isDirectory()) continue;
                try {
                    PluginClassLoader pluginClassLoader = new PluginClassLoader(this.m_PluginsDir, this.m_CacheDir, this.m_DataDir, (String)string + File.separator);
                    this.m_PluginClassLoaders.add(pluginClassLoader);
                    this.scanForPluginClasses(pluginClassLoader, this.m_PluginsDir + (String)string + File.separator);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        for (PluginClassLoader pluginClassLoader : this.m_PluginClassLoaders) {
            for (String string : pluginClassLoader.getJavaFiles()) {
                this.compilePlugin(pluginClassLoader, string);
            }
        }
        for (PluginClassLoader pluginClassLoader : this.m_PluginClassLoaders) {
            LinkedList<Class> linkedList = pluginClassLoader.findPluginClasses();
            this.m_PluginClasses.addAll(linkedList);
        }
        this.m_PluginClasses.add(eazycam.Plugin.class);
    }

    public Collection<Plugin> getPlugins() {
        return this.m_Plugins.values();
    }

    public Class getCallingPluginsClass() {
        long l = System.nanoTime();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = null;
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        block4: for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            String string = stackTraceElementArray[i].getClassName();
            try {
                classLoader2.loadClass(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                for (Plugin plugin : this.m_Plugins.values()) {
                    try {
                        clazz = plugin.getClass().getClassLoader().loadClass(string);
                        break block4;
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                    }
                }
            }
        }
        long l2 = System.nanoTime();
        return clazz;
    }
}

