/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.toad.simu;

import eazycnc.toad.simu.StepperState;

class CmdInterp
extends StepperState {
    static final int MAX_ARGS = 7;
    static final byte ARG_OK = 0;
    static final byte ARG_QUEUE_FULL = 1;
    static final byte ARG_MISSING = 2;
    static final byte ARG_POS = 3;
    static final byte ARG_NEG = 4;
    static final byte ARG_WILDCARD = 5;
    static final byte ARG_OVERFLOW = 6;
    static final byte ARG_BAD_MOTOR = 7;
    static final byte ARG_TOO_MANY = 8;
    static final byte ARG_MIN = 9;
    static final byte ARG_MAX = 10;
    static final byte ARG_BAD_COMMAND = 11;
    static final byte ARG_LINE_TOO_LONG = 12;
    static final int MAX_LINE_LEN = 32;
    static final int MAX_RESP = 48;
    final byte CMD_MOVE_REVERSE = 0;
    final byte CMD_MOVE_FORWARD = 1;
    final byte CMD_JOG_REVERSE = (byte)2;
    final byte CMD_JOG_FORWARD = (byte)3;
    final byte CMD_RAMP_UP_REVERSE = (byte)4;
    final byte CMD_RAMP_UP_FORWARD = (byte)5;
    final byte CMD_RAMP_DOWN_REVERSE = (byte)6;
    final byte CMD_RAMP_DOWN_FORWARD = (byte)7;
    final byte CMD_RESET_QUEUE = (byte)8;
    final byte CMD_ENABLE_QUEUE = (byte)9;
    final byte CMD_QUEUE_STATE = (byte)10;
    final byte CMD_MOTOR_STATE = (byte)11;
    final byte CMD_SET_MODE = (byte)12;
    final byte CMD_SEEK_HOME = (byte)13;
    final byte CMD_CTRL_JOG = (byte)14;
    final byte CMD_SET_POS = (byte)15;
    final byte CMD_GET_POS = (byte)16;
    final byte CMD_GET_VERSION = (byte)17;
    final byte CMD_ARM_PROBE = (byte)18;
    final byte CMD_GET_PROBE_POS = (byte)19;
    final byte CMD_CONFIG_PROBE = (byte)20;
    final byte CMD_SET_OUTPUT = (byte)21;
    final byte CMD_GET_INPUT = (byte)22;
    byte linelen;
    boolean lineTooLong;
    byte[] linebuffer;
    int lptr;
    byte forward;
    byte rampup;
    byte motor;
    byte cmd = (byte)(this.motor >> 3);
    byte[] rbuffer = new byte[48];
    int rlen = 0;
    int position;
    private long T0;

    CmdInterp() {
    }

    void binaryOut(byte by) {
        this.rbuffer[this.rlen++] = by;
    }

    byte parseByte() {
        this.linelen = (byte)(this.linelen - 1);
        return this.linebuffer[this.lptr++];
    }

    short parseDoubleByte() {
        return (short)((this.parseByte() & 0xFF) << 8 | this.parseByte() & 0xFF);
    }

    int parseQuadByte() {
        return (this.parseDoubleByte() & 0xFFFF) << 16 | this.parseDoubleByte() & 0xFFFF;
    }

    private void missing_data() {
        this.binaryOut((byte)2);
    }

    private void queue_full() {
        this.binaryOut((byte)1);
    }

    private void move() {
        if (this.linelen < 4) {
            this.missing_data();
        } else if (0 == this.stepperMove(this.motor, (byte)15, this.forward, this.parseDoubleByte(), this.parseDoubleByte())) {
            this.queue_full();
        } else {
            this.binaryOut((byte)0);
        }
    }

    private void jog() {
        if (this.linelen < 10) {
            this.missing_data();
        } else if (0 == this.stepperJog(this.motor, this.parseDoubleByte(), this.parseDoubleByte(), this.parseDoubleByte(), this.forward, this.parseDoubleByte(), this.parseDoubleByte(), this.parseQuadByte())) {
            this.queue_full();
        } else {
            this.binaryOut((byte)0);
        }
    }

    int processMessage(byte[] byArray, byte[] byArray2) {
        byte by;
        this.linebuffer = byArray;
        this.rbuffer = byArray2;
        this.lptr = 1;
        this.rlen = 1;
        if (byArray.length < 1 || (byArray[0] & 0xFF) < 128) {
            throw new IllegalArgumentException("Bad line");
        }
        this.linelen = (byte)(byArray[0] & 0x7F);
        if (this.linelen >= 32) {
            throw new IllegalArgumentException("Bad checksum");
        }
        this.linelen = (byte)(this.linelen - 1);
        int n = 85;
        int n2 = 0;
        for (n2 = 1; n2 <= this.linelen; ++n2) {
            n = (byte)(n + this.linebuffer[n2]);
        }
        if (this.linebuffer[n2] != n) {
            throw new IllegalArgumentException("Bad checksum");
        }
        block26: while (true) {
            byte by2 = this.linelen;
            this.linelen = (byte)(by2 - 1);
            if (by2 == 0) break;
            this.motor = this.linebuffer[this.lptr++];
            this.cmd = (byte)(this.motor >> 3 & 0x1F);
            this.motor = (byte)(this.motor & 7);
            switch (this.cmd) {
                case 21: {
                    if (this.linelen < 2) {
                        this.missing_data();
                        continue block26;
                    }
                    by = this.parseByte();
                    byte by3 = this.parseByte();
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 22: {
                    if (this.linelen < 1) {
                        this.missing_data();
                        continue block26;
                    }
                    this.parseByte();
                    this.binaryOut((byte)0);
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 20: {
                    if (this.linelen < 2) {
                        this.missing_data();
                        continue block26;
                    }
                    this.stepperConfigProbe(this.parseByte(), this.parseByte());
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 18: {
                    if (this.linelen < 4) {
                        this.missing_data();
                        continue block26;
                    }
                    this.stepperArmProbe(this.motor, this.parseDoubleByte(), this.parseDoubleByte());
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 19: {
                    this.position = this.stepperGetProbePosition(this.motor);
                    this.binaryOut((byte)0);
                    this.binaryOut((byte)(this.position >> 24 & 0xFF));
                    this.binaryOut((byte)(this.position >> 16 & 0xFF));
                    this.binaryOut((byte)(this.position >> 8 & 0xFF));
                    this.binaryOut((byte)(this.position >> 0 & 0xFF));
                    continue block26;
                }
                case 10: {
                    this.binaryOut((byte)0);
                    this.binaryOut(this.stepperGetState(this.motor));
                    this.binaryOut(this.stepperQueueSize(this.motor));
                    this.binaryOut(this.stepperQueueCapacity(this.motor));
                    continue block26;
                }
                case 11: {
                    this.binaryOut((byte)0);
                    this.binaryOut(this.stepperGetState(this.motor));
                    continue block26;
                }
                case 8: {
                    this.binaryOut((byte)0);
                    this.stepperAbort(this.motor);
                    continue block26;
                }
                case 9: {
                    this.binaryOut((byte)0);
                    this.stepperGo(this.motor);
                    continue block26;
                }
                case 12: {
                    if (this.linelen < 5) {
                        this.missing_data();
                        continue block26;
                    }
                    this.stepperSetMode(this.motor, this.parseByte(), this.parseByte(), this.parseByte(), this.parseByte(), this.parseByte());
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 13: {
                    if (this.linelen < 10) {
                        this.missing_data();
                        continue block26;
                    }
                    if (0 == this.stepperSeekHome(this.motor, this.parseDoubleByte(), this.parseDoubleByte(), this.parseDoubleByte(), this.parseQuadByte())) {
                        this.queue_full();
                        continue block26;
                    }
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 2: {
                    this.forward = 0;
                    this.jog();
                    continue block26;
                }
                case 3: {
                    this.forward = 1;
                    this.jog();
                    continue block26;
                }
                case 14: {
                    if (this.linelen < 2) {
                        this.missing_data();
                        continue block26;
                    }
                    this.stepperSetJogFlag(this.motor, this.parseDoubleByte());
                    this.binaryOut((byte)0);
                    continue block26;
                }
                case 15: {
                    this.binaryOut((byte)0);
                    if (this.linelen < 4) {
                        this.missing_data();
                        continue block26;
                    }
                    this.position = this.parseByte();
                    this.position = this.position << 8 | 0xFF & this.parseByte();
                    this.position = this.position << 8 | 0xFF & this.parseByte();
                    this.position = this.position << 8 | 0xFF & this.parseByte();
                    this.stepperSetPosition(this.motor, this.position);
                    continue block26;
                }
                case 16: {
                    this.position = this.stepperGetPosition(this.motor);
                    this.binaryOut((byte)0);
                    this.binaryOut((byte)(this.position >> 24 & 0xFF));
                    this.binaryOut((byte)(this.position >> 16 & 0xFF));
                    this.binaryOut((byte)(this.position >> 8 & 0xFF));
                    this.binaryOut((byte)(this.position >> 0 & 0xFF));
                    continue block26;
                }
                case 0: {
                    this.forward = 0;
                    this.move();
                    continue block26;
                }
                case 1: {
                    this.forward = 1;
                    this.move();
                    continue block26;
                }
                case 4: {
                    this.forward = 0;
                    this.rampup = 1;
                    continue block26;
                }
                case 5: {
                    this.forward = 1;
                    this.rampup = 1;
                    continue block26;
                }
                case 6: {
                    this.forward = 0;
                    this.rampup = 0;
                    continue block26;
                }
                case 7: {
                    this.forward = 1;
                    this.rampup = 0;
                    continue block26;
                }
                case 17: {
                    String string = "0.0.0.1";
                    this.binaryOut((byte)0);
                    n2 = 0;
                    while (true) {
                        if (n2 >= 16) continue block26;
                        this.binaryOut((byte)(n2 < string.length() ? string.charAt(n2) : (char)'\u0000'));
                        ++n2;
                    }
                }
            }
            this.binaryOut((byte)11);
            this.binaryOut(this.cmd);
        }
        n = 85;
        this.rbuffer[0] = (byte)(this.rlen + 1 | 0x80);
        n2 = 1;
        while (--this.rlen != 0) {
            by = this.rbuffer[n2++];
            n = (byte)(n + by);
        }
        this.rbuffer[n2++] = n;
        return n2;
    }
}

