/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.toad.simu;

import eazycnc.toad.simu.Stepper;
import eazycnc.toad.simu.StepperCmd;

class CmdQueue {
    static final int QUEUE_CAPACITY = 16;
    volatile StepperCmd[] queue = new StepperCmd[16];

    CmdQueue() {
        for (int i = 0; i < 16; ++i) {
            this.queue[i] = new StepperCmd();
        }
    }

    static boolean queueFull(Stepper stepper) {
        return stepper.size >= 16;
    }

    static boolean queueEmpty(Stepper stepper) {
        return stepper.size == 0;
    }

    static void pushQueue(Stepper stepper) {
        byte by = stepper.rear;
        by = by < 15 ? (byte)(by + 1) : (byte)0;
        stepper.rear = by;
        stepper.size = (byte)(stepper.size + 1);
    }

    static void popQueue(Stepper stepper) {
        byte by = stepper.front;
        by = by < 15 ? (byte)(by + 1) : (byte)0;
        stepper.front = by;
        stepper.size = (byte)(stepper.size - 1);
    }

    static StepperCmd queueRear(Stepper stepper, CmdQueue cmdQueue) {
        return cmdQueue.queue[stepper.rear];
    }

    static StepperCmd queueFront(Stepper stepper, CmdQueue cmdQueue) {
        return cmdQueue.queue[stepper.front];
    }

    static byte queueSize(Stepper stepper) {
        return stepper.size;
    }

    static byte queueCapacity(Stepper stepper) {
        return 16;
    }

    static void queueInit(byte by, Stepper stepper) {
        stepper.size = 0;
        stepper.rear = by;
        stepper.front = by;
    }

    static void queueClear(Stepper stepper) {
        stepper.front = 0;
        stepper.rear = 0;
        stepper.size = 0;
    }
}

