/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.toad.simu;

import eazycnc.toad.simu.CaptureData;
import eazycnc.toad.simu.CmdQueue;
import eazycnc.toad.simu.Stepper;
import eazycnc.toad.simu.StepperCmd;

public class StepperState {
    boolean g_probeArmed;
    boolean g_probeTriggered;
    volatile byte syncCounter;
    volatile Stepper[] m_Steppers;
    volatile int[] m_ProbeSimuPos = new int[]{1000, 0, 0, 0};
    volatile CmdQueue[] m_Queues;
    volatile boolean[] m_Home;
    volatile boolean[] m_HomePolarity = new boolean[]{false, false, false, false};
    volatile int[] m_HomePos = new int[]{0, 0, 0, 0};
    volatile int[] m_HomeHyst = new int[]{100, 100, 100, 100};
    volatile Object m_IntSema4;
    volatile Object m_Debug;
    volatile int m_IntCnt;
    volatile int[] m_Positions = new int[5];
    volatile long t1;
    final int INITIAL_CAPTURE_CAPACITY = 1000;
    final double CAPTURE_EXPANSION_FACTOR = 1.2;
    volatile boolean m_CaptureON;
    volatile CaptureData[] m_CaptureData;
    volatile int m_CaptureSize;
    volatile int m_CaptureCapacity;
    volatile byte STEP_X;
    volatile byte STEP_X_TRIS;
    volatile byte STEP_Y;
    volatile byte STEP_Y_TRIS;
    volatile byte STEP_Z;
    volatile byte STEP_Z_TRIS;
    volatile byte DIR_X;
    volatile byte DIR_X_TRIS;
    volatile byte DIR_Y;
    volatile byte DIR_Y_TRIS;
    volatile byte DIR_Z;
    volatile byte DIR_Z_TRIS;
    volatile byte MODE1_X;
    volatile byte MODE1_X_TRIS;
    volatile byte MODE1_Y;
    volatile byte MODE1_Y_TRIS;
    volatile byte MODE1_Z;
    volatile byte MODE1_Z_TRIS;
    volatile byte ENABLE_X;
    volatile byte ENABLE_X_TRIS;
    volatile byte ENABLE_Y;
    volatile byte ENABLE_Y_TRIS;
    volatile byte ENABLE_Z;
    volatile byte ENABLE_Z_TRIS;
    volatile byte TQ1_X;
    volatile byte TQ1_X_TRIS;
    volatile byte TQ2_X;
    volatile byte TQ2_X_TRIS;
    volatile byte TQ1_Y;
    volatile byte TQ1_Y_TRIS;
    volatile byte TQ2_Y;
    volatile byte TQ2_Y_TRIS;
    volatile byte TQ1_Z;
    volatile byte TQ1_Z_TRIS;
    volatile byte TQ2_Z;
    volatile byte TQ2_Z_TRIS;
    volatile byte DCY1_X;
    volatile byte DCY1_X_TRIS;
    volatile byte DCY1_Y;
    volatile byte DCY1_Y_TRIS;
    volatile byte DCY1_Z;
    volatile byte DCY1_Z_TRIS;
    volatile byte HOME_X;
    volatile byte HOME_X_TRIS;
    volatile byte HOME_Y;
    volatile byte HOME_Y_TRIS;
    volatile byte HOME_Z;
    volatile byte HOME_Z_TRIS;
    volatile byte LED_PIN;
    volatile byte LED_TRIS;
    volatile byte RELAY_PIN;
    volatile byte RELAY_TRIS;
    volatile boolean probeInput;
    static final byte FALSE = 0;
    static final byte TRUE = 1;
    int prevState;

    byte FORWARD(Stepper stepper) {
        return stepper.forwardDir;
    }

    byte REVERSE(Stepper stepper) {
        return (byte)(stepper.forwardDir ^ 1);
    }

    StepperState() {
        this.m_Positions[0] = 200;
        this.m_Positions[1] = 400;
        this.m_Positions[2] = 600;
        this.m_Positions[3] = 800;
        this.INITIAL_CAPTURE_CAPACITY = 1000;
        this.CAPTURE_EXPANSION_FACTOR = 1.2;
        this.m_CaptureSize = 0;
        this.prevState = -1;
        this.m_Steppers = new Stepper[4];
        this.m_Queues = new CmdQueue[4];
        this.m_Home = new boolean[4];
        this.m_IntSema4 = new Object();
        for (int i = 0; i < 4; ++i) {
            this.m_Steppers[i] = new Stepper();
            this.m_Queues[i] = new CmdQueue();
        }
    }

    void stepperInit(byte by) {
        Stepper stepper = this.m_Steppers[by];
        CmdQueue cmdQueue = this.m_Queues[by];
        stepper.state = 0;
        CmdQueue.queueInit(this.syncCounter, stepper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stepperAbort(byte by) {
        Stepper stepper = this.m_Steppers[by];
        CmdQueue cmdQueue = this.m_Queues[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            stepper.state = 0;
            stepper.stepCounter = 0;
            CmdQueue.queueInit(this.syncCounter, stepper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperGetState(byte by) {
        byte by2;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            by2 = stepper.cmd != 0 ? (byte)16 : (byte)stepper.state;
        }
        if (this.g_probeTriggered) {
            by2 = (byte)(by2 | 0x80);
        }
        return by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stepperGetPosition(byte by) {
        int n;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            n = stepper.position;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stepperSetPosition(byte by, int n) {
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            stepper.position = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stepperGo(byte by) {
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            if (stepper.state < 2) {
                stepper.state = (byte)2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperQueueSize(byte by) {
        byte by2;
        Stepper stepper = this.m_Steppers[by];
        CmdQueue cmdQueue = this.m_Queues[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            by2 = CmdQueue.queueSize(stepper);
        }
        return by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperQueueCapacity(byte by) {
        byte by2;
        Stepper stepper = this.m_Steppers[by];
        CmdQueue cmdQueue = this.m_Queues[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            by2 = CmdQueue.queueCapacity(stepper);
        }
        return by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperMove(byte by, byte by2, byte by3, short s, short s2) {
        byte by4 = 0;
        Stepper stepper = this.m_Steppers[by];
        CmdQueue cmdQueue = this.m_Queues[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            if (!CmdQueue.queueFull(stepper)) {
                StepperCmd stepperCmd = CmdQueue.queueRear(stepper, cmdQueue);
                stepperCmd.moveSpeed = s2;
                stepperCmd.moveDistance = s;
                CmdQueue.pushQueue(stepper);
                by4 = 1;
            }
        }
        return by4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stepperSetJogFlag(byte by, short s) {
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            stepper.jogFlag = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short stepperGetJogFlag(byte by) {
        short s;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            s = stepper.jogFlag;
        }
        return s;
    }

    byte stepperGetHome(byte by) {
        return (byte)((this.m_Home[by] ? (byte)1 : 0) == this.m_Steppers[0].home ? 1 : 0);
    }

    void stepperSetMode(byte by, byte by2, byte by3, byte by4, byte by5, byte by6) {
        switch (by) {
            case 0: {
                this.m_Steppers[0].forwardDir = by5;
                this.m_Steppers[0].home = by6;
                this.m_Steppers[0].syncMask = by2;
                this.ENABLE_X = by3;
                break;
            }
            case 1: {
                this.m_Steppers[1].forwardDir = by5;
                this.m_Steppers[1].home = by6;
                this.m_Steppers[1].syncMask = by2;
                this.ENABLE_Y = by3;
                break;
            }
            case 2: {
                this.m_Steppers[2].forwardDir = by5;
                this.m_Steppers[2].home = by6;
                this.m_Steppers[2].syncMask = by2;
                this.ENABLE_Z = by3;
                break;
            }
            case 3: {
                this.m_Steppers[3].syncMask = by2;
                break;
            }
        }
    }

    private void printf_tiny(String string, Object ... objectArray) {
        System.out.printf(string, objectArray);
    }

    void stepperDump(byte by) {
        Stepper stepper = this.m_Steppers[by];
        CmdQueue cmdQueue = this.m_Queues[by];
        Stepper stepper2 = this.m_Steppers[by];
        this.printf_tiny("MOTOR        %d\n", by);
        this.printf_tiny("state        %d\n", stepper.state);
        this.printf_tiny("accelNCO     %d\n", stepper.accelNCO);
        this.printf_tiny("speedNCO     %d\n", stepper.speedNCO);
        this.printf_tiny("position     %d\n", stepper.position);
        this.printf_tiny("stepCounter  %d\n", stepper.stepCounter);
        this.printf_tiny("motorSpeed   %d\n", stepper.motorSpeed);
        this.printf_tiny("acceleration %d\n", stepper.acceleration);
        this.printf_tiny("queue size   %d\n", stepper2.size);
        this.printf_tiny("queue rear   %d\n", stepper2.rear);
        this.printf_tiny("queue front  %d\n", stepper2.front);
        this.printf_tiny("\n", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperSeekHome(byte by, short s, short s2, short s3, int n) {
        byte by2 = 0;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            if (stepper.state == 1) {
                stepper.state = (byte)2;
            }
            if (stepper.state == 2 && stepper.cmd == 0) {
                stepper.cmd = (byte)3;
                stepper.seekLoSpeed = s;
                stepper.seekHiSpeed = s2;
                stepper.seekTimeout = n;
                stepper.seekAcceleration = s3;
                by2 = 1;
            }
        }
        return by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperJog(byte by, short s, short s2, short s3, byte by2, short s4, short s5, int n) {
        byte by3 = 0;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            if (stepper.state == 1) {
                stepper.state = (byte)2;
            }
            if (stepper.state == 2 && stepper.cmd == 0) {
                stepper.cmd = (byte)4;
                stepper.jogForward = by2;
                stepper.jogPorch = s4;
                stepper.jogCrawl = s5;
                stepper.jogAcceleration = s3;
                stepper.jogLoSpeed = s;
                stepper.jogHiSpeed = s2;
                stepper.jogTimeout = n;
                by3 = 1;
            }
        }
        return by3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperArmProbe(byte by, short s, short s2) {
        byte by2 = 0;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            boolean bl = this.g_probeArmed = s != 0;
            if (!this.g_probeArmed) {
                this.g_probeTriggered = false;
            }
        }
        return by2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte stepperConfigProbe(byte by, byte by2) {
        byte by3 = 0;
        Object object = this.m_IntSema4;
        synchronized (object) {
        }
        return by3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stepperGetProbePosition(byte by) {
        int n;
        Stepper stepper = this.m_Steppers[by];
        Object object = this.m_IntSema4;
        synchronized (object) {
            n = this.g_probeTriggered ? stepper.probePosition : Integer.MIN_VALUE;
        }
        return n;
    }

    private static byte not(byte by) {
        return (byte)(by == 0 ? 1 : 0);
    }

    private static int unsigned(short s) {
        return s & 0xFFFF;
    }

    protected void interruptIrq() {
        byte by;
        boolean bl;
        short s;
        short s2;
        Stepper stepper;
        int n;
        byte by2 = this.m_Steppers[0].state;
        if (this.prevState != by2) {
            this.prevState = by2;
        }
        boolean bl2 = false;
        this.m_Positions[0] = this.m_IntCnt++;
        boolean bl3 = this.probeInput = this.m_Steppers[0].position >= this.m_ProbeSimuPos[0] && this.m_Steppers[1].position >= this.m_ProbeSimuPos[1] && this.m_Steppers[2].position >= this.m_ProbeSimuPos[2] && this.m_Steppers[3].position >= this.m_ProbeSimuPos[3];
        if (this.probeInput && this.g_probeArmed && !this.g_probeTriggered) {
            this.g_probeTriggered = true;
            this.m_Steppers[0].probePosition = this.m_Steppers[0].position;
            this.m_Steppers[1].probePosition = this.m_Steppers[1].position;
            this.m_Steppers[2].probePosition = this.m_Steppers[2].position;
            this.m_Steppers[3].probePosition = this.m_Steppers[3].position;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl4 = false;
        for (n = 0; n < 4; ++n) {
            stepper = this.m_Steppers[n];
            int n4 = this.m_HomePos[n] - (this.m_Home[n] ? 0 : this.m_HomeHyst[n]);
            this.m_Home[n] = stepper.position < n4;
            s2 = this.m_Home[n] == this.m_HomePolarity[n] ? (short)1 : 0;
            boolean bl5 = false;
            if (stepper.jogFlag != 0) {
                stepper.jogFlag = (short)(stepper.jogFlag - 1);
            }
            if (stepper.stepCounter != 0) {
                s = stepper.speedNCO;
                stepper.speedNCO = (short)(stepper.speedNCO + stepper.motorSpeed);
                if (stepper.speedNCO < s && stepper.motorSpeed != 0) {
                    bl5 = true;
                    bl2 = true;
                    --stepper.stepCounter;
                    stepper.position = stepper.forward != 0 ? ++stepper.position : --stepper.position;
                }
                s = stepper.accelNCO;
                stepper.accelNCO = (short)(stepper.accelNCO + stepper.acceleration);
                if (stepper.accelNCO < s) {
                    if (stepper.accelerate == 1) {
                        if (StepperState.unsigned(stepper.motorSpeed) < 65535) {
                            stepper.motorSpeed = (short)(stepper.motorSpeed + 1);
                        }
                    } else if (StepperState.unsigned(stepper.motorSpeed) > 1) {
                        stepper.motorSpeed = (short)(stepper.motorSpeed - 1);
                    }
                }
            }
            bl = stepper.stepCounter != 0;
            switch (stepper.state) {
                case 1: {
                    stepper.stepCounter = 0;
                    break;
                }
                case 3: {
                    if (n == 2) {
                        // empty if block
                    }
                    if (bl) break;
                    stepper.state = (byte)2;
                    CmdQueue.popQueue(stepper);
                    break;
                }
                case 15: {
                    if (stepper.motorSpeed < stepper.probeStopSpeed) {
                        stepper.state = (byte)17;
                        stepper.stepCounter = 0;
                        break;
                    }
                    stepper.stepCounter = 1;
                    break;
                }
                case 4: {
                    if (s2 == 0 && stepper.motorSpeed < stepper.seekHiSpeed) break;
                    stepper.motorSpeed = stepper.seekHiSpeed;
                    stepper.state = (byte)5;
                    stepper.acceleration = 0;
                    break;
                }
                case 5: {
                    if (s2 != 0) {
                        stepper.state = (byte)6;
                        stepper.accelerate = 0;
                        stepper.acceleration = stepper.seekAcceleration;
                        break;
                    }
                    if (bl) break;
                    stepper.state = 1;
                    break;
                }
                case 6: {
                    if (stepper.motorSpeed > stepper.seekLoSpeed) break;
                    stepper.state = (byte)11;
                    stepper.motorSpeed = stepper.seekLoSpeed;
                    stepper.acceleration = 0;
                    stepper.forward = 0;
                    by = (byte)(stepper.forwardDir != 1 ? 1 : 0);
                    break;
                }
                case 7: {
                    if (s2 != 0 && stepper.motorSpeed < stepper.seekHiSpeed) break;
                    stepper.motorSpeed = stepper.seekHiSpeed;
                    stepper.state = (byte)8;
                    stepper.acceleration = 0;
                    break;
                }
                case 8: {
                    if (s2 == 0) {
                        stepper.state = (byte)9;
                        stepper.accelerate = 0;
                        stepper.acceleration = stepper.seekAcceleration;
                        break;
                    }
                    if (stepper.stepCounter != 0) break;
                    stepper.state = 1;
                    break;
                }
                case 9: {
                    if (stepper.motorSpeed > stepper.seekLoSpeed) break;
                    stepper.state = (byte)10;
                    stepper.motorSpeed = stepper.seekLoSpeed;
                    stepper.acceleration = 0;
                    stepper.forward = 1;
                    by = stepper.forwardDir;
                    break;
                }
                case 10: {
                    if (s2 != 0) {
                        stepper.state = (byte)11;
                        stepper.forward = 0;
                        by = stepper.forwardDir;
                        break;
                    }
                    if (bl) break;
                    stepper.state = 1;
                    break;
                }
                case 11: {
                    if (s2 == 0) {
                        stepper.state = (byte)2;
                        stepper.stepCounter = 0;
                        break;
                    }
                    if (bl) break;
                    stepper.state = 1;
                    break;
                }
                case 12: {
                    if (stepper.jogPorch != 0) {
                        if (!bl) {
                            stepper.jogPorch = (short)(stepper.jogPorch - 1);
                        }
                        stepper.stepCounter = 1;
                        break;
                    }
                    stepper.state = (byte)13;
                }
                case 13: {
                    if (stepper.jogCrawl != 0) {
                        if (!bl) {
                            stepper.jogCrawl = (short)(stepper.jogCrawl - 1);
                            if (stepper.jogFlag == 0) {
                                stepper.stepCounter = 0;
                                stepper.state = (byte)2;
                                break;
                            }
                        }
                        stepper.stepCounter = 1;
                        break;
                    }
                    stepper.state = (byte)14;
                }
                case 14: {
                    if (stepper.jogTimeout != 0 && !bl) {
                        --stepper.jogTimeout;
                        stepper.stepCounter = 1;
                    }
                    if (bl) break;
                    if (stepper.jogFlag == 0 || stepper.jogTimeout == 0) {
                        if (StepperState.unsigned(stepper.motorSpeed) > StepperState.unsigned(stepper.jogLoSpeed)) {
                            stepper.accelerate = 0;
                            stepper.acceleration = stepper.jogAcceleration;
                            stepper.stepCounter = 1;
                            break;
                        }
                        stepper.state = (byte)2;
                        stepper.acceleration = 0;
                        stepper.stepCounter = 0;
                        break;
                    }
                    if (StepperState.unsigned(stepper.motorSpeed) < StepperState.unsigned(stepper.jogHiSpeed)) {
                        stepper.accelerate = 1;
                        stepper.acceleration = stepper.jogAcceleration;
                        stepper.stepCounter = 1;
                        break;
                    }
                    stepper.acceleration = 0;
                    stepper.stepCounter = 1;
                    break;
                }
            }
            stepper.pop = 0;
            if (stepper.syncMask == 0) continue;
            n2 = (byte)(n2 + 1);
            if (stepper.state != 2 || stepper.front != this.syncCounter || stepper.size == 0) continue;
            stepper.pop = 1;
            n3 = (byte)(n3 + 1);
        }
        if (n3 > 0 && n3 == n2) {
            bl4 = true;
            this.syncCounter = this.syncCounter == 15 ? (byte)0 : (byte)(this.syncCounter + 1);
        }
        for (n = 0; n < 4; ++n) {
            stepper = this.m_Steppers[n];
            if (bl4 && stepper.pop == 1) {
                stepper.state = (byte)3;
                stepper.cmd = 0;
                StepperCmd stepperCmd = CmdQueue.queueFront(stepper, this.m_Queues[n]);
                s2 = stepperCmd.moveDistance;
                if (s2 < 0) {
                    s2 = -s2;
                    s = 0;
                } else {
                    s = 1;
                }
                by = s != 0 ? this.FORWARD(stepper) : this.REVERSE(stepper);
                stepper.forward = s;
                stepper.motorSpeed = stepperCmd.moveSpeed;
                stepper.stepCounter = s2;
                stepper.acceleration = 0;
                stepper.accelerate = 0;
            }
            if (stepper.state == 2) {
                switch (stepper.cmd) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        stepper.state = (byte)12;
                        stepper.cmd = 0;
                        by = stepper.jogForward;
                        stepper.forward = stepper.jogForward;
                        stepper.stepCounter = 1;
                        stepper.motorSpeed = stepper.jogLoSpeed;
                        stepper.acceleration = 0;
                        break;
                    }
                    case 3: {
                        boolean bl6 = bl = this.m_Home[n] == this.m_HomePolarity[n];
                        if (bl) {
                            stepper.state = (byte)7;
                            stepper.cmd = 0;
                            by = this.REVERSE(stepper);
                            stepper.forward = 0;
                            stepper.stepCounter = stepper.seekTimeout;
                            stepper.acceleration = stepper.seekAcceleration;
                            stepper.accelerate = 1;
                            break;
                        }
                        stepper.state = (byte)4;
                        stepper.cmd = 0;
                        by = this.FORWARD(stepper);
                        stepper.forward = 1;
                        stepper.stepCounter = stepper.seekTimeout;
                        stepper.acceleration = stepper.seekAcceleration;
                        stepper.accelerate = 1;
                        break;
                    }
                }
            }
            this.m_Positions[1 + n] = stepper.position;
        }
        if (bl2 && this.m_CaptureON) {
            this.capture(new CaptureData(this.m_Positions, this.m_Debug));
        }
    }

    public void clearCapture() {
        this.m_CaptureON = false;
        this.m_CaptureData = null;
        this.m_CaptureSize = 0;
    }

    public void stopCapture() {
        this.m_CaptureON = false;
    }

    public void startCapture() {
        if (this.m_CaptureData == null) {
            this.m_CaptureData = new CaptureData[1000];
            this.m_CaptureSize = 0;
            this.m_CaptureCapacity = this.m_CaptureData.length;
        }
        this.m_CaptureON = true;
    }

    private void capture(CaptureData captureData) {
        while (this.m_CaptureSize >= this.m_CaptureCapacity) {
            CaptureData[] captureDataArray = new CaptureData[(int)((double)this.m_CaptureCapacity * 1.2)];
            System.arraycopy(this.m_CaptureData, 0, captureDataArray, 0, this.m_CaptureSize);
            this.m_CaptureData = captureDataArray;
            this.m_CaptureCapacity = this.m_CaptureData.length;
        }
        this.m_CaptureData[this.m_CaptureSize++] = captureData;
    }

    public CaptureData[] getCaptureData() {
        return this.m_CaptureData;
    }

    public int getCaptureDataSize() {
        return this.m_CaptureSize;
    }
}

