/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.toad.simu;

import eazycnc.toad.simu.CmdInterp;
import java.io.IOException;
import toad4.CommandFormatter;
import toad4.ResponseParser;
import toad4.ToadComm;

public class Toad4Simulator
extends CmdInterp
implements ToadComm {
    private volatile Thread m_Thread;
    private volatile boolean m_IsRunning;
    private volatile boolean m_Connected;
    private volatile byte[] m_RespBuffer = new byte[256];
    private volatile int m_RespLen = 0;
    static final int INT_FREQ = 23437;

    public void start() {
        if (this.m_Thread == null) {
            this.m_Thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    block14: {
                        try {
                            Toad4Simulator.this.m_IsRunning = true;
                            var1_1 = System.nanoTime();
                            var3_4 = 0L;
                            var5_5 = 0L;
                            while (true) {
                                if ((var7_6 = System.nanoTime() - var1_1 - var5_5 * 1000000000L / 23437L) <= 0L) ** GOTO lbl20
                                var3_4 = System.nanoTime();
                                if (Toad4Simulator.this.m_Thread.isInterrupted()) {
                                    return;
                                }
                                var9_7 = Toad4Simulator.this.m_IntSema4;
                                synchronized (var9_7) {
                                    Toad4Simulator.this.interruptIrq();
                                    ++var5_5;
                                    continue;
                                }
lbl20:
                                // 1 sources

                                if (Toad4Simulator.this.allQueuesEmpty()) {
                                    Thread.sleep(10L);
                                    continue;
                                }
                                Thread.yield();
                                continue;
                                break;
                            }
                            catch (InterruptedException var1_2) {
                                break block14;
                            }
                            catch (Exception var1_3) {
                                var1_3.printStackTrace();
                            }
                        }
                        finally {
                            Toad4Simulator.this.m_IsRunning = false;
                            Toad4Simulator.this.m_Thread = null;
                        }
                    }
                }
            }, "Toad4Simularor ");
            this.m_Thread.setPriority(10);
            this.m_Thread.setUncaughtExceptionHandler((thread, throwable) -> {
                System.err.println("class Toad4Simulator: uncaught exception");
                throwable.printStackTrace();
            });
            this.m_Thread.start();
            while (!this.m_IsRunning) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public void stop() {
        if (this.m_Thread != null) {
            this.m_Thread.interrupt();
            this.m_Thread.setPriority(10);
            while (this.m_IsRunning) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public boolean isRunning() {
        return this.m_IsRunning;
    }

    public int processMessage(byte[] byArray, byte[] byArray2, Object object) {
        if (object != null) {
            this.m_Debug = object;
        }
        return super.processMessage(byArray, byArray2);
    }

    boolean allQueuesEmpty() {
        for (int i = 0; i < 4; ++i) {
            if (this.m_Steppers[i].size <= 0) continue;
            return false;
        }
        return true;
    }

    public static void mainx(String[] stringArray) {
        try {
            Toad4Simulator toad4Simulator = new Toad4Simulator();
            toad4Simulator.start();
            CommandFormatter commandFormatter = new CommandFormatter();
            ResponseParser responseParser = new ResponseParser();
            commandFormatter.appendGo(0);
            commandFormatter.appendMove(0, 1000, 1000);
            commandFormatter.appendMove(0, -1000, 2000);
            commandFormatter.pack();
            int n = toad4Simulator.processMessage(commandFormatter.getBuffer(), responseParser.getBuffer());
            responseParser.reset(n);
            int n2 = responseParser.parseByte();
            if (n2 != 0) {
                System.out.println("Error " + n2);
            }
            if ((n2 = responseParser.parseByte()) != 0) {
                System.out.println("Error " + n2);
            }
            System.out.println("OK");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        return this.m_Connected;
    }

    @Override
    public void openConnection(String string) throws ToadComm.DeviceBusyException, ToadComm.AccessDeniedException, ToadComm.DeviceNotFound, IOException {
        this.m_Connected = true;
    }

    @Override
    public void closeConnection() {
        this.m_Connected = false;
    }

    @Override
    public int read(byte[] byArray, int n) throws Exception {
        if (this.m_Connected) {
            int n2 = this.m_RespLen < n ? this.m_RespLen : n;
            System.arraycopy(this.m_RespBuffer, 0, byArray, 0, n2);
            return n2;
        }
        return 0;
    }

    @Override
    public void write(byte[] byArray, int n) throws Exception {
        if (this.m_Connected) {
            this.m_RespLen = this.processMessage(byArray, this.m_RespBuffer);
        }
    }

    @Override
    public void flush() throws Exception {
    }
}

