/*
 * Decompiled with CFR 0.152.
 */
package eazycnc.udevrules;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.UWKit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class UdevRules {
    private static String SCRIPTNAME = "setup-udev-rules";

    private static void writeOutScript(String string) throws IOException {
        InputStream inputStream = UdevRules.class.getResourceAsStream("write-udev-rules.sh");
        File file = new File(string + "/" + SCRIPTNAME);
        Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        file.setExecutable(true);
    }

    private static void try2open(String string, String object) throws Success {
        try {
            int n;
            if (string != null && (n = ((String)object).indexOf("$1")) >= 0) {
                object = ((String)object).substring(0, n) + string + ((String)object).substring(n + 2);
            }
            String[] stringArray = ((String)object).split(" ");
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.inheritIO().start();
            throw new Success();
        }
        catch (Success success) {
            throw success;
        }
        catch (Exception exception) {
            System.out.println((String)object + " failed.");
            return;
        }
    }

    public static void main(String ... stringArray) throws IOException {
        UdevRules.writeOutScript("/Volumes/Partition2/Users/nyholku/EazyCNC/");
        UdevRules.openConsole("/Volumes/Partition2/Users/nyholku/EazyCNC/");
    }

    public static boolean openConsole(String string) {
        try {
            UdevRules.try2open(string, "x-terminal-emulator --working-directory=$1");
            UdevRules.try2open(string, "konsole --workdir $1");
        }
        catch (Success success) {
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static void showConfirmation(String string) {
        UWKit.showInformationDialog("Confirm udev Setup", "Next a script that will set up the udev rules<br>will be written to '" + string + "'<br>A terminal window set up for that directory should then appear.<br><br>In the terminal you should type in and execute following command: <br><br><b>sudo ./" + SCRIPTNAME + " </b><br><br>Lastly you will need to unplug/replug the USB device(s) in question.", "OK", null, "Cancel", dialogOptions -> {
            if (dialogOptions == DialogCallback.DialogOptions.YES) {
                try {
                    UdevRules.writeOutScript(string);
                    UdevRules.openConsole(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void offerToFixUdevRule(boolean bl, boolean bl2, String string) {
        UWKit.showInformationDialog("USB Access Denied", "Looks like the <b>udev</b> rules do not allow access to the USB.<br>Would you like EazyCNC to help you to set them up correctly?<br><br>(You will not asked this again in this session)", "YES", "NO", null, dialogOptions -> {
            if (dialogOptions == DialogCallback.DialogOptions.YES) {
                UdevRules.showConfirmation(string);
            }
        });
    }

    static class Success
    extends Exception {
        Success() {
        }
    }
}

