/*
 * Decompiled with CFR 0.152.
 */
package graph;

import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class Graph
extends JPanel {
    public static final Color TRANSPARENT = new Color(0, 0, 0);
    public static final Color AUTOMATIC = new Color(0, 0, 0);
    public static final Line SOLID = new Line(1.0, new Number[0]);
    public static final Line DASH = new Line(1.0, 4, 2);
    public static final Line DOT = new Line(1.0, 2, 2);
    public static final Line DASH_DOT = new Line(1.0, 4, 2, 2, 2);
    public static final Line DASH_DOT_DOT = new Line(1.0, 4, 2, 2, 2, 2);
    public static final Line DOT_DOT = new Line(1.0, 2, 2, 2, 6);
    public static final Box BOX = new Box(4.0, Color.BLACK);
    public static final Circle CIRCLE = new Circle(4.0, Color.BLACK);
    public static final Cross CROSS = new Cross(4.0, Color.BLACK);
    public static final Plus PLUS = new Plus(4.0, Color.BLACK);
    public static final Policy NOWINDOW = Policy.NOWINDOW;
    public static final Policy PILE = Policy.PILE;
    public static final Policy STACK = Policy.STACK;
    public static final Policy TILE = Policy.TILE;
    private String m_Title = "Graph";
    private static int m_MinimumWindowWidth = 400;
    private static int m_MinimumWindowHeight = 300;
    private static Robot g_Robot;
    private double m_Zoom = 0.9;
    private Graph m_This;
    private double m_CenterX = 0.5;
    private double m_CenterY = 0.5;
    private Point m_LastClick;
    private Color[] m_AutoColors = new Color[]{Color.RED, Color.BLACK, Color.BLUE};
    private int m_NextAutoColor = 0;
    private AffineTransform m_InverseViewTransform;
    private double m_Scaling;
    private boolean m_ZoomWidths;
    private static LinkedList<JFrame> m_Windows;
    private LinkedList<Scale> m_Scales = new LinkedList();
    private Scale m_CurrentScale;

    public void scale(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m_CurrentScale = new Scale(d, d2, d3, d4, d5, d6);
        this.m_Scales.add(this.m_CurrentScale);
    }

    public void autoScale() {
        this.m_CurrentScale = new Scale();
        this.m_Scales.add(this.m_CurrentScale);
    }

    public Graph(Policy policy, boolean bl, double d) {
        this(policy, bl, d, null);
    }

    public Graph(Policy policy, boolean bl, double d, String string) {
        if (string != null) {
            this.m_Title = string;
        }
        this.m_This = this;
        this.m_Scaling = d;
        this.m_ZoomWidths = bl;
        this.autoScale();
        if (g_Robot == null) {
            try {
                g_Robot = new Robot();
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
        }
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            private boolean centerMouse() {
                Graph graph = Graph.this;
                Point point = graph.getLocationOnScreen();
                g_Robot.mouseMove(point.x + graph.getWidth() / 2, point.y + graph.getHeight() / 2);
                return true;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                double d = Math.sqrt(Math.sqrt(Math.sqrt(2.0)));
                if (n < 0) {
                    Graph.this.m_Zoom *= d;
                }
                if (n > 0) {
                    Graph.this.m_Zoom /= d;
                }
                Point2D point2D = Graph.this.m_InverseViewTransform.transform(mouseWheelEvent.getPoint(), null);
                Graph.this.m_CenterX = point2D.getX();
                Graph.this.m_CenterY = point2D.getY();
                this.centerMouse();
                Graph.this.repaint();
            }
        };
        this.addMouseWheelListener(mouseWheelListener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        if (policy != Policy.NOWINDOW) {
            JFrame jFrame = new JFrame(this.m_Title);
            m_Windows.add(jFrame);
            jFrame.getContentPane().add(this);
            int n = 30;
            int n2 = 30;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n3 = dimension.width - 2 * n;
            int n4 = dimension.height - 2 * n2;
            int n5 = m_Windows.size();
            switch (policy) {
                case STACK: {
                    int n6 = 20;
                    int n7 = n3 - n5 * n6;
                    int n8 = n4 - n5 * n6;
                    int n9 = 0;
                    for (JFrame jFrame2 : m_Windows) {
                        jFrame2.setSize(n7, n8);
                        jFrame2.setLocation(n + n9 * n6, n2 + n9 * n6);
                        ++n9;
                    }
                    break;
                }
                case PILE: {
                    JFrame jFrame3 = n5 > 1 ? m_Windows.getLast() : null;
                    int n10 = n3;
                    int n11 = n4;
                    jFrame.setSize(n10, n11);
                    break;
                }
                case TILE: {
                    int n12;
                    int n13 = 3;
                    int n14 = n3 / (m_MinimumWindowWidth + n13);
                    int n15 = (n3 - n13 * (n14 - 1)) / n14;
                    if (n14 > n5) {
                        n14 = n5;
                    }
                    n15 = (n3 - n13 * (n14 - 1)) / n14;
                    int n16 = (n5 - 1) / n14 + 1;
                    int n17 = (n4 - n13 * (n16 - 1)) / n16;
                    if (n17 >= m_MinimumWindowHeight) {
                        n17 = (n4 - n13 * (n16 - 1)) / n16;
                        n12 = n17 + n13;
                    } else {
                        n17 = n4 / n16;
                        n17 = m_MinimumWindowHeight;
                        n12 = n16 > 1 ? (n4 - m_MinimumWindowHeight) / (n16 - 1) : 0;
                    }
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    for (JFrame jFrame4 : m_Windows) {
                        jFrame4.setSize(n15, n17);
                        jFrame4.setLocation(n + n18, n2 + n19);
                        if (++n20 >= n14) {
                            n20 = 0;
                            n18 = 0;
                            n19 += n12;
                            continue;
                        }
                        n18 += n15 + n13;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unimplemeted policy used");
                }
            }
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
        } else {
            this.setPreferredSize(new Dimension(500, 500));
        }
    }

    public static Line LINE(double d, Number ... numberArray) {
        return new Line(d, numberArray);
    }

    public static Line LINE(double d, Color color, Number ... numberArray) {
        return new Line(d, color, numberArray);
    }

    public static Box BOX(double d, Color ... colorArray) {
        return new Box(d, colorArray);
    }

    public static Circle CIRCLE(double d, Color ... colorArray) {
        return new Circle(d, colorArray);
    }

    public static Cross CROSS(double d, Color ... colorArray) {
        return new Cross(d, colorArray);
    }

    public static Plus PLUS(double d, Color ... colorArray) {
        return new Plus(d, colorArray);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            this.m_NextAutoColor = 0;
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            graphics2D.setClip(insets.left + 1, insets.top + 1, dimension.width - insets.right - insets.left - 2, dimension.height - insets.top - insets.bottom - 2);
            AffineTransform affineTransform2 = graphics2D.getTransform();
            affineTransform2.preConcatenate(AffineTransform.getTranslateInstance(-this.m_CenterX, -this.m_CenterY));
            double d = Math.min(dimension.getWidth(), dimension.getHeight());
            affineTransform2.preConcatenate(AffineTransform.getScaleInstance(d, -d));
            affineTransform2.preConcatenate(AffineTransform.getScaleInstance(this.m_Zoom, this.m_Zoom));
            affineTransform2.preConcatenate(AffineTransform.getTranslateInstance(this.getWidth() / 2, this.getHeight() / 2));
            this.m_InverseViewTransform = affineTransform2.createInverse();
            for (Scale scale : this.m_Scales) {
                double d2 = this.m_Scaling;
                AffineTransform affineTransform3 = new AffineTransform(affineTransform2);
                affineTransform3.concatenate(scale.getScaleTransform());
                if (!this.m_ZoomWidths) {
                    AffineTransform affineTransform4 = affineTransform3.createInverse();
                    Point2D point2D = affineTransform4.transform(new Point2D.Double(0.0, 0.0), null);
                    Point2D point2D2 = affineTransform4.transform(new Point2D.Double(0.0, d2), null);
                    d2 = point2D.distance(point2D2);
                }
                graphics2D.setTransform(affineTransform3);
                scale.paint(this, graphics2D, d2);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        graphics2D.setTransform(affineTransform);
    }

    private Color autoColor() {
        return this.m_AutoColors[this.m_NextAutoColor++ % this.m_AutoColors.length];
    }

    public void plot(Plot plot, Object ... objectArray) {
        this.plot(plot.getX(), plot.getY(), objectArray);
    }

    public void plot(double[] dArray, Object ... objectArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = i;
        }
        this.m_CurrentScale.add(new Item(dArray2, dArray, objectArray));
        this.m_This.repaint();
    }

    public void plot(List list, Object ... objectArray) {
        Tuple2d[] tuple2dArray = new Tuple2d[list.size()];
        for (int i = 0; i < tuple2dArray.length; ++i) {
            Object e = list.get(i);
            if (e instanceof Point2d) {
                tuple2dArray[i] = new Point2d((Point2d)e);
                continue;
            }
            double[] dArray = (double[])e;
            tuple2dArray[i] = new Point2d(dArray[0], dArray[1]);
        }
        this.plot(tuple2dArray, objectArray);
    }

    public void plot(double[] dArray, double[] dArray2, Object ... objectArray) {
        this.m_CurrentScale.add(new Item(dArray, dArray2, objectArray));
        this.m_This.repaint();
    }

    public void plot(List<Double> list, List<Double> list2, Object ... objectArray) {
        int n;
        double[] dArray = new double[list.size()];
        double[] dArray2 = new double[list2.size()];
        for (n = 0; n < list.size(); ++n) {
            dArray[n] = list.get(n);
        }
        for (n = 0; n < list2.size(); ++n) {
            dArray2[n] = list2.get(n);
        }
        this.plot(dArray, dArray2, objectArray);
    }

    public void plot(Tuple2d[] tuple2dArray, Object ... objectArray) {
        int n = tuple2dArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = i; n2 < n && tuple2dArray[n2] != null && !Double.isNaN(tuple2dArray[n2].x) && !Double.isNaN(tuple2dArray[n2].y); ++n2) {
            }
            int n3 = n2 - i;
            if (n3 <= 1) continue;
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            for (int j = i; j < n2; ++j) {
                dArray[j - i] = tuple2dArray[j].x;
                dArray2[j - i] = tuple2dArray[j].y;
            }
            this.plot(dArray, dArray2, objectArray);
            i = n2;
        }
    }

    static {
        m_Windows = new LinkedList();
    }

    static class Scale {
        Axis m_AxisX = new Axis(new Vector2d(1.0, 0.0));
        Axis m_AxisY = new Axis(new Vector2d(0.0, 1.0));
        LinkedList<Item> m_Items = new LinkedList();

        Scale() {
            this.m_AxisY.setScale(null, null, null);
        }

        Scale(double d, double d2, double d3, double d4, double d5, double d6) {
            this.m_AxisX.setScale(d, d2, d3);
            this.m_AxisY.setScale(d4, d5, d6);
        }

        public void add(Item item) {
            this.m_Items.add(item);
            double d = Double.MAX_VALUE;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            double d4 = -1.7976931348623157E308;
            for (Item item2 : this.m_Items) {
                for (int i = 0; i < item2.m_X.length; ++i) {
                    d = Math.min(d, item2.m_X[i]);
                    d2 = Math.min(d2, item2.m_Y[i]);
                    d3 = Math.max(d3, item2.m_X[i]);
                    d4 = Math.max(d4, item2.m_Y[i]);
                }
            }
            if (d >= d3 || d2 >= d4) {
                return;
            }
            double d5 = (d3 - d) / 1000.0;
            double d6 = (d4 - d2) / 1000.0;
            this.m_AxisX.rescale(d - d5, d3 + d5);
            this.m_AxisY.rescale(d2 - d5, d4 + d5);
        }

        public void paint(Graph graph, Graphics2D graphics2D, double d) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setColor(Color.LIGHT_GRAY);
            this.m_AxisX.paint(graphics2D, this.m_AxisY);
            this.m_AxisY.paint(graphics2D, this.m_AxisX);
            for (Item item : this.m_Items) {
                item.paint(graph, graphics2D, d);
            }
        }

        public AffineTransform getScaleTransform() {
            AffineTransform affineTransform = new AffineTransform();
            double d = Double.MIN_VALUE;
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-this.m_AxisX.m_Min - d, -this.m_AxisY.m_Min - d));
            affineTransform.preConcatenate(AffineTransform.getScaleInstance(1.0 / (this.m_AxisX.m_Max - this.m_AxisX.m_Min + 2.0 * d), 1.0 / (this.m_AxisY.m_Max - this.m_AxisY.m_Min + 2.0 * d)));
            return affineTransform;
        }
    }

    static enum Policy {
        NOWINDOW,
        PILE,
        STACK,
        TILE;

    }

    static class Line {
        float m_Width;
        float[] m_Dash;
        Color m_Color = AUTOMATIC;

        public Line(double d, Number ... numberArray) {
            this(d, AUTOMATIC, numberArray);
        }

        public Line(double d, Color color, Number ... numberArray) {
            this.m_Width = (float)d;
            this.m_Color = color;
            if (numberArray != null && numberArray.length > 0) {
                this.m_Dash = new float[numberArray.length];
                for (int i = 0; i < this.m_Dash.length; ++i) {
                    this.m_Dash[i] = numberArray[i].floatValue();
                }
            }
        }

        public void paint(Graphics2D graphics2D, double d, double[] dArray, double[] dArray2, Color color) {
            GeneralPath generalPath = new GeneralPath();
            if (dArray.length < 2) {
                return;
            }
            generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
            for (int i = 1; i < dArray.length; ++i) {
                generalPath.lineTo((float)dArray[i], (float)dArray2[i]);
            }
            if (Item.setColor(graphics2D, color)) {
                if (this.m_Dash != null) {
                    graphics2D.setStroke(new BasicStroke(this.m_Width * (float)d, 1, 1, 0.0f, this.m_Dash, 0.0f));
                } else {
                    graphics2D.setStroke(new BasicStroke(this.m_Width * (float)d, 1, 1));
                }
                graphics2D.draw(generalPath);
            }
        }
    }

    static class Box
    extends Marker {
        Box(double d, Color ... colorArray) {
            super(d, colorArray);
        }

        @Override
        public Shape getShape(double d, double d2, double d3) {
            double d4 = d * this.m_Size / 2.0;
            return new Rectangle2D.Double(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4);
        }
    }

    static class Circle
    extends Marker {
        Circle(double d, Color ... colorArray) {
            super(d, colorArray);
        }

        @Override
        public Shape getShape(double d, double d2, double d3) {
            double d4 = d * this.m_Size / 2.0;
            return new Ellipse2D.Double(d2 - d4, d3 - d4, 2.0 * d4, 2.0 * d4);
        }
    }

    static class Cross
    extends Marker {
        Cross(double d, Color ... colorArray) {
            super(d, colorArray);
        }

        @Override
        public void paint(Graphics2D graphics2D, double d, double d2, double d3, Color color, Color color2) {
            double d4 = d * this.m_Size / 2.0;
            if (Item.setColor(graphics2D, this.m_LineColor != null ? this.m_LineColor : color)) {
                graphics2D.setStroke(new BasicStroke(0.0f));
                graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 + d4));
                graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 - d4));
            }
        }
    }

    static class Plus
    extends Marker {
        Plus(double d, Color ... colorArray) {
            super(d, colorArray);
        }

        @Override
        public void paint(Graphics2D graphics2D, double d, double d2, double d3, Color color, Color color2) {
            double d4 = d * this.m_Size / 2.0;
            if (Item.setColor(graphics2D, this.m_LineColor != null ? this.m_LineColor : color)) {
                graphics2D.setStroke(new BasicStroke(0.0f));
                graphics2D.draw(new Line2D.Double(d2 - d4, d3, d2 + d4, d3));
                graphics2D.draw(new Line2D.Double(d2, d3 + d4, d2, d3 - d4));
            }
        }
    }

    public static class Plot {
        private ArrayList<Double> m_X = new ArrayList();
        private ArrayList<Double> m_Y = new ArrayList();
        private double m_Xi;
        private double m_dX;

        public void add(Point2d point2d) {
            this.add(point2d.x, point2d.y);
        }

        public void add(double[] dArray) {
            this.add(dArray[0], dArray[1]);
        }

        public void add(int n, double[] dArray) {
            this.add(dArray[n], dArray[n + 1]);
        }

        public void add(double d, double d2) {
            this.m_X.add(d);
            this.m_Y.add(d2);
        }

        public void deltax(double d, double d2) {
            this.m_Xi = d;
            this.m_dX = d2;
        }

        public void add(double d) {
            this.add(this.m_Xi, d);
            this.m_Xi += this.m_dX;
        }

        public double[] getX() {
            double[] dArray = new double[this.m_X.size()];
            int n = 0;
            for (Double d : this.m_X) {
                dArray[n++] = d;
            }
            return dArray;
        }

        public double[] getY() {
            double[] dArray = new double[this.m_Y.size()];
            int n = 0;
            for (Double d : this.m_Y) {
                dArray[n++] = d;
            }
            return dArray;
        }
    }

    static class Item {
        double[] m_X;
        double[] m_Y;
        Object[] m_Args;

        Item(double[] dArray, double[] dArray2, Object ... objectArray) {
            if (dArray.length != dArray2.length) {
                throw new IllegalArgumentException("x and y sizes must match");
            }
            this.m_X = dArray;
            this.m_Y = dArray2;
            this.m_Args = objectArray;
        }

        static boolean setColor(Graphics2D graphics2D, Color color) {
            if (color == null || color == TRANSPARENT) {
                return false;
            }
            graphics2D.setColor(color);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void paint(Graph graph, Graphics2D graphics2D, double d) {
            void var8_10;
            Line line = SOLID;
            Object[] object = this.m_Args;
            int marker = object.length;
            boolean object3 = false;
            while (var8_10 < marker) {
                Object object2 = object[var8_10];
                if (object2 instanceof Line) {
                    line = (Line)object2;
                    break;
                }
                ++var8_10;
            }
            Color color = line.m_Color != AUTOMATIC ? line.m_Color : graph.autoColor();
            line.paint(graphics2D, d, this.m_X, this.m_Y, color);
            Marker marker2 = null;
            Object[] objectArray = this.m_Args;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object4 = objectArray[i];
                if (!(object4 instanceof Marker)) continue;
                marker2 = (Marker)object4;
                break;
            }
            if (marker2 != null) {
                Color color2 = marker2.m_FillColor != AUTOMATIC ? marker2.m_FillColor : graph.autoColor();
                for (n = 0; n < this.m_X.length; ++n) {
                    marker2.paint(graphics2D, d, this.m_X[n], this.m_Y[n], color, color2);
                }
            }
        }
    }

    static class Axis {
        Vector2d m_Dir;
        boolean m_AutoMin;
        boolean m_AutoTick;
        boolean m_AutoMax;
        double m_Min;
        double m_Tick;
        double m_Max;

        public Axis(Vector2d vector2d) {
            this.m_Dir = vector2d;
        }

        void paint(Graphics2D graphics2D, Axis axis) {
            Vector2d vector2d = this.m_Dir;
            Vector2d vector2d2 = axis.m_Dir;
            if (this.m_Tick <= 0.0) {
                return;
            }
            for (double d = this.m_Min; d <= this.m_Max; d += this.m_Tick) {
                Point2d point2d = new Point2d((Tuple2d)vector2d);
                point2d.scale(d);
                Point2d point2d2 = new Point2d((Tuple2d)vector2d2);
                point2d2.scale(axis.m_Min);
                point2d2.add((Tuple2d)point2d);
                Point2d point2d3 = new Point2d((Tuple2d)vector2d2);
                point2d3.scale(axis.m_Max);
                point2d3.add((Tuple2d)point2d);
                Line2D.Double double_ = new Line2D.Double(point2d2.x, point2d2.y, point2d3.x, point2d3.y);
                graphics2D.draw(double_);
            }
        }

        void setScale(Double d, Double d2, Double d3) {
            boolean bl = this.m_AutoMin = d == null;
            if (d != null) {
                this.m_Min = d;
            }
            boolean bl2 = this.m_AutoTick = d2 == null;
            if (d2 != null) {
                this.m_Tick = d2;
            }
            boolean bl3 = this.m_AutoMax = d3 == null;
            if (d3 != null) {
                this.m_Max = d3;
            }
        }

        void rescale(double d, double d2) {
            if (this.m_AutoTick) {
                double d3;
                double d4 = d2 - d;
                double d5 = Math.pow(10.0, Math.ceil(Math.log(d4) / Math.log(10.0)));
                double d6 = d5 / 2.0;
                double d7 = d5 / 4.0;
                this.m_Tick = d3 = d5 / 5.0;
                if (d4 > this.m_Tick) {
                    this.m_Tick = d7;
                }
                if (d4 > this.m_Tick) {
                    this.m_Tick = d6;
                }
                if (d4 > this.m_Tick) {
                    this.m_Tick = d5;
                }
                this.m_Tick /= 10.0;
            }
            if (this.m_AutoMin) {
                this.m_Min = d > 0.0 ? Math.floor(d / this.m_Tick) * this.m_Tick : -Math.floor(-d / this.m_Tick) * this.m_Tick;
            }
            if (this.m_AutoMax) {
                this.m_Max = d2 > 0.0 ? Math.ceil(d2 / this.m_Tick) * this.m_Tick : -Math.ceil(-d2 / this.m_Tick) * this.m_Tick;
            }
        }
    }

    static class Marker {
        double m_Size;
        Color m_LineColor = AUTOMATIC;
        Color m_FillColor = AUTOMATIC;

        Marker(double d, Color ... colorArray) {
            this.m_Size = d;
            if (colorArray.length > 0 && colorArray[0] != null) {
                this.m_LineColor = colorArray[0];
            }
            if (colorArray.length > 1 && colorArray[1] != null) {
                this.m_FillColor = colorArray[1];
            }
        }

        public void paint(Graphics2D graphics2D, double d, double d2, double d3, Color color, Color color2) {
            Shape shape = this.getShape(d, d2, d3);
            if (Item.setColor(graphics2D, this.m_LineColor != null ? this.m_LineColor : color)) {
                graphics2D.setColor(this.m_LineColor != null ? this.m_LineColor : color);
                graphics2D.setStroke(new BasicStroke(0.0f));
                graphics2D.draw(shape);
            }
        }

        public Shape getShape(double d, double d2, double d3) {
            return null;
        }
    }
}

