/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class GraphicsLoader {
    public static ImageIcon loadIcon(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find image in system: " + string);
        return null;
    }

    public static BufferedImage loadImage(Class clazz, String string) {
        try {
            if (string == null) {
                throw new IllegalArgumentException("No filename specified");
            }
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Could not find file '" + string + "'");
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (inputStream == null) {
                throw new IllegalArgumentException("Could not load file '" + string + "'");
            }
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

