/*
 * Decompiled with CFR 0.152.
 */
package hb04pendant;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.UWKit;
import eazycnc.Main;
import eazycnc.ShortcutManager;
import eazycnc.pendant.Pendant;
import java.util.concurrent.ConcurrentLinkedQueue;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;

public class WHB04
extends Pendant {
    static volatile byte[] dataOut = new byte[0];
    private volatile boolean[] m_ButtonPressed = new boolean[256];
    private volatile DispMode m_DispMode;
    private volatile int m_Switch2Axis = -1;
    private volatile int[] m_StepMultDispCodeMetric = new int[]{0, 3, 8, 10};
    private volatile int[] m_StepMultDispCodeImperial = new int[]{0, 1, 3, 8};
    private volatile int m_MpgTargetSpeed;
    private volatile int m_MpgActualSpeed;
    private int m_MpgTargetPos = Integer.MIN_VALUE;
    private long m_T0;
    private static final int DATA_OFFSET_BUTTON_1 = 1;
    private static final int DATA_OFFSET_BUTTON_2 = 2;
    private static final int DATA_OFFSET_WHEEL_MODE = 3;
    private static final int DATA_OFFSET_WHEEL_DELTA = 4;
    private static final int WHEEL_MODE_OFF = 0;
    private static final int WHEEL_MODE_X = 17;
    private static final int WHEEL_MODE_Y = 18;
    private static final int WHEEL_MODE_Z = 19;
    private static final int WHEEL_MODE_A = 24;
    private static final int WHEEL_MODE_SPINDLE = 20;
    private static final int WHEEL_MODE_FEED = 21;
    private ConcurrentLinkedQueue<InputReportData> m_InputQueue;

    private void setup_dro_data(byte[] byArray, double[] dArray) {
        int n;
        double d;
        int n2;
        byArray[0] = -2;
        byArray[1] = -3;
        double[] dArray2 = this.m_MachController.axisPositionFromMotorPosition(this.m_MachController.getMotorPosition());
        double[] dArray3 = this.m_MachController.getMachState().axisToLocal(dArray2);
        for (n2 = 0; n2 < 3; ++n2) {
            d = 0.0;
            if (this.m_DispMode == DispMode.XYZ) {
                d = dArray3[n2];
            }
            if (this.m_DispMode == DispMode.A) {
                d = dArray3[n2 + 3];
            }
            boolean bl = d < 0.0;
            int n3 = 0;
            int n4 = 0;
            String string = this.m_DroFormatter.format(Math.abs(d));
            int n5 = string.indexOf(".");
            if (n5 >= 0) {
                int n6;
                String string2 = string.substring(0, n5);
                String string3 = string.substring(n5 + 1);
                n3 = Integer.parseInt(string2);
                n4 = Integer.parseInt(string3);
                for (n = n6 = string3.length(); n < 4; ++n) {
                    n4 *= 10;
                }
                for (n = n6; n > 4; ++n) {
                    n4 /= 10;
                }
            }
            if (bl) {
                n4 |= 0x8000;
            }
            int n7 = 3 + 4 * n2;
            byArray[n7++] = (byte)n3;
            byArray[n7++] = (byte)(n3 >> 8);
            byArray[n7++] = (byte)n4;
            byArray[n7++] = (byte)(n4 >> 8);
        }
        n2 = 27;
        d = this.m_MachState.getParamDouble(15141);
        double d2 = this.m_MachState.getParamDouble(15145) / d;
        double d3 = d2 * this.m_MachState.getParamDouble(15132);
        double d4 = this.m_MachState.getParamDouble(15127);
        double d5 = this.m_MachState.getParamDouble(15161);
        n = (int)d3;
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        n = (int)d5;
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        n = (int)d2;
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        n = (int)d4;
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        if (d == 1.0) {
            byArray[n2++] = (byte)(128 + this.m_StepMultDispCodeMetric[this.m_StepMultiplier]);
            byArray[n2++] = 0;
        } else {
            byArray[n2++] = (byte)(128 + this.m_StepMultDispCodeImperial[this.m_StepMultiplier]);
            byArray[n2++] = -128;
        }
    }

    @Override
    protected void onInputReport(HidDevice hidDevice, byte by, byte[] byArray, int n) {
        long l = System.nanoTime();
        double d = (double)(l - this.m_T0) / 1.0E9;
        this.m_T0 = l;
        this.m_InputQueue.add(new InputReportData(byArray, d));
        boolean[] blArray = (boolean[])this.m_ButtonPressed.clone();
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        blArray[n2] = true;
        blArray[n3] = true;
        for (int i = 1; i < blArray.length; ++i) {
            if (this.m_ButtonPressed[i] && i != n2 && i != n3) {
                blArray[i] = false;
            }
            if (this.m_ButtonPressed[i] == blArray[i]) continue;
            this.m_ButtonPressed[i] = blArray[i];
            if (this.m_ButtonPressed[i]) {
                UWKit.blip();
                this.m_KeyPressed = i;
                int n4 = ++this.m_KeyPressCount;
                UWKit.scheduleInEDT(1000, 0, () -> {
                    if (this.m_KeyPressed > 0 && n4 == this.m_KeyPressCount) {
                        String string = (String)this.m_ButtonMapping.get(this.m_KeyPressed);
                        if (string != null) {
                            this.m_ShortcutManager.dispatchShortcutEvent(this, ShortcutManager.Press.PRESSED_LONG, "MPG:" + string);
                        }
                        this.m_KeyPressed = 0;
                    }
                });
            } else {
                this.m_KeyPressed = 0;
            }
            String string = (String)this.m_ButtonMapping.get(i);
            if (string == null) continue;
            this.m_ShortcutManager.dispatchShortcutEvent(this, this.m_ButtonPressed[i] ? ShortcutManager.Press.PRESSED : ShortcutManager.Press.RELEASED, "MPG:" + string);
        }
    }

    @Override
    protected void runOnBackgroundUpdateDros() {
        double[] dArray = new double[6];
        while (true) {
            byte[] byArray = new byte[42];
            this.setup_dro_data(byArray, dArray);
            for (int i = 0; i < 42; i += 7) {
                byte[] byArray2 = new byte[8];
                System.arraycopy(byArray, i, byArray2, 1, 7);
                byArray2[0] = 6;
                if (this.m_Device == null) continue;
                this.m_Device.setOutputReport((byte)0, byArray2, 8);
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception exception) {
                this.m_Device = null;
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    protected void handleWheel() {
        InputReportData inputReportData = this.m_InputQueue.poll();
        if (inputReportData != null) {
            byte by;
            byte[] byArray = inputReportData.m_Data;
            double d = inputReportData.m_DeltaT;
            switch (byArray[3]) {
                case 0: {
                    this.m_Switch2Axis = -1;
                    break;
                }
                case 17: {
                    this.m_Switch2Axis = 0;
                    this.m_DispMode = DispMode.XYZ;
                    break;
                }
                case 18: {
                    this.m_Switch2Axis = 1;
                    this.m_DispMode = DispMode.XYZ;
                    break;
                }
                case 19: {
                    this.m_Switch2Axis = 2;
                    this.m_DispMode = DispMode.XYZ;
                    break;
                }
                case 24: {
                    this.m_Switch2Axis = 3;
                    this.m_DispMode = DispMode.A;
                    break;
                }
                case 21: {
                    this.m_Switch2Axis = -2;
                    break;
                }
                case 20: {
                    this.m_Switch2Axis = -3;
                }
            }
            ConnectionState connectionState = this.m_MotorController.getConnectionState();
            if ((connectionState == ConnectionState.CONNECTED || connectionState == ConnectionState.SIMULATION) && (by = byArray[4]) != 0 && this.m_Axis >= 0) {
                int n;
                double d2;
                if (this.m_MotorController.isIdle(this.m_Axis)) {
                    this.m_MpgTargetPos = this.m_MotorController.getMotorPosition()[this.m_Axis];
                }
                int n2 = this.m_MotorController.getMotorPosition()[this.m_Axis];
                double d3 = this.m_MachState.getParamDouble(-2147483646, this.m_Axis);
                double d4 = Math.pow(10.0, this.m_StepMultiplier) / 1000.0 / this.m_MachState.getParamDouble(15141) * d3;
                if (this.m_StepMultiplier == 0) {
                    d4 = 1.0;
                }
                double d5 = (double)by * d4;
                if (d > 0.5) {
                    d = 0.5;
                }
                double d6 = this.m_MotorController.getVelocityFactor();
                double d7 = d6 / d;
                double d8 = Math.abs(d5) * d7;
                if (d8 > (d2 = this.m_MachState.getParamDouble(0x20000001, this.m_Axis) * d3 * d6)) {
                    d8 = d2;
                }
                if (d5 > (double)(n = (int)(d4 * 10.0))) {
                    d5 = n;
                }
                if (Math.abs(this.m_MpgTargetPos - n2) > n) {
                    d5 = 0.0;
                }
                this.m_MpgTargetPos = (int)((double)this.m_MpgTargetPos + d5);
                this.m_MpgTargetSpeed = (int)d8;
            }
            if (!(this.m_Axis >= 0 && this.m_MotorController.isInMpgMode(this.m_Axis) || this.m_Axis == this.m_Switch2Axis)) {
                this.m_Axis = this.m_Switch2Axis;
                this.m_MpgTargetPos = Integer.MIN_VALUE;
                this.m_MpgActualSpeed = 0;
            }
            if (this.m_Axis >= 0 && this.m_MpgTargetPos != Integer.MIN_VALUE) {
                if (this.m_MpgTargetPos != this.m_MotorController.getMotorPosition()[this.m_Axis]) {
                    double d9 = (double)(this.m_MpgTargetSpeed - this.m_MpgActualSpeed) * 0.1;
                    if (Math.abs(d9) < 1.0) {
                        d9 = Math.signum(d9);
                    }
                    this.m_MpgActualSpeed = (int)(d9 + (double)this.m_MpgActualSpeed);
                    this.m_MotorController.setMpgTarget(this.m_Axis, this.m_MpgTargetPos, this.m_MpgActualSpeed);
                } else {
                    this.m_MpgTargetPos = Integer.MIN_VALUE;
                }
            }
        }
    }

    public WHB04(Main main, HidDeviceInfo hidDeviceInfo) throws Exception {
        super(main, hidDeviceInfo);
        this.init("RESET", 23);
        this.init("Stop", 22);
        this.init("Goto Origin", 1);
        this.init("Start/Pause", 2);
        this.init("Rewind", 3);
        this.init("Probe-Z", 4);
        this.init("Spindle", 12);
        this.init("= 1/2", 6);
        this.init("= 0", 7);
        this.init("Safe-Z", 8);
        this.init("Set Origin", 9);
        this.init("Macro-1", 10);
        this.init("Macro-2", 11);
        this.init("Macro-3", 5);
        this.init("Step++", 13);
        this.init("MPG Mode", 14);
        this.init("Macro-6", 15);
        this.init("Macro-7", 16);
        this.m_InputQueue = new ConcurrentLinkedQueue();
    }

    static enum DispMode {
        XYZ,
        A;

    }

    private class InputReportData {
        byte[] m_Data;
        double m_DeltaT;

        InputReportData(byte[] byArray, double d) {
            this.m_Data = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.m_Data, 0, byArray.length);
            this.m_DeltaT = d;
        }
    }
}

