/*
 * Decompiled with CFR 0.152.
 */
package hb04pendant;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.UWKit;
import eazycnc.Main;
import eazycnc.ShortcutManager;
import eazycnc.pendant.Pendant;
import java.util.concurrent.ConcurrentLinkedQueue;
import printf.Printf;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;

public class WHB04B
extends Pendant {
    private static final double[] m_TickSizeMetric = new double[]{0.001, 0.01, 0.1, 1.0};
    private static final double[] m_TickSizeImperial = new double[]{0.001, 0.01, 0.1, 0.1};
    private volatile int m_MpgTargetSpeed;
    private volatile int m_MpgActualSpeed;
    private int m_MpgTargetPos = Integer.MIN_VALUE;
    private static final int DATA_OFFSET_FIRST_KEY = 1;
    private static final int DATA_OFFSET_SECOND_KEY = 2;
    private static final int DATA_OFFSET_STEP_MODE = 3;
    private static final int DATA_OFFSET_WHEEL_MODE = 4;
    private static final int DATA_OFFSET_WHEEL_DELTA = 5;
    private static final int STEP_MODE_2P = 13;
    private static final int STEP_MODE_5P = 14;
    private static final int STEP_MODE_10P = 15;
    private static final int STEP_MODE_30P = 16;
    private static final int STEP_MODE_60P = 26;
    private static final int STEP_MODE_100P = 27;
    private static final int STEP_MODE_LEAD = -101;
    private static final int WHEEL_MODE_OFF = 6;
    private static final int WHEEL_MODE_X = 17;
    private static final int WHEEL_MODE_Y = 18;
    private static final int WHEEL_MODE_Z = 19;
    private static final int WHEEL_MODE_A = 20;
    private static final int WHEEL_MODE_B = 21;
    private static final int WHEEL_MODE_C = 22;
    private volatile int m_Switch2Axis = -1;
    private volatile long m_T0;
    private volatile DispMode m_DispMode;
    private final int FUNCTION = 64;
    private final int FUNCTION_KEY = 12;
    private final int SPIDLE_PLUS_KEY = 70;
    private final int SPIDLE_MINUS_KEY = 71;
    private final int FEED_PLUS_KEY = 68;
    private final int FEED_MINUS_KEY = 69;
    private volatile int m_PendantModeChanged = 5;
    private volatile boolean m_LinkOk = false;
    private volatile boolean m_AxisOff = true;
    private volatile PendantMode m_PendantMode = PendantMode.DISP_KNOB;
    private boolean m_FunctionOn;
    private ConcurrentLinkedQueue<InputReportData> m_InputQueue;
    int seed;

    public WHB04B(Main main, HidDeviceInfo hidDeviceInfo) throws Exception {
        super(main, hidDeviceInfo);
        this.init("RESET", 65);
        this.init("Stop", 66);
        this.init("Start/Pause", 67);
        this.init("RESET", 1);
        this.init("Stop", 2);
        this.init("Start/Pause", 3);
        this.init("Feed+", 68);
        this.init("Feed-", 69);
        this.init("Spindle+", 70);
        this.init("Spindle-", 71);
        this.init("Goto M Origin", 72);
        this.init("Safe-Z", 73);
        this.init("Goto Origin", 74);
        this.init("Spindle", 75);
        this.init("Probe-Z", 77);
        this.init("Cont-Jog", 14);
        this.init("Step-Jog", 15);
        this.init("Cont-Jog", 78);
        this.init("Step-Jog", 79);
        this.init("Macro-1", 4);
        this.init("Macro-2", 5);
        this.init("Macro-3", 6);
        this.init("Macro-4", 7);
        this.init("Macro-5", 8);
        this.init("Macro-6", 9);
        this.init("Macro-7", 10);
        this.init("Macro-8", 11);
        this.init("Macro-9", 13);
        this.init("Macro-10", 16);
        this.m_InputQueue = new ConcurrentLinkedQueue();
        this.seed = 0;
    }

    @Override
    protected void onInputReport(HidDevice hidDevice, byte by, byte[] byArray, int n) {
        int n2;
        long l = System.nanoTime();
        double d = (double)(l - this.m_T0) / 1.0E9;
        this.m_T0 = l;
        if (byArray[4] == 0 && byArray[3] == 0) {
            this.m_PendantModeChanged = 5;
            this.m_LinkOk = false;
            this.m_AxisOff = true;
        } else {
            this.m_LinkOk = true;
        }
        if (this.m_LinkOk && byArray[4] == 6) {
            this.m_PendantModeChanged = 5;
            this.m_AxisOff = true;
        } else {
            this.m_AxisOff = false;
        }
        this.m_InputQueue.add(new InputReportData(byArray, d));
        int n3 = byArray[1] & 0xFF;
        if (n3 == 12) {
            n2 = byArray[2] & 0xFF;
            n3 = n2 != 0 ? 64 + n2 : 0;
        }
        if (this.m_KeyPressed == 0 && n3 != 0) {
            if (n3 == 69 || n3 == 68) {
                if (this.m_PendantMode != PendantMode.DISP_FEED) {
                    this.m_PendantModeChanged = 5;
                    this.m_PendantMode = PendantMode.DISP_FEED;
                    return;
                }
            } else if (n3 == 71 || n3 == 70) {
                if (this.m_PendantMode != PendantMode.DISP_SPINDLE) {
                    this.m_PendantModeChanged = 5;
                    this.m_PendantMode = PendantMode.DISP_SPINDLE;
                    return;
                }
            } else if (this.m_PendantMode == PendantMode.DISP_FEED || this.m_PendantMode == PendantMode.DISP_SPINDLE) {
                this.m_PendantModeChanged = 5;
                this.m_PendantMode = PendantMode.DISP_KNOB;
                return;
            }
        }
        n2 = 0;
        boolean bl = false;
        if (this.m_KeyPressed == 0 && n3 != 0) {
            if (n3 != 12) {
                bl = true;
            }
            n2 = n3;
            this.m_KeyPressed = n3;
            UWKit.blip();
            ++this.m_KeyPressCount;
            int n4 = this.m_KeyPressCount;
            UWKit.scheduleInEDT(1000, 0, () -> {
                if (this.m_KeyPressed > 0 && n4 == this.m_KeyPressCount) {
                    String string = (String)this.m_ButtonMapping.get(this.m_KeyPressed);
                    Printf.println("long press: m_KeyPressed " + this.m_KeyPressed);
                    if (string != null) {
                        this.m_ShortcutManager.dispatchShortcutEvent(this, ShortcutManager.Press.PRESSED_LONG, "MPG:" + string);
                    }
                }
            });
        } else if (this.m_KeyPressed != 0 && n3 == 0) {
            Printf.println("released: m_KeyPressed " + this.m_KeyPressed);
            n2 = 0;
            this.m_KeyPressed = 0;
        }
        if (n2 != 0) {
            String string = (String)this.m_ButtonMapping.get(n2);
            Printf.println("key pressed: m_KeyPressed " + this.m_KeyPressed);
            if (string != null) {
                this.m_ShortcutManager.dispatchShortcutEvent(this, bl ? ShortcutManager.Press.PRESSED : ShortcutManager.Press.RELEASED, "MPG:" + string);
            }
        }
    }

    int getMode() {
        return 3;
    }

    private void fillInDroData(byte[] byArray, double[] dArray) {
        int n;
        byArray[0] = -2;
        byArray[1] = -3;
        byArray[2] = -2;
        if (this.m_AxisOff) {
            n = 2;
        } else if (this.m_PendantModeChanged > 0) {
            --this.m_PendantModeChanged;
            n = 2;
        } else {
            n = this.getMode();
        }
        byArray[3] = (byte)n;
        double[] dArray2 = this.m_MachController.axisPositionFromMotorPosition(this.m_MachController.getMotorPosition());
        double[] dArray3 = this.m_MachController.getMachState().axisToLocal(dArray2);
        int n2 = 4;
        for (int i = 0; i < 3; ++i) {
            double d = 0.0;
            if (this.m_DispMode == DispMode.XYZ) {
                d = dArray3[i];
            }
            if (this.m_DispMode == DispMode.ABC) {
                d = dArray3[i + 3];
            }
            boolean bl = d < 0.0;
            int n3 = 0;
            int n4 = 0;
            String string = this.m_DroFormatter.format(Math.abs(d));
            int n5 = string.indexOf(".");
            if (n5 >= 0) {
                String string2 = string.substring(0, n5);
                Object object = string.substring(n5 + 1);
                while (((String)object).length() < 4) {
                    object = (String)object + "0";
                }
                n3 = Integer.parseInt(string2);
                n4 = Integer.parseInt((String)object);
            }
            if (bl) {
                n4 |= 0x8000;
            }
            byArray[n2++] = (byte)n3;
            byArray[n2++] = (byte)(n3 >> 8);
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)(n4 >> 8);
        }
        double d = this.m_MachState.getParamDouble(15141);
        double d2 = this.m_MachState.getParamDouble(15145) / d * (this.m_MachState.getParamBoolean(15131) ? this.m_MachState.getParamDouble(15132) : 1.0);
        double d3 = this.m_MachState.getParamBoolean(15162) ? this.m_MachState.getParamDouble(15161) : this.m_MachState.getParamDouble(15127);
        int n6 = (int)d2;
        byArray[n2++] = (byte)n6;
        byArray[n2++] = (byte)(n6 >> 8);
        n6 = (int)d3;
        byArray[n2++] = (byte)n6;
        byArray[n2++] = (byte)(n6 >> 8);
    }

    @Override
    protected void runOnBackgroundUpdateDros() {
        double[] dArray = new double[]{1.2, 2.3, 3.4, 4.5, 5.6, 6.7};
        while (true) {
            byte[] byArray = new byte[64];
            this.fillInDroData(byArray, dArray);
            for (int i = 0; i < 28; i += 7) {
                byte[] byArray2 = new byte[7];
                System.arraycopy(byArray, i, byArray2, 0, 7);
                if (this.m_Device == null) continue;
                this.m_Device.setFeatureReport((byte)6, byArray2, 7);
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (Exception exception) {
                this.m_Device = null;
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    protected void handleWheel() {
        InputReportData inputReportData = this.m_InputQueue.poll();
        if (inputReportData != null) {
            byte by;
            byte[] byArray = inputReportData.m_Data;
            double d = inputReportData.m_DeltaT;
            switch (byArray[3]) {
                default: {
                    this.m_StepMultiplier = -1;
                    break;
                }
                case 13: {
                    this.m_StepMultiplier = 0;
                    break;
                }
                case 14: {
                    this.m_StepMultiplier = 1;
                    break;
                }
                case 15: {
                    this.m_StepMultiplier = 2;
                    break;
                }
                case 16: {
                    this.m_StepMultiplier = 3;
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                }
                case -101: 
            }
            switch (byArray[4]) {
                case 6: {
                    this.m_Switch2Axis = -1;
                    this.m_PendantMode = PendantMode.DISP_KNOB;
                    break;
                }
                case 17: {
                    this.m_Switch2Axis = 0;
                    this.m_DispMode = DispMode.XYZ;
                    break;
                }
                case 18: {
                    this.m_Switch2Axis = 1;
                    this.m_DispMode = DispMode.XYZ;
                    break;
                }
                case 19: {
                    this.m_Switch2Axis = 2;
                    this.m_DispMode = DispMode.XYZ;
                    break;
                }
                case 20: {
                    this.m_Switch2Axis = 3;
                    this.m_DispMode = DispMode.ABC;
                    break;
                }
                case 21: {
                    this.m_Switch2Axis = 4;
                    this.m_DispMode = DispMode.ABC;
                    break;
                }
                case 22: {
                    this.m_Switch2Axis = 5;
                    this.m_DispMode = DispMode.ABC;
                }
            }
            ConnectionState connectionState = this.m_MotorController.getConnectionState();
            if ((connectionState == ConnectionState.CONNECTED || connectionState == ConnectionState.SIMULATION) && (by = byArray[5]) != 0 && this.m_Axis >= 0) {
                int n;
                double d2;
                if (this.m_MotorController.isIdle(this.m_Axis)) {
                    this.m_MpgTargetPos = this.m_MotorController.getMotorPosition()[this.m_Axis];
                }
                int n2 = this.m_MotorController.getMotorPosition()[this.m_Axis];
                double d3 = this.m_MachState.getParamDouble(-2147483646, this.m_Axis);
                double d4 = 1.0;
                if (this.m_StepMultiplier >= 0) {
                    d4 = this.m_MachState.getParamDouble(15141) != 1.0 ? m_TickSizeImperial[this.m_StepMultiplier] : m_TickSizeMetric[this.m_StepMultiplier];
                    if (d4 > 3.0) {
                        d4 = 1.0;
                    }
                    if ((d4 *= d3) < 1.0) {
                        d4 = 1.0;
                    }
                }
                double d5 = (double)by * d4;
                if (d > 0.5) {
                    d = 0.5;
                }
                double d6 = this.m_MotorController.getVelocityFactor();
                double d7 = d6 / d;
                double d8 = Math.abs(d5) * d7;
                if (d8 > (d2 = this.m_MachState.getParamDouble(0x20000001, this.m_Axis) * d3 * d6)) {
                    d8 = d2;
                }
                if (d5 > (double)(n = (int)(d4 * 10.0))) {
                    d5 = n;
                }
                if (Math.abs(this.m_MpgTargetPos - n2) > n) {
                    d5 = 0.0;
                }
                this.m_MpgTargetPos = (int)((double)this.m_MpgTargetPos + d5);
                this.m_MpgTargetSpeed = (int)d8;
            }
            if (!(this.m_Axis >= 0 && this.m_MotorController.isInMpgMode(this.m_Axis) || this.m_Axis == this.m_Switch2Axis)) {
                this.m_Axis = this.m_Switch2Axis;
                this.m_MpgTargetPos = Integer.MIN_VALUE;
                this.m_MpgActualSpeed = 0;
            }
            if (this.m_Axis >= 0 && this.m_MpgTargetPos != Integer.MIN_VALUE) {
                if (this.m_MpgTargetPos != this.m_MotorController.getMotorPosition()[this.m_Axis]) {
                    double d9 = (double)(this.m_MpgTargetSpeed - this.m_MpgActualSpeed) * 0.1;
                    if (Math.abs(d9) < 1.0) {
                        d9 = Math.signum(d9);
                    }
                    this.m_MpgActualSpeed = (int)(d9 + (double)this.m_MpgActualSpeed);
                    this.m_MotorController.setMpgTarget(this.m_Axis, this.m_MpgTargetPos, this.m_MpgActualSpeed);
                } else {
                    this.m_MpgTargetPos = Integer.MIN_VALUE;
                }
            }
        }
    }

    static enum PendantMode {
        DISP_SPINDLE,
        DISP_FEED,
        DISP_KNOB;

    }

    private class InputReportData {
        byte[] m_Data;
        double m_DeltaT;

        InputReportData(byte[] byArray, double d) {
            this.m_Data = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.m_Data, 0, byArray.length);
            this.m_DeltaT = d;
        }
    }

    static enum DispMode {
        XYZ,
        ABC;

    }
}

