/*
 * Decompiled with CFR 0.152.
 */
package inmemorycompiler;

import inmemorycompiler.CompilerUtils;
import inmemorycompiler.FileManeger;
import inmemorycompiler.StringAsSource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class CachedCompiler
implements Closeable {
    private static final PrintWriter DEFAULT_WRITER = new PrintWriter(System.err);
    private final Map<ClassLoader, Map<String, Class>> m_LoadedClasses = Collections.synchronizedMap(new WeakHashMap());
    private final Map<ClassLoader, FileManeger> m_FileManagers = Collections.synchronizedMap(new WeakHashMap());
    private final File m_SourceDir;
    private final File m_ClassDir;
    private final Map<String, JavaFileObject> m_JavaFileObjects = new HashMap<String, JavaFileObject>();

    public CachedCompiler(File file, File file2) {
        this.m_SourceDir = file;
        this.m_ClassDir = file2;
    }

    @Override
    public void close() {
        try {
            for (FileManeger fileManeger : this.m_FileManagers.values()) {
                fileManeger.close();
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public Class loadFromJava(String string, String string2) throws ClassNotFoundException {
        return this.loadFromJava(this.getClass().getClassLoader(), string, string2, DEFAULT_WRITER);
    }

    public Class loadFromJava(ClassLoader classLoader, String string, String string2) throws ClassNotFoundException {
        return this.loadFromJava(classLoader, string, string2, DEFAULT_WRITER);
    }

    Map<String, byte[]> compileFromJava(String string, String string2, FileManeger fileManeger) {
        return this.compileFromJava(string, string2, DEFAULT_WRITER, fileManeger);
    }

    Map<String, byte[]> compileFromJava(String string, String string2, final PrintWriter printWriter, FileManeger fileManeger) {
        Iterable<JavaFileObject> iterable;
        Object object;
        if (this.m_SourceDir != null) {
            String string3 = string.replaceAll("\\.", "\\" + File.separator) + ".java";
            object = new File(this.m_SourceDir, string3);
            CompilerUtils.writeText((File)object, string2);
            iterable = CompilerUtils.s_standardJavaFileManager.getJavaFileObjects(new File[]{object});
        } else {
            this.m_JavaFileObjects.put(string, new StringAsSource(string, string2));
            iterable = this.m_JavaFileObjects.values();
        }
        boolean bl = CompilerUtils.s_compiler.getTask(printWriter, fileManeger, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    printWriter.println(diagnostic);
                }
            }
        }, null, null, iterable).call();
        object = fileManeger.getAllBuffers();
        if (!bl) {
            if (this.m_SourceDir == null) {
                this.m_JavaFileObjects.remove(string);
            }
            return Collections.emptyMap();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadFromJava(ClassLoader classLoader, String string, String string2, PrintWriter printWriter) throws ClassNotFoundException {
        Map<ClassLoader, Map<String, Class>> map;
        Map<String, Class> map2;
        Class<?> clazz = null;
        Object object = this.m_LoadedClasses;
        synchronized (object) {
            map2 = this.m_LoadedClasses.get(classLoader);
            if (map2 == null) {
                map2 = new LinkedHashMap<String, Class>();
                this.m_LoadedClasses.put(classLoader, map2);
            } else {
                clazz = map2.get(string);
            }
        }
        Object object2 = object = printWriter == null ? DEFAULT_WRITER : printWriter;
        if (clazz != null) {
            return clazz;
        }
        FileManeger fileManeger = this.m_FileManagers.get(classLoader);
        if (fileManeger == null) {
            map = CompilerUtils.s_compiler.getStandardFileManager(null, null, null);
            fileManeger = new FileManeger((StandardJavaFileManager)((Object)map));
            this.m_FileManagers.put(classLoader, fileManeger);
        }
        for (Map.Entry entry : this.compileFromJava(string, string2, (PrintWriter)object, fileManeger).entrySet()) {
            Object object3;
            String string3 = (String)entry.getKey();
            Object object4 = this.m_LoadedClasses;
            synchronized (object4) {
                if (map2.containsKey(string3)) {
                    continue;
                }
            }
            object4 = (byte[])entry.getValue();
            if (this.m_ClassDir != null) {
                object3 = string3.replaceAll("\\.", "\\" + File.separator) + ".class";
                boolean bl = CompilerUtils.writeBytes(new File(this.m_ClassDir, (String)object3), (byte[])object4);
            }
            object3 = CompilerUtils.defineClass(classLoader, string3, (byte[])object4);
            Map<ClassLoader, Map<String, Class>> map3 = this.m_LoadedClasses;
            synchronized (map3) {
                map2.put(string3, (Class)object3);
            }
        }
        map = this.m_LoadedClasses;
        synchronized (map) {
            clazz = classLoader.loadClass(string);
            map2.put(string, clazz);
        }
        return clazz;
    }
}

