/*
 * Decompiled with CFR 0.152.
 */
package inmemorycompiler;

import inmemorycompiler.CachedCompiler;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class CompilerUtils
extends Enum<CompilerUtils> {
    public static final CachedCompiler CACHED_COMPILER;
    private static final Method DEFINE_CLASS_METHOD;
    private static final Charset UTF_8;
    private static final String JAVA_CLASS_PATH = "java.class.path";
    static JavaCompiler s_compiler;
    static StandardJavaFileManager s_standardJavaFileManager;
    private static final /* synthetic */ CompilerUtils[] $VALUES;

    public static CompilerUtils[] values() {
        return (CompilerUtils[])$VALUES.clone();
    }

    public static CompilerUtils valueOf(String string) {
        return Enum.valueOf(CompilerUtils.class, string);
    }

    private static void reset() {
        s_compiler = ToolProvider.getSystemJavaCompiler();
        if (s_compiler == null) {
            try {
                Class<?> clazz = Class.forName("com.sun.tools.javac.api.JavacTool");
                Method method = clazz.getMethod("create", new Class[0]);
                s_compiler = (JavaCompiler)method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
    }

    public static Class loadFromResource(String string, String string2) throws IOException, ClassNotFoundException {
        return CompilerUtils.loadFromJava(string, CompilerUtils.readText(string2));
    }

    private static Class loadFromJava(String string, String string2) throws ClassNotFoundException {
        return CACHED_COMPILER.loadFromJava(Thread.currentThread().getContextClassLoader(), string, string2);
    }

    public static boolean addClassPath(String string) {
        File file = new File(string);
        if (file.exists()) {
            String string2;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            if (!Arrays.asList(System.getProperty(JAVA_CLASS_PATH).split(File.pathSeparator)).contains(string2)) {
                System.setProperty(JAVA_CLASS_PATH, System.getProperty(JAVA_CLASS_PATH) + File.pathSeparator + string2);
            }
        } else {
            return false;
        }
        CompilerUtils.reset();
        return true;
    }

    public static void defineClass(String string, byte[] byArray) {
        CompilerUtils.defineClass(Thread.currentThread().getContextClassLoader(), string, byArray);
    }

    public static Class defineClass(ClassLoader classLoader, String string, byte[] byArray) {
        try {
            return (Class)DEFINE_CLASS_METHOD.invoke((Object)classLoader, string, byArray, 0, byArray.length);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(String string) throws IOException {
        if (string.startsWith("=")) {
            return string.substring(1);
        }
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader(CompilerUtils.getInputStream(string), UTF_8);
        try {
            int n;
            char[] cArray = new char[8192];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringWriter.write(cArray, 0, n);
            }
        }
        finally {
            CompilerUtils.close(inputStreamReader);
        }
        return stringWriter.toString();
    }

    private static byte[] readBytes(File file) {
        if (!file.exists()) {
            return null;
        }
        long l = file.length();
        if (l > Runtime.getRuntime().totalMemory() / 10L) {
            throw new IllegalStateException("Attempted to read large file " + file + " was " + l + " bytes.");
        }
        byte[] byArray = new byte[(int)l];
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            dataInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to read file " + file, iOException);
        }
        return byArray;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean writeText(File file, String string) {
        return CompilerUtils.writeBytes(file, CompilerUtils.encodeUTF8(string));
    }

    private static byte[] encodeUTF8(String string) {
        try {
            return string.getBytes(UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public static boolean writeBytes(File file, byte[] byArray) {
        Object object;
        File file2 = file.getParentFile();
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new IllegalStateException("Unable to create directory " + file2);
        }
        File file3 = null;
        if (file.exists()) {
            object = CompilerUtils.readBytes(file);
            if (Arrays.equals(byArray, object)) {
                return false;
            }
            file3 = new File(file2, file.getName() + ".bak");
            file.renameTo(file3);
        }
        try {
            object = new FileOutputStream(file);
            try {
                object.write(byArray);
            }
            finally {
                object.close();
            }
        }
        catch (IOException iOException) {
            file.delete();
            if (file3 != null) {
                file3.renameTo(file);
            }
            throw new IllegalStateException("Unable to write " + file, iOException);
        }
        return true;
    }

    private static InputStream getInputStream(String string) throws FileNotFoundException {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The file name cannot be empty.");
        }
        if (string.charAt(0) == '=') {
            return new ByteArrayInputStream(CompilerUtils.encodeUTF8(string.substring(1)));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        InputStream inputStream2 = classLoader.getResourceAsStream("/" + string);
        if (inputStream2 != null) {
            return inputStream2;
        }
        return new FileInputStream(string);
    }

    private static /* synthetic */ CompilerUtils[] $values() {
        return new CompilerUtils[0];
    }

    static {
        $VALUES = CompilerUtils.$values();
        CACHED_COMPILER = new CachedCompiler(null, null);
        UTF_8 = Charset.forName("UTF-8");
        try {
            DEFINE_CLASS_METHOD = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            DEFINE_CLASS_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        CompilerUtils.reset();
    }
}

