/*
 * Decompiled with CFR 0.152.
 */
package inmemorycompiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

class FileManeger
implements JavaFileManager {
    private final StandardJavaFileManager m_StandardFileManager;
    private final Map<String, ByteArrayOutputStream> m_Buffers = new LinkedHashMap<String, ByteArrayOutputStream>();

    FileManeger(StandardJavaFileManager standardJavaFileManager) {
        this.m_StandardFileManager = standardJavaFileManager;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.m_StandardFileManager.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        return this.m_StandardFileManager.list(location, string, set, bl);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        return this.m_StandardFileManager.inferBinaryName(location, javaFileObject);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        return this.m_StandardFileManager.isSameFile(fileObject, fileObject2);
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return this.m_StandardFileManager.handleOption(string, iterator);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.m_StandardFileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        if (location == StandardLocation.CLASS_OUTPUT && this.m_Buffers.containsKey(string) && kind == JavaFileObject.Kind.CLASS) {
            final byte[] byArray = this.m_Buffers.get(string).toByteArray();
            return new SimpleJavaFileObject(URI.create(string), kind){

                @Override
                public InputStream openInputStream() {
                    return new ByteArrayInputStream(byArray);
                }
            };
        }
        return this.m_StandardFileManager.getJavaFileForInput(location, string, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        return new SimpleJavaFileObject(URI.create(string), kind){

            @Override
            public OutputStream openOutputStream() {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileManeger.this.m_Buffers.put(string, byteArrayOutputStream);
                return byteArrayOutputStream;
            }
        };
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        return this.m_StandardFileManager.getFileForInput(location, string, string2);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        return this.m_StandardFileManager.getFileForOutput(location, string, string2, fileObject);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.m_StandardFileManager.close();
    }

    @Override
    public int isSupportedOption(String string) {
        return this.m_StandardFileManager.isSupportedOption(string);
    }

    public void clearBuffers() {
        this.m_Buffers.clear();
    }

    public Map<String, byte[]> getAllBuffers() {
        LinkedHashMap<String, byte[]> linkedHashMap = new LinkedHashMap<String, byte[]>(this.m_Buffers.size() * 2);
        for (Map.Entry<String, ByteArrayOutputStream> entry : this.m_Buffers.entrySet()) {
            linkedHashMap.put(entry.getKey(), entry.getValue().toByteArray());
        }
        return linkedHashMap;
    }
}

