/*
 * Decompiled with CFR 0.152.
 */
package macstuff;

import eazycnc.Main;
import java.awt.Desktop;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class MacStuff {
    public MacStuff(Main main) {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            System.out.println("JVM arguments:");
            for (String object2 : list) {
                System.out.println("   " + object2);
            }
            InputMap inputMap = (InputMap)UIManager.get("TextField.focusInputMap");
            inputMap.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
            inputMap.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
            inputMap.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
            Desktop desktop = Desktop.getDesktop();
            desktop.setQuitHandler((quitEvent, quitResponse) -> main.tryToQuit());
            desktop.setOpenFileHandler(openFilesEvent -> {
                for (File file : openFilesEvent.getFiles()) {
                    try {
                        main.m_MachController.ensurePausedOrStopped(null);
                        main.m_GCodeEditor.tryToLoadFile(file.getAbsolutePath());
                    }
                    catch (Exception exception) {
                        System.err.println("Open file '" + file.getAbsolutePath() + "' failed.");
                        exception.printStackTrace(System.err);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            System.out.println("I guess this is not Mac OS X after all - this occured: " + throwable.getClass().getSimpleName() + " " + throwable.getMessage());
        }
    }
}

