/*
 * Decompiled with CFR 0.152.
 */
package motorcontrol;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.Observer;
import com.eazycnc.uwk.SimpleVariable;
import eazycnc.LimitChecker;
import eazycnc.Main;
import eazycnc.PluginMethods;
import eazycnc.ToolpathDisplayPanel;
import eazycnc.gcode.FilePos;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import eazycnc.gcode.ParameterValidators;
import eazycnc.planner.MovePipeline;
import eazycnc.planner.PlotDataDouble;
import eazycnc.planner.PlotDataObject;
import eazycnc.planner.QuinticToolPathPlanner;
import eazycnc.planner.ToolPathPlanner;
import eazycnc.planner.ToolPathPlannerInterface;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.LinkedList;
import motorcontrol.MachiningState;
import motorcontrol.ProgressQueue;
import motorcontrol.TrajectoryPathPlotter;
import toad4plus.Toad4PlusMotorController;

public final class MachController {
    private static final boolean LOG_EXCECUTE = false;
    public static final int SPEED_ANALOG_OUTPUT = 0;
    public static final int SPINDLE_FORWARD_OUTPUT = 0;
    public static final int SPINDLE_REVERSE_OUTPUT = 1;
    public static final int COOLANT_OUTPUT = 2;
    public static final int ARC_START_OUTPUT = 3;
    public static final int MOTOR_CONTROLLER_TOAD4 = 1;
    public static final int MOTOR_CONTROLLER_TOAD4_PLUS = 2;
    private volatile boolean m_PairXA;
    private boolean m_IsToad4Plus;
    private volatile ToolpathDisplayPanel m_ToolpathDisplayPanel;
    public volatile Toad4PlusMotorController m_MotorController;
    private volatile ToolPathPlannerInterface m_MovePlanner;
    private volatile ToolPathPlannerInterface m_DisplayPlanner;
    private volatile MachState m_DisplayMachState;
    private volatile LimitChecker m_MoveLimitChecker;
    public ProgressQueue m_ProgressQueue = new ProgressQueue();
    private volatile boolean m_Pushed = false;
    private volatile Machcode m_PushedCurrentMachCode;
    private volatile Machcode m_PushedFirstMachCode;
    private volatile int m_PushedPausedAtMachCode;
    private volatile double[] m_PushedPausedAtPosition;
    private volatile boolean m_PushedStopped = false;
    private volatile boolean m_PushedMachiningAtStart;
    private volatile boolean m_PushedMachiningAtEnd;
    private volatile CompletionCallback m_CompletionCallback;
    private volatile long m_DwellUntil;
    public volatile Thread m_RealTimeThread2;
    private volatile StatusDisplay m_StatusDisplay;
    public int HISTOGRAM_SIZE = 100;
    public static final int HISTOGRAM_BUCKETS = 1000;
    private volatile int[] m_Histogram = new int[1000];
    private volatile int[] m_MotorFromAxis;
    private volatile int[] m_AxisFromMotor;
    private volatile boolean m_Compiling;
    private volatile MachiningState m_PreviousState = null;
    private volatile double[] m_GetPlannerPosition;
    public MachState m_MachState;
    private volatile MachiningState m_PostLoadMachiningState;
    private volatile boolean m_Reloading;
    private volatile int m_PausedAtMachCodeID;
    private volatile double[] m_PausedAtPosition;
    private volatile boolean m_OutOfLimits;
    private volatile String m_Error;
    private volatile String m_ErrorMessage2;
    private volatile FilePos m_ErrorFilePos2;
    private volatile long T0;
    private volatile long m_Average;
    private volatile long m_Maximum;
    private volatile int m_MotorTestMotor = -1;
    private volatile double m_MotorTestRunLength = 0.0;
    private volatile boolean m_MotorTestHasHomeSwitch;
    private volatile int[] m_MotorTestHomePosition;
    private volatile Machcode m_FirstMachCode;
    private volatile Machcode m_CurrentMachCode;
    private volatile Machcode m_LastProcessedMachCode;
    private volatile Machcode m_LoadingMachCode;
    private volatile boolean m_RunReverseMode;
    private volatile boolean m_SingleStepMode;
    private volatile boolean m_MachiningAtStart;
    private volatile boolean m_MachiningAtEnd;
    private double m_Odometer = 0.0;
    private double[] m_Move0;
    private double m_EstimatedRunTime;
    private boolean m_StopWatchOn = false;
    private double m_StopWatchStartTime = 0.0;
    private double m_StopWatchStopTime = 0.0;
    private double m_StopWatchLapTime = 0.0;
    private double m_StopWatchLapStartTime;
    private double m_TotalRunTime = 0.0;
    private boolean m_WarningGiven;
    private boolean m_WarningGiven2;
    private SimpleVariable m_OutputOverrideOn = new SimpleVariable(false);
    private SimpleVariable m_SpindleSpeedOverride = new NumericVariable(0.0, 0, 100);
    private SimpleVariable m_SpindleForwardOverride = new SimpleVariable(false);
    private SimpleVariable m_SpindleReverseOverride = new SimpleVariable(false);
    private SimpleVariable m_CoolantOverride = new SimpleVariable(false);
    private SimpleVariable m_ArcStartOverride = new SimpleVariable(false);
    double[] m_ProbeStartPos;
    double[] m_ProbedPosition;
    private volatile MotorTestState m_MotorTestState;
    private int m_CachedPausedAtMachCodeID;
    private FilePos m_CachedPauseAtMachCodeFilePos;
    final boolean debug = false;
    MotorTestState state0;
    private Machcode debugCurrentMachCode;
    MachiningState m_State0;

    public double[] getProbedPosition() {
        return this.m_ProbedPosition;
    }

    public SimpleVariable getOutputOverrideOn() {
        return this.m_OutputOverrideOn;
    }

    public SimpleVariable getSpindleSpeedOverride() {
        return this.m_SpindleSpeedOverride;
    }

    public SimpleVariable getSpindleForwardOverride() {
        return this.m_SpindleForwardOverride;
    }

    public SimpleVariable getSpindleReverseOverride() {
        return this.m_SpindleReverseOverride;
    }

    public SimpleVariable getCoolantOverride() {
        return this.m_CoolantOverride;
    }

    public SimpleVariable getArcStartOverride() {
        return this.m_ArcStartOverride;
    }

    public void setTestMode(boolean bl) {
    }

    public void setPairXA(boolean bl) {
        this.m_PairXA = bl;
        this.m_MotorController.setPairXA(bl);
    }

    public boolean isPairXA() {
        return this.m_PairXA;
    }

    public synchronized void saveState(String string) throws Exception {
        this.ensurePausedOrStopped(null);
        String string2 = this.m_MachState.getStateAsJSON();
        Files.write(Paths.get(string, new String[0]), string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public boolean machiningIsAtEnd() {
        return this.m_RunReverseMode ? this.m_MachiningAtStart : this.m_MachiningAtEnd;
    }

    public synchronized boolean checkIfLoadedMachCodeIsStale() {
        return false;
    }

    private synchronized boolean checkIfLoadedMachCodeIsStale_() {
        if (this.m_FirstMachCode == null) {
            return false;
        }
        double[] dArray = this.m_FirstMachCode.getPosition();
        double[] dArray2 = this.getAxisPos();
        int n = Math.min(dArray.length, dArray2.length);
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == dArray2[i]) continue;
            return true;
        }
        return false;
    }

    public void showPlanPlotter() {
        try {
            if (this.m_FirstMachCode == null) {
                return;
            }
            PlotDataObject plotDataObject = new PlotDataObject();
            PlotDataDouble plotDataDouble = new PlotDataDouble();
            int[] nArray = new int[]{0};
            double[] dArray = new double[]{0.0};
            this.m_DisplayPlanner.setCapture((object, bl, d, dArray2) -> {
                plotDataObject.add(object);
                int n = dArray2.length;
                if (nArray[0] == 0) {
                    nArray[0] = n;
                } else if (nArray[0] != n) {
                    throw new IllegalArgumentException("BUG, inconsistent capture data lengths " + nArray[0] + " != " + n);
                }
                for (int i = 0; i < dArray2.length; ++i) {
                    plotDataDouble.add(dArray2[i]);
                }
                if (d > dArray[0]) {
                    dArray[0] = d;
                }
            });
            this.load(this.m_FirstMachCode, true);
            this.m_DisplayPlanner.setCapture(null);
            TrajectoryPathPlotter.showTrajectoryData(plotDataObject, plotDataDouble, nArray[0], this.m_MachState.getParamDouble(15150), dArray[0], this.m_MachState.getParamDouble(15148), this.m_MachState.getParamDouble(15169));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkAutoZero() {
        if (this.getMachiningState() == MachiningState.STOPPED) {
            this.syncMachStateWithMotorPositions();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < 6; ++i) {
                if (!this.getMachState().getParamBoolean(-2147483639, i) || this.getMachState().getLocalPos(i) == 0.0) continue;
                this.getMachState().setWorkOffsetFromLocal(i, 0.0);
                linkedList.add(this.getAxisLetterFromMotor(this.motorFromAxis(i)));
            }
            if (!linkedList.isEmpty()) {
                Object object = "";
                if (linkedList.size() == 1) {
                    object = (String)linkedList.getFirst() + " axis has";
                } else {
                    for (String string : linkedList) {
                        if (!((String)object).isEmpty()) {
                            object = string == linkedList.getLast() ? (String)object + " and " : (String)object + ",";
                        }
                        object = (String)object + string;
                    }
                    object = (String)object + " axes have";
                }
                throw new IllegalArgumentException((String)object + " been auto ZEROed, press RUN again to start machining.");
            }
        }
    }

    private void checkSpindleOn() {
        if (this.getMachiningState() == MachiningState.PAUSED && !this.m_MachState.getParamBoolean(15126) && !this.m_WarningGiven) {
            this.m_WarningGiven = true;
            throw new IllegalArgumentException("Warning Spindle not ON!!!  Press RUN again to start machining.");
        }
    }

    public synchronized void checkStartCyclePrerequisites() {
        ParameterValidators.validateMotorParameters(this);
        this.ensurePausedOrStoppedAndConnected(MachiningState.RUNNING);
        if (this.m_MachState.getParamInt(15168) == 7) {
            throw new IllegalArgumentException("In MANUAL Jog mode, select non-manual jog mode to be able to RUN");
        }
        if (this.m_Compiling) {
            throw new IllegalArgumentException("G-code processing in progress");
        }
        if (this.m_FirstMachCode == null) {
            throw new IllegalArgumentException("No G-code loaded");
        }
        if (!this.m_RunReverseMode && this.m_MachiningAtEnd) {
            throw new IllegalArgumentException("Already at the end of program, press STOP to rewind");
        }
        if (this.m_RunReverseMode && this.m_MachiningAtStart) {
            throw new IllegalArgumentException("Already at the start of program, toggle REVERSE to run forward");
        }
    }

    public synchronized void checkSpindleSpeedAndFeedRate() {
        if (this.getMachiningState() != MachiningState.STOPPED) {
            return;
        }
        if (this.m_WarningGiven2) {
            return;
        }
        double d = this.m_MachState.getParamDouble(15149) * 60.0;
        double d2 = this.m_MachState.getParamDouble(15157);
        double d3 = this.m_MachState.getParamBoolean(15162) ? this.m_MachState.getParamDouble(15161) : this.m_MachState.getParamDouble(15127);
        double d4 = this.m_MachState.getParamBoolean(15131) ? this.m_MachState.getParamDouble(15132) : this.m_MachState.getParamDouble(15145);
        if (d3 > d2) {
            this.m_WarningGiven2 = true;
            throw new IllegalArgumentException("Current spindle speed over machine maxium!!!  Press RUN again to start machining.");
        }
        if (d4 > d) {
            this.m_WarningGiven2 = true;
            throw new IllegalArgumentException("Current feedrate over machine maxium!!!  Press RUN again to start machining.");
        }
        Machcode machcode = this.m_FirstMachCode;
        while (machcode != null) {
            if (machcode.m_Type == Machcode.SegmentType.SET_PARAMETER) {
                Machcode.SetParameter setParameter = (Machcode.SetParameter)machcode;
                if (setParameter.m_Parameter == 15127 && (d3 = ((Double)setParameter.m_Value).doubleValue()) > d2) {
                    this.m_WarningGiven2 = true;
                    throw new IllegalArgumentException("Spindle speed in G-code over machine maxium!!!  Press RUN again to start machining.");
                }
            }
            if ((d4 = machcode.getVelocity() * 60.0) > 0.0 && d4 > d) {
                this.m_WarningGiven2 = true;
                throw new IllegalArgumentException("Feedrate in G-code over machine maxium!!!  Press RUN again to start machining.");
            }
            machcode = machcode.m_Next;
        }
    }

    public synchronized void startCycle(CompletionCallback completionCallback) {
        this.startCycle(false, completionCallback);
    }

    public synchronized void startCycle(boolean bl) {
        this.startCycle(bl, null);
    }

    public synchronized void startCycle(boolean bl, CompletionCallback completionCallback) {
        this.clearError();
        this.checkStartCyclePrerequisites();
        if (bl) {
            this.checkAutoZero();
        }
        this.checkSpindleOn();
        this.checkSpindleSpeedAndFeedRate();
        if (this.m_RunReverseMode) {
            this.m_MachiningAtEnd = false;
        } else {
            this.m_MachiningAtStart = false;
        }
        this.m_StatusDisplay.setOperatorMessage(null);
        this.syncMachStateWithMotorPositions();
        if (this.getMachiningState() == MachiningState.STOPPED) {
            this.m_PausedAtMachCodeID = this.m_FirstMachCode.m_MachCodeID;
            this.m_PausedAtPosition = null;
            this.m_ToolpathDisplayPanel.clearMachinedPath();
            this.resetStopWatch();
        }
        this.m_CompletionCallback = completionCallback;
        Machcode machcode = this.m_FirstMachCode;
        while (machcode != null) {
            System.out.println(machcode);
            machcode = machcode.m_Next;
        }
        this.setMachiningState(MachiningState.START_RUNNING);
    }

    public synchronized void pauseCycle() {
        MachiningState machiningState = this.getMachiningState();
        this.ensureNotPausingNorStopping(machiningState);
        if (machiningState == MachiningState.PAUSED || machiningState == MachiningState.PAUSING) {
            return;
        }
        if (machiningState != MachiningState.RUNNING && machiningState != MachiningState.STEP_WAIT) {
            throw new IllegalArgumentException("Machining not in progress");
        }
        this.setMachiningState(MachiningState.PAUSING);
        this.m_RealTimeThread2.interrupt();
    }

    public synchronized void stopCycle() {
        MachiningState machiningState = this.getMachiningState();
        this.ensureNotPausingNorStopping(machiningState);
        this.m_MachiningAtStart = false;
        this.m_MachiningAtEnd = false;
        if (this.getMachiningState() == MachiningState.STOPPED) {
            return;
        }
        if (this.getMachiningState() != MachiningState.RUNNING && this.getMachiningState() != MachiningState.PAUSED) {
            throw new IllegalArgumentException("Machining not in progress");
        }
        this.m_ToolpathDisplayPanel.clearMachinedPath();
        this.setMachiningState(MachiningState.STOPPING);
        this.m_RealTimeThread2.interrupt();
    }

    public synchronized void stopEverything() {
        if (this.getMachiningState() == MachiningState.STOPPED || this.getMachiningState() == MachiningState.PAUSED) {
            this.m_MotorController.abortAll();
        }
    }

    public synchronized void gotoLine(String string, int n) {
        this.ensurePausedOrStopped(MachiningState.PAUSED);
        this.m_MachiningAtEnd = false;
        this.m_MachiningAtStart = false;
        Machcode machcode = this.m_FirstMachCode;
        while (machcode != null) {
            if (machcode.m_FilePos != null && machcode.m_FilePos.getLineNo() == n && string.equals(machcode.m_FilePos.getFileName()) && machcode.m_MachCodeID != -1) {
                this.m_PausedAtPosition = this.m_MachState.axisToLocal(this.getAxisPos());
                this.m_PausedAtMachCodeID = machcode.m_MachCodeID;
                this.m_CurrentMachCode = machcode;
                this.setMachiningState(MachiningState.PAUSED);
                break;
            }
            machcode = machcode.m_Next;
        }
    }

    public static void dumpMachCode(Machcode machcode) {
        int n = 0;
        Machcode machcode2 = machcode;
        System.out.println("MachController.dumpMachCode()");
        while (machcode2 != null) {
            System.out.println(machcode2);
            machcode2 = machcode2.m_Next;
            if (n++ <= 100) continue;
            break;
        }
    }

    private void resetStopWatch() {
        this.m_StopWatchStartTime = 0.0;
        this.m_StopWatchStopTime = 0.0;
        this.m_StopWatchOn = false;
        this.m_StopWatchLapStartTime = 0.0;
        this.m_StopWatchLapTime = 0.0;
    }

    private void startStopWatch() {
        double d;
        if (this.m_StopWatchOn) {
            return;
        }
        this.m_StopWatchOn = true;
        this.m_StopWatchLapStartTime = d = this.getTime();
        if (this.m_StopWatchStartTime == 0.0) {
            this.m_StopWatchStartTime = d;
            this.m_TotalRunTime = 0.0;
        }
    }

    private void stopStopWatch() {
        if (!this.m_StopWatchOn) {
            return;
        }
        double d = this.getTime();
        this.m_StopWatchLapTime += d - this.m_StopWatchLapStartTime;
        this.m_StopWatchStopTime = d;
        this.m_TotalRunTime += this.m_StopWatchLapTime;
        String string = "Machining " + (this.getMachiningState() == MachiningState.PAUSED ? "paused" : "stopped");
        string = string + " total " + this.getElapseRunTimeString();
        if (this.m_ErrorMessage2 == null) {
            this.m_ErrorMessage2 = string;
            this.m_ErrorFilePos2 = null;
        }
        this.m_StopWatchOn = false;
    }

    public static String formatTime(double d) {
        long l = (long)d;
        long l2 = l / 3600L;
        long l3 = l % 3600L / 60L;
        long l4 = l % 60L;
        if (l2 > 0L) {
            return String.format("%d hr %d min %d sec ", l2, l3, l4);
        }
        if (l3 > 0L) {
            return String.format("%d min %d sec ", l3, l4);
        }
        return String.format("%d sec ", l4);
    }

    public synchronized Machcode getLoadedMachCode() {
        return this.m_FirstMachCode;
    }

    public synchronized boolean load(Machcode machcode, boolean bl) {
        MachiningState machiningState = this.getMachiningState();
        this.ensureNotPausingNorStopping(machiningState);
        MachiningState machiningState2 = this.getMachiningState();
        try {
            this.m_FirstMachCode = machcode;
            this.m_PostLoadMachiningState = machiningState2;
            this.m_Reloading = bl;
            this.setMachiningState(MachiningState.START_LOADING);
            while (this.getMachiningState() == MachiningState.START_LOADING || this.getMachiningState() == MachiningState.LOADING || this.getMachiningState() == MachiningState.STOP_LOADING) {
                this.wait(100L);
            }
            if (!bl) {
                this.m_PausedAtMachCodeID = this.m_FirstMachCode.m_MachCodeID;
            }
            return true;
        }
        catch (Exception exception) {
            this.setMachiningState(machiningState2);
            exception.printStackTrace();
            return false;
        }
    }

    public synchronized void setRunReverse(boolean bl) {
        this.ensurePausedOrStoppedAndConnected(null);
        this.m_RunReverseMode = bl;
    }

    public synchronized void setSingleStepMode(boolean bl) {
        this.ensureConnected();
        this.m_SingleStepMode = bl;
        if (this.m_SingleStepMode && this.getMachiningState() == MachiningState.RUNNING) {
            this.setMachiningState(MachiningState.STEP_WAIT);
            this.m_RealTimeThread2.interrupt();
        }
    }

    public MotorController getMotorController() {
        return this.m_MotorController;
    }

    public String getMotorUnderTest() {
        if (this.m_MotorTestMotor < 0) {
            return null;
        }
        return this.getAxisLetterFromMotor(this.m_MotorTestMotor);
    }

    public String getAxisLetterFromMotor(int n) {
        return Interpreter.getAxisLetter(this.m_AxisFromMotor[n]);
    }

    public String getAxisLetter(int n) {
        return Interpreter.getAxisLetter(n);
    }

    public int motorFromAxis(int n) {
        if (n < 0) {
            return -1;
        }
        return this.m_MotorFromAxis[n];
    }

    public MachiningState getMachiningState() {
        MachiningState machiningState = this.m_MachState.getMachiningState();
        return machiningState;
    }

    public MachState getMachState() {
        return this.m_MachState;
    }

    public synchronized boolean isMacro() {
        return this.m_Pushed;
    }

    public void setCompiling(boolean bl) {
        this.m_Compiling = bl;
    }

    public boolean isCompiling() {
        return this.m_Compiling;
    }

    public boolean getRunReverse() {
        return this.m_RunReverseMode;
    }

    public boolean getSingleStepMode() {
        return this.m_SingleStepMode;
    }

    public double[] axisPositionFromMotorPosition(int[] nArray) {
        double[] dArray = new double[6];
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.m_MotorFromAxis[i];
            if (n < 0) continue;
            dArray[i] = (double)nArray[n] / this.m_MachState.getParamDouble(-2147483646, i);
        }
        return dArray;
    }

    private int[] motorPositionFromAxisPosition(double[] dArray) {
        int[] nArray = new int[6];
        double[] dArray2 = this.m_MachState.m_DoubleValues;
        for (int i = 0; i < dArray.length; ++i) {
            int n = this.m_MotorFromAxis[i];
            if (n < 0) continue;
            nArray[n] = (int)Math.round(dArray[i] * this.m_MachState.getParamDouble(-2147483646, i));
        }
        return nArray;
    }

    private void clearError() {
        this.m_Error = null;
        this.m_ErrorMessage2 = null;
        this.m_ErrorFilePos2 = null;
    }

    public String getError() {
        String string = this.m_ErrorMessage2;
        this.m_ErrorMessage2 = null;
        return string;
    }

    private void setError(FilePos filePos, String string) {
        System.out.println("ERROR LOG: " + string + ",on " + filePos);
        this.m_ErrorMessage2 = string;
        this.m_ErrorFilePos2 = filePos;
        this.m_Error = string;
    }

    public FilePos getErrorFilePos() {
        FilePos filePos = this.m_ErrorFilePos2;
        return filePos;
    }

    public FilePos getCurrentMachCodeFilePos() {
        if (this.m_MachState.getMachiningState() == MachiningState.PAUSED) {
            if (this.m_CachedPausedAtMachCodeID != this.m_PausedAtMachCodeID) {
                this.m_CachedPausedAtMachCodeID = this.m_PausedAtMachCodeID;
                Machcode machcode = this.findMachCode(this.m_PausedAtMachCodeID);
                if (machcode != null) {
                    this.m_CachedPauseAtMachCodeFilePos = machcode.m_FilePos;
                }
            }
            return this.m_CachedPauseAtMachCodeFilePos;
        }
        Machcode machcode = this.m_MovePlanner.getCurrentMachCode();
        if (machcode == null) {
            machcode = this.m_CurrentMachCode;
        }
        if (machcode != null) {
            return machcode.m_FilePos;
        }
        return null;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.m_MotorController.setConnectionState(connectionState);
    }

    public int getNumberOfMotors() {
        return this.m_MotorController.getNumberOfMotors();
    }

    public int[] getMotorPosition() {
        return this.m_MotorController.getMotorPosition();
    }

    public MachController(MachState machState, int n, Toad4PlusMotorController.ToadPlusCommInterface toadPlusCommInterface, StatusDisplay statusDisplay, ToolpathDisplayPanel toolpathDisplayPanel, PluginMethods pluginMethods) {
        Observer observer;
        this.m_MachState = machState;
        this.m_MotorController = new Toad4PlusMotorController(n, toadPlusCommInterface, this.m_MachState, pluginMethods, Main.m_ToadCommLogger);
        this.m_ToolpathDisplayPanel = toolpathDisplayPanel;
        this.m_MotorFromAxis = new int[n];
        this.m_AxisFromMotor = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            observer = observable -> {
                int n2;
                this.m_MotorFromAxis[n] = n2 = this.m_MachState.getParamInt(-2147483638, n3);
                if (n2 >= 0) {
                    this.m_AxisFromMotor[n2] = n3;
                }
            };
            this.m_MachState.getVariable(-2147483638, n3).addObserver(observer);
            this.m_MachState.getVariable(-2147483637, n3).addObserver(observer);
        }
        Observer observer2 = observable -> this.updateSpindle();
        this.m_MachState.getVariable(15126).addObserver(observer2);
        this.m_MachState.getVariable(15128).addObserver(observer2);
        this.m_MachState.getVariable(15162).addObserver(observer2);
        this.m_MachState.getVariable(15127).addObserver(observer2);
        this.m_MachState.getVariable(15359).addObserver(observer2);
        this.m_MachState.getVariable(15360).addObserver(observer2);
        this.m_OutputOverrideOn.addObserver(observer2);
        this.m_SpindleSpeedOverride.addObserver(observer2);
        this.m_SpindleForwardOverride.addObserver(observer2);
        this.m_SpindleReverseOverride.addObserver(observer2);
        Observer observer3 = observable -> this.updateCoolant();
        this.m_MachState.getVariable(15124).addObserver(observer3);
        this.m_OutputOverrideOn.addObserver(observer3);
        this.m_CoolantOverride.addObserver(observer3);
        observer = observable -> this.updateArcStart();
        this.m_MachState.getVariable(15126).addObserver(observer);
        this.m_MachState.getVariable(15128).addObserver(observer);
        this.m_OutputOverrideOn.addObserver(observer);
        this.m_ArcStartOverride.addObserver(observer);
        this.m_StatusDisplay = statusDisplay;
        this.m_GetPlannerPosition = new double[n];
        MovePipeline movePipeline = new MovePipeline(){

            @Override
            public void queueMove(Object object, double[] dArray) throws InterruptedException {
                try {
                    if (MachController.this.m_OutOfLimits) {
                        return;
                    }
                    int n = -1;
                    if (MachController.this.m_MoveLimitChecker != null) {
                        n = MachController.this.m_MoveLimitChecker.checkLimits(dArray);
                    }
                    if (n < 0) {
                        int[] nArray = MachController.this.motorPositionFromAxisPosition(dArray);
                        MachController.this.m_ProgressQueue.put(MachController.this.m_MachState.getParamBoolean(15126) ? 1 : 0, MachController.getToolRadiusForDisplay(MachController.this.m_MachState), dArray);
                        MachController.this.m_MotorController.queueMove(nArray);
                    } else {
                        MachController.this.m_OutOfLimits = true;
                        MachController.this.setMachiningState(MachiningState.STOPPING);
                        MachController.this.setError(((Machcode)object).m_FilePos, "Toolpath out of limits on " + MachController.this.getAxisLetter(n) + " axis");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("FIXME for some reason queueing a move was aborted");
                }
            }

            @Override
            public void flush() throws InterruptedException {
                MachController.this.m_MotorController.flush();
            }
        };
        this.m_MovePlanner = new QuinticToolPathPlanner("MOVE", this.getNumberOfMotors(), movePipeline, Main.m_DebugLogsDir);
        MovePipeline movePipeline2 = new MovePipeline(){

            @Override
            public void queueMove(Object object, double[] dArray) throws InterruptedException {
                try {
                    int n = -1;
                    if (MachController.this.m_MoveLimitChecker != null) {
                        n = MachController.this.m_MoveLimitChecker.checkLimits(dArray);
                    }
                    if (n >= 0) {
                        if (!MachController.this.m_OutOfLimits) {
                            MachController.this.setError(((Machcode)object).m_FilePos, "Toolpath out of limits on " + MachController.this.getAxisLetter(n) + " axis");
                        }
                        MachController.this.m_OutOfLimits = true;
                    }
                    boolean bl = MachController.this.m_DisplayMachState.getParamBoolean(15126);
                    double d = MachController.getToolRadiusForDisplay(MachController.this.m_DisplayMachState);
                    MachController.this.m_ToolpathDisplayPanel.m_PlannedToolPath.concatToolMove(false, bl, bl ? d : 0.2, dArray);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    MachController.this.m_ToolpathDisplayPanel.clearAllToolpaths();
                }
            }

            @Override
            public void flush() throws InterruptedException {
            }
        };
        this.m_DisplayMachState = new MachState("DISPLAY", this.m_MachState);
        boolean bl = true;
        this.m_DisplayPlanner = bl ? new QuinticToolPathPlanner("DISPLAY", this.getNumberOfMotors(), movePipeline2, Main.m_DebugLogsDir) : new ToolPathPlanner("DISPLAY", this.getNumberOfMotors(), this.m_DisplayMachState, movePipeline2);
        this.m_RealTimeThread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                MachController.this.backgroundRun2();
            }
        }, "MachController");
        this.m_RealTimeThread2.setPriority(10);
        this.m_RealTimeThread2.setUncaughtExceptionHandler((thread, throwable) -> throwable.printStackTrace());
        this.m_RealTimeThread2.start();
    }

    public static int hwPwm2ReqPwm(double d) {
        int n = (int)Math.round(d / 100.0 * 255.0);
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    private void updateSpindle() {
        double d;
        if (this.m_OutputOverrideOn.getValue().equals(true)) {
            this.m_MotorController.setDigitalOutput(0, this.m_SpindleForwardOverride.getValue().equals(true));
            this.m_MotorController.setDigitalOutput(1, this.m_SpindleReverseOverride.getValue().equals(true));
            double d2 = (Double)this.m_SpindleSpeedOverride.getValue();
            this.m_MotorController.setAnalogOutput(0, MachController.hwPwm2ReqPwm(d2));
            return;
        }
        boolean bl = this.m_MachState.getParamBoolean(15126);
        int n = this.m_MachState.getParamInt(15128);
        double d3 = d = this.m_MachState.getParamBoolean(15162) ? this.m_MachState.getParamDouble(15161) : this.m_MachState.getParamDouble(15127);
        if (bl) {
            if (1 == n) {
                this.m_MotorController.setDigitalOutput(0, true);
                this.m_MotorController.setDigitalOutput(1, false);
            }
            if (2 == n) {
                this.m_MotorController.setDigitalOutput(0, false);
                this.m_MotorController.setDigitalOutput(1, true);
            }
        } else {
            this.m_MotorController.setDigitalOutput(0, false);
            this.m_MotorController.setDigitalOutput(1, false);
            d = 0.0;
        }
        double d4 = this.m_MachState.getParamDouble(15359);
        double d5 = this.m_MachState.getParamDouble(15360);
        double d6 = this.m_MachState.getParamDouble(15357);
        double d7 = this.m_MachState.getParamDouble(15358);
        double d8 = (d7 - d6) / (d5 - d4) * (d - d4) + d6;
        if (d <= 0.0) {
            d8 = 0.0;
        }
        this.m_MotorController.setAnalogOutput(0, MachController.hwPwm2ReqPwm(d8));
    }

    private void updateCoolant() {
        if (this.m_OutputOverrideOn.getValue().equals(true)) {
            this.m_MotorController.setDigitalOutput(2, this.m_CoolantOverride.getValue().equals(true));
            return;
        }
        boolean bl = this.m_MachState.getParamBoolean(15124);
        if (bl) {
            this.m_MotorController.setDigitalOutput(2, true);
        } else {
            this.m_MotorController.setDigitalOutput(2, false);
        }
    }

    private void updateArcStart() {
        if (this.m_OutputOverrideOn.getValue().equals(true)) {
            this.m_MotorController.setDigitalOutput(3, this.m_ArcStartOverride.getValue().equals(true));
            return;
        }
        boolean bl = this.m_MachState.getParamBoolean(15126);
        int n = this.m_MachState.getParamInt(15128);
        this.m_MotorController.setDigitalOutput(3, bl && 1 == n);
    }

    private boolean probeTriggeredOrPlannerIsStarvedAndAllMotorsAreReady() {
        return false;
    }

    private void initPlanner(ToolPathPlannerInterface toolPathPlannerInterface) {
        toolPathPlannerInterface.setParameters(this.m_MachState.getParamDouble(15172), this.m_MachState.getParamDouble(15150), this.m_MachState.getParamDouble(15149), this.m_MachState.getParamDouble(15148), this.m_MachState.getParamDouble(15169));
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = this.m_MachState.getParamDouble(-2147483633, i);
        }
        toolPathPlannerInterface.setScalers(dArray);
        ((QuinticToolPathPlanner)toolPathPlannerInterface).m_UseNewArcInterpolation = this.m_MachState.getParamBoolean(15288);
    }

    private void startLoading(boolean bl) throws InterruptedException {
        this.m_OutOfLimits = false;
        this.m_MoveLimitChecker = new LimitChecker(this.m_MachState);
        this.initPlanner(this.m_DisplayPlanner);
        this.m_LoadingMachCode = this.m_FirstMachCode;
        if (bl) {
            Machcode machcode = this.m_LoadingMachCode.m_Next;
            while (machcode != null && machcode.getPosition() == null) {
                machcode = machcode.m_Next;
            }
            if (machcode != null) {
                this.m_DisplayPlanner.startPlanner(true, machcode.getPosition());
                return;
            }
        }
        this.m_DisplayPlanner.startPlanner(true, this.getAxisPos());
    }

    private void startRunning() throws InterruptedException {
        this.m_OutOfLimits = false;
        this.m_Odometer = 0.0;
        this.m_Move0 = null;
        this.initPlanner(this.m_MovePlanner);
        this.m_CurrentMachCode = this.findMachCode(this.m_PausedAtMachCodeID);
        this.m_MotorController.startRunning();
        this.m_MovePlanner.startPlanner(false, this.getAxisPos());
        if (this.m_PausedAtPosition != null) {
            Machcode.LinearMove linearMove = new Machcode.LinearMove(null, 0, 0.0, 0.0, this.m_MachState.getParamDouble(15149), this.m_PausedAtPosition);
            this.m_MovePlanner.queueSegment(((Machcode)linearMove).getVelocity(), linearMove);
        }
        this.m_PausedAtMachCodeID = 0;
        this.m_PausedAtPosition = null;
    }

    private Machcode findMachCode(int n) {
        Machcode machcode = this.m_FirstMachCode;
        while (machcode != null) {
            if (machcode.m_MachCodeID == n) {
                return machcode;
            }
            machcode = machcode.m_Next;
        }
        return null;
    }

    private static double getToolRadiusForDisplay(MachState machState) {
        int n;
        double d = Math.abs(machState.getParamDouble(15136));
        if (d == 0.0 && (n = machState.getParamInt(15147)) > 0 && n <= 255) {
            d = machState.getParamDouble(0x40000000, n - 1) / 2.0;
        }
        return d;
    }

    private double[] getAxisPos() {
        this.syncMachStateWithMotorPositions();
        return this.m_MachState.getAxisPos();
    }

    private void printMessageToConsole(String string) {
        Object object = "";
        while (string.length() > 0) {
            int n = string.indexOf("#");
            if (n >= 0) {
                char c;
                object = (String)object + string.substring(0, n);
                int n2 = 0;
                boolean bl = false;
                ++n;
                while (n < string.length() && (c = string.charAt(n)) >= '0' && c <= '9') {
                    n2 = n2 * 10 + c - 48;
                    ++n;
                    bl = true;
                }
                if (bl) {
                    object = (String)object + this.m_MachState.getParam(n2);
                }
            } else {
                n = 0;
            }
            string = string.substring(n);
        }
        System.err.println((String)object);
    }

    private void loadMachCode() throws InterruptedException {
        Machcode machcode = this.m_LoadingMachCode;
        MachState machState = this.m_DisplayMachState;
        try {
            switch (machcode.m_Type) {
                default: {
                    this.m_DisplayPlanner.flush();
                    break;
                }
                case STOP: {
                    this.m_LoadingMachCode = null;
                    return;
                }
                case SET_PARAMETER: {
                    Machcode.SetParameter setParameter = (Machcode.SetParameter)machcode;
                    if (setParameter.m_Parameter != 15122 || ((Number)setParameter.m_Value).intValue() == 0) {
                        this.m_DisplayPlanner.flush();
                    }
                    machState.setParam(setParameter.m_Parameter, setParameter.m_Value);
                    break;
                }
                case MOVE_LINEAR: 
                case MOVE_ARC_CCW: 
                case MOVE_ARC_CW: {
                    double d = machcode.getVelocity();
                    if (d == 0.0) {
                        d = machState.getParamDouble(15149);
                    }
                    this.m_DisplayPlanner.queueSegment(d, machcode);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_LoadingMachCode = this.m_LoadingMachCode.m_Next;
    }

    private void motorTest() throws Exception {
        block6: while (true) {
            Thread.sleep(100L);
            this.state0 = this.m_MotorTestState;
            switch (this.m_MotorTestState) {
                case HOME0: {
                    boolean bl = this.m_MotorTestHasHomeSwitch = this.m_MachState.getParamInt(-2147483644, this.m_MotorTestMotor) >= 0;
                    if (this.m_MotorTestHasHomeSwitch) {
                        this.m_MotorController.startHoming(this.m_MotorTestMotor, Integer.MIN_VALUE);
                    }
                    this.m_MotorTestState = MotorTestState.WAIT_HOME0;
                    break;
                }
                case WAIT_HOME0: {
                    MotorController.MotorState motorState;
                    if (this.m_MotorTestHasHomeSwitch) {
                        motorState = this.m_MotorController.getMotorState(this.m_MotorTestMotor);
                        if (this.m_MotorController.isHoming(this.m_MotorTestMotor)) continue block6;
                        if (motorState != MotorController.MotorState.READY) {
                            this.setError(null, "Homing timed out or aborted abnormally");
                            this.m_MotorTestState = null;
                            this.setMachiningState(MachiningState.STOPPING);
                            return;
                        }
                    }
                    this.m_MotorTestHomePosition = this.m_MotorController.getMotorPosition();
                    this.queueMotionTest();
                    this.m_MotorTestState = MotorTestState.RUN;
                    break;
                }
                case RUN: {
                    this.m_MovePlanner.flush();
                    this.m_MotorController.stopRunning();
                    if (this.m_MotorTestHasHomeSwitch) {
                        this.m_MotorController.startHoming(this.m_MotorTestMotor, Integer.MIN_VALUE);
                    }
                    this.m_MotorTestState = MotorTestState.WAIT_HOME;
                    break;
                }
                case WAIT_HOME: {
                    MotorController.MotorState motorState;
                    if (this.m_MotorTestHasHomeSwitch) {
                        motorState = this.m_MotorController.getMotorState(this.m_MotorTestMotor);
                        if (this.m_MotorController.isHoming(this.m_MotorTestMotor)) continue block6;
                        if (motorState != MotorController.MotorState.READY) {
                            this.setError(null, "Homing timed out or aborted abnormally");
                        } else {
                            int[] nArray = this.m_MotorController.getMotorPosition();
                            if (this.m_MotorTestHasHomeSwitch) {
                                this.setError(null, "Motion test run completed with " + (nArray[this.m_MotorTestMotor] - this.m_MotorTestHomePosition[this.m_MotorTestMotor]) + " step variability");
                            } else {
                                this.setError(null, "Motion test run completed, measure variability manually.");
                            }
                        }
                    }
                    this.m_MotorTestState = MotorTestState.HOME0;
                    return;
                }
            }
        }
    }

    private void performSeekHomeMachCode(Machcode.SeekHome seekHome) throws InterruptedException {
        int n;
        this.m_MovePlanner.flush();
        this.m_MovePlanner.stopPlanner();
        this.m_MotorController.stopRunning();
        boolean[] blArray = seekHome.m_Axis;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n] || !this.m_MachState.isAxisEnabled(n)) continue;
            this.m_MotorController.startHoming(n, 0);
        }
        block3: while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                if (this.getMachiningState() == MachiningState.RUNNING || this.getMachiningState() == MachiningState.STEP_WAIT) continue;
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i] || !this.m_MachState.isAxisEnabled(i) || !this.m_MotorController.isHoming(i)) continue;
                    this.m_MotorController.stopHoming(i);
                }
                throw interruptedException;
            }
            for (n = 0; n < blArray.length; ++n) {
                if (!(blArray[n] && this.m_MachState.isAxisEnabled(n) && this.m_MotorController.isHoming(n))) continue;
                continue block3;
            }
            break;
        }
        this.m_MotorController.startRunning();
        this.m_MovePlanner.startPlanner(false, this.getAxisPos());
    }

    private void processMachCode() throws InterruptedException {
        Machcode machcode = this.m_RunReverseMode ? this.m_CurrentMachCode.m_Prev : this.m_CurrentMachCode.m_Next;
        this.m_LastProcessedMachCode = this.m_CurrentMachCode;
        Machcode machcode2 = this.m_CurrentMachCode;
        MachState machState = this.m_MachState;
        switch (machcode2.m_Type) {
            default: {
                break;
            }
            case RESET_WORK_OFFSETS: {
                this.m_MovePlanner.flush();
                this.syncMachStateWithMotorPositions();
                Double[] doubleArray = ((Machcode.ResetWorkOffset)machcode2).m_DroValues;
                int n = ((Machcode.ResetWorkOffset)machcode2).m_WorkOffsetNo;
                for (int i = 0; i < 6; ++i) {
                    if (doubleArray[i] == null || !this.m_MachState.isAxisEnabled(i)) continue;
                    this.m_MachState.setWorkOffsetFromLocal(n, i, doubleArray[i]);
                }
                this.m_MotorController.startRunning();
                this.m_MovePlanner.startPlanner(false, this.getAxisPos());
                break;
            }
            case SEEK_HOME: {
                this.performSeekHomeMachCode((Machcode.SeekHome)machcode2);
                break;
            }
            case ARM_PROBE: {
                this.m_MovePlanner.flush();
                this.m_MotorController.armProbe(true);
                this.syncMachStateWithMotorPositions();
                this.m_ProbeStartPos = this.m_MachState.getLocalPos();
                this.m_ProbedPosition = null;
                break;
            }
            case WAIT_PROBE: {
                long l = System.currentTimeMillis();
                this.m_MovePlanner.flush(() -> this.m_MotorController.getProbeTriggered());
                if (this.m_MotorController.getProbeTriggered()) {
                    this.updateProbedPostion();
                    this.m_MotorController.armProbe(false);
                    while (this.m_MotorController.getProbeTriggered()) {
                        Thread.sleep(10L);
                    }
                    this.m_MovePlanner.startPlanner(false, this.getAxisPos());
                    break;
                }
                this.setError(machcode2.m_FilePos, "Probe failed to trip");
                this.setMachiningState(MachiningState.STOPPING);
                this.m_MotorController.armProbe(false);
                break;
            }
            case OPERATOR_MSG: {
                Machcode.OperatorMessage operatorMessage = (Machcode.OperatorMessage)machcode2;
                if (operatorMessage.m_MessageType == Machcode.OperatorMessageType.MESSAGE) {
                    this.m_StatusDisplay.setOperatorMessage(operatorMessage.m_Message);
                }
                if (operatorMessage.m_MessageType != Machcode.OperatorMessageType.PRINT) break;
                this.printMessageToConsole(operatorMessage.m_Message);
                break;
            }
            case PAUSE: 
            case COND_PAUSE: {
                if (machcode2.m_Type != Machcode.SegmentType.PAUSE && (machcode2.m_Type != Machcode.SegmentType.COND_PAUSE || !machState.getParamBoolean(15166))) break;
                this.m_MovePlanner.flush();
                this.m_PausedAtMachCodeID = 0;
                if (this.m_CurrentMachCode != null) {
                    Machcode machcode3;
                    Machcode machcode4 = machcode3 = this.m_RunReverseMode ? this.m_CurrentMachCode.m_Prev : this.m_CurrentMachCode.m_Next;
                    if (machcode3 != null) {
                        this.m_PausedAtMachCodeID = machcode3.m_MachCodeID;
                    }
                }
                this.setMachiningState(MachiningState.PAUSING);
                break;
            }
            case STOP: {
                this.m_MovePlanner.flush();
                this.setMachiningState(MachiningState.STOPPING);
                break;
            }
            case DWELL: {
                this.m_MovePlanner.flush();
                this.m_DwellUntil = System.currentTimeMillis() + (long)(((Machcode.Dwell)machcode2).m_DwellTime * 1000.0);
                Thread.sleep((int)(((Machcode.Dwell)machcode2).m_DwellTime * 1000.0));
                System.out.println("X = " + this.getAxisPos()[0] + "  " + this.m_MotorController.getMotorPosition()[0]);
                break;
            }
            case SET_PARAMETER: {
                Machcode.SetParameter setParameter = (Machcode.SetParameter)machcode2;
                if (setParameter.m_Parameter != 15122 || ((Number)setParameter.m_Value).intValue() == 0) {
                    this.m_MovePlanner.flush();
                }
                machState.setParam(setParameter.m_Parameter, setParameter.m_Value);
                break;
            }
            case MOVE_LINEAR: 
            case MOVE_ARC_CCW: 
            case MOVE_ARC_CW: {
                Machcode machcode5;
                double d = machcode2.getVelocity();
                d = d == 0.0 ? this.m_MachState.getParamDouble(15149) : (d *= this.m_MachState.getParamBoolean(15131) ? this.m_MachState.getParamDouble(15132) : 1.0);
                if (!this.m_RunReverseMode) {
                    this.m_MovePlanner.queueSegment(d, machcode2);
                } else {
                    Machcode.MoveCode moveCode;
                    machcode5 = this.m_CurrentMachCode;
                    while (null == (machcode5 = machcode5.m_Prev).getPosition()) {
                    }
                    if (machcode5.m_Type == Machcode.SegmentType.START || machcode5.m_FilePos == null) {
                        machcode = null;
                        break;
                    }
                    if (machcode2.m_Type == Machcode.SegmentType.MOVE_ARC_CCW || machcode2.m_Type == Machcode.SegmentType.MOVE_ARC_CW) {
                        Machcode.SegmentType segmentType = machcode2.m_Type == Machcode.SegmentType.MOVE_ARC_CW ? Machcode.SegmentType.MOVE_ARC_CCW : Machcode.SegmentType.MOVE_ARC_CW;
                        moveCode = new Machcode.ArcMove(machcode2.m_FilePos, machcode2.getPlane(), machcode2.getToolCompensation(), machcode2.getTolerance(), machcode2.getVelocity(), machcode5.getPosition(), machcode2.getCenter(), segmentType);
                    } else {
                        moveCode = new Machcode.LinearMove(machcode2.m_FilePos, machcode2.getPlane(), machcode2.getToolCompensation(), machcode2.getTolerance(), machcode2.getVelocity(), machcode5.getPosition());
                    }
                    moveCode.m_MachCodeID = this.m_CurrentMachCode.m_MachCodeID;
                    this.m_MovePlanner.queueSegment(d, moveCode);
                }
                machcode5 = machcode2.m_Next;
                while (machcode5 != null && machcode5.m_Type == Machcode.SegmentType.SET_PARAMETER) {
                    machcode5 = machcode5.m_Next;
                }
                if (machcode5 == null || machcode5.getVelocity() != 0.0 || machcode5.m_Type == Machcode.SegmentType.WAIT_PROBE) break;
                this.m_MovePlanner.flush();
            }
        }
        if (this.m_SingleStepMode && machcode != null && this.m_CurrentMachCode.m_FilePos != machcode.m_FilePos) {
            this.m_MovePlanner.flush();
            this.m_PausedAtMachCodeID = machcode.m_MachCodeID;
            this.setMachiningState(MachiningState.PAUSING);
            return;
        }
        this.m_CurrentMachCode = machcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundRun2() {
        block18: while (true) {
            try {
                while (true) {
                    MachiningState machiningState = this.getMachiningState();
                    switch (machiningState) {
                        case START_LOADING: {
                            this.startLoading(this.m_Reloading);
                            if (!this.m_Pushed) {
                                this.m_ToolpathDisplayPanel.clearPlannedPath();
                            }
                            this.setMachiningState(MachiningState.LOADING);
                            break;
                        }
                        case LOADING: {
                            while (this.m_LoadingMachCode != null) {
                                this.loadMachCode();
                            }
                            this.m_DisplayPlanner.flush();
                            this.setMachiningState(MachiningState.STOP_LOADING);
                            break;
                        }
                        case STOP_LOADING: {
                            double d = this.m_DisplayPlanner.stopPlanner();
                            if (this.m_PostLoadMachiningState == MachiningState.STOPPED) {
                                this.m_EstimatedRunTime = d;
                            }
                            Main.m_Main.m_ToolpathDisplayPanel.setToolPathExtents(this.m_MoveLimitChecker.getToolpathMin(), this.m_MoveLimitChecker.getToolpathMax());
                            this.setMachiningState(this.m_PostLoadMachiningState);
                            break;
                        }
                        case START_RUNNING: {
                            this.startRunning();
                            this.setMachiningState(MachiningState.RUNNING);
                            this.startStopWatch();
                            break;
                        }
                        case RUNNING: {
                            if (this.m_CurrentMachCode != null) {
                                this.processMachCode();
                                this.m_MachiningAtStart = false;
                                this.m_MachiningAtEnd = false;
                                break;
                            }
                            this.m_MovePlanner.flush();
                            this.m_PausedAtMachCodeID = this.m_LastProcessedMachCode.m_MachCodeID;
                            this.m_MachiningAtStart = this.m_RunReverseMode;
                            boolean bl = this.m_MachiningAtEnd = !this.m_RunReverseMode;
                            if (this.m_PushedStopped) {
                                this.setMachiningState(MachiningState.STOPPING);
                                break;
                            }
                            this.setMachiningState(MachiningState.PAUSING);
                            break;
                        }
                        case STEP_WAIT: {
                            this.stopRunning();
                            Machcode machcode = this.m_MovePlanner.getCurrentMachCode();
                            this.m_PausedAtMachCodeID = machcode != null ? machcode.m_MachCodeID : (this.m_CurrentMachCode != null ? this.m_CurrentMachCode.m_MachCodeID : 0);
                            this.startRunning();
                            this.setMachiningState(MachiningState.RUNNING);
                            break;
                        }
                        case PAUSING: {
                            Object object;
                            this.stopRunning();
                            if (this.m_PausedAtMachCodeID == 0) {
                                object = this.m_MovePlanner.getCurrentMachCode();
                                this.m_PausedAtMachCodeID = object != null ? ((Machcode)object).m_MachCodeID : (this.m_CurrentMachCode != null ? this.m_CurrentMachCode.m_MachCodeID : 0);
                            }
                            this.syncMachStateWithMotorPositions();
                            this.m_PausedAtPosition = this.getAxisPos();
                            this.setMachiningState(MachiningState.PAUSED);
                            this.pop();
                            this.stopStopWatch();
                            if (this.m_CompletionCallback == null) continue block18;
                            this.m_CompletionCallback.onComplete(this.m_Error);
                            break;
                        }
                        case STOPPING: {
                            this.m_WarningGiven = false;
                            this.m_WarningGiven2 = false;
                            this.stopRunning();
                            this.m_CurrentMachCode = null;
                            this.pop();
                            this.m_PausedAtMachCodeID = 0;
                            this.m_PausedAtPosition = null;
                            this.m_StatusDisplay.setOperatorMessage(null);
                            this.stopStopWatch();
                            this.setMachiningState(MachiningState.STOPPED);
                            if (this.m_CompletionCallback != null) {
                                this.m_CompletionCallback.onComplete(this.m_Error);
                            }
                            this.m_CompletionCallback = null;
                            break;
                        }
                        case TEST_START: {
                            this.m_MotorTestState = MotorTestState.HOME0;
                            this.motorTest();
                            break;
                        }
                        case PAUSED: 
                        case STOPPED: {
                            Object object = this;
                            synchronized (object) {
                                this.wait(100L);
                                break;
                            }
                        }
                        default: {
                            System.err.println("unhandled state in MachControl background thread " + machiningState);
                            Thread.sleep(100L);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Throwable throwable) {
                this.setMachiningState(MachiningState.STOPPED);
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    private void updateProbedPostion() {
        int[] nArray = this.m_MotorController.getProbePosition();
        if (nArray != null) {
            double[] dArray = this.axisPositionFromMotorPosition(nArray);
            this.m_ProbedPosition = this.m_MachState.axisToLocal(dArray);
            System.err.printf("PROBE TRIGGERED AT x=%f y=%f z=%f (abs x=%f y=%f z=%f)\n", this.m_ProbedPosition[0], this.m_ProbedPosition[1], this.m_ProbedPosition[2], dArray[0], dArray[1], dArray[2]);
            if (this.m_ProbeStartPos == null) {
                System.err.append("m_ProbeStartPos == null!");
                return;
            }
            double[] dArray2 = new double[this.m_ProbedPosition.length];
            System.arraycopy(this.m_ProbedPosition, 0, dArray2, 0, dArray2.length);
            double d = this.m_ProbedPosition[0] - this.m_ProbeStartPos[0];
            double d2 = this.m_ProbedPosition[1] - this.m_ProbeStartPos[1];
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 > 0.0) {
                d /= d3;
                d2 /= d3;
                d = d > 0.0 ? (d *= this.m_MachState.getParamDouble(0x4000001, 0)) : (d *= this.m_MachState.getParamDouble(0x4000000, 0));
                d2 = d2 > 0.0 ? (d2 *= this.m_MachState.getParamDouble(0x4000001, 1)) : (d2 *= this.m_MachState.getParamDouble(0x4000000, 1));
                System.err.printf("PROBE CORRECTION dx= %f dy=%f\n", d, d2);
                dArray2[0] = dArray2[0] + d;
                dArray2[1] = dArray2[1] + d2;
            }
            System.err.printf("CALIBRATED POSITION x=%f y=%f\n", dArray2[0], dArray2[1]);
            for (int i = 0; i < 6; ++i) {
                if (!this.m_MachState.isAxisEnabled(i)) continue;
                this.m_MachState.setParameterNoUpdate(2000 + i, dArray2[i] / this.m_MachState.getParamDouble(15141));
            }
        }
    }

    public boolean isConnected() {
        ConnectionState connectionState = this.getConnectionState();
        return connectionState == ConnectionState.CONNECTED || connectionState == ConnectionState.SIMULATION;
    }

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new IllegalArgumentException("Motor controller not connected");
        }
    }

    private void ensurePausedOrStoppedAndConnected(MachiningState machiningState) {
        this.ensurePausedOrStopped(machiningState);
        this.ensureConnected();
    }

    public void ensurePausedOrStopped(MachiningState machiningState) {
        String string;
        MachiningState machiningState2 = this.getMachiningState();
        String string2 = string = machiningState2 == machiningState ? " already" : "";
        if (machiningState2 == MachiningState.RUNNING) {
            throw new IllegalArgumentException("System is" + string + " RUNing");
        }
        if (machiningState2 == MachiningState.PAUSING) {
            throw new IllegalArgumentException("System is" + string + " PAUSEing");
        }
        if (machiningState2 == MachiningState.STOPPING) {
            throw new IllegalArgumentException("System is" + string + " STOPing");
        }
        if (machiningState2 != MachiningState.PAUSED && machiningState2 != MachiningState.STOPPED) {
            throw new IllegalArgumentException("One or more motors busy (" + machiningState2 + ")");
        }
    }

    private synchronized void setMachiningState(MachiningState machiningState) {
        this.m_MachState.setMachinginState(machiningState);
        this.notifyAll();
    }

    public double getVelocityUnit() {
        return this.m_MotorController.getVelocityFactor();
    }

    private void ensureNotPausingNorStopping(MachiningState machiningState) {
        if (machiningState == MachiningState.STOPPING) {
            throw new IllegalArgumentException("Stopping in proress");
        }
        if (machiningState == MachiningState.PAUSING) {
            throw new IllegalArgumentException("Pausing in proress");
        }
    }

    private void pop() {
        if (this.m_Pushed) {
            this.m_Pushed = false;
            this.m_CurrentMachCode = this.m_PushedCurrentMachCode;
            this.m_FirstMachCode = this.m_PushedFirstMachCode;
            this.m_PausedAtMachCodeID = this.m_PushedPausedAtMachCode;
            this.m_PausedAtPosition = this.m_PushedPausedAtPosition;
            this.m_PushedCurrentMachCode = null;
            this.m_PushedFirstMachCode = null;
            this.m_PushedPausedAtMachCode = -1;
            this.m_PushedPausedAtPosition = null;
            this.m_PushedStopped = false;
            this.m_MachiningAtStart = this.m_PushedMachiningAtStart;
            this.m_MachiningAtEnd = this.m_PushedMachiningAtEnd;
        }
    }

    public void push() {
        if (this.m_Pushed) {
            System.err.println("PUSH stack overflow");
        }
        this.m_PushedStopped = this.getMachiningState() == MachiningState.STOPPED;
        this.m_Pushed = true;
        this.m_PushedCurrentMachCode = this.m_CurrentMachCode;
        this.m_PushedFirstMachCode = this.m_FirstMachCode;
        this.m_PushedPausedAtMachCode = this.m_PausedAtMachCodeID;
        this.m_PushedPausedAtPosition = this.m_PausedAtPosition;
        this.m_PushedMachiningAtStart = this.m_MachiningAtStart;
        this.m_PushedMachiningAtEnd = this.m_MachiningAtEnd;
        this.m_PushedMachiningAtStart = true;
        this.m_PushedMachiningAtEnd = false;
        this.m_CurrentMachCode = null;
        this.m_FirstMachCode = null;
        this.m_PausedAtMachCodeID = 0;
        this.m_PausedAtPosition = null;
    }

    public ConnectionState getConnectionState() {
        return this.m_MotorController.getConnectionState();
    }

    public String getVersion() {
        return this.m_MotorController.getVersion();
    }

    public synchronized void startTest(int n, double d) throws Exception {
        this.ensurePausedOrStoppedAndConnected(null);
        MotorController.MotorState motorState = this.m_MotorController.getMotorState(n);
        if (motorState != MotorController.MotorState.READY) {
            throw new IllegalArgumentException("Motor " + n + " busy with: " + motorState);
        }
        this.m_MotorTestMotor = n;
        this.m_MotorTestRunLength = d;
        this.setMachiningState(MachiningState.TEST_START);
    }

    private int getMasterMotor(int n) throws Exception {
        int n2 = this.m_MotorFromAxis[n];
        if (n2 < 0) {
            throw new IllegalArgumentException("No master motor assigned for " + this.getAxisLetter(n) + "-axis");
        }
        return n2;
    }

    private int getSlaveMotor(int n) throws Exception {
        int n2 = this.m_MotorFromAxis[n];
        if (n2 < 0) {
            throw new IllegalArgumentException("No master motor assigned for " + this.getAxisLetter(n) + "-axis");
        }
        return n2;
    }

    public synchronized boolean startJog(int n, boolean bl) throws Exception {
        return this.m_MotorController.startJogging(this.getMasterMotor(n), bl);
    }

    public synchronized void startHoming(int n, int n2) throws Exception {
        this.m_MotorController.startHoming(this.getMasterMotor(n), n2);
    }

    public synchronized boolean isHoming(int n) throws Exception {
        return this.m_MotorController.isHoming(this.getMasterMotor(n));
    }

    public synchronized void stopHoming(int n) throws Exception {
        this.m_MotorController.stopHoming(this.getMasterMotor(n));
    }

    public synchronized void stopJog(int n) throws Exception {
        this.m_MotorController.stopJogging(this.getMasterMotor(n));
    }

    public synchronized void resetPosition(int n, int n2) throws Exception {
        this.m_MotorController.setPosition(this.getMasterMotor(n), n2);
    }

    public synchronized void abortAll() {
        if (!this.isConnected()) {
            throw new IllegalArgumentException("Motor controller not connected");
        }
        this.m_MotorController.abortAll();
    }

    public synchronized void syncMachStateWithMotorPositions() {
        this.m_MachState.setPositionFromAxisPos(this.axisPositionFromMotorPosition(this.m_MotorController.getMotorPosition()));
    }

    private double[] clone(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    private void queueMotionTest() throws Exception {
        double[] dArray = this.getAxisPos();
        double[] dArray2 = this.clone(dArray);
        double[] dArray3 = this.clone(dArray2);
        int n = this.m_MotorTestMotor;
        dArray2[n] = dArray2[n] + this.m_MotorTestRunLength;
        Machcode.LinearMove linearMove = new Machcode.LinearMove(null, 0, 0.0, 0.0, this.m_MachState.getParamDouble(15305), dArray2);
        Machcode.LinearMove linearMove2 = new Machcode.LinearMove(null, 0, 0.0, 0.0, 5.0, dArray3);
        this.m_MotorController.startRunning();
        this.m_MovePlanner.startPlanner(false, dArray);
        this.m_MovePlanner.setParameters(this.m_MachState.getParamDouble(15172), this.m_MachState.getParamDouble(15150), this.m_MachState.getParamDouble(15305), this.m_MachState.getParamDouble(15303), this.m_MachState.getParamDouble(15308));
        this.m_MovePlanner.queueSegment(((Machcode)linearMove).getVelocity(), linearMove);
        this.m_MovePlanner.queueSegment(((Machcode)linearMove2).getVelocity(), linearMove2);
    }

    private void stopRunning() throws InterruptedException {
        this.m_MovePlanner.stopPlanner();
        this.m_MovePlanner.flush(() -> true);
        this.m_MotorController.stopRunning();
        this.m_MachState.retrigCompile();
    }

    private static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        Object object = "";
        for (double d : dArray) {
            object = (String)object + String.format("%1.6f  ", d);
        }
        return object;
    }

    public String getElapseRunTimeString() {
        double d;
        double d2 = Math.round(this.getTime());
        double d3 = Math.round(this.m_EstimatedRunTime - this.m_TotalRunTime);
        if (this.m_StopWatchOn) {
            d3 -= (double)Math.round(d2 - this.m_StopWatchLapStartTime);
            d = Math.round(d2 - this.m_StopWatchStartTime);
        } else {
            d = this.m_StopWatchStopTime - this.m_StopWatchStartTime;
        }
        Object object = String.format("run time %s ", MachController.formatTime(d));
        if (d3 > 0.0) {
            object = (String)object + String.format("(time left %s)", MachController.formatTime(d3));
        }
        return object;
    }

    private double getTime() {
        return (double)System.nanoTime() / 1.0E9;
    }

    public static interface CompletionCallback {
        public void onComplete(Object var1);
    }

    public static interface StatusDisplay {
        public void setOperatorMessage(String var1);

        public void setMacroMessage(String var1);
    }

    private static enum MotorTestState {
        HOME0,
        WAIT_HOME0,
        RUN,
        WAIT_HOME;

    }
}

