/*
 * Decompiled with CFR 0.152.
 */
package motorcontrol;

import java.util.EnumSet;

public enum MachiningState {
    STEP_WAIT,
    START_RUNNING,
    PAUSED,
    STOPPED,
    RUNNING,
    START_JOG_FWD,
    START_JOG_REV,
    JOGGING_FWD,
    JOGGING_REV,
    STOP_JOGGING,
    PAUSING,
    STOPPING,
    START_LOADING,
    LOADING,
    STOP_LOADING,
    START_HOMING,
    HOMING,
    TEST_START,
    TEST_WAITHOME,
    TEST_RUNNING,
    TEST_WAITHOME2,
    DEBUG;

    private static EnumSet<MachiningState> m_StopStates;
    private static EnumSet<MachiningState> m_HoldStates;
    private static EnumSet<MachiningState> m_RunStates;

    public static boolean isRunState(MachiningState machiningState) {
        return m_RunStates.contains((Object)machiningState);
    }

    public static boolean isStopState(MachiningState machiningState) {
        return m_StopStates.contains((Object)machiningState);
    }

    public static boolean isHoldState(MachiningState machiningState) {
        return m_HoldStates.contains((Object)machiningState);
    }

    static {
        m_StopStates = EnumSet.of(STOPPED);
        m_HoldStates = EnumSet.of(PAUSED);
        m_RunStates = EnumSet.of(START_RUNNING, RUNNING, PAUSING, STOPPING);
    }
}

