/*
 * Decompiled with CFR 0.152.
 */
package motorcontrol;

import com.eazycnc.motorcontroller.MotorController;
import eazycnc.gcode.MachState;
import java.util.ArrayList;

public class MotionTest {
    private State m_State;
    private int m_Motor;
    private MotorController m_MotorController2;
    private ArrayList<Integer> m_Position;
    private int m_MoveTestIndex;
    private boolean m_HasHomeSwitch;
    private int[] m_InitialPosition;
    private int m_Direction;
    private double m_RunLength;
    private double m_HiVelo;
    private double m_LoVelo;
    private double m_Accel;
    private double m_CycleTime;
    private double m_StepSize;

    public int getMotorUnderTest() {
        return this.m_Motor;
    }

    public double getRunLength() {
        return this.m_RunLength;
    }

    public MotionTest(MotorController motorController, MachState machState, int n, double d, double d2, double d3, int n2) {
        this.m_MotorController2 = motorController;
        this.m_State = State.START_TEST;
        this.m_Motor = n;
        this.m_Direction = n2;
        this.m_HasHomeSwitch = machState.getParamInt(-2147483644, n) >= 0;
        this.m_CycleTime = machState.getParamDouble(15150);
        this.m_HiVelo = d2;
        this.m_LoVelo = d;
        this.m_Accel = d3;
        this.m_StepSize = machState.getParamDouble(-2147483646, n);
    }

    private void calculateTestMoves() {
        this.m_Position = new ArrayList();
        double d = 25.0;
        double d2 = this.m_CycleTime;
        double d3 = this.m_MotorController2.getVelocityFactor() / d2;
        double d4 = (this.m_HiVelo - this.m_LoVelo) / this.m_Accel;
        double d5 = d / this.m_HiVelo;
        double d6 = d4;
        double d7 = d4 + d5 + d6;
        double d8 = 0.0;
        int n = 0;
        int n2 = 0;
        for (double d9 = 0.0; d9 <= d7; d9 += d2) {
            int n3;
            int n4;
            double d10 = 0.0;
            double d11 = d9;
            double d12 = d11;
            if (d12 > d4) {
                d12 = d4;
            }
            d10 = this.m_LoVelo * d12 + 0.5 * this.m_Accel * d12 * d12;
            if ((d11 -= d12) > 0.0) {
                d12 = d11;
                if (d12 > d5) {
                    d12 = d5;
                }
                d10 += this.m_HiVelo * d12;
                if ((d11 -= d12) > 0.0) {
                    d12 = d11;
                    d10 += this.m_HiVelo * d12 - 0.5 * this.m_Accel * d12 * d12;
                }
            }
            this.ASSERT((n4 = (int)(Math.abs((double)(n3 = (n = (int)(d10 * this.m_StepSize)) - n2) * d3) + 0.5)) >= 0 && n4 <= 65535);
            this.ASSERT(n3 >= Short.MIN_VALUE && n3 <= Short.MAX_VALUE);
            this.m_Position.add(n);
            n2 = n;
        }
        this.m_RunLength = (double)n2 / this.m_StepSize;
        if (!this.m_HasHomeSwitch) {
            int n5;
            int n6 = (int)(-1.0 * this.m_StepSize);
            while (n > n6) {
                n5 = (n -= (int)(d2 * this.m_LoVelo * this.m_StepSize)) - n2;
                int n7 = (int)(Math.abs((double)n5 * d3) + 0.5);
                this.ASSERT(n7 >= 0 && n7 <= 65535);
                this.ASSERT(n5 >= Short.MIN_VALUE && n5 <= Short.MAX_VALUE);
                this.m_Position.add(n);
                n2 = n;
            }
            while (n < 0) {
                if ((n += (int)(d2 * this.m_LoVelo * this.m_StepSize)) + (n5 = n - n2) > 0) {
                    n = 0;
                    n5 = n - n2;
                }
                int n8 = (int)(Math.abs((double)n5 * d3) + 0.5);
                int n9 = this.m_MotorController2.getMaxVelo();
                int n10 = this.m_MotorController2.getMaxTravel();
                this.ASSERT(n8 >= 0 && n8 <= n9);
                this.ASSERT(n5 >= -n10 && n5 <= n10);
                this.m_Position.add(n);
                n2 = n;
            }
        }
    }

    private void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static enum State {
        START_TEST,
        GO_HOME,
        TEST_RUN,
        RETURN_HOME,
        TEST_COMPLED;

    }
}

