/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.uwk.ResourceLoader;
import com.eazycnc.uwk.widgets.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import swing.SwingWidgetFactory;
import swing.Utils;

class ButtonImpl
extends JButton
implements Button {
    BufferedImage image = null;
    BufferedImage image2 = null;

    public ButtonImpl(ResourceLoader resourceLoader, String string, String string2) {
        super(string2);
        this.setFocusable(false);
        this.setLook(resourceLoader, string);
    }

    private void setLook(ResourceLoader resourceLoader, String string) {
        if (string == null) {
            return;
        }
        String string2 = string;
        if (string2 != null) {
            this.image = resourceLoader.loadImage(string2 + ".png");
            this.image2 = resourceLoader.loadImage(string2 + "_selected.png");
            if (SwingWidgetFactory.m_SmallScreenMode) {
                this.image = SwingWidgetFactory.scale(this.image);
                this.image2 = SwingWidgetFactory.scale(this.image2);
            }
        }
        if (this.image != null) {
            Dimension dimension = new Dimension(this.image.getWidth(), this.image.getHeight());
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(Utils.getText(string));
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.image != null && this.image2 != null) {
            boolean bl;
            boolean bl2 = bl = this.getModel().isPressed() || this.getModel().isSelected();
            if (this.image2 != null && bl) {
                graphics.setColor(Color.black);
                graphics.drawImage(this.image2, 0, 0, this.getWidth(), this.getHeight(), null);
            }
            if (this.image != null && !bl) {
                graphics.setColor(Color.white);
                graphics.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
            }
            Utils.drawButtonText(this, graphics, this.getText());
        }
    }

    @Override
    public void addActionListener(com.eazycnc.uwk.widgets.ActionListener actionListener) {
        this.addActionListener(actionListener, 0);
    }

    @Override
    public void addButtonListener(final Button.ButtonListener buttonListener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                buttonListener.buttonPressed(ButtonImpl.this);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                buttonListener.buttonReleased(ButtonImpl.this);
            }
        });
    }

    @Override
    public void addActionListener(final com.eazycnc.uwk.widgets.ActionListener actionListener, final int n) {
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ((actionEvent.getModifiers() & 0x2F) == n) {
                    actionListener.onAction();
                }
            }
        });
    }
}

