/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.uwk.widgets.ColorPicker;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JColorChooser;

class ColorPickerImpl
extends JButton
implements ColorPicker {
    Color m_Color = Color.RED;
    LinkedList<com.eazycnc.uwk.widgets.ActionListener> m_Listeners = new LinkedList();

    ColorPickerImpl() {
        super("Set Color");
        this.updateColor();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(ColorPickerImpl.this, "Choose Color", ColorPickerImpl.this.m_Color);
                if (color != null) {
                    ColorPickerImpl.this.m_Color = color;
                    ColorPickerImpl.this.updateColor();
                    for (com.eazycnc.uwk.widgets.ActionListener actionListener : ColorPickerImpl.this.m_Listeners) {
                        actionListener.onAction();
                    }
                }
            }
        });
    }

    @Override
    public void addActionListener(com.eazycnc.uwk.widgets.ActionListener actionListener) {
        this.m_Listeners.add(actionListener);
    }

    @Override
    public void setColor(String string) {
        try {
            int n = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : (string.startsWith("#") ? Integer.parseInt(string.substring(1), 16) : Integer.parseInt(string));
            this.m_Color = new Color(n >> 16 & 0xFF, n >> 8 & 0xFF, n >> 0 & 0xFF);
            this.updateColor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getColor() {
        int n = (this.m_Color.getRed() << 16) + (this.m_Color.getGreen() << 8) + this.m_Color.getBlue();
        String string = String.format("#%06X", n);
        return string;
    }

    void updateColor() {
        this.setBackground(this.m_Color);
        this.setForeground(new Color(255 - this.m_Color.getRed(), 255 - this.m_Color.getGreen(), 255 - this.m_Color.getBlue()));
    }
}

