/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.opengl.GLU;
import com.eazycnc.uwk.widgets.OpenGLCanvas;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.swing.BorderFactory;
import swing.GLUWrapper;
import swing.GLWrapper;

class OpenGLViewImpl
extends GLJPanel
implements OpenGLCanvas {
    private OpenGLCanvas.GestureHandler m_GestureHandler;
    private boolean m_Pressed;

    @Override
    public void setGestureHandler(OpenGLCanvas.GestureHandler gestureHandler) {
        this.m_GestureHandler = gestureHandler;
    }

    public OpenGLViewImpl(GLCapabilities gLCapabilities) {
        super((GLCapabilitiesImmutable)gLCapabilities);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(100, 100));
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setSurfaceScale(new float[]{10.0f, 10.0f});
        int[] nArray = new int[2];
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                System.out.println("PRESSED");
                if (OpenGLViewImpl.this.m_GestureHandler != null) {
                    OpenGLViewImpl.this.m_GestureHandler.onSwipe(true, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                }
                OpenGLViewImpl.this.m_Pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                System.out.println("RELEASED");
                if (OpenGLViewImpl.this.m_GestureHandler != null) {
                    OpenGLViewImpl.this.m_GestureHandler.onSwipe(false, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                }
                OpenGLViewImpl.this.m_Pressed = false;
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                System.out.println("DRAGGED");
                if (OpenGLViewImpl.this.m_GestureHandler != null) {
                    if (!OpenGLViewImpl.this.m_Pressed) {
                        OpenGLViewImpl.this.m_GestureHandler.onSwipe(true, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                        OpenGLViewImpl.this.m_Pressed = true;
                    }
                    OpenGLViewImpl.this.m_GestureHandler.onSwipe(false, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.isAltDown());
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (OpenGLViewImpl.this.m_GestureHandler != null) {
                    OpenGLViewImpl.this.m_GestureHandler.onPinch(mouseWheelEvent.getWheelRotation());
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    @Override
    public void setRendererCallback(final OpenGLCanvas.RenderCallback renderCallback) {
        super.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                try {
                    renderCallback.onSurfaceChanged(new GLWrapper(gLAutoDrawable.getGL()), n3, n4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void init(GLAutoDrawable gLAutoDrawable) {
                try {
                    renderCallback.onSurfaceCreate(new GLWrapper(gLAutoDrawable.getGL()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                try {
                    renderCallback.onDrawFrame(new GLWrapper(gLAutoDrawable.getGL()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
    }

    void MyOrtho2D(float[] fArray, float f, float f2, float f3, float f4) {
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = 1.0f / (f6 - f5);
        float f8 = 1.0f / (f4 - f3);
        float f9 = 1.0f / (f2 - f);
        int n = 0;
        fArray[n++] = 2.0f * f9;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = 2.0f * f8;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = 0.0f;
        fArray[n++] = -2.0f * f7;
        fArray[n++] = 0.0f;
        fArray[n++] = -(f2 + f) * f9;
        fArray[n++] = -(f4 + f3) * f8;
        fArray[n++] = -(f6 + f5) * f7;
        fArray[n++] = 1.0f;
    }

    private void experiment(GL2 gL2) {
        try {
            String string = "Hello";
            Graphics2D graphics2D = (Graphics2D)new BufferedImage(1, 1, 2).getGraphics();
            Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext());
            int n = (int)rectangle2D.getWidth();
            int n2 = (int)rectangle2D.getHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics();
            graphics2D2.setColor(Color.red);
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.setColor(Color.green);
            graphics2D2.fillOval(0, 0, n, n2);
            graphics2D2.setColor(Color.blue);
            graphics2D2.drawString("Hello", 0, n2);
            Texture texture = AWTTextureIO.newTexture((GLProfile)GLProfile.getDefault(), (BufferedImage)bufferedImage, (boolean)true);
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            float[] fArray = new float[16];
            this.MyOrtho2D(fArray, -1.0f, 1.0f, -1.0f, 1.0f);
            gL2.glLoadMatrixf(fArray, 0);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(48);
            byteBuffer.order(ByteOrder.nativeOrder());
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.position(0);
            floatBuffer.put(new float[]{-1.0f, -1.0f, 0.0f});
            floatBuffer.put(new float[]{1.0f, -1.0f, 0.0f});
            floatBuffer.put(new float[]{1.0f, 1.0f, 0.0f});
            floatBuffer.put(new float[]{-1.0f, 1.0f, 0.0f});
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(32);
            byteBuffer2.order(ByteOrder.nativeOrder());
            FloatBuffer floatBuffer2 = byteBuffer2.asFloatBuffer();
            floatBuffer2.position(0);
            floatBuffer2.put(new float[]{0.0f, 0.0f});
            floatBuffer2.put(new float[]{1.0f, 0.0f});
            floatBuffer2.put(new float[]{1.0f, 1.0f});
            floatBuffer2.put(new float[]{0.0f, 1.0f});
            floatBuffer.position(0);
            floatBuffer2.position(0);
            int[] nArray = new int[]{0};
            gL2.glEnable(3553);
            gL2.glGenTextures(1, nArray, 0);
            gL2.glBindTexture(3553, texture.getTextureObject());
            gL2.glActiveTexture(33984);
            gL2.glTexParameteri(3553, 10241, 9729);
            gL2.glColor3f(1.0f, 1.0f, 1.0f);
            gL2.glEnableClientState(32884);
            gL2.glEnableClientState(32888);
            gL2.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
            gL2.glTexCoordPointer(2, 5126, 0, (Buffer)floatBuffer2);
            gL2.glDrawArrays(6, 0, floatBuffer.limit() / 3);
            gL2.glDisableClientState(32888);
            gL2.glDisableClientState(32884);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public GLU getGLU() {
        return new GLUWrapper();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }
}

