/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.SourceCodeEditor;
import com.eazycnc.uwk.widgets.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SourceCodeEditorImpl
extends JScrollPane
implements Widget,
SourceCodeEditor {
    private boolean m_IsNewFile;
    private File m_File;
    private CRLFMode m_CRLFmode = null;
    private Document m_Document;
    private boolean m_Open;
    private int m_EditCount;
    private int m_EditCountOnSave;
    private JTextArea m_TextEditor;
    private UndoManager m_UndoManager;
    private Action m_UndoAction = new AbstractAction("Undo"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceCodeEditorImpl.this.m_UndoManager.undo();
        }
    };
    private Action m_RedoAction;
    private Action m_CopyAction;
    private Action m_PasteAction;
    private Action m_SaveAction;
    private Action m_CutAction;
    private int m_ErrorLine = -1;
    private int m_CurrentLine = -1;
    private boolean m_ScrollToView = false;
    private SourceCodeEditor.EditListener m_EditListener;
    private SourceCodeEditor.SelectionListener m_SelectionListener;

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this.m_TextEditor.setEnabled(bl);
        this.m_TextEditor.setEditable(bl);
        this.m_TextEditor.setFocusable(bl);
    }

    @Override
    public void setErrorLine(int n) {
        if (this.m_ErrorLine != n) {
            this.m_ErrorLine = n;
            this.m_ScrollToView = n >= 0;
            this.repaint();
        }
    }

    @Override
    public void setCurrentLine(int n) {
        if (this.m_CurrentLine != n) {
            this.m_CurrentLine = n;
            this.m_ScrollToView = n >= 0;
            this.repaint();
        }
    }

    @Override
    public boolean isDirty() {
        return this.m_EditCount != this.m_EditCountOnSave;
    }

    @Override
    public File getFile() {
        return this.m_File;
    }

    private void updateActions() {
        int n = this.m_TextEditor.getSelectionStart();
        int n2 = this.m_TextEditor.getSelectionEnd();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        boolean bl = false;
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                bl = !transferable.getTransferData(DataFlavor.stringFlavor).toString().equals("");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_UndoAction.setEnabled(this.m_UndoManager.canUndo());
        this.m_RedoAction.setEnabled(this.m_UndoManager.canRedo());
        this.m_CutAction.setEnabled(n != n2);
        this.m_CopyAction.setEnabled(n != n2);
        this.m_PasteAction.setEnabled(bl);
        this.m_SaveAction.setEnabled(this.isDirty());
    }

    private void contentsChanged() {
        this.updateActions();
        this.m_EditListener.contentsChanged(this);
    }

    @Override
    public void setEditListener(SourceCodeEditor.EditListener editListener) {
        this.m_EditListener = editListener;
    }

    @Override
    public void setSelectionListener(SourceCodeEditor.SelectionListener selectionListener) {
        this.m_SelectionListener = selectionListener;
    }

    private static void addShortCut(JComponent jComponent, int n, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 256);
        jComponent.registerKeyboardAction(action, null, keyStroke, 2);
    }

    private byte[] convertFromCRLFs(byte[] byArray) {
        this.m_CRLFmode = null;
        byte[] byArray2 = null;
        int n = 0;
        byte by = 13;
        byte by2 = 10;
        int n2 = byArray.length;
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                byArray2 = new byte[n];
            }
            n = 0;
            for (int j = 0; j < n2; ++j) {
                byte by3 = byArray[j];
                byte by4 = j + 1 < n2 ? byArray[j + 1] : (byte)0;
                CRLFMode cRLFMode = null;
                if (by3 == by || by3 == by2) {
                    if (by3 == by) {
                        if (by4 == by2) {
                            cRLFMode = CRLFMode.CRLF;
                            ++j;
                        } else {
                            cRLFMode = CRLFMode.CR;
                        }
                    } else if (by3 == by2) {
                        if (by4 == by) {
                            cRLFMode = CRLFMode.LFCR;
                            ++j;
                        } else {
                            cRLFMode = CRLFMode.LF;
                        }
                    }
                    by3 = by2;
                }
                if (cRLFMode != null) {
                    if (this.m_CRLFmode == null) {
                        this.m_CRLFmode = cRLFMode;
                    } else if (cRLFMode != this.m_CRLFmode) {
                        System.err.println("Inconsistent line endings, previously " + this.m_CRLFmode + " now found " + cRLFMode + " at byte " + j);
                    }
                }
                if (i > 0) {
                    byArray2[n] = by3;
                }
                ++n;
            }
        }
        System.out.println("detected line end mode was " + this.m_CRLFmode);
        return byArray2;
    }

    private byte[] convertToCRLF(byte[] byArray) {
        byte[] byArray2 = null;
        int n = 0;
        int n2 = 13;
        int n3 = 10;
        int n4 = byArray.length;
        for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                byArray2 = new byte[n];
            }
            n = 0;
            for (int j = 0; j < n4; ++j) {
                int n5 = byArray[j];
                int n6 = 0;
                if (n5 == n3 && this.m_CRLFmode != null) {
                    switch (this.m_CRLFmode) {
                        default: {
                            n5 = n3;
                            break;
                        }
                        case CRLF: {
                            n5 = n2;
                            n6 = n3;
                            break;
                        }
                        case CR: {
                            n5 = n2;
                            break;
                        }
                        case LFCR: {
                            n5 = n3;
                            n6 = n2;
                        }
                    }
                }
                if (i > 0) {
                    byArray2[n] = n5;
                    if (n6 != 0) {
                        byArray2[n + 1] = n6;
                    }
                }
                ++n;
                if (n6 == 0) continue;
                ++n;
            }
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceCodeEditorImpl(boolean bl, File file) {
        Object object;
        this.m_UndoAction.setEnabled(false);
        this.m_RedoAction = new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodeEditorImpl.this.m_UndoManager.redo();
            }
        };
        this.m_RedoAction.setEnabled(false);
        this.m_CopyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodeEditorImpl.this.m_TextEditor.copy();
            }
        };
        this.m_CopyAction.setEnabled(false);
        this.m_CutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodeEditorImpl.this.m_TextEditor.cut();
            }
        };
        this.m_CutAction.setEnabled(false);
        this.m_PasteAction = new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodeEditorImpl.this.m_TextEditor.paste();
            }
        };
        this.m_PasteAction.setEnabled(false);
        this.m_SaveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceCodeEditorImpl.this.saveFile();
            }
        };
        this.m_SaveAction.setEnabled(false);
        this.m_File = file;
        this.m_Document = new PlainDocument();
        if (this.m_File.exists() && !bl) {
            object = null;
            try {
                object = new FileInputStream(file);
                int n = (int)file.length();
                byte[] byArray = new byte[n];
                int n2 = 0;
                while ((n2 += ((InputStream)object).read(byArray, n2, n - n2)) < n) {
                }
                byArray = this.convertFromCRLFs(byArray);
                this.m_Document.insertString(0, new String(byArray, "UTF8"), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        this.m_IsNewFile = bl;
        this.m_Open = true;
        this.m_UndoManager = new UndoManager(){

            @Override
            public synchronized boolean addEdit(UndoableEdit undoableEdit) {
                ++SourceCodeEditorImpl.this.m_EditCount;
                SourceCodeEditorImpl.this.contentsChanged();
                return super.addEdit(undoableEdit);
            }

            @Override
            public synchronized void undo() throws CannotUndoException {
                super.undo();
                --SourceCodeEditorImpl.this.m_EditCount;
                SourceCodeEditorImpl.this.contentsChanged();
            }

            @Override
            public synchronized void redo() throws CannotUndoException {
                ++SourceCodeEditorImpl.this.m_EditCount;
                SourceCodeEditorImpl.this.contentsChanged();
                super.redo();
            }
        };
        this.m_TextEditor = new JTextArea(this.m_Document){

            @Override
            public void paintComponent(Graphics graphics) {
                Color color = this.getBackground();
                this.setBackground(new Color(0, 0, 0, 0));
                Insets insets = this.getInsets();
                Rectangle rectangle = graphics.getClipBounds();
                if (this.isEnabled()) {
                    graphics.setColor(Color.WHITE);
                } else {
                    graphics.setColor(Color.GREEN);
                }
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = fontMetrics.getHeight();
                if (SourceCodeEditorImpl.this.m_ErrorLine >= 0 || SourceCodeEditorImpl.this.m_CurrentLine >= 0) {
                    int n2;
                    if (SourceCodeEditorImpl.this.m_ErrorLine >= 0) {
                        graphics.setColor(Color.red);
                        n2 = SourceCodeEditorImpl.this.m_ErrorLine - 1;
                    } else {
                        graphics.setColor(Color.blue);
                        n2 = SourceCodeEditorImpl.this.m_CurrentLine - 1;
                    }
                    graphics.fillRect(rectangle.x, n2 * n + insets.top, rectangle.width, n);
                    if (SourceCodeEditorImpl.this.m_ScrollToView) {
                        SourceCodeEditorImpl.this.m_ScrollToView = false;
                        Rectangle rectangle2 = new Rectangle(0, n2 * n + insets.top, this.getWidth(), 7 * n);
                        this.scrollRectToVisible(rectangle2);
                    }
                }
                super.paintComponent(graphics);
            }

            @Override
            public Insets getInsets() {
                Insets insets = super.getInsets();
                insets.top += 2;
                insets.left += 2;
                return insets;
            }
        };
        this.m_TextEditor.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                SourceCodeEditorImpl.this.m_UndoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.m_TextEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SourceCodeEditorImpl.this.m_TextEditor.getCaret().setVisible(true);
                SourceCodeEditorImpl.this.updateActions();
                if (SourceCodeEditorImpl.this.m_SelectionListener != null) {
                    SourceCodeEditorImpl.this.m_SelectionListener.selectionChanged(caretEvent.getDot(), caretEvent.getDot());
                }
            }
        });
        this.m_TextEditor.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SourceCodeEditorImpl.this.m_TextEditor.getCaret().setVisible(true);
            }
        });
        this.setViewportView(this.m_TextEditor);
        SourceCodeEditorImpl.addShortCut(this.m_TextEditor, 83, this.m_SaveAction);
        SourceCodeEditorImpl.addShortCut(this.m_TextEditor, 67, this.m_CopyAction);
        SourceCodeEditorImpl.addShortCut(this.m_TextEditor, 86, this.m_PasteAction);
        SourceCodeEditorImpl.addShortCut(this.m_TextEditor, 88, this.m_CutAction);
        SourceCodeEditorImpl.addShortCut(this.m_TextEditor, 90, this.m_UndoAction);
        SourceCodeEditorImpl.addShortCut(this.m_TextEditor, 89, this.m_RedoAction);
        this.m_TextEditor.setFont(new Font("Courier", 1, 16));
        this.m_TextEditor.setFont(new Font("Monospaced", 0, 16));
        this.m_TextEditor.setEditable(true);
        this.m_TextEditor.requestFocusInWindow();
        object = new Dimension(this.getMinimumSize());
        ((Dimension)object).height = 100;
        ((Dimension)object).width = 300;
        this.setMinimumSize((Dimension)object);
        this.setPreferredSize((Dimension)object);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.m_Document.getText(0, this.m_Document.getLength()).getBytes("UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public File getSaveFile() {
        FileDialog fileDialog = new FileDialog((Frame)null, "Save", 1);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            File file = new File(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveFile() {
        Object object;
        FileOutputStream fileOutputStream = null;
        if (this.m_IsNewFile || !this.m_File.exists()) {
            object = this.getSaveFile();
            if (object == null) {
                return false;
            }
            this.m_File = object;
            this.m_IsNewFile = false;
        }
        try {
            fileOutputStream = new FileOutputStream(this.m_File);
            object = this.getBytes();
            object = this.convertToCRLF((byte[])object);
            fileOutputStream.write((byte[])object, 0, ((Object)object).length);
            this.m_EditCountOnSave = this.m_EditCount;
            this.updateActions();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Could not create file '" + this.m_File.getAbsolutePath() + "'", "Save failure", 0);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "IOException while saving file '" + this.m_File.getAbsolutePath() + "'", "Save failure", 0);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_EditListener.contentsChanged(this);
        return true;
    }

    @Override
    public void closeFile(final Runnable runnable) {
        if (!this.isDirty()) {
            runnable.run();
        } else {
            UWKit.showConfirmDialog("Save changes", "<b>Save changes to file:<br>'" + this.m_File.getName() + "' ?</b><br><br>Your changes will be lost if you don\u2019t save them.<br>", "Save", "No", "Cancel", new DialogCallback(){

                @Override
                public void onClose(DialogCallback.DialogOptions dialogOptions) {
                    if (dialogOptions == DialogCallback.DialogOptions.CANCEL) {
                        return;
                    }
                    if (dialogOptions == DialogCallback.DialogOptions.YES && SourceCodeEditorImpl.this.saveFile()) {
                        runnable.run();
                    }
                    if (dialogOptions == DialogCallback.DialogOptions.NO) {
                        runnable.run();
                    }
                }
            });
        }
    }

    @Override
    public int getSelectionStart() {
        return this.m_TextEditor.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.m_TextEditor.getSelectionEnd();
    }

    @Override
    public int getLineNo(int n) {
        int n2 = 0;
        try {
            n2 = this.m_TextEditor.getLineOfOffset(n) + 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    static enum CRLFMode {
        CR,
        LF,
        CRLF,
        LFCR;

    }
}

