/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.ResourceLoader;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.TextFieldCallback;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.Canvas;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.CheckBox;
import com.eazycnc.uwk.widgets.ColorPicker;
import com.eazycnc.uwk.widgets.ComboBox;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import com.eazycnc.uwk.widgets.Image;
import com.eazycnc.uwk.widgets.Label;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.OpenGLCanvas;
import com.eazycnc.uwk.widgets.Picture;
import com.eazycnc.uwk.widgets.RadioButton;
import com.eazycnc.uwk.widgets.SourceCodeEditor;
import com.eazycnc.uwk.widgets.SplitLayout;
import com.eazycnc.uwk.widgets.TabbedLayout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.ToggleButton;
import com.eazycnc.uwk.widgets.Widget;
import com.eazycnc.uwk.widgets.WidgetFactory;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import swing.ButtonImpl;
import swing.CanvasImpl;
import swing.CardLayoutImpl;
import swing.CheckBoxImpl;
import swing.ColorPickerImpl;
import swing.ComboBoxImpl;
import swing.ImageImpl;
import swing.LabelImpl;
import swing.OpenGLViewImpl;
import swing.PanelImpl;
import swing.PictureImpl;
import swing.RadioButtonImpl;
import swing.SourceCodeEditorImpl;
import swing.SplitLayoutImpl;
import swing.TabbedLaytoutImpl;
import swing.TextFieldImpl;
import swing.ToggleButtonImpl;

public class SwingWidgetFactory
implements WidgetFactory {
    public static JFrame m_Window;
    JDialog m_Dialog;
    DialogCallback m_DialogCallback;
    static boolean m_SmallScreenMode;
    public static boolean m_EnableClickSound;
    static TextFieldCallback m_TextFieldCallback;
    JFileChooser m_FileChooser;
    FileDialog m_FileDialog;

    static BufferedImage scale(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getWidth() - 14 - 10;
        if (n2 < 24) {
            n2 = 24;
        }
        if ((n = bufferedImage.getHeight() - 16) < 24) {
            n = 24;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 6);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, n2, n, null);
        return bufferedImage2;
    }

    @Override
    public Image createImage(ResourceLoader resourceLoader, String string) {
        return new ImageImpl(resourceLoader.loadImage(string));
    }

    @Override
    public Button createButton(ResourceLoader resourceLoader, String string, String string2) {
        return new ButtonImpl(resourceLoader, string, string2);
    }

    @Override
    public CheckBox createCheckBox(String string) {
        return new CheckBoxImpl(string);
    }

    @Override
    public void setRootWidget(Widget widget) {
        m_Window.getContentPane().removeAll();
        m_Window.getContentPane().add((Component)((Object)widget));
    }

    @Override
    public Layout createLayout(boolean bl, String string, String string2) {
        return new PanelImpl(m_SmallScreenMode, bl, string, string2);
    }

    @Override
    public void realize() {
        m_Window.pack();
        m_Window.setSize(m_Window.getMinimumSize());
        Dimension dimension = m_Window.getMinimumSize();
        if (dimension.height < 480) {
            dimension.height = 480;
        }
        if (dimension.width < 800) {
            dimension.width = 800;
        }
        m_Window.setMinimumSize(dimension);
        m_Window.setVisible(true);
        System.out.println("WINDOW SIZE " + m_Window.getWidth() + " x " + m_Window.getHeight());
    }

    public SwingWidgetFactory(int n, final Runnable runnable) {
        JFrame.setDefaultLookAndFeelDecorated(false);
        m_Window = new JFrame(){
            boolean m_FirstPaint = true;

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (this.m_FirstPaint && runnable != null) {
                    runnable.run();
                }
                this.m_FirstPaint = false;
            }
        };
        m_Window.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getLastComponent(Container container) {
                return null;
            }

            @Override
            public Component getFirstComponent(Container container) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return null;
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                return null;
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                return null;
            }
        });
        m_SmallScreenMode = n != 0;
    }

    @Override
    public Label createLabel(String string) {
        return new LabelImpl(string);
    }

    @Override
    public ComboBox craeteComboBox(Object[] objectArray) {
        return new ComboBoxImpl(objectArray);
    }

    @Override
    public ToggleButton createToggleButton(ResourceLoader resourceLoader, String string, String string2) {
        return new ToggleButtonImpl(resourceLoader, string, string2);
    }

    @Override
    public TextField createTextField(String string, double d, int n, boolean bl) {
        return new TextFieldImpl(string, d, n, bl);
    }

    public ComboBox createComboBox(Object[] objectArray) {
        return new ComboBoxImpl(objectArray);
    }

    @Override
    public RadioButton createRadioButton(String string) {
        return new RadioButtonImpl(string);
    }

    @Override
    public TabbedLayout createTabbedLayout() {
        return new TabbedLaytoutImpl();
    }

    @Override
    public CardLayout createCardLayout() {
        return new CardLayoutImpl();
    }

    @Override
    public Picture createPicture(ResourceLoader resourceLoader, String string) {
        return new PictureImpl(resourceLoader, string);
    }

    @Override
    public SplitLayout createSplitLayout(Widget widget, Widget widget2) {
        return new SplitLayoutImpl(widget, widget2);
    }

    @Override
    public OpenGLCanvas createOpenGLView() {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        return new OpenGLViewImpl(gLCapabilities);
    }

    @Override
    public SourceCodeEditor createSourceCodeEditor(boolean bl, File file) {
        return new SourceCodeEditorImpl(bl, file);
    }

    @Override
    public void scheduleInEDT(int n, final int n2, final Runnable runnable) {
        final Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (n2 == 0) {
                    timer.cancel();
                }
                SwingUtilities.invokeLater(runnable);
            }
        }, n, n2 > 0 ? (long)n2 : 1L);
    }

    @Override
    public void scheduleInEDT(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void click() {
        SwingWidgetFactory.clickx();
    }

    public static void clickx() {
        if (!m_EnableClickSound) {
            return;
        }
        try {
            URL uRL = SwingWidgetFactory.class.getResource("click.wav");
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            Clip clip = AudioSystem.getClip();
            clip.open(audioInputStream);
            clip.start();
            clip.drain();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Canvas createCanvas(Canvas.OnPaintCallback onPaintCallback) {
        return new CanvasImpl(onPaintCallback);
    }

    @Override
    public void showFileDialog(String string, boolean bl, FileDialogCallback fileDialogCallback) {
        if (this.m_FileDialog == null) {
            this.m_FileDialog = new FileDialog((Dialog)null);
        }
        if (bl) {
            this.m_FileDialog.setMode(1);
        } else {
            this.m_FileDialog.setMode(0);
        }
        if (string != null && new File(string).exists()) {
            this.m_FileDialog.setDirectory(string);
        }
        this.m_FileDialog.setVisible(true);
        String string2 = this.m_FileDialog.getDirectory();
        String string3 = this.m_FileDialog.getFile();
        if (string2 != null && string3 != null) {
            fileDialogCallback.onFileSelected(string2 + File.separator + string3);
        } else {
            fileDialogCallback.onFileSelected(null);
        }
    }

    @Override
    public void showConfirmDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        this.showConfirmDialog(string, new SimpleVariable(variable), string2, string3, string4, dialogCallback);
    }

    @Override
    public void showConfirmDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        this.showConfirmDialog("OptionPane.questionIcon", string, new SimpleVariable(string2), string3, string4, string5, dialogCallback);
    }

    @Override
    public void showInformationDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        this.showInformationDialog(string, new SimpleVariable(string2), string3, string4, string5, dialogCallback);
    }

    @Override
    public void showInformationDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        this.showConfirmDialog("OptionPane.informationIcon", string, variable, string2, string3, string4, dialogCallback);
    }

    @Override
    public void showWarningDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        this.showConfirmDialog("OptionPane.warningIcon", string, variable, string2, string3, string4, dialogCallback);
    }

    @Override
    public void showWarningDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        this.showWarningDialog(string, new SimpleVariable(string2), string3, string4, string5, dialogCallback);
    }

    @Override
    public void showErrorDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        this.showErrorDialog(string, new SimpleVariable(string2), string3, string4, string5, dialogCallback);
    }

    @Override
    public void showErrorDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        this.showConfirmDialog("OptionPane.errorIcon", string, variable, string2, string3, string4, dialogCallback);
    }

    public void showConfirmDialog(String string, String string2, Variable variable, String string3, String string4, String string5, final DialogCallback dialogCallback) {
        Serializable serializable;
        final JDialog jDialog = new JDialog(m_Window, string2, Dialog.ModalityType.APPLICATION_MODAL){

            @Override
            public void setVisible(boolean bl) {
                if (bl) {
                    if (SwingWidgetFactory.this.m_Dialog != null) {
                        System.err.println("WARNING! Nested dialogs not supported");
                    }
                    SwingWidgetFactory.this.m_Dialog = this;
                    SwingWidgetFactory.this.m_DialogCallback = dialogCallback;
                    super.setVisible(true);
                } else {
                    super.setVisible(false);
                    if (SwingWidgetFactory.this.m_Dialog == null) {
                        System.err.println("WARNING! Dialog already closed");
                    }
                    SwingWidgetFactory.this.m_Dialog = null;
                    if (SwingWidgetFactory.this.m_DialogCallback != null) {
                        DialogCallback dialogCallback2 = SwingWidgetFactory.this.m_DialogCallback;
                        SwingWidgetFactory.this.m_DialogCallback = null;
                        dialogCallback2.onClose(DialogCallback.DialogOptions.CANCEL);
                    }
                }
            }
        };
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        if (string != null) {
            jPanel.add((Component)new JLabel(UIManager.getIcon(string)), "cell 1 1,top");
        }
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, "cell 2 1, span 3,gap 10 10 10 20, top");
        variable.addObserver(observable -> jLabel.setText("<html>" + ((Variable)((Object)observable)).getValue() + "</html>"));
        if (string3 != null) {
            serializable = new JButton(string3);
            jPanel.add((Component)serializable, "sgx 1,cell 3 2,w 80,tag yes");
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DialogCallback dialogCallback = SwingWidgetFactory.this.m_DialogCallback;
                    SwingWidgetFactory.this.m_DialogCallback = null;
                    jDialog.setVisible(false);
                    if (dialogCallback != null) {
                        dialogCallback.onClose(DialogCallback.DialogOptions.YES);
                    }
                }
            });
        }
        if (string5 != null) {
            serializable = new JButton(string5);
            jPanel.add((Component)serializable, "sgx 1,cell 4 2,tag cancel");
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DialogCallback dialogCallback = SwingWidgetFactory.this.m_DialogCallback;
                    SwingWidgetFactory.this.m_DialogCallback = null;
                    jDialog.setVisible(false);
                    if (dialogCallback != null) {
                        dialogCallback.onClose(DialogCallback.DialogOptions.CANCEL);
                    }
                }
            });
        }
        if (string4 != null) {
            serializable = new JButton(string4);
            jPanel.add((Component)serializable, "sgx 1,cell 4 2,tag cancel");
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DialogCallback dialogCallback = SwingWidgetFactory.this.m_DialogCallback;
                    SwingWidgetFactory.this.m_DialogCallback = null;
                    jDialog.setVisible(false);
                    if (dialogCallback != null) {
                        dialogCallback.onClose(DialogCallback.DialogOptions.NO);
                    }
                }
            });
        }
        jDialog.add(jPanel);
        jDialog.pack();
        serializable = m_Window.getSize();
        Point point = m_Window.getLocationOnScreen();
        Dimension dimension = jDialog.getSize();
        int n = (((Dimension)serializable).width - dimension.width) / 2 + point.x;
        int n2 = (((Dimension)serializable).height - dimension.height) / 3 + point.y;
        jDialog.setBounds(n, n2, dimension.width, dimension.height);
        jDialog.setModal(false);
        jDialog.setVisible(true);
    }

    @Override
    public Layout createScrollLayout() {
        return new ScrollPaneImpl();
    }

    @Override
    public void closeDialog() {
        if (this.m_Dialog != null) {
            this.m_Dialog.setVisible(false);
        }
    }

    @Override
    public ColorPicker createColorPicker() {
        return new ColorPickerImpl();
    }

    public static void makeScreenshot(File file, double d, double d2) {
        try {
            JFrame jFrame = m_Window;
            Rectangle rectangle = jFrame.getBounds();
            int n = 2 * rectangle.width;
            int n2 = 2 * rectangle.height;
            if (d != 0.0) {
                n = (int)((double)n * d);
            }
            if (d2 != 0.0) {
                n2 = (int)((double)n2 * d2);
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.scale(2.0, 2.0);
            jFrame.paint(graphics2D);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setTextFieldCallback(TextFieldCallback textFieldCallback) {
        m_TextFieldCallback = textFieldCallback;
    }

    static class ScrollPaneImpl
    extends JScrollPane
    implements Layout {
        public ScrollPaneImpl() {
            super(22, 31);
        }

        @Override
        public void add(Widget widget, String ... stringArray) {
            this.getViewport().add((Component)((Object)widget));
        }

        @Override
        public void remove(Widget widget) {
        }

        @Override
        public void relayout() {
            this.validate();
        }
    }
}

