/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.uwk.widgets.EditListener;
import com.eazycnc.uwk.widgets.TextField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import swing.SwingWidgetFactory;

class TextFieldImpl
extends JTextField
implements TextField {
    private EditListener m_EditListener;

    private static String fill(int n) {
        Object object = "";
        for (int i = 0; i < n; ++i) {
            object = (String)object + "0";
        }
        return object;
    }

    @Override
    public void setColor(int n, int n2) {
        this.setForeground(new Color(n));
        this.setBackground(new Color(n2));
    }

    public TextFieldImpl(String string, double d, int n, boolean bl) {
        super(TextFieldImpl.fill(n));
        this.setFont(this.getFont().deriveFont((float)d));
        if (bl) {
            this.setHorizontalAlignment(4);
        }
        Dimension dimension = new Dimension(this.getPreferredSize());
        this.setMinimumSize(dimension);
        this.setFieldText(string);
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TextFieldImpl.this.setFocusable(true);
                TextFieldImpl.this.requestFocus();
                if (SwingWidgetFactory.m_TextFieldCallback != null) {
                    SwingWidgetFactory.m_TextFieldCallback.textFieldClicked(TextFieldImpl.this);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "cancelcommand");
        this.getActionMap().put("cancelcommand", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextFieldImpl.this.setFocusable(false);
                if (TextFieldImpl.this.m_EditListener != null) {
                    TextFieldImpl.this.m_EditListener.onEndEdit(false);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TextFieldImpl.this.m_EditListener != null) {
                    TextFieldImpl.this.m_EditListener.onEndEdit(true);
                }
                TextFieldImpl.this.setFocusable(false);
            }
        });
    }

    @Override
    public void fireOnEndEdit(boolean bl) {
        if (this.m_EditListener != null) {
            this.m_EditListener.onEndEdit(bl);
        }
    }

    @Override
    public void setEditListener(EditListener editListener) {
        this.m_EditListener = editListener;
    }

    @Override
    public void addFocusListener(final com.eazycnc.uwk.widgets.FocusListener focusListener) {
        super.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                focusListener.focusGained(TextFieldImpl.this);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                focusListener.focusLost(TextFieldImpl.this);
                TextFieldImpl.this.setFocusable(false);
            }
        });
    }

    @Override
    public String getFieldText() {
        return super.getText();
    }

    @Override
    public void setFieldText(String string) {
        super.setText(string);
    }
}

