/*
 * Decompiled with CFR 0.152.
 */
package swing;

import com.eazycnc.uwk.ResourceLoader;
import com.eazycnc.uwk.widgets.ToggleButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JToggleButton;
import swing.SwingWidgetFactory;
import swing.Utils;

class ToggleButtonImpl
extends JToggleButton
implements ToggleButton {
    BufferedImage m_ButtonImage;
    BufferedImage m_ButtonImageSelected;
    BufferedImage m_ButtonImageDisabled;

    public ToggleButtonImpl(ResourceLoader resourceLoader, String string, String string2) {
        super(string2);
        this.setLook(resourceLoader, string);
        this.setFocusable(false);
    }

    public void setLook(ResourceLoader resourceLoader, String string) {
        if (string == null) {
            return;
        }
        String string2 = string;
        if (string2 != null) {
            this.m_ButtonImage = resourceLoader.loadImage(string2 + ".png");
            this.m_ButtonImageSelected = resourceLoader.loadImage(string2 + "_selected.png");
            this.m_ButtonImageDisabled = new File(string2 + "_disabled.png").exists() ? resourceLoader.loadImage(string2 + "_disabled.png") : this.m_ButtonImage;
            if (SwingWidgetFactory.m_SmallScreenMode) {
                this.m_ButtonImage = SwingWidgetFactory.scale(this.m_ButtonImage);
                this.m_ButtonImageSelected = SwingWidgetFactory.scale(this.m_ButtonImageSelected);
                this.m_ButtonImageDisabled = SwingWidgetFactory.scale(this.m_ButtonImageDisabled);
            }
        }
        if (this.m_ButtonImage != null) {
            Dimension dimension = new Dimension(this.m_ButtonImage.getWidth(), this.m_ButtonImage.getHeight());
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.m_ButtonImage != null && this.m_ButtonImageSelected != null) {
            boolean bl;
            boolean bl2 = bl = this.getModel().isSelected() != this.getModel().isPressed();
            if (this.isEnabled()) {
                if (this.m_ButtonImageSelected != null && bl) {
                    graphics.setColor(Color.black);
                    graphics.drawImage(this.m_ButtonImageSelected, 0, 0, this.getWidth(), this.getHeight(), null);
                }
                if (this.m_ButtonImage != null && !bl) {
                    graphics.setColor(Color.white);
                    graphics.drawImage(this.m_ButtonImage, 0, 0, this.getWidth(), this.getHeight(), null);
                }
            } else {
                graphics.setColor(Color.gray);
                graphics.drawImage(this.m_ButtonImageDisabled, 0, 0, this.getWidth(), this.getHeight(), null);
            }
            Utils.drawButtonText(this, graphics, this.getText());
        } else {
            super.paint(graphics);
        }
    }

    @Override
    public void addActionListener(com.eazycnc.uwk.widgets.ActionListener actionListener) {
        this.addActionListener(actionListener, 0);
    }

    @Override
    public void addActionListener(final com.eazycnc.uwk.widgets.ActionListener actionListener, final int n) {
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ((actionEvent.getModifiers() & 0x2F) == n) {
                    actionListener.onAction();
                }
            }
        });
    }
}

