/*
 * Decompiled with CFR 0.152.
 */
package testnewfirmware;

import java.io.FileNotFoundException;
import java.util.List;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.PureJavaHidApi;

public class NewFirmwareTest {
    private static final short VID = 7504;
    private static final short PID = 24608;
    private HidDevice m_Device;

    public static void main(String ... stringArray) {
        try {
            NewFirmwareTest newFirmwareTest = new NewFirmwareTest();
            newFirmwareTest.openDevice((short)7504, (short)24608);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void setByte(byte[] byArray, int n, byte by) {
        byArray[n + 0] = (byte)(by & 0xFF);
    }

    static void setShort(byte[] byArray, int n, short s) {
        byArray[n * 2 + 0] = (byte)(s & 0xFF);
        byArray[n * 2 + 1] = (byte)(s >> 8 & 0xFF);
    }

    static void setInt(byte[] byArray, int n, int n2) {
        byArray[n * 4 + 0] = (byte)(n2 & 0xFF);
        byArray[n * 4 + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n * 4 + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n * 4 + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    public void openDevice(short s, short s2) throws Exception {
        List list = PureJavaHidApi.enumerateDevices();
        HidDeviceInfo hidDeviceInfo = null;
        for (HidDeviceInfo hidDeviceInfo2 : list) {
            if (hidDeviceInfo2.getVendorId() != s || hidDeviceInfo2.getProductId() != s2) continue;
            hidDeviceInfo = hidDeviceInfo2;
            break;
        }
        if (hidDeviceInfo == null) {
            throw new FileNotFoundException();
        }
        this.m_Device = PureJavaHidApi.openDevice(hidDeviceInfo);
        if (this.m_Device == null) {
            throw new FileNotFoundException();
        }
        this.m_Device.setInputReportListener(new InputReportListener(){

            public void onInputReport(HidDevice hidDevice, byte by, byte[] byArray, int n) {
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                System.out.printf("%5d ", (0xFF & byArray2[0]) + (0xFF & byArray2[1]) * 256);
                System.out.printf("%5d      ", (0xFF & byArray2[50]) + (0xFF & byArray2[51]) * 256);
                System.out.printf("0x%02X ", 0xFF & byArray2[48]);
                System.out.printf("0x%02X ", 0xFF & byArray2[49]);
                System.out.println();
            }
        });
        Object object = new byte[64];
        NewFirmwareTest.setByte((byte[])object, 0, (byte)12);
        NewFirmwareTest.setByte((byte[])object, 1, (byte)0);
        NewFirmwareTest.setShort((byte[])object, 1, (short)16);
        NewFirmwareTest.setShort((byte[])object, 2, (short)4660);
        this.m_Device.setOutputReport((byte)0, (byte[])object, 64);
        Thread.sleep(100000L);
        System.exit(0);
    }
}

