/*
 * Decompiled with CFR 0.152.
 */
package toad4;

import toad4.Commands;

public final class CommandFormatter
extends Commands {
    private byte[] m_Buffer = new byte[1024];
    private int m_Length;
    private int m_RespLength;

    private void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public CommandFormatter() {
        this.reset();
    }

    public void reset() {
        this.m_Length = 1;
        this.m_RespLength = 2;
    }

    public byte[] getBuffer() {
        return this.m_Buffer;
    }

    public void pack() {
        this.ASSERT(this.m_Length >= 2);
        int n = 85;
        int n2 = this.m_Length;
        this.m_Buffer[0] = (byte)(128 + n2);
        for (int i = 1; i < n2; ++i) {
            n = (byte)(n + this.m_Buffer[i]);
        }
        this.m_Buffer[n2] = n;
        ++this.m_Length;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.m_Length];
        System.arraycopy(this.m_Buffer, 0, byArray, 0, this.m_Length);
        return byArray;
    }

    public int getLength() {
        return this.m_Length;
    }

    public int getRespLength() {
        return this.m_RespLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_Length; ++i) {
            stringBuffer.append(String.format("%02X ", this.m_Buffer[i]));
        }
        return stringBuffer.toString();
    }

    private void appendQuadByte(int n) {
        this.ASSERT(this.m_Length + 4 <= this.m_Buffer.length);
        this.m_Buffer[this.m_Length++] = (byte)(n >> 24);
        this.m_Buffer[this.m_Length++] = (byte)(n >> 16);
        this.m_Buffer[this.m_Length++] = (byte)(n >> 8);
        this.m_Buffer[this.m_Length++] = (byte)n;
        this.ASSERT(this.m_Length <= 32);
    }

    private void appendDoubleByte(int n) {
        this.ASSERT(this.m_Length + 2 <= this.m_Buffer.length);
        this.m_Buffer[this.m_Length++] = (byte)(n >> 8);
        this.m_Buffer[this.m_Length++] = (byte)n;
        this.ASSERT(this.m_Length <= 32);
    }

    private void appendByte(int n) {
        this.ASSERT(this.m_Length + 1 <= this.m_Buffer.length);
        this.m_Buffer[this.m_Length++] = (byte)n;
        this.ASSERT(this.m_Length <= 32);
    }

    private void appendCommand(int n, int n2) {
        this.ASSERT(this.m_Length + 1 <= this.m_Buffer.length);
        this.ASSERT((n & 0xFFFFFFF8) == 0);
        this.ASSERT((n2 & 0xFFFFFFE0) == 0);
        this.m_Buffer[this.m_Length++] = (byte)(n2 << 3 | n);
        this.ASSERT(this.m_Length <= 32);
    }

    public void appendMode(int n, int n2, boolean bl, boolean bl2, int n3, int n4) {
        this.ASSERT(n2 >= 0 && n2 <= 15);
        int n5 = 12;
        this.appendCommand(n, n5);
        this.appendByte(n2);
        this.appendByte(bl ? 1 : 0);
        this.appendByte(bl2 ? 1 : 0);
        this.appendByte(n3);
        this.appendByte(n4);
        this.m_RespLength += m_CommandResp[n5];
    }

    public void appendGetVersion() {
        int n = 17;
        this.appendCommand(0, n);
        this.m_RespLength += m_CommandResp[n];
    }

    public void appendGo(int n) {
        int n2 = 9;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendGetState(int n) {
        int n2 = 11;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendGetQueueState(int n) {
        int n2 = 10;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendResetQueue(int n) {
        int n2 = 8;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendGetInput(int n) {
        int n2 = 22;
        this.appendCommand(0, n2);
        this.appendByte(n);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendSetOutput(int n, int n2) {
        int n3 = 21;
        this.appendCommand(0, n3);
        this.appendByte(n);
        this.appendByte(n2);
        this.m_RespLength += m_CommandResp[n3];
    }

    public void appendAbort(int n) {
        int n2 = 8;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendGetPos(int n) {
        int n2 = 16;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendGetProbePos(int n) {
        int n2 = 19;
        this.appendCommand(n, n2);
        this.m_RespLength += m_CommandResp[n2];
    }

    public void appendSetPos(int n, int n2) {
        int n3 = 15;
        this.appendCommand(n, n3);
        this.appendDoubleByte(n2 >> 16 & 0xFFFF);
        this.appendDoubleByte(n2 & 0xFFFF);
        this.m_RespLength += m_CommandResp[n3];
    }

    public void appendHome(int n, int n2, int n3, int n4, int n5) {
        this.ASSERT(n2 >= 0 && n2 <= 65535);
        this.ASSERT(n3 >= 0 && n3 <= 65535);
        this.ASSERT(n4 >= 0 && n4 <= 65535);
        this.ASSERT(n5 >= 0 && n5 <= 65535);
        int n6 = 13;
        this.appendCommand(n, n6);
        this.appendDoubleByte(n2);
        this.appendDoubleByte(n3);
        this.appendDoubleByte(n4);
        this.appendQuadByte(n5);
        this.m_RespLength += m_CommandResp[n6];
    }

    public void appendMove(int n, int n2, int n3) {
        this.ASSERT(n3 >= 0 && n3 <= 65535);
        this.ASSERT(n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE);
        int n4 = 1;
        this.appendCommand(n, n4);
        this.appendDoubleByte(n2);
        this.appendDoubleByte(n3);
        this.m_RespLength += m_CommandResp[n4];
    }

    public void appendConfigProbe(int n, int n2) {
        this.ASSERT(n >= 0 && n <= 0);
        this.ASSERT(n2 >= 0 && n2 <= 1);
        int n3 = 20;
        this.appendCommand(0, n3);
        this.appendByte(n);
        this.appendByte(n2);
        this.m_RespLength += m_CommandResp[n3];
    }

    public void appendArmProbe(int n, int n2, int n3) {
        this.ASSERT(n2 >= 0 && n2 <= 65535);
        this.ASSERT(n3 >= 0 && n3 <= 65535);
        int n4 = 18;
        this.appendCommand(n, n4);
        this.appendDoubleByte(n2);
        this.appendDoubleByte(n3);
        this.m_RespLength += m_CommandResp[n4];
    }

    public void appendJogControl(int n, int n2) {
        this.ASSERT(n2 >= 0 && n2 <= 65535);
        int n3 = 14;
        this.appendCommand(n, n3);
        this.appendDoubleByte(n2);
        this.m_RespLength += m_CommandResp[n3];
    }

    public void appendJog(int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ASSERT(n5 >= 0 && n5 <= 65535);
        this.ASSERT(n6 >= 0 && n6 <= 65535);
        this.ASSERT(n2 >= 0 && n2 <= 65535);
        this.ASSERT(n3 >= 0 && n3 <= 65535);
        this.ASSERT(n4 >= 0 && n4 <= 65535);
        int n8 = bl ? 3 : 2;
        this.appendCommand(n, n8);
        this.appendDoubleByte(n2);
        this.appendDoubleByte(n3);
        this.appendDoubleByte(n4);
        this.appendDoubleByte(n5);
        this.appendDoubleByte(n6);
        this.appendQuadByte(n7);
        this.m_RespLength += m_CommandResp[n8];
    }
}

