/*
 * Decompiled with CFR 0.152.
 */
package toad4;

public class ResponseLine {
    private byte[] m_Buffer;
    private int m_Length;
    private int m_Cursor;
    private boolean m_OK;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_Length; ++i) {
            stringBuffer.append(String.format("%02X ", this.m_Buffer[i]));
        }
        return stringBuffer.toString();
    }

    public boolean isOK() {
        return this.m_OK;
    }

    private void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public ResponseLine(byte[] byArray) {
        if (byArray == null) {
            this.m_OK = false;
            return;
        }
        byte by = 85;
        int n = byArray.length;
        for (int i = 0; i < n - 1; ++i) {
            by = (byte)(by + byArray[i]);
        }
        this.m_OK = byArray[n - 1] == by;
        this.m_Buffer = byArray;
        this.m_Length = this.m_Buffer.length - 1;
        this.m_Cursor = 0;
    }

    public String parseString() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = (char)this.parseByte()) != '\u0000') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public int parseByte() {
        this.ASSERT(this.m_Cursor < this.m_Length);
        return this.m_Buffer[this.m_Cursor++] & 0xFF;
    }

    public int parseDoubleByte() {
        this.ASSERT(this.m_Cursor < this.m_Length);
        return (this.parseByte() << 8) + this.parseByte();
    }

    public int getLength() {
        return this.m_Length;
    }
}

