/*
 * Decompiled with CFR 0.152.
 */
package toad4;

public class ResponseParser {
    private byte[] m_Buffer = new byte[128];
    private int m_Length;
    private int m_Cursor;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= this.m_Length; ++i) {
            stringBuffer.append(String.format("%02X ", this.m_Buffer[i]));
        }
        return stringBuffer.toString();
    }

    private void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] getBuffer() {
        return this.m_Buffer;
    }

    public void reset(int n) throws ChecksumErrorException, BadDataException {
        if (n < 1) {
            throw new BadDataException("No data");
        }
        byte by = 85;
        for (int i = 1; i < n - 1; ++i) {
            by = (byte)(by + this.m_Buffer[i]);
        }
        this.m_Length = n - 1;
        this.m_Cursor = 1;
        if (this.m_Buffer[n - 1] != by) {
            throw new ChecksumErrorException();
        }
    }

    public String parseString() throws Exception {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = (char)this.parseByte()) != '\u0000') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public int parseByte() throws BadDataException {
        if (this.m_Cursor >= this.m_Length) {
            throw new BadDataException("Expected more data from TOAD");
        }
        return this.m_Buffer[this.m_Cursor++] & 0xFF;
    }

    public void parseErrCode() throws BadDataException {
        int n = this.parseByte();
        if (n != 0) {
            throw new BadDataException("TOAD returned error code " + n);
        }
    }

    public int parseDoubleByte() throws BadDataException {
        return (this.parseByte() << 8) + this.parseByte();
    }

    public int parseQuadByte() throws BadDataException {
        return (this.parseDoubleByte() << 16) + this.parseDoubleByte();
    }

    public int getLength() {
        return this.m_Length;
    }

    public static class BadDataException
    extends Exception {
        public BadDataException(String string) {
            super(string);
        }
    }

    public static class ChecksumErrorException
    extends Exception {
    }
}

