/*
 * Decompiled with CFR 0.152.
 */
package toad4;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.Observer;
import eazycnc.PluginMethods;
import eazycnc.gcode.MachState;
import eazycnc.toad.simu.Toad4Simulator;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import motorcontrol.MachiningState;
import toad4.CommandFormatter;
import toad4.Commands;
import toad4.ResponseParser;
import toad4.ToadComm;

public class Toad4MotorController
implements MotorController {
    public static final int NUMBER_OF_MOTORS = 4;
    private boolean m_ProbeTriggered;
    private String m_FileName;
    private boolean m_ArmProbe;
    private boolean m_ProbeArmed;
    private long m_StartTime;
    private long m_StopTime;
    private int m_MachiningTime;
    private double m_NCOSize = 65536.0;
    private double m_NCOFreq = 11718.75;
    private ConnectionState m_ConnectionState = ConnectionState.SHUTDOWN;
    private ConnectionState m_TargetStatus = ConnectionState.SHUTDOWN;
    final int SPINDLE_FORWARD_OUTPUT = 0;
    final int SPINDLE_REVERSE_OUTPUT = 1;
    final int SPINDLE_SPEED_OUTPUT = 2;
    final int COOLANT_OUTPUT = 3;
    private boolean m_SpindleOn = false;
    private int m_SpindleDir = -1;
    private double m_SpindleSpeed = -1.0;
    private boolean m_CoolantOn = false;
    private volatile Thread m_RealTimeThread;
    private int m_CycleTimeInMilliSeconds = 100;
    private double m_Factor;
    private volatile boolean m_ForceMotorReConfig = false;
    private ToadComm m_ToadComm;
    private Toad4Simulator m_ToadSimu;
    private ToadComm m_ToadReal;
    public int HISTOGRAM_SIZE = 100;
    public static final int HISTOGRAM_BUCKETS = 1000;
    private int[] m_Histogram = new int[1000];
    private volatile ResponseParser m_Parser = new ResponseParser();
    private volatile CommandFormatter m_Formatter = new CommandFormatter();
    private PluginMethods m_PluginMethods;
    private boolean m_Compiling;
    private int[] m_PlannedMotorPosition;
    private int[] m_NextPos;
    private volatile String m_Version = null;
    private volatile byte[] m_StateInquiryCmd;
    private volatile int m_StateInquiryResp;
    private volatile byte[] m_SpindleForwardCmd;
    private volatile int m_SpindleForwardResp;
    private volatile byte[] m_SpindleReverseCmd;
    private volatile int m_SpindleReverseResp;
    private volatile byte[] m_SpindleOffCmd;
    private volatile int m_SpindleOffResp;
    private volatile byte[] m_CoolantOffCmd;
    private volatile int m_CoolantOffResp;
    private volatile byte[] m_CoolantOnCmd;
    private volatile int m_CoolantOnResp;
    private int m_JogRespLen;
    private byte[][] m_JogCommand = new byte[4][];
    private MachiningState m_PreviousState = null;
    private boolean[] m_CurrentON = new boolean[4];
    private MachiningState[] m_PrevMotorStates = new MachiningState[4];
    private boolean m_AbortAll;
    private int[] m_JogLoSpeed = new int[4];
    private int[] m_JogHiSpeed = new int[4];
    private int[] m_JogAccel = new int[4];
    private int[] m_JogPorch = new int[4];
    private int[] m_JogCrawl = new int[4];
    private int[] m_JogTimeout = new int[4];
    private boolean[] m_JogOn = new boolean[4];
    private boolean[] m_SetPosition = new boolean[4];
    private int[] m_NewPosition = new int[4];
    private double[] m_Temp2;
    private volatile boolean m_AllMotorQueuesFull;
    private volatile boolean m_MachMotorRunning;
    private volatile boolean m_MotorsRunning;
    private int[] m_MotorPosition = new int[4];
    private int[] m_QueueCapacity = new int[4];
    private int[] m_MotorState = new int[4];
    private int[] m_PendingMotorState = new int[4];
    private int[] m_QueueSize = new int[4];
    private int[] m_MotorCurrent = new int[]{20, 20, 20, 20};
    private int[] m_DirPolarity = new int[]{1, 0, 0, 0};
    private int[] m_HomePolarity = new int[]{1, 0, 1, 0};
    private int[] m_MotorStepSize = new int[]{1, 1, 1, 1};
    private int[] m_MotorDecayMode = new int[]{0, 0, 0, 0};
    public MachState m_MachState;
    private MachiningState[] m_MotorMachiningState = new MachiningState[4];
    private long T0;
    private long m_Average;
    private long m_Maximum;
    private boolean m_PairXA;
    private Queue<int[]> m_MoveQueue = new ArrayDeque<int[]>(1);
    private volatile boolean m_AllMotorsAreReady;
    private volatile boolean m_AllQueuesAreEmpty;
    private int[] m_ProbePos;
    private int[] move = new int[4];
    private int[] velo = new int[4];
    int[] oldSize = new int[]{12345, 12345, 12345, 12345};
    boolean m_FirstTime = true;

    @Override
    public void setPairXA(boolean bl) {
        this.m_PairXA = bl;
    }

    @Override
    public synchronized void queueMove(int[] nArray) throws Exception {
        if (this.m_ConnectionState != ConnectionState.CONNECTED && this.m_ConnectionState != ConnectionState.SIMULATION) {
            this.throwNotConnected();
        }
        while (true) {
            if (this.m_MoveQueue.size() >= 16) {
                this.wait();
                continue;
            }
            try {
                if (!this.m_MoveQueue.add(nArray)) continue;
                this.m_AllMotorsAreReady = false;
                this.notifyAll();
            }
            catch (IllegalStateException illegalStateException) {
                this.wait();
                continue;
            }
            break;
        }
    }

    @Override
    public MotorController.MotorState getMotorState(int n) {
        int n2;
        if (this.m_ConnectionState != ConnectionState.CONNECTED && this.m_ConnectionState != ConnectionState.SIMULATION) {
            return MotorController.MotorState.OFFLINE;
        }
        int n3 = n2 = this.m_PendingMotorState[n] >= 0 ? this.m_PendingMotorState[n] : this.m_MotorState[n];
        if (n2 == 1) {
            return MotorController.MotorState.TIMEOUT;
        }
        if (n2 == 2) {
            return MotorController.MotorState.READY;
        }
        return MotorController.MotorState.BUSY;
    }

    @Override
    public double getVelocityFactor() {
        return this.m_NCOSize / this.m_NCOFreq;
    }

    public int getMachTimeInMillis() {
        return this.m_MachiningTime;
    }

    @Override
    public int[] getMotorPosition() {
        int[] nArray = new int[this.m_MotorPosition.length];
        System.arraycopy(this.m_MotorPosition, 0, nArray, 0, this.m_MotorPosition.length);
        return nArray;
    }

    private void sendKeepJogging(int n) throws Exception {
        this.m_Formatter.reset();
        short s = (short)((double)(2 * this.m_CycleTimeInMilliSeconds) * this.m_NCOFreq / 1000.0);
        this.m_Formatter.appendJogControl(n, s);
        if (n == 0 && this.m_PairXA) {
            this.m_Formatter.appendJogControl(3, s);
        }
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
    }

    private void updateHoming(int n) {
        if (this.m_MotorState[n] < 3) {
            if (this.m_MotorState[n] == 2) {
                this.setPosition(n, 0);
            }
            this.setMachiningState(n, this.m_PrevMotorStates[n]);
        }
    }

    private boolean currentON(int n) throws Exception {
        int n2 = this.m_MachState.getParamInt(Integer.MIN_VALUE, n);
        if (n2 <= 1) {
            return true;
        }
        boolean bl = this.m_CurrentON[n];
        if (!bl) {
            this.m_CurrentON[n] = true;
            this.configureMotor(n, true, -1);
            if (this.m_PairXA && n == 0) {
                this.configureMotor(3, true, -1);
            }
        }
        return bl;
    }

    private void currentOFF() throws Exception {
        boolean bl = this.m_MachState.getParamInt(15168) == 7;
        for (int i = 0; i < 4; ++i) {
            MachiningState machiningState = this.getMachiningState(i);
            int n = this.m_MachState.getParamInt(Integer.MIN_VALUE, i);
            if (n <= 1 && !bl || machiningState != MachiningState.STOPPED && machiningState != MachiningState.PAUSED || !this.m_CurrentON[i]) continue;
            this.m_CurrentON[i] = false;
            this.configureMotor(i, false, -1);
            if (!this.m_PairXA || i != 0) continue;
            this.configureMotor(3, false, -1);
        }
    }

    private void updateJogging() throws Exception {
        int n = this.m_MachState.getParamInt(15168);
        boolean bl = 5 >= n && n >= 2;
        block9: for (int i = 0; i < 4; ++i) {
            switch (this.getMachiningState(i)) {
                case START_RUNNING: {
                    this.currentON(i);
                    continue block9;
                }
                case START_HOMING: {
                    this.currentON(i);
                    this.sendStartHoming(i);
                    this.setMachiningState(i, MachiningState.HOMING);
                    continue block9;
                }
                case START_JOG_FWD: {
                    this.currentON(i);
                    if (!bl) {
                        this.sendKeepJogging(i);
                    }
                    if (!this.sendStartJog(i, true)) continue block9;
                    this.setMachiningState(i, MachiningState.JOGGING_FWD);
                    continue block9;
                }
                case START_JOG_REV: {
                    this.currentON(i);
                    if (!bl) {
                        this.sendKeepJogging(i);
                    }
                    if (!this.sendStartJog(i, false)) continue block9;
                    this.setMachiningState(i, MachiningState.JOGGING_REV);
                    continue block9;
                }
                case JOGGING_FWD: 
                case JOGGING_REV: {
                    if (!bl) {
                        this.sendKeepJogging(i);
                    }
                    if (this.m_JogOn[i]) continue block9;
                    this.setMachiningState(i, MachiningState.STOP_JOGGING);
                    continue block9;
                }
                case STOP_JOGGING: {
                    if (this.m_MotorState[i] >= 3) continue block9;
                    this.setMachiningState(i, this.m_PrevMotorStates[i]);
                    continue block9;
                }
                case HOMING: {
                    this.updateHoming(i);
                    continue block9;
                }
            }
        }
    }

    @Override
    public int[] getProbePosition() {
        int[] nArray = this.m_ProbePos;
        this.m_ProbePos = null;
        return nArray;
    }

    public synchronized void setCycleTime(double d) {
        this.m_CycleTimeInMilliSeconds = (int)(d * 1000.0);
        this.m_Factor = this.getVelocityFactor() / d;
    }

    private void checkProbe() throws Exception {
        if (this.m_ProbeArmed) {
            this.m_Formatter.reset();
            for (int i = 0; i < 4; ++i) {
                this.m_Formatter.appendGetProbePos(i);
            }
            this.m_Formatter.pack();
            this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
            int[] nArray = new int[6];
            for (int i = 0; i < 4; ++i) {
                if (!this.m_MachState.isAxisEnabled(i)) continue;
                this.m_Parser.parseErrCode();
                nArray[i] = this.m_Parser.parseQuadByte();
            }
            this.m_ProbePos = nArray;
        }
    }

    private synchronized void backgroundRun2() {
        while (true) {
            try {
                while (true) {
                    if (this.checkConnectionStatus()) {
                        if (this.m_Version == null) {
                            this.updateVersionString();
                        }
                        if (this.m_AbortAll) {
                            this.doAbortAll();
                        }
                        if (this.m_ForceMotorReConfig) {
                            this.configureMotors(-1, true);
                        }
                        this.updateMotorState();
                        this.updateSpindle();
                        this.m_ForceMotorReConfig = false;
                        this.resetPosition();
                        this.updateJogging();
                        this.checkProbe();
                        if (!this.m_AllMotorQueuesFull) {
                            this.updateCut2();
                        }
                        this.currentOFF();
                        this.measurePerformance();
                    }
                    if (this.m_AllMotorQueuesFull || !this.m_MotorsRunning) {
                        this.wait(this.m_CycleTimeInMilliSeconds / 2);
                        continue;
                    }
                    this.wait(5L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    this.m_ConnectionState = ConnectionState.DEVICE_NOT_RESPONDING;
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    private void addDependencies() {
        Observer observer = observable -> this.forceConfig();
        int n = 0;
        while (n < 4) {
            int n2 = n++;
            MachState machState = this.m_MachState;
            machState.getVariable(15150).addObserver(observer);
            machState.getVariable(-2147483646, n2).addObserver(observer);
            machState.getVariable(0x20000002, n2).addObserver(observer);
            machState.getVariable(0x20000001, n2).addObserver(observer);
            machState.getVariable(0x20000000, n2).addObserver(observer);
            machState.getVariable(0x20000000, n2).addObserver(observer);
            machState.getVariable(0x20000001, n2).addObserver(observer);
            machState.getVariable(0x20000004, n2).addObserver(observer);
            machState.getVariable(0x20000000, n2).addObserver(observer);
            machState.getVariable(15168).addObserver(observer);
            machState.getVariable(-2147483640, n2).addObserver(observer);
            machState.getVariable(-2147483642, n2).addObserver(observer);
            machState.getVariable(-2147483641, n2).addObserver(observer);
            machState.getVariable(-2147483644, n2).addObserver(observer);
            machState.getVariable(-2147483643, n2).addObserver(observer);
            machState.getVariable(Integer.MIN_VALUE, n2).addObserver(observer);
        }
    }

    public Toad4MotorController(int n, ToadComm toadComm, MachState machState, PluginMethods pluginMethods) {
        this.m_PluginMethods = pluginMethods;
        this.m_MachState = machState;
        this.m_ToadComm = null;
        this.m_ToadReal = toadComm;
        this.m_ToadSimu = new Toad4Simulator();
        this.addDependencies();
        this.preformatCommands();
        for (int i = 0; i < 4; ++i) {
            int n2 = i;
            this.m_PendingMotorState[i] = -1;
            this.m_MotorMachiningState[i] = MachiningState.STOPPED;
        }
        this.m_NextPos = new int[4];
        this.m_PlannedMotorPosition = new int[4];
        this.m_Temp2 = new double[n];
        this.m_RealTimeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Toad4MotorController.this.backgroundRun2();
            }
        }, "MotorController2");
        this.m_RealTimeThread.setPriority(10);
        this.m_RealTimeThread.setUncaughtExceptionHandler((thread, throwable) -> {
            System.err.println("class MotorControllerNew: uncaught exception");
            throwable.printStackTrace();
        });
        this.m_RealTimeThread.start();
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.m_ConnectionState;
    }

    @Override
    public synchronized void setConnectionState(ConnectionState connectionState) {
        if (ConnectionState.SHUTDOWN != connectionState && ConnectionState.SIMULATION != connectionState && ConnectionState.CONNECTED != connectionState) {
            throw new IllegalArgumentException("Bad request " + connectionState);
        }
        this.m_TargetStatus = connectionState;
        if (this.m_TargetStatus != this.m_ConnectionState) {
            if (this.m_ToadComm != null && this.m_ToadComm.isConnected()) {
                this.m_ToadComm.closeConnection();
                this.m_ToadSimu.stop();
                this.m_Version = null;
            }
            this.m_ToadComm = null;
            if (this.m_TargetStatus == ConnectionState.SHUTDOWN) {
                this.m_ConnectionState = ConnectionState.SHUTDOWN;
            }
            if (this.m_TargetStatus == ConnectionState.CONNECTED) {
                this.m_ToadComm = this.m_ToadReal;
            }
            if (this.m_TargetStatus == ConnectionState.SIMULATION) {
                this.m_ToadSimu.start();
                this.m_ToadComm = this.m_ToadSimu;
            }
            if (this.m_ToadComm != null) {
                try {
                    String string = this.m_MachState.getParamString(15302);
                    if (this.m_TargetStatus == ConnectionState.SIMULATION || string != null && !string.isEmpty()) {
                        this.m_ToadComm.openConnection(string);
                        this.m_ConnectionState = this.m_TargetStatus;
                        this.m_ForceMotorReConfig = true;
                        this.m_Version = null;
                    } else {
                        this.m_ConnectionState = ConnectionState.NO_PORT_SPECIFIED;
                    }
                }
                catch (ToadComm.DeviceBusyException deviceBusyException) {
                    this.m_ConnectionState = ConnectionState.DEVICE_BUSY;
                }
                catch (ToadComm.AccessDeniedException accessDeniedException) {
                    this.m_ConnectionState = ConnectionState.ACCESS_DENIED;
                }
                catch (ToadComm.DeviceNotFound deviceNotFound) {
                    this.m_ConnectionState = ConnectionState.DEVICE_NOT_FOUND;
                }
                catch (IOException iOException) {
                    this.m_ConnectionState = ConnectionState.DEVICE_NOT_RESPONDING;
                }
                catch (Exception exception) {
                    this.m_ConnectionState = ConnectionState.DEVICE_NOT_RESPONDING;
                }
                if (this.m_ConnectionState != this.m_TargetStatus) {
                    // empty if block
                }
            }
        }
    }

    public int getPosition(int n) {
        this.ASSERT(n >= 0 && n <= 4);
        return this.m_MotorPosition[n];
    }

    @Override
    public synchronized boolean startJogging(int n, boolean bl) throws Exception {
        double d;
        MachiningState machiningState;
        this.ASSERT(n >= 0 && n < 4);
        while (MachiningState.STOP_JOGGING == (machiningState = this.getMachiningState(n))) {
            this.wait(100L);
        }
        if (bl && (machiningState == MachiningState.JOGGING_FWD || machiningState == MachiningState.START_JOG_FWD)) {
            return true;
        }
        if (!(bl || machiningState != MachiningState.JOGGING_REV && machiningState != MachiningState.START_JOG_REV)) {
            return true;
        }
        double d2 = this.m_MachState.getParamDouble(-2147483646, n);
        double d3 = (short)(this.m_MachState.getParamDouble(0x20000004, n) * d2);
        double d4 = this.m_MachState.getParamDouble(0x20000003, n) * d2;
        double d5 = this.m_MachState.getParamDouble(0x20000000, n) * d2 * this.m_NCOSize / this.m_NCOFreq;
        double d6 = this.m_MachState.getParamDouble(0x20000001, n) * d2 * this.m_NCOSize / this.m_NCOFreq;
        double d7 = this.m_MachState.getParamDouble(0x20000002, n) * d2 * this.m_NCOSize * this.m_NCOSize / (4.0 * this.m_NCOFreq * this.m_NCOFreq);
        double d8 = 2.147483647E9;
        double d9 = 0.0;
        if (this.m_MachState.getParamBoolean(-2147483640, n)) {
            d8 = bl ? this.m_MachState.getParamDouble(-2147483641, n) * d2 - (double)this.m_MotorPosition[n] : (double)this.m_MotorPosition[n] - this.m_MachState.getParamDouble(-2147483642, n) * d2;
            if (d8 <= 0.0) {
                throw new IllegalArgumentException("Axis already at limit");
            }
            if (this.m_MachState.getParamDouble(0x20000002, n) > 0.0) {
                d = this.m_MachState.getParamDouble(0x20000001, n);
                double d10 = this.m_MachState.getParamDouble(0x20000000, n);
                double d11 = this.m_MachState.getParamDouble(0x20000002, n);
                d9 = (d * d - d10 * d10) / (2.0 * d11) * d2;
            }
        }
        if ((d8 = d8 - d3 - d4) < 0.0) {
            d4 += d8;
            d8 = 0.0;
            if (d4 <= 0.0) {
                d3 = d4;
                d4 = 0.0;
            }
        } else if (d8 > 2.0 * d9) {
            d8 -= d9;
        } else {
            d4 += d8;
            d8 = 0.0;
        }
        if (d8 < 0.0 || d8 > 2.147483647E9) {
            throw new IllegalArgumentException("Jog limit calculation failure");
        }
        d = (int)(this.m_MachState.getParamDouble(0x20000001, n) * (double)this.m_CycleTimeInMilliSeconds / 1000.0 * d2);
        if (d < 1.0 || d > 65535.0) {
            throw new IllegalArgumentException("Jog value calculation failure");
        }
        this.m_JogCrawl[n] = (int)d4;
        this.m_JogLoSpeed[n] = (int)d5;
        this.m_JogHiSpeed[n] = (int)d6;
        this.m_JogAccel[n] = (int)d7;
        this.m_JogTimeout[n] = (int)d8;
        this.m_JogPorch[n] = (int)d3;
        this.m_PrevMotorStates[n] = this.setMachiningState(n, bl ? MachiningState.START_JOG_FWD : MachiningState.START_JOG_REV);
        this.m_JogOn[n] = true;
        this.m_PendingMotorState[n] = 16;
        return true;
    }

    @Override
    public synchronized void stopJogging(int n) throws Exception {
        this.ASSERT(n >= 0 && n < 4);
        this.m_JogOn[n] = false;
    }

    @Override
    public synchronized void startHoming(int n, int n2) {
        this.ASSERT(n >= 0 && n < 4);
        this.m_PrevMotorStates[n] = this.setMachiningState(n, MachiningState.START_HOMING);
        this.m_PendingMotorState[n] = 16;
    }

    public synchronized void startHoming2(int n) {
        this.m_PendingMotorState[n] = 16;
        this.setMachiningState(n, MachiningState.START_HOMING);
    }

    @Override
    public synchronized void setPosition(int n, int n2) {
        if (this.m_ConnectionState != ConnectionState.SIMULATION && this.m_ConnectionState != ConnectionState.CONNECTED) {
            throw new IllegalArgumentException("Motor controller not connected");
        }
        this.m_SetPosition[n] = true;
        this.m_NewPosition[n] = n2;
    }

    @Override
    public synchronized void abortAll() {
        if (this.m_ConnectionState != ConnectionState.SIMULATION && this.m_ConnectionState != ConnectionState.CONNECTED) {
            throw new IllegalArgumentException("Motor controller not connected");
        }
        this.m_AbortAll = true;
    }

    public int[] getHistogram() {
        return this.m_Histogram;
    }

    public void resetHistogram() {
        for (int i = 0; i < this.m_Histogram.length; ++i) {
            this.m_Histogram[i] = 0;
        }
        this.m_Average = 0L;
        this.m_Maximum = 0L;
    }

    @Override
    public void armProbe(boolean bl) {
        this.m_ArmProbe = bl;
    }

    @Override
    public String getVersion() {
        String string = this.m_Version;
        return string;
    }

    public synchronized void forceConfig() {
        this.m_CycleTimeInMilliSeconds = (int)(1000.0 * this.m_MachState.getParamDouble(15150));
        this.m_ForceMotorReConfig = true;
    }

    private void preformatCommands() {
        int n;
        CommandFormatter commandFormatter = new CommandFormatter();
        commandFormatter.reset();
        for (n = 0; n < 4; ++n) {
            commandFormatter.appendGetQueueState(n);
            this.m_StateInquiryResp += Commands.m_CommandResp[10];
            commandFormatter.appendGetPos(n);
            this.m_StateInquiryResp += Commands.m_CommandResp[16];
        }
        commandFormatter.pack();
        this.m_StateInquiryCmd = commandFormatter.getBytes();
        this.m_StateInquiryResp = commandFormatter.getRespLength();
        for (n = 0; n < 4; ++n) {
            commandFormatter.reset();
            commandFormatter.appendJogControl(n, 25);
            commandFormatter.pack();
            this.m_JogRespLen = commandFormatter.getRespLength();
            this.m_JogCommand[n] = commandFormatter.getBytes();
        }
        commandFormatter.reset();
        commandFormatter.appendSetOutput(1, 0);
        commandFormatter.appendSetOutput(0, 1);
        commandFormatter.pack();
        this.m_SpindleForwardCmd = commandFormatter.getBytes();
        this.m_SpindleForwardResp = commandFormatter.getRespLength();
        commandFormatter.reset();
        commandFormatter.appendSetOutput(0, 0);
        commandFormatter.appendSetOutput(1, 1);
        commandFormatter.pack();
        this.m_SpindleReverseCmd = commandFormatter.getBytes();
        this.m_SpindleReverseResp = commandFormatter.getRespLength();
        commandFormatter.reset();
        commandFormatter.appendSetOutput(0, 0);
        commandFormatter.appendSetOutput(1, 0);
        commandFormatter.pack();
        this.m_SpindleOffCmd = commandFormatter.getBytes();
        this.m_SpindleOffResp = commandFormatter.getRespLength();
        commandFormatter.reset();
        commandFormatter.appendSetOutput(3, 0);
        commandFormatter.pack();
        this.m_CoolantOffCmd = commandFormatter.getBytes();
        this.m_CoolantOffResp = commandFormatter.getRespLength();
        commandFormatter.reset();
        commandFormatter.appendSetOutput(3, 1);
        commandFormatter.pack();
        this.m_CoolantOnCmd = commandFormatter.getBytes();
        this.m_CoolantOnResp = commandFormatter.getRespLength();
    }

    private synchronized MachiningState setMachiningState(int n, MachiningState machiningState) {
        this.ASSERT(n >= 0 && n < 4);
        if (this.m_ConnectionState != ConnectionState.CONNECTED && this.m_ConnectionState != ConnectionState.SIMULATION) {
            throw new IllegalArgumentException("Motor controller not connected");
        }
        MachiningState machiningState2 = this.getMachiningState(n);
        if (machiningState2 == machiningState) {
            return machiningState2;
        }
        if (machiningState2 != MachiningState.STOPPED && machiningState2 != MachiningState.PAUSED && machiningState2 != MachiningState.TEST_START) {
            throw new IllegalArgumentException("Motor busy with: " + machiningState2);
        }
        this.m_MotorMachiningState[n] = machiningState;
        return machiningState2;
    }

    private MachiningState getMachiningState(int n) {
        return this.m_MotorMachiningState[n];
    }

    private void parse(int n) throws Exception {
        this.m_Parser.reset(n);
    }

    private void sendCommand(byte[] byArray, int n, byte[] byArray2, int n2, Object object) throws Exception {
        int n3 = 0;
        int n4 = 3;
        while (n4-- > 0) {
            try {
                if (this.m_ConnectionState == ConnectionState.CONNECTED || this.m_ConnectionState == ConnectionState.SIMULATION) {
                    if (this.m_ToadComm != null && this.m_ToadComm.isConnected()) {
                        this.m_ToadComm.write(byArray, n);
                        n3 = this.m_ToadComm.read(byArray2, n2);
                    }
                } else {
                    System.err.println("Send aborted, motor controller not connected");
                    return;
                }
                this.parse(n3);
                return;
            }
            catch (ResponseParser.ChecksumErrorException checksumErrorException) {
                this.m_ToadComm.flush();
                System.err.println("Checksum error, retrying ");
                Thread.sleep(500L);
            }
            catch (ToadComm.TimeoutException timeoutException) {
                this.m_ToadComm.flush();
                System.err.println("Communication timeout, retrying ");
                Thread.sleep(500L);
            }
        }
    }

    private synchronized void configureMotor(int n, boolean bl, int n2) throws Exception {
        boolean bl2;
        boolean bl3;
        int n3 = n;
        if (this.m_PairXA && n == 3) {
            n = 0;
        }
        this.m_Formatter.reset();
        int n4 = this.m_MachState.getParamInt(Integer.MIN_VALUE, n);
        int n5 = this.m_MachState.getParamInt(-2147483643, n) != 0 ? 1 : 0;
        int n6 = this.m_MachState.getParamInt(-2147483644, n) != 0 ? 1 : 0;
        switch (n4) {
            case 0: {
                bl3 = true;
                bl2 = false;
                break;
            }
            case 1: {
                bl3 = true;
                bl2 = true;
                break;
            }
            case 2: {
                if (bl) {
                    bl3 = true;
                    bl2 = true;
                    break;
                }
                bl3 = true;
                bl2 = false;
                break;
            }
            case 3: {
                if (bl) {
                    bl3 = true;
                    bl2 = true;
                    break;
                }
                bl3 = false;
                bl2 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad MOTOR_CURRENT_MODE " + n4);
            }
        }
        if (!bl && this.m_MachState.getParamInt(15168) == 7) {
            bl3 = false;
        }
        this.m_Formatter.appendGo(n3);
        int n7 = n2 < 0 ? (this.m_MachState.isAxisEnabled(n) ? 1 : 0) : (n == n2 ? 1 : 0);
        this.m_Formatter.appendMode(n3, n7, bl3, bl2, n5, n6);
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
        this.m_Parser.parseErrCode();
    }

    private void configureMotors(int n, boolean bl) throws Exception {
        try {
            for (int i = 0; i < 4; ++i) {
                this.m_CurrentON[i] = bl;
                this.configureMotor(i, bl, n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private synchronized void doAbortAll() {
        this.m_MoveQueue.clear();
        for (int i = 0; i < 4; ++i) {
            this.setMachiningState(i, MachiningState.STOPPED);
            try {
                this.m_Formatter.reset();
                this.m_Formatter.appendAbort(i);
                this.m_Formatter.pack();
                this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
                this.m_Parser.parseErrCode();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_AbortAll = false;
        this.forceConfig();
    }

    private void sendResetPosition(int n, int n2) throws Exception {
        this.m_Formatter.reset();
        this.m_Formatter.appendSetPos(n, n2);
        if (n == 0 && this.m_PairXA) {
            this.m_Formatter.appendSetPos(3, n2);
        }
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
        this.m_Parser.parseErrCode();
        this.m_MotorPosition[n] = n2;
    }

    private void updateVersionString() throws Exception {
        this.m_Formatter.reset();
        this.m_Formatter.appendGetVersion();
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
        this.m_Parser.parseErrCode();
        this.m_Version = this.m_Parser.parseString();
    }

    private void sendArmProbe(boolean bl) throws Exception {
        this.m_Formatter.reset();
        this.m_Formatter.appendArmProbe(0, bl ? 1 : 0, 0);
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
        this.m_Parser.parseErrCode();
        this.m_ProbeArmed = bl;
    }

    private static int sqr(int n) {
        return n * n;
    }

    private static double sqr(double d) {
        return d * d;
    }

    private void updateCut2() throws Exception {
        boolean bl = false;
        try {
            this.m_NextPos = this.m_MoveQueue.poll();
            if (null != this.m_NextPos) {
                int n;
                int n2;
                this.notifyAll();
                double d = 0.0;
                int n3 = this.getMaxVelo();
                int n4 = this.getMaxTravel();
                for (n2 = 0; n2 < 4; ++n2) {
                    if (!this.m_MachState.isAxisEnabled(n2) || this.m_PairXA && n2 == 3) continue;
                    n = this.m_NextPos[n2] - this.m_PlannedMotorPosition[n2];
                    int n5 = (int)Math.abs((double)n * this.m_Factor);
                    if (n < -this.getMaxTravel()) {
                        System.err.printf("motor %d move %d < %d [%d => %d]\n", n2, n, -n4, this.m_PlannedMotorPosition[n2], this.m_NextPos[n2]);
                        n = -n4;
                    }
                    if (n > n4) {
                        System.err.printf("motor %d move %d > %d [%d => %d]\n", n2, n, n4, this.m_PlannedMotorPosition[n2], this.m_NextPos[n2]);
                        n = n4;
                    }
                    if (n5 <= 0) {
                        if (n != 0) {
                            System.err.printf("motor %d velo %d <= %d [%d => %d]\n", n2, n5, 0, this.m_PlannedMotorPosition[n2], this.m_NextPos[n2]);
                            n = 0;
                        }
                        n5 = 0;
                    }
                    if ((double)n5 - this.m_Factor > (double)n3) {
                        System.err.printf("motor %d velo %d > %d [%d => %d]\n", n2, n5, n3, this.m_PlannedMotorPosition[n2], this.m_NextPos[n2]);
                    }
                    if (n5 > n3) {
                        n5 = n3;
                    }
                    this.move[n2] = n;
                    this.velo[n2] = n5;
                    if (bl) {
                        double d2 = this.m_MachState.getParamDouble(-2147483646, n2);
                        d += Toad4MotorController.sqr((double)n / d2);
                    }
                    int n6 = n2;
                    this.m_PlannedMotorPosition[n6] = this.m_PlannedMotorPosition[n6] + this.move[n2];
                }
                if (bl) {
                    System.out.printf("velocity %5.1f mm/min\n", Math.sqrt(d) / (double)this.m_CycleTimeInMilliSeconds * 1000.0 * 60.0);
                }
                this.m_Formatter.reset();
                for (n2 = 0; n2 < 4; ++n2) {
                    n = n2;
                    if (this.m_PairXA && n2 == 3) {
                        n = 0;
                    }
                    if (!this.m_MachState.isAxisEnabled(n)) continue;
                    this.m_Formatter.appendMove(n2, this.move[n], this.velo[n]);
                }
                this.m_Formatter.pack();
                this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
                this.m_MachMotorRunning = true;
                this.m_MotorsRunning = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    private void updateMotorState() throws Exception {
        this.sendCommand(this.m_StateInquiryCmd, this.m_StateInquiryCmd.length, this.m_Parser.getBuffer(), this.m_StateInquiryResp, null);
        boolean bl = false;
        boolean bl2 = true;
        this.m_MachMotorRunning = false;
        this.m_MotorsRunning = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i = 0; i < 4; ++i) {
            this.m_Parser.parseErrCode();
            int n = this.m_Parser.parseByte();
            if (i == 0) {
                this.m_ProbeTriggered = (n & 0x80) != 0;
            }
            this.m_MotorState[i] = n & 0x7F;
            this.m_QueueSize[i] = this.m_Parser.parseByte();
            this.m_QueueCapacity[i] = this.m_Parser.parseByte();
            this.m_Parser.parseErrCode();
            this.m_MotorPosition[i] = this.m_Parser.parseQuadByte();
            if (this.m_MotorState[i] >= 3) {
                this.m_MotorsRunning = true;
            }
            if (!this.m_MachState.isAxisEnabled(i)) continue;
            if (this.m_QueueSize[i] != 0) {
                bl2 = false;
            } else {
                bl4 = true;
            }
            if (this.m_QueueCapacity[i] - this.m_QueueSize[i] <= 0) {
                bl = true;
            }
            if (this.m_MotorState[i] < 3) continue;
            this.m_MachMotorRunning = true;
            bl3 = false;
        }
        if (!this.m_MoveQueue.isEmpty()) {
            bl3 = false;
        }
        if (bl2) {
            System.arraycopy(this.getMotorPosition(), 0, this.m_PlannedMotorPosition, 0, this.m_PlannedMotorPosition.length);
        }
        if (this.m_AllMotorQueuesFull != bl) {
            this.m_AllMotorQueuesFull = bl;
            this.notifyAll();
        }
        if (this.m_AllQueuesAreEmpty != bl2) {
            this.m_AllQueuesAreEmpty = bl2;
            this.notifyAll();
        }
        if (this.m_AllMotorsAreReady != bl3) {
            this.m_AllMotorsAreReady = bl3;
            this.notifyAll();
        }
    }

    private void measurePerformance() {
        long l = System.nanoTime();
        long l2 = l - this.T0;
        if (this.T0 > 0L) {
            int n;
            this.m_Average += (l2 - this.m_Average) / 100L;
            this.m_Maximum = Math.max(this.m_Maximum, l2);
            if (this.HISTOGRAM_SIZE != this.m_CycleTimeInMilliSeconds) {
                this.HISTOGRAM_SIZE = this.m_CycleTimeInMilliSeconds;
                for (n = 0; n < this.m_Histogram.length; ++n) {
                    this.m_Histogram[n] = 0;
                }
            }
            if ((n = (int)((double)l2 / 1000000.0 / (double)this.HISTOGRAM_SIZE * 1000.0)) >= 0 && n < 1000) {
                int n2 = n;
                this.m_Histogram[n2] = this.m_Histogram[n2] + 1;
            }
        }
        this.T0 = l;
    }

    private void updateSpindle() {
        try {
            if (this.m_ProbeArmed != this.m_ArmProbe) {
                this.sendArmProbe(this.m_ArmProbe);
            }
            if (this.m_ConnectionState == ConnectionState.CONNECTED || this.m_ConnectionState == ConnectionState.SIMULATION) {
                boolean bl;
                boolean bl2;
                double d;
                this.m_SpindleOn = this.m_MachState.getParamBoolean(15126);
                boolean bl3 = this.m_SpindleOn != this.m_SpindleOn;
                this.m_SpindleDir = this.m_MachState.getParamInt(15128);
                boolean bl4 = this.m_SpindleDir != this.m_SpindleDir;
                this.m_SpindleSpeed = d = this.m_MachState.getParamBoolean(15162) ? this.m_MachState.getParamDouble(15161) : this.m_MachState.getParamDouble(15127);
                boolean bl5 = bl2 = this.m_SpindleSpeed != this.m_SpindleSpeed;
                if (bl2 || bl3 || bl4 || this.m_ForceMotorReConfig) {
                    if (bl3 || bl4 || this.m_ForceMotorReConfig) {
                        if (!this.m_SpindleOn) {
                            this.sendCommand(this.m_SpindleOffCmd, this.m_SpindleOffCmd.length, this.m_Parser.getBuffer(), this.m_SpindleOffResp, null);
                        } else if (this.m_SpindleDir == 1) {
                            this.sendCommand(this.m_SpindleForwardCmd, this.m_SpindleForwardCmd.length, this.m_Parser.getBuffer(), this.m_SpindleForwardResp, null);
                        } else if (this.m_SpindleDir == 2) {
                            this.sendCommand(this.m_SpindleReverseCmd, this.m_SpindleReverseCmd.length, this.m_Parser.getBuffer(), this.m_SpindleReverseResp, null);
                        }
                    }
                    if (bl2 || this.m_ForceMotorReConfig) {
                        double d2;
                        double d3 = this.m_MachState.getParamDouble(15359);
                        int n = (int)((this.m_SpindleSpeed - d3) / ((d2 = this.m_MachState.getParamDouble(15360)) - d3) * 255.0);
                        if (n > 255) {
                            n = 255;
                        }
                        if (n < 0) {
                            n = 0;
                        }
                        this.m_Formatter.reset();
                        this.m_Formatter.appendSetOutput(2, n);
                        this.m_Formatter.pack();
                        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
                        this.m_Parser.parseErrCode();
                    }
                }
                boolean bl6 = bl = (this.m_CoolantOn = this.m_MachState.getParamBoolean(15124)) != this.m_CoolantOn;
                if (bl || this.m_ForceMotorReConfig) {
                    if (this.m_CoolantOn) {
                        this.sendCommand(this.m_CoolantOnCmd, this.m_CoolantOnCmd.length, this.m_Parser.getBuffer(), this.m_CoolantOnResp, null);
                    } else {
                        this.sendCommand(this.m_CoolantOffCmd, this.m_CoolantOffCmd.length, this.m_Parser.getBuffer(), this.m_CoolantOffResp, null);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void throwNotConnected() throws Exception {
        throw new IllegalArgumentException("Motor controller not connected");
    }

    private void sendStartHoming(int n) throws Exception {
        this.m_Formatter.reset();
        this.m_Formatter.appendHome(n, 500, 1500, 50000, 65535);
        if (n == 0 && this.m_PairXA) {
            this.m_Formatter.appendHome(3, 500, 1500, 50000, 65535);
        }
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
        this.m_Parser.parseErrCode();
        this.m_MotorState[n] = this.m_PendingMotorState[n];
        this.m_PendingMotorState[n] = -1;
    }

    private void resetPosition() throws Exception {
        for (int i = 0; i < 4; ++i) {
            if (!this.m_SetPosition[i]) continue;
            this.m_SetPosition[i] = false;
            this.sendResetPosition(i, this.m_NewPosition[i]);
        }
    }

    private void ASSERT(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    private boolean checkConnectionStatus() {
        return this.m_ConnectionState == ConnectionState.SIMULATION || this.m_ConnectionState == ConnectionState.CONNECTED;
    }

    private boolean sendStartJog(int n, boolean bl) throws Exception {
        this.m_Formatter.reset();
        int n2 = this.m_JogPorch[n] - 1;
        int n3 = this.m_JogHiSpeed[n];
        if (this.m_MachState.getParamInt(15168) == 1) {
            n3 = this.m_JogLoSpeed[n];
        }
        this.m_Formatter.appendJog(n, bl, this.m_JogLoSpeed[n], n3, this.m_JogAccel[n], n2, this.m_JogCrawl[n], this.m_JogTimeout[n]);
        if (n == 0 && this.m_PairXA) {
            this.m_Formatter.appendJog(3, bl, this.m_JogLoSpeed[n], n3, this.m_JogAccel[n], n2, this.m_JogCrawl[n], this.m_JogTimeout[n]);
        }
        this.m_Formatter.pack();
        this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
        if (this.m_Parser.parseByte() != 0) {
            return false;
        }
        this.m_MotorState[n] = this.m_PendingMotorState[n];
        this.m_PendingMotorState[n] = -1;
        if (n == 0 && this.m_PairXA) {
            this.m_MotorState[3] = this.m_PendingMotorState[3];
            this.m_PendingMotorState[3] = -1;
        }
        return true;
    }

    @Override
    public synchronized void emergencyStop() {
        if (this.m_ConnectionState == ConnectionState.CONNECTED || this.m_ConnectionState == ConnectionState.SIMULATION) {
            for (int i = 0; i < 4; ++i) {
                try {
                    this.m_Formatter.reset();
                    this.m_Formatter.appendAbort(i);
                    this.m_Formatter.pack();
                    this.sendCommand(this.m_Formatter.getBuffer(), this.m_Formatter.getLength(), this.m_Parser.getBuffer(), this.m_Formatter.getRespLength(), null);
                    this.m_Parser.parseErrCode();
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("failed to send abort command");
                }
            }
            try {
                this.sendCommand(this.m_SpindleOffCmd, this.m_SpindleOffCmd.length, this.m_Parser.getBuffer(), this.m_SpindleOffResp, null);
            }
            catch (Exception exception) {
                System.err.println("failed to send spindle off command");
            }
            try {
                this.sendCommand(this.m_CoolantOffCmd, this.m_CoolantOffCmd.length, this.m_Parser.getBuffer(), this.m_CoolantOffResp, null);
            }
            catch (Exception exception) {
                System.err.println("failed to send coolant off command");
            }
            if (this.m_ToadComm != null && this.m_ToadComm.isConnected()) {
                this.m_ToadComm.closeConnection();
                this.m_ToadSimu.stop();
                this.m_Version = null;
            }
            this.m_TargetStatus = ConnectionState.SHUTDOWN;
        }
        this.m_MoveQueue.clear();
    }

    @Override
    public synchronized void flush() throws InterruptedException {
        if (this.m_ConnectionState != ConnectionState.CONNECTED && this.m_ConnectionState != ConnectionState.SIMULATION) {
            return;
        }
        while (!this.m_AllMotorsAreReady) {
            this.wait();
        }
    }

    @Override
    public int getNumberOfMotors() {
        return 4;
    }

    @Override
    public boolean getProbeTriggered() {
        return this.m_ProbeTriggered;
    }

    @Override
    public void startRunning() {
    }

    @Override
    public void stopRunning() {
    }

    public void reconfigureMotors() {
    }

    @Override
    public void stopHoming(int n) {
    }

    @Override
    public boolean getProbeInput() {
        return false;
    }

    @Override
    public boolean getHomeInput(int n) {
        return false;
    }

    @Override
    public boolean isHoming(int n) {
        return false;
    }

    @Override
    public boolean getDigitalInput(int n) {
        return false;
    }

    @Override
    public void setDigitalOutput(int n, boolean bl) {
    }

    @Override
    public int getAnalogInput(int n) {
        return 0;
    }

    @Override
    public void setAnalogOutput(int n, int n2) {
    }

    @Override
    public boolean getDigitalOutput(int n) {
        return false;
    }

    @Override
    public int getAnalogOutput(int n) {
        return 0;
    }

    @Override
    public int getMaxVelo() {
        return 65535;
    }

    @Override
    public int getMaxTravel() {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean isPositionReset(int n) {
        return false;
    }

    @Override
    public void setMpgTarget(int n, int n2, int n3) {
    }

    @Override
    public boolean isInMpgMode(int n) {
        return false;
    }

    @Override
    public void setMpgTargetSpeed(int n, int n2) {
    }

    @Override
    public boolean isIdle(int n) {
        return false;
    }

    @Override
    public boolean getArcTransferInput() {
        return false;
    }

    @Override
    public boolean getIsControllerInManualMode() {
        return false;
    }

    @Override
    public void setTestMode(boolean bl) {
    }

    @Override
    public boolean getProbeInputAsserted() {
        return false;
    }

    @Override
    public boolean getHomeInputAsserted(int n) {
        return false;
    }
}

